/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.service;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;
import org.eclipse.acceleo.engine.internal.utils.AcceleoDynamicModulesEclipseUtil;
import org.eclipse.acceleo.engine.internal.utils.DynamicModuleContribution;
import org.eclipse.emf.common.EMFPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoDynamicModulesRegistry {
    public static final AcceleoDynamicModulesRegistry INSTANCE = new AcceleoDynamicModulesRegistry();

    private AcceleoDynamicModulesRegistry() {
    }

    public Set<File> getRegisteredModules(String generatorID) {
        CompactLinkedHashSet compound = new CompactLinkedHashSet();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            CompactLinkedHashSet<DynamicModuleContribution> modules = AcceleoDynamicModulesEclipseUtil.getRegisteredModules();
            for (DynamicModuleContribution dynamicModuleContribution : modules) {
                List<String> generatorIDs = dynamicModuleContribution.getGeneratorIDs();
                for (String genID : generatorIDs) {
                    if (!genID.equals(generatorID)) continue;
                    compound.addAll(dynamicModuleContribution.getFiles());
                }
            }
        }
        return compound;
    }
}

