/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.utils;

import java.util.ArrayList;
import org.eclipse.acceleo.engine.internal.utils.AcceleoDynamicModulesDescriptor;
import org.eclipse.acceleo.engine.internal.utils.AcceleoDynamicModulesEclipseUtil;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class DynamicModulesRegistryListener
implements IRegistryEventListener {
    public static final String DYNAMIC_MODULES_EXTENSION_POINT = "org.eclipse.acceleo.engine.dynamic.modules";
    private static final String DYNAMIC_MODULES_ATTRIBUTE_PATH = "path";
    private static final String DYNAMIC_MODULES_TAG_MODULES = "modules";
    private static final String DYNAMIC_MODULES_TAG_GENERATOR = "generator";
    private static final String DYNAMIC_MODULES_TAG_GENERATOR_ID = "generatorID";

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void parseInitialContributions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(DYNAMIC_MODULES_EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    private void parseExtension(IExtension extension) {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        ArrayList<String> paths = new ArrayList<String>(configElements.length);
        ArrayList<String> generators = new ArrayList<String>(configElements.length);
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            String generator;
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (DYNAMIC_MODULES_TAG_MODULES.equals(elem.getName())) {
                String path = elem.getAttribute(DYNAMIC_MODULES_ATTRIBUTE_PATH);
                if (path != null) {
                    paths.add(path);
                }
            } else if (DYNAMIC_MODULES_TAG_GENERATOR.equals(elem.getName()) && (generator = elem.getAttribute(DYNAMIC_MODULES_TAG_GENERATOR_ID)) != null) {
                generators.add(generator);
            }
            ++n2;
        }
        Bundle bundle = Platform.getBundle((String)extension.getContributor().getName());
        if (bundle != null) {
            if (paths.size() == 0) {
                paths.add("/");
            }
            AcceleoDynamicModulesDescriptor acceleoDynamicModulesDescriptor = new AcceleoDynamicModulesDescriptor(generators, paths);
            AcceleoDynamicModulesEclipseUtil.addExtendingBundle(bundle, acceleoDynamicModulesDescriptor);
        }
    }
}

