/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.cst.ModuleImportCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.HyperlinkUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.IHyperlinkDetectorHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.QvtFileHyperlink;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.PathNameCS;

public class ImportHyperlinkDetector
implements IHyperlinkDetectorHelper {
    public IHyperlink detectHyperlink(IHyperlinkDetectorHelper.IDetectionContext context) {
        CSTNode syntaxElement = context.getSyntaxElement();
        CFile sourceFile = ImportHyperlinkDetector.findDefinition(syntaxElement);
        if (sourceFile != null) {
            PathNameCS linkNodeCS;
            Region destRegion = new Region(0, 0);
            ModuleImportCS importCS = ImportHyperlinkDetector.getModuleImport(syntaxElement);
            PathNameCS pathNameCS = linkNodeCS = importCS != null ? importCS.getPathNameCS() : null;
            if (linkNodeCS == null) {
                linkNodeCS = syntaxElement;
            }
            IRegion hlinkReg = HyperlinkUtil.createRegion((CSTNode)linkNodeCS);
            return new QvtFileHyperlink(hlinkReg, sourceFile, (IRegion)destRegion, (IRegion)destRegion);
        }
        return null;
    }

    public static CFile findDefinition(CSTNode syntaxElement) {
        ModuleImport moduleImportAST;
        ModuleImportCS moduleImportCS = ImportHyperlinkDetector.getModuleImport(syntaxElement);
        if (syntaxElement instanceof ModuleImportCS) {
            moduleImportCS = (ModuleImportCS)syntaxElement;
        } else if (syntaxElement instanceof PathNameCS && syntaxElement.eContainer() instanceof ModuleImportCS) {
            moduleImportCS = (ModuleImportCS)syntaxElement.eContainer();
        }
        if (moduleImportCS != null && (moduleImportAST = (ModuleImport)ASTBindingHelper.resolveASTNode((CSTNode)moduleImportCS, ModuleImport.class)) != null && moduleImportAST.getImportedModule() != null) {
            return ASTBindingHelper.resolveModuleFile((EObject)moduleImportAST.getImportedModule());
        }
        return null;
    }

    private static ModuleImportCS getModuleImport(CSTNode syntaxElement) {
        ModuleImportCS importCS = null;
        if (syntaxElement instanceof ModuleImportCS) {
            importCS = (ModuleImportCS)syntaxElement;
        } else if (syntaxElement instanceof PathNameCS && syntaxElement.eContainer() instanceof ModuleImportCS) {
            importCS = (ModuleImportCS)syntaxElement.eContainer();
        }
        return importCS;
    }
}

