/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalTypesUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingDeclarationCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingMethodCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingQueryCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingRuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.adapters.ModelTypeMetamodelsAdapter;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QvtKeywords;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QvtOpLPGParsersym;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.CFileData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.LightweightParserUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionProposal;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.OCLExpressionCS;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.TypeExp;
import org.eclipse.ocl.ecore.VoidType;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionProposalUtil {
    private static final int[] PREDEFINED_TYPES = new int[]{15, 16, 73, 14, 11, 12, 13, 10, 8, 5, 9, 6, 7};
    private static final int[] PREDEFINED_INSTANCES = new int[]{53, 17, 71, 72};
    private static final int[] RVALUE_TERMINALS = new int[]{70, 75, 54, 64, 74, 65, 78, 79, 82, 83};
    private static final int[] MAPPING_CALL_TERMINALS = new int[]{62, 63};

    public static final void addRValues(Collection<ICompletionProposal> proposals, QvtCompletionData data) {
        CompletionProposalUtil.addVariables(proposals, data);
        CompletionProposalUtil.addModuleFeatures(proposals, data);
        CompletionProposalUtil.addModuleOperations(proposals, data);
        CompletionProposalUtil.addAllTypes(proposals, data);
        CompletionProposalUtil.addKeywords(proposals, PREDEFINED_INSTANCES, data);
        CompletionProposalUtil.addKeywords(proposals, RVALUE_TERMINALS, data);
    }

    public static final void addContextProposals(Collection<ICompletionProposal> proposals, EClassifier owner, boolean addResolveFamily, QvtCompletionData data) {
        CompletionProposalUtil.addStructuralFeatures(proposals, owner, data);
        CompletionProposalUtil.addOperations(proposals, owner, data);
        CompletionProposalUtil.addKeywords(proposals, MAPPING_CALL_TERMINALS, data);
        if (addResolveFamily) {
            CompletionProposalUtil.addKeyword(proposals, 65, data);
            CompletionProposalUtil.addKeywords(proposals, LightweightParserUtil.RESOLVE_FAMILY_TERMINALS, data);
        }
    }

    public static final void addKeyword(Collection<ICompletionProposal> proposals, int keyword, QvtCompletionData data) {
        QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal(LightweightParserUtil.getTokenText(keyword), "cat-keyword", data);
        CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
    }

    public static final void addKeywords(Collection<ICompletionProposal> proposals, int[] keywords, QvtCompletionData data) {
        int[] nArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            int keyword = nArray[n2];
            CompletionProposalUtil.addKeyword(proposals, keyword, data);
            ++n2;
        }
    }

    public static final void addProposalIfNecessary(Collection<ICompletionProposal> proposals, QvtCompletionProposal info, QvtCompletionData data) {
        IToken currentToken = data.getCurrentToken();
        if (currentToken != null) {
            int len = data.getOffset() - currentToken.getStartOffset();
            String startText = currentToken.toString().substring(0, len);
            String replacementString = info.getReplacementString();
            if (replacementString.equals(startText) || !replacementString.toUpperCase().startsWith(startText.toUpperCase())) {
                return;
            }
        }
        proposals.add(info);
    }

    public static final void addAllTypes(Collection<ICompletionProposal> proposals, QvtCompletionData data) {
        CompletionProposalUtil.addModelTypes(proposals, data);
        int[] nArray = PREDEFINED_TYPES;
        int n = PREDEFINED_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            int predefinedType = nArray[n2];
            QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal(QvtOpLPGParsersym.orderedTerminalSymbols[predefinedType], "cat-type", data);
            CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
            ++n2;
        }
    }

    public static final void addModelTypes(Collection<ICompletionProposal> proposals, QvtCompletionData data) {
        for (ModelType modelType : data.getEnvironment().getModelTypeRegistry().values()) {
            if (modelType.getName() == null || modelType.getName().trim().length() == 0) continue;
            QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal(modelType, data);
            CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
        }
        for (Map.Entry entry : data.getEnvironment().getEPackageRegistry().entrySet()) {
            Object pack = entry.getValue();
            if (!(pack instanceof EPackage)) continue;
            QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal((EPackage)pack, data);
            CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
        }
        for (ModelType modelType : data.getEnvironment().getModelTypeRegistry().values()) {
            List metamodels = ModelTypeMetamodelsAdapter.getMetamodels((EObject)modelType);
            for (EPackage pack : metamodels) {
                CompletionProposalUtil.addPackageContentsProposals(proposals, data, pack);
            }
        }
    }

    public static final void addPackageContentsProposals(Collection<ICompletionProposal> proposals, QvtCompletionData data, EPackage pack) {
        for (EClassifier classifier : pack.getEClassifiers()) {
            String imageCategory;
            String classifierName = classifier.getName();
            if (classifier instanceof EClass) {
                imageCategory = "cat-class";
                classifierName = CompletionProposalUtil.escapeNameIfNecessary(classifierName);
            } else {
                imageCategory = classifier instanceof EEnum ? "cat-enum" : (classifier instanceof EDataType ? "cat-datatype" : "cat-classifier");
            }
            QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal(classifierName, imageCategory, data);
            CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
        }
        for (EPackage subPack : pack.getESubpackages()) {
            QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal(subPack.getName(), "cat-package", data);
            CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
        }
    }

    public static final void addVariables(Collection<ICompletionProposal> proposals, QvtCompletionData data) {
        QvtOperationalEnv env = data.getEnvironment();
        Variable selfVariable = env.lookup("self");
        if (selfVariable != null && !(selfVariable.getType() instanceof VoidType)) {
            QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal((Variable<EClassifier, EParameter>)selfVariable, data);
            CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
        }
        for (Variable variable : env.getVariables()) {
            if (variable.getName() == null || variable.getName().trim().length() <= 0) continue;
            QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal((Variable<EClassifier, EParameter>)variable, data);
            CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
        }
    }

    public static final void addStructuralFeatures(Collection<ICompletionProposal> proposals, EClassifier owner, QvtCompletionData data) {
        List attributes = TypeUtil.getAttributes((Environment)data.getEnvironment(), (Object)owner);
        for (EStructuralFeature structuralFeature : attributes) {
            QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal(structuralFeature, data);
            CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
        }
    }

    public static final void addOperations(Collection<ICompletionProposal> proposals, EClassifier owner, QvtCompletionData data) {
        List<EOperation> operations = CompletionProposalUtil.getOperations(owner, data.getEnvironment());
        CompletionProposalUtil.addOperationsInternal(operations, proposals, data);
    }

    public static final void addModuleOperations(Collection<ICompletionProposal> proposals, QvtCompletionData data) {
        QvtCompletionProposal info;
        MappingMethodCS[] allImperativeOperationsCS = data.getAllImperativeOperationsCS();
        MappingMethodCS[] mappingMethodCSArray = allImperativeOperationsCS;
        int n = allImperativeOperationsCS.length;
        int n2 = 0;
        while (n2 < n) {
            TypeCS contextTypeCS;
            MappingMethodCS mappingMethodCS = mappingMethodCSArray[n2];
            MappingDeclarationCS mappingDeclarationCS = mappingMethodCS.getMappingDeclarationCS();
            if (mappingDeclarationCS != null && (contextTypeCS = mappingDeclarationCS.getContextType()) == null) {
                info = CompletionProposalUtil.createCompletionProposal(mappingMethodCS, data);
                CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
            }
            ++n2;
        }
        List libs = data.getEnvironment().getNativeLibs();
        ArrayList<Module> allLibs = new ArrayList<Module>(libs.size() + 1);
        allLibs.addAll(libs);
        allLibs.add(QvtOperationalStdLibrary.INSTANCE.getStdLibModule());
        for (Module module : allLibs) {
            for (EOperation nextLibOper : data.getEnvironment().getAdditionalOperations((Object)module)) {
                if (data.getEnvironment().getUMLReflection().getOwningClassifier((Object)nextLibOper) != module) continue;
                info = CompletionProposalUtil.createCompletionProposal(nextLibOper, data);
                CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
            }
        }
    }

    public static final void addModuleFeatures(Collection<ICompletionProposal> proposals, QvtCompletionData data) {
        MappingModuleCS[] allMappingModulesCS;
        MappingModuleCS[] mappingModuleCSArray = allMappingModulesCS = data.getAllMappingModulesCS();
        int n = allMappingModulesCS.length;
        int n2 = 0;
        while (n2 < n) {
            MappingModuleCS mappingModuleCS = mappingModuleCSArray[n2];
            Module module = (Module)ASTBindingHelper.resolveASTNode((CSTNode)mappingModuleCS);
            if (module != null) {
                CompletionProposalUtil.addStructuralFeatures(proposals, (EClassifier)module, data);
            }
            ++n2;
        }
    }

    public static final void addMappingOperations(Collection<ICompletionProposal> proposals, EClassifier owner, QvtCompletionData data) {
        List<EOperation> operations = CompletionProposalUtil.getMappingOperations(owner, data.getEnvironment());
        CompletionProposalUtil.addOperationsInternal(operations, proposals, data);
    }

    public static final void addOperationsInternal(List<EOperation> operations, Collection<ICompletionProposal> proposals, QvtCompletionData data) {
        for (EOperation operation : operations) {
            QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal(operation, data);
            CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
        }
    }

    public static final QvtCompletionProposal createCompletionProposal(EStructuralFeature structuralFeature, QvtCompletionData data) {
        IToken currentToken = data.getCurrentToken();
        int offset = data.getOffset();
        int replacementOffset = currentToken == null ? offset : currentToken.getStartOffset();
        int replacementLength = offset - replacementOffset;
        String proposalString = CompletionProposalUtil.escapeNameIfNecessary(structuralFeature.getName());
        if (proposalString == null) {
            proposalString = "null";
        }
        String type = CompletionProposalUtil.getTypeNameAndMultiplicity((ETypedElement)structuralFeature);
        String displayString = String.valueOf(proposalString) + " : " + type;
        Image image = structuralFeature.isChangeable() ? CompletionProposalUtil.getImage("cat-property") : CompletionProposalUtil.getImage("cat-property", "cat-readonly");
        return new QvtCompletionProposal(proposalString, replacementOffset, replacementLength, proposalString.length(), image, displayString, null, null);
    }

    public static final QvtCompletionProposal createCompletionProposal(Variable<EClassifier, EParameter> variable, QvtCompletionData data) {
        String proposalString;
        IToken currentToken = data.getCurrentToken();
        int offset = data.getOffset();
        int replacementOffset = currentToken == null ? offset : currentToken.getStartOffset();
        int replacementLength = offset - replacementOffset;
        String displayString = proposalString = variable.getName();
        if (variable.getType() != null) {
            displayString = String.valueOf(displayString) + " : " + QvtOperationalTypesUtil.getTypeName((EClassifier)((EClassifier)variable.getType()));
        }
        Image image = CompletionProposalUtil.getImage("cat-variable");
        return new QvtCompletionProposal(variable.getName(), replacementOffset, replacementLength, variable.getName().length(), image, displayString, null, null);
    }

    public static final QvtCompletionProposal createCompletionProposal(EOperation operation, QvtCompletionData data) {
        IToken currentToken = data.getCurrentToken();
        int offset = data.getOffset();
        int replacementOffset = currentToken == null ? offset : currentToken.getStartOffset();
        int replacementLength = offset - replacementOffset;
        String proposalString = operation.getName();
        StringBuilder parametersStringBuilder = new StringBuilder();
        for (EParameter parameter : operation.getEParameters()) {
            if (parametersStringBuilder.length() != 0) {
                parametersStringBuilder.append(", ");
            }
            parametersStringBuilder.append(parameter.getName());
            parametersStringBuilder.append(" : ");
            parametersStringBuilder.append(CompletionProposalUtil.getTypeNameAndMultiplicity((ETypedElement)parameter));
        }
        String displayString = String.valueOf(proposalString) + "(" + parametersStringBuilder + ")";
        if (operation.getEType() != null) {
            displayString = String.valueOf(displayString) + " : " + CompletionProposalUtil.getTypeNameAndMultiplicity((ETypedElement)operation);
        }
        Image image = null;
        image = QvtOperationalUtil.isMappingOperation((EOperation)operation) ? CompletionProposalUtil.getImage("cat-mapping") : (QvtOperationalUtil.isImperativeOperation((EOperation)operation) ? CompletionProposalUtil.getImage("cat-imperative-operation") : CompletionProposalUtil.getImage("cat-operation"));
        String replacementString = String.valueOf(operation.getName()) + "()";
        int cursorPosition = operation.getEParameters().isEmpty() ? replacementString.length() : replacementString.length() - 1;
        return new QvtCompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, null, null);
    }

    public static final QvtCompletionProposal createCompletionProposal(MappingMethodCS mappingMethodCS, QvtCompletionData data) {
        IToken currentToken = data.getCurrentToken();
        int offset = data.getOffset();
        int replacementOffset = currentToken == null ? offset : currentToken.getStartOffset();
        int replacementLength = offset - replacementOffset;
        MappingDeclarationCS mappingDeclarationCS = mappingMethodCS.getMappingDeclarationCS();
        String methodName = mappingDeclarationCS.getSimpleNameCS().getValue();
        MappingModuleCS mappingModuleCS = (MappingModuleCS)mappingMethodCS.eContainer();
        CFileData cFileData = data.getQvtCompiler().getCFileData(mappingModuleCS);
        String lightweightScript = cFileData.getLightweightScript();
        String displayString = lightweightScript.substring(mappingDeclarationCS.getStartOffset(), mappingDeclarationCS.getEndOffset() + 1);
        Image image = null;
        image = mappingMethodCS instanceof MappingRuleCS ? CompletionProposalUtil.getImage("cat-mapping") : (mappingMethodCS instanceof MappingQueryCS ? CompletionProposalUtil.getImage("cat-imperative-operation") : CompletionProposalUtil.getImage("cat-operation"));
        String replacementString = String.valueOf(methodName) + "()";
        int cursorPosition = mappingDeclarationCS.getParameters().isEmpty() ? replacementString.length() : replacementString.length() - 1;
        return new QvtCompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, null, null);
    }

    public static QvtCompletionProposal createCompletionProposal(ModelType modelType, QvtCompletionData data) {
        IToken currentToken = data.getCurrentToken();
        int offset = data.getOffset();
        int replacementOffset = currentToken == null ? offset : currentToken.getStartOffset();
        int replacementLength = offset - replacementOffset;
        String proposalString = modelType.getName();
        Image image = CompletionProposalUtil.getImage("cat-modeltype");
        return new QvtCompletionProposal(proposalString, replacementOffset, replacementLength, proposalString.length(), image, proposalString, null, null);
    }

    public static QvtCompletionProposal createCompletionProposal(EPackage pack, QvtCompletionData data) {
        IToken currentToken = data.getCurrentToken();
        int offset = data.getOffset();
        int replacementOffset = currentToken == null ? offset : currentToken.getStartOffset();
        int replacementLength = offset - replacementOffset;
        String proposalString = pack.getName();
        Image image = CompletionProposalUtil.getImage("cat-package");
        return new QvtCompletionProposal(proposalString, replacementOffset, replacementLength, proposalString.length(), image, proposalString, null, null);
    }

    public static final QvtCompletionProposal createCompletionProposal(String proposalString, String category, QvtCompletionData data) {
        IToken currentToken = data.getCurrentToken();
        int offset = data.getOffset();
        int replacementOffset = currentToken == null ? offset : currentToken.getStartOffset();
        int replacementLength = offset - replacementOffset;
        Image image = CompletionProposalUtil.getImage(category);
        return new QvtCompletionProposal(proposalString, replacementOffset, replacementLength, proposalString.length(), image, proposalString, null, null);
    }

    public static final ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor descriptor = CompletionProposalUtil.getImageRegistry().getDescriptor(key);
        if (descriptor == null) {
            ImageDescriptor id = CompletionProposalUtil.imageDescriptorFromPlugin("icons/" + key + ".gif");
            CompletionProposalUtil.getImageRegistry().put(key, id);
            return CompletionProposalUtil.getImageRegistry().getDescriptor(key);
        }
        return descriptor;
    }

    public static final List<EOperation> getOperations(EClassifier owner, QvtOperationalEnv env) {
        List<EOperation> rawOperations = CompletionProposalUtil.getAllOperations(owner, env);
        ArrayList<EOperation> operations = new ArrayList<EOperation>();
        for (EOperation operation : rawOperations) {
            if ("allInstances".equals(operation.getName())) continue;
            operations.add(operation);
        }
        EClassifier resolvedOwnerType = (EClassifier)TypeUtil.resolveType((Environment)env, (Object)owner);
        if (!(resolvedOwnerType instanceof Module)) {
            if (!(resolvedOwnerType instanceof CollectionType)) {
                operations.add(CompletionProposalUtil.buildAllInstancesOperation(env));
            }
            return operations;
        }
        return operations;
    }

    public static final List<EOperation> getMappingOperations(EClassifier owner, QvtOperationalEnv env) {
        List<EOperation> operations = CompletionProposalUtil.getOperations(owner, env);
        ArrayList<EOperation> result = new ArrayList<EOperation>();
        for (EOperation operation : operations) {
            if (!QvtOperationalUtil.isMappingOperation((EOperation)operation)) continue;
            result.add(operation);
        }
        return result;
    }

    public static final Image getImage(String key) {
        Image image = CompletionProposalUtil.getImageRegistry().get(key);
        if (image == null) {
            ImageDescriptor id = CompletionProposalUtil.imageDescriptorFromPlugin("icons/" + key + ".gif");
            CompletionProposalUtil.getImageRegistry().put(key, id);
            return CompletionProposalUtil.getImageRegistry().get(key);
        }
        return image;
    }

    public static final Image getImage(String imageKey, String decoratorKey) {
        String key = String.valueOf(imageKey) + decoratorKey;
        Image image = CompletionProposalUtil.getImageRegistry().get(key);
        if (image == null) {
            Image baseImage = CompletionProposalUtil.getImage(imageKey);
            ImageDescriptor decoratorId = CompletionProposalUtil.imageDescriptorFromPlugin("icons/" + decoratorKey + ".gif");
            DecorationOverlayIcon decoratedIconId = new DecorationOverlayIcon(baseImage, decoratorId, 3);
            CompletionProposalUtil.getImageRegistry().put(key, (ImageDescriptor)decoratedIconId);
            return CompletionProposalUtil.getImageRegistry().get(key);
        }
        return image;
    }

    public static final void addAllMappingNamesProposals(Collection<ICompletionProposal> proposals, QvtCompletionData data, EClassifier owner, boolean longForm) {
        List<String> mappingNames = CompletionProposalUtil.getAllMappingNames(data, owner, longForm);
        for (String mapping : mappingNames) {
            QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal(mapping, "cat-mapping", data);
            CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
        }
    }

    public static final List<String> getAllMappingNames(QvtCompletionData data, EClassifier owner, boolean longForm) {
        EClassifier resolvedOwner = owner == null ? null : (EClassifier)TypeUtil.resolveType((Environment)data.getEnvironment(), (Object)owner);
        ArrayList<String> mappingNames = new ArrayList<String>();
        MappingMethodCS[] mappingMethodCSArray = data.getAllImperativeOperationsCS();
        int n = mappingMethodCSArray.length;
        int n2 = 0;
        while (n2 < n) {
            MappingDeclarationCS declarationCS;
            MappingMethodCS methodCS = mappingMethodCSArray[n2];
            if (methodCS instanceof MappingRuleCS && (declarationCS = methodCS.getMappingDeclarationCS()).getContextType() != null && !declarationCS.getResult().isEmpty()) {
                EClassifier resolvedContextType;
                OCLExpression<EClassifier> contextType;
                TypeCS contextTypeCS = declarationCS.getContextType();
                if ((resolvedOwner == null || (contextType = LightweightParserUtil.getOclExpression((OCLExpressionCS)contextTypeCS, data)) instanceof TypeExp && resolvedOwner.equals(resolvedContextType = (EClassifier)TypeUtil.resolveType((Environment)data.getEnvironment(), (Object)((EClassifier)((TypeExp)contextType).getReferredType())))) && contextTypeCS instanceof PathNameCS) {
                    StringBuilder sb = new StringBuilder();
                    if (longForm) {
                        PathNameCS pathNameCS = (PathNameCS)contextTypeCS;
                        for (String name : pathNameCS.getSequenceOfNames()) {
                            sb.append(name);
                            sb.append("::");
                        }
                    }
                    String shortName = declarationCS.getSimpleNameCS().getValue();
                    sb.append(shortName);
                    String mappingName = sb.toString();
                    if (!mappingNames.remove(mappingName)) {
                        mappingNames.add(mappingName);
                    }
                }
            }
            ++n2;
        }
        return mappingNames;
    }

    private static ImageDescriptor imageDescriptorFromPlugin(String imageFilePath) {
        return Activator.imageDescriptorFromPlugin((String)Activator.getDefault().getBundle().getSymbolicName(), (String)imageFilePath);
    }

    private static ImageRegistry getImageRegistry() {
        return Activator.getDefault().getImageRegistry();
    }

    private static String getTypeNameAndMultiplicity(ETypedElement typedElement) {
        if (typedElement.getEType() == null) {
            return "?";
        }
        String elementType = QvtOperationalTypesUtil.getTypeName((EClassifier)typedElement.getEType());
        if (typedElement.isMany()) {
            String collectionType = typedElement.isUnique() ? (typedElement.isOrdered() ? "OrderedSet" : "Set") : (typedElement.isOrdered() ? "Sequence" : "Bag");
            return String.valueOf(collectionType) + '(' + QvtOperationalTypesUtil.getTypeName((EClassifier)typedElement.getEType()) + ')';
        }
        return elementType;
    }

    private static List<EOperation> getAllOperations(EClassifier owner, QvtOperationalEnv env) {
        ArrayList<EOperation> result = new ArrayList<EOperation>(TypeUtil.getOperations((Environment)env, (Object)owner));
        if (owner instanceof CollectionType) {
            CollectionType collType = (CollectionType)owner;
            result.addAll((Collection)collType.oclIterators());
        }
        Iterator it = result.iterator();
        while (it.hasNext()) {
            EOperation op = (EOperation)it.next();
            if (!CompletionProposalUtil.isFilteredOutPredefinedOperation(op)) continue;
            it.remove();
        }
        return result;
    }

    private static EOperation buildAllInstancesOperation(QvtOperationalEnv env) {
        OCLStandardLibrary oclStdLib = env.getOCLStandardLibrary();
        EOperation result = EcoreFactory.eINSTANCE.createEOperation();
        result.setName("allInstances");
        result.setEType((EClassifier)oclStdLib.getSet());
        EParameter param = EcoreFactory.eINSTANCE.createEParameter();
        EClassifier oclType = (EClassifier)oclStdLib.getOclType();
        param.setName(oclType.getName());
        param.setEType(oclType);
        result.getEParameters().add((Object)param);
        return result;
    }

    private static String escapeNameIfNecessary(String name) {
        if (QvtKeywords.isKeyword((String)name)) {
            return String.valueOf('_') + name;
        }
        return name;
    }

    private static boolean isFilteredOutPredefinedOperation(EOperation operation) {
        String name = operation.getName();
        if (name != null) {
            int code = OCLStandardLibraryUtil.getOperationCode((String)name);
            switch (code) {
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }
}

