/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.expressions.Constructor;
import org.eclipse.m2m.internal.qvt.oml.expressions.ConstructorBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.EntryOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Helper;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingCallExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.m2m.internal.qvt.oml.expressions.ObjectExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveInExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.util.QVTOperationalVisitor;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AltExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AssertExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AssignExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.BlockExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.BreakExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.CatchExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ComputeExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ContinueExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictLiteralExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictLiteralPart;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ForExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeIterateExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeLoopExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.InstantiationExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.LogExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.OrderedTupleLiteralExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.OrderedTupleLiteralPart;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.RaiseExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ReturnExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.SwitchExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.TryExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.UnlinkExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.UnpackExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.VariableInitExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.WhileExp;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralPart;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.Visitable;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalAstWalker
implements QVTOperationalVisitor<Object> {
    private final NodeProcessor myNodeProcessor;
    private final Set<Visitable> myProcessed;

    public QvtOperationalAstWalker(NodeProcessor processor) {
        this.myNodeProcessor = processor;
        this.myProcessed = new HashSet<Visitable>();
    }

    public Object visitDictLiteralExp(DictLiteralExp dictLiteralExp) {
        for (DictLiteralPart part : dictLiteralExp.getPart()) {
            this.doProcess((Visitable)part.getKey(), (Visitable)dictLiteralExp);
            this.doProcess((Visitable)part.getValue(), (Visitable)dictLiteralExp);
        }
        return null;
    }

    public Object visitAssignExp(AssignExp assignExp) {
        this.doProcess((Visitable)assignExp.getLeft(), (Visitable)assignExp);
        for (OCLExpression exp : assignExp.getValue()) {
            this.doProcess((Visitable)exp, (Visitable)assignExp);
        }
        return null;
    }

    @Override
    public Object visitHelper(Helper helper) {
        this.visitImperativeOperation(helper);
        return null;
    }

    @Override
    public Object visitEntryOperation(EntryOperation entryOperation) {
        return this.visitImperativeOperation(entryOperation);
    }

    @Override
    public Object visitImperativeOperation(ImperativeOperation imperativeOperation) {
        this.doProcess(imperativeOperation.getBody(), imperativeOperation);
        return null;
    }

    @Override
    public Object visitLibrary(Library library) {
        return this.visitModule(library);
    }

    public Object visitReturnExp(ReturnExp returnExp) {
        if (returnExp.getValue() != null) {
            this.doProcess((Visitable)returnExp.getValue(), (Visitable)returnExp);
        }
        return null;
    }

    @Override
    public Object visitMappingBody(MappingBody mappingBody) {
        for (OCLExpression exp : mappingBody.getInitSection()) {
            this.doProcess((Visitable)exp, mappingBody);
        }
        for (OCLExpression exp : mappingBody.getContent()) {
            this.doProcess((Visitable)exp, mappingBody);
        }
        for (OCLExpression exp : mappingBody.getEndSection()) {
            this.doProcess((Visitable)exp, mappingBody);
        }
        return null;
    }

    @Override
    public Object visitMappingCallExp(MappingCallExp mappingCallExp) {
        this.visitOperationCallExp((OperationCallExp<EClassifier, EOperation>)mappingCallExp);
        return null;
    }

    @Override
    public Object visitMappingOperation(MappingOperation mappingOperation) {
        this.visitImperativeOperation(mappingOperation);
        for (OCLExpression exp : mappingOperation.getWhen()) {
            this.doProcess((Visitable)exp, mappingOperation);
        }
        return null;
    }

    @Override
    public Object visitModule(Module module) {
        this.myNodeProcessor.process(module, null);
        for (EOperation op : new ArrayList<EOperation>(QvtOperationalParserUtil.getOwnedOperations(module))) {
            this.doProcess((ImperativeOperation)op, module);
        }
        for (EStructuralFeature feature : module.getEStructuralFeatures()) {
            if (feature instanceof ContextualProperty) {
                ContextualProperty ctxProp = (ContextualProperty)feature;
                this.doProcess(ctxProp, module);
                continue;
            }
            OCLExpression<EClassifier> initExp = QvtOperationalParserUtil.getInitExpression(feature);
            if (initExp == null) continue;
            this.doProcess((Visitable)initExp, module);
        }
        return null;
    }

    @Override
    public Object visitModuleImport(ModuleImport moduleImport) {
        return null;
    }

    @Override
    public Object visitObjectExp(ObjectExp objectExp) {
        if (objectExp.getBody() != null) {
            EList<org.eclipse.ocl.ecore.OCLExpression> contents = objectExp.getBody().getContent();
            for (OCLExpression exp : contents) {
                this.doProcess((Visitable)exp, (Visitable)objectExp);
            }
        }
        return null;
    }

    public Object visitInstantiationExp(InstantiationExp instantiationExp) {
        for (OCLExpression argExp : instantiationExp.getArgument()) {
            this.doProcess((Visitable)argExp, (Visitable)argExp);
        }
        return null;
    }

    @Override
    public Object visitOperationBody(OperationBody operationBody) {
        for (OCLExpression exp : operationBody.getContent()) {
            this.doProcess((Visitable)exp, operationBody);
        }
        return null;
    }

    @Override
    public Object visitVarParameter(VarParameter varParameter) {
        return null;
    }

    public Object visitVariableInitExp(VariableInitExp variableInitExp) {
        Variable referredVariable = variableInitExp.getReferredVariable();
        if (referredVariable.getInitExpression() != null) {
            this.doProcess((Visitable)referredVariable.getInitExpression(), (Visitable)variableInitExp);
        }
        return null;
    }

    public Object visitBlockExp(BlockExp blockExp) {
        for (OCLExpression exp : blockExp.getBody()) {
            this.doProcess((Visitable)exp, (Visitable)blockExp);
        }
        return null;
    }

    public Object visitComputeExp(ComputeExp computeExp) {
        if (computeExp.getReturnedElement() != null) {
            this.doProcess((Visitable)computeExp.getReturnedElement(), (Visitable)computeExp);
        }
        if (computeExp.getBody() != null) {
            this.doProcess((Visitable)computeExp.getBody(), (Visitable)computeExp);
        }
        return null;
    }

    public Object visitWhileExp(WhileExp whileExp) {
        if (whileExp.getCondition() != null) {
            this.doProcess((Visitable)whileExp.getCondition(), (Visitable)whileExp);
        }
        if (whileExp.getBody() != null) {
            this.doProcess((Visitable)whileExp.getBody(), (Visitable)whileExp);
        }
        return null;
    }

    public Object visitAssociationClassCallExp(AssociationClassCallExp<EClassifier, EStructuralFeature> callExp) {
        for (OCLExpression exp : callExp.getQualifier()) {
            this.doProcess((Visitable)exp, (Visitable)callExp);
        }
        this.doProcess((Visitable)callExp.getSource(), (Visitable)callExp);
        return null;
    }

    public Object visitBooleanLiteralExp(BooleanLiteralExp<EClassifier> literalExp) {
        return null;
    }

    public Object visitCollectionItem(CollectionItem<EClassifier> item) {
        this.doProcess((Visitable)item.getItem(), (Visitable)item);
        return null;
    }

    public Object visitCollectionLiteralExp(CollectionLiteralExp<EClassifier> literalExp) {
        for (CollectionLiteralPart part : literalExp.getPart()) {
            this.doProcess((Visitable)part, (Visitable)literalExp);
        }
        return null;
    }

    public Object visitCollectionRange(CollectionRange<EClassifier> range) {
        this.doProcess((Visitable)range.getFirst(), (Visitable)range);
        this.doProcess((Visitable)range.getLast(), (Visitable)range);
        return null;
    }

    public Object visitConstraint(Constraint constraint) {
        this.doProcess((Visitable)constraint.getSpecification().getBodyExpression(), (Visitable)constraint.getSpecification());
        return null;
    }

    public Object visitEnumLiteralExp(EnumLiteralExp<EClassifier, EEnumLiteral> literalExp) {
        return null;
    }

    public Object visitExpressionInOCL(ExpressionInOCL<EClassifier, EParameter> expression) {
        return null;
    }

    public Object visitIfExp(IfExp<EClassifier> ifExp) {
        this.doProcess((Visitable)ifExp.getCondition(), (Visitable)ifExp);
        this.doProcess((Visitable)ifExp.getThenExpression(), (Visitable)ifExp);
        this.doProcess((Visitable)ifExp.getElseExpression(), (Visitable)ifExp);
        return null;
    }

    public Object visitIntegerLiteralExp(IntegerLiteralExp<EClassifier> literalExp) {
        return null;
    }

    public Object visitInvalidLiteralExp(InvalidLiteralExp<EClassifier> literalExp) {
        return null;
    }

    public Object visitIterateExp(IterateExp<EClassifier, EParameter> callExp) {
        this.doProcess((Visitable)callExp.getResult(), (Visitable)callExp);
        this.doProcess((Visitable)callExp.getBody(), (Visitable)callExp);
        return null;
    }

    public Object visitIteratorExp(IteratorExp<EClassifier, EParameter> callExp) {
        if (callExp.getSource() != null) {
            this.doProcess((Visitable)callExp.getSource(), (Visitable)callExp);
        }
        this.doProcess((Visitable)callExp.getBody(), (Visitable)callExp);
        return null;
    }

    public Object visitLetExp(LetExp<EClassifier, EParameter> letExp) {
        this.doProcess((Visitable)letExp.getVariable(), (Visitable)letExp);
        this.doProcess((Visitable)letExp.getIn(), (Visitable)letExp);
        return null;
    }

    public Object visitMessageExp(MessageExp<EClassifier, CallOperationAction, SendSignalAction> messageExp) {
        this.doProcess((Visitable)messageExp.getTarget(), (Visitable)messageExp);
        return null;
    }

    public Object visitNullLiteralExp(NullLiteralExp<EClassifier> literalExp) {
        return null;
    }

    public Object visitOperationCallExp(OperationCallExp<EClassifier, EOperation> callExp) {
        OCLExpression source = callExp.getSource();
        if (source != null) {
            this.doProcess((Visitable)source, (Visitable)callExp);
        }
        for (OCLExpression exp : callExp.getArgument()) {
            this.doProcess((Visitable)exp, (Visitable)callExp);
        }
        EOperation referredOperation = (EOperation)callExp.getReferredOperation();
        boolean cfr_ignored_0 = referredOperation instanceof Visitable;
        return null;
    }

    public Object visitPropertyCallExp(PropertyCallExp<EClassifier, EStructuralFeature> callExp) {
        return null;
    }

    public Object visitRealLiteralExp(RealLiteralExp<EClassifier> literalExp) {
        return null;
    }

    public Object visitStateExp(StateExp<EClassifier, EObject> stateExp) {
        return null;
    }

    public Object visitStringLiteralExp(StringLiteralExp<EClassifier> literalExp) {
        return null;
    }

    public Object visitTupleLiteralExp(TupleLiteralExp<EClassifier, EStructuralFeature> literalExp) {
        return null;
    }

    public Object visitTupleLiteralPart(TupleLiteralPart<EClassifier, EStructuralFeature> part) {
        return null;
    }

    public Object visitTypeExp(TypeExp<EClassifier> typeExp) {
        return null;
    }

    public Object visitUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp<EClassifier> literalExp) {
        return null;
    }

    public Object visitUnspecifiedValueExp(UnspecifiedValueExp<EClassifier> unspecExp) {
        return null;
    }

    public Object visitVariable(org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> variable) {
        return null;
    }

    public Object visitVariableExp(VariableExp<EClassifier, EParameter> variableExp) {
        org.eclipse.ocl.expressions.Variable referredVariable = variableExp.getReferredVariable();
        if (referredVariable instanceof Visitable) {
            this.doProcess((Visitable)referredVariable, (Visitable)variableExp);
        }
        return null;
    }

    @Override
    public Object visitResolveExp(ResolveExp resolveExp) {
        this.doProcess((Visitable)resolveExp.getCondition(), (Visitable)resolveExp);
        return null;
    }

    @Override
    public Object visitResolveInExp(ResolveInExp resolveInExp) {
        return this.visitResolveExp(resolveInExp);
    }

    @Override
    public Object visitModelType(ModelType modelType) {
        for (OCLExpression exp : modelType.getAdditionalCondition()) {
            this.doProcess((Visitable)exp, modelType);
        }
        return null;
    }

    public Object visitLogExp(LogExp logExp) {
        for (OCLExpression arg : logExp.getArgument()) {
            this.doProcess((Visitable)arg, (Visitable)logExp);
        }
        if (logExp.getCondition() != null) {
            this.doProcess((Visitable)logExp.getCondition(), (Visitable)logExp);
        }
        return null;
    }

    public Object visitAssertExp(AssertExp assertExp) {
        if (assertExp.getAssertion() != null) {
            this.doProcess((Visitable)assertExp.getAssertion(), (Visitable)assertExp);
        }
        if (assertExp.getLog() != null) {
            this.doProcess((Visitable)assertExp.getLog(), (Visitable)assertExp);
        }
        return null;
    }

    protected NodeProcessor getNodeProcessor() {
        return this.myNodeProcessor;
    }

    private void doProcess(Visitable e, Visitable parent) {
        if (e != null && !this.myProcessed.contains(e)) {
            this.myNodeProcessor.process(e, parent);
            this.myProcessed.add(e);
            e.accept((Visitor)this);
        }
    }

    public Object visitAltExp(AltExp altExp) {
        this.doProcess((Visitable)altExp.getCondition(), (Visitable)altExp);
        this.doProcess((Visitable)altExp.getBody(), (Visitable)altExp);
        return null;
    }

    public Object visitSwitchExp(SwitchExp switchExp) {
        EList alternativePart = switchExp.getAlternativePart();
        if (alternativePart != null) {
            for (AltExp altExp : alternativePart) {
                this.doProcess((Visitable)altExp, (Visitable)switchExp);
            }
        }
        this.doProcess((Visitable)switchExp.getElsePart(), (Visitable)switchExp);
        return null;
    }

    public Object visitImperativeLoopExp(ImperativeLoopExp imperativeLoopExp) {
        if (imperativeLoopExp.getSource() != null) {
            this.doProcess((Visitable)imperativeLoopExp.getSource(), (Visitable)imperativeLoopExp);
        }
        this.doProcess((Visitable)imperativeLoopExp.getCondition(), (Visitable)imperativeLoopExp);
        this.doProcess((Visitable)imperativeLoopExp.getBody(), (Visitable)imperativeLoopExp);
        return null;
    }

    public Object visitImperativeIterateExp(ImperativeIterateExp imperativeIterateExp) {
        return this.visitImperativeLoopExp((ImperativeLoopExp)imperativeIterateExp);
    }

    @Override
    public Object visitContextualProperty(ContextualProperty contextualProperty) {
        this.doProcess((Visitable)contextualProperty.getInitExpression(), contextualProperty);
        return null;
    }

    public Object visitForExp(ForExp forExp) {
        return this.visitImperativeLoopExp((ImperativeLoopExp)forExp);
    }

    @Override
    public Object visitConstructor(Constructor constructor) {
        return this.visitImperativeOperation(constructor);
    }

    @Override
    public Object visitConstructorBody(ConstructorBody constructorBody) {
        return this.visitOperationBody(constructorBody);
    }

    public Object visitBreakExp(BreakExp astNode) {
        return null;
    }

    public Object visitCatchtExp(CatchExp astNode) {
        return null;
    }

    public Object visitContinueExp(ContinueExp astNode) {
        return null;
    }

    public Object visitDictLiteralPart(DictLiteralPart astNode) {
        return null;
    }

    public Object visitOrderedTupleLiteralExp(OrderedTupleLiteralExp astNode) {
        return null;
    }

    public Object visitOrderedTupleLiteralPart(OrderedTupleLiteralPart astNode) {
        return null;
    }

    public Object visitRaiseExp(RaiseExp astNode) {
        return null;
    }

    public Object visitTryExp(TryExp astNode) {
        return null;
    }

    public Object visitUnlinkExp(UnlinkExp astNode) {
        return null;
    }

    public Object visitUnpackExp(UnpackExp astNode) {
        return null;
    }

    public static interface NodeProcessor {
        public void process(Visitable var1, Visitable var2);
    }
}

