/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitContents;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;

public abstract class UnitProxy {
    public static final int TYPE_MODEL = 1;
    public static final int TYPE_CST_STREAM = 0;
    public static final char NAMESPACE_SEP = '.';
    private String fName;
    private String fNamespace;
    private String fQName;
    private URI fUri;

    protected UnitProxy(String namespace, String unitName, URI uri) {
        if (unitName == null || uri == null || !uri.isHierarchical() || uri.isRelative()) {
            throw new IllegalArgumentException("Invalid unit URI: " + uri);
        }
        this.fNamespace = namespace;
        this.fName = unitName;
        this.fQName = this.fNamespace == null ? this.fName : String.valueOf(this.fNamespace) + '.' + this.fName;
        this.fUri = uri;
    }

    public abstract int getContentType();

    public abstract UnitContents getContents() throws IOException;

    public abstract UnitResolver getResolver();

    public String getName() {
        return this.fName;
    }

    public String getNamespace() {
        return this.fNamespace;
    }

    public String getQualifiedName() {
        return this.fQName;
    }

    public URI getURI() {
        return this.fUri;
    }

    public String toString() {
        return this.fUri.toString();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof UnitProxy) {
            UnitProxy another = (UnitProxy)obj;
            return this.fUri.equals((Object)another.fUri);
        }
        return super.equals(obj);
    }

    public final int hashCode() {
        return this.fUri.hashCode();
    }
}

