/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AtlUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.m2m.atl.adt.ui";
    private static AtlUIPlugin plugin;
    private static Map<String, Image> path2image;
    private ResourceBundle resourceBundle;

    static {
        path2image = new HashMap<String, Image>();
    }

    public AtlUIPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("atlPerspective.AtlPerspectivePluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static AtlUIPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = AtlUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static Image getImage(String path) {
        ImageDescriptor descriptor;
        Image result = path2image.get(path);
        if (result == null && !path2image.containsKey(path) && (descriptor = AtlUIPlugin.getImageDescriptor(path)) != null) {
            result = descriptor.createImage();
            path2image.put(path, result);
        }
        if (result != null && result.isDisposed()) {
            result = null;
        }
        return result;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        String pluginDir = plugin.getBundle().getEntry("/").toString();
        String iconPath = "icons/";
        try {
            return ImageDescriptor.createFromURL((URL)new URL(String.valueOf(pluginDir) + iconPath + name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }
}

