/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests;

import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePlugin;
import org.eclipse.gmf.tests.AllTests;
import org.eclipse.gmf.tests.Configurator;
import org.osgi.framework.BundleContext;

public class Plugin
extends org.eclipse.core.runtime.Plugin {
    private static Plugin ourInstance;
    private BundleContext myContext;
    private Configurator myConfiguration;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ourInstance = this;
        this.myContext = context;
        EMFTypePlugin.startDynamicAwareMode();
    }

    public void stop(BundleContext context) throws Exception {
        ourInstance = null;
        this.myContext = null;
        if (this.myConfiguration != null) {
            this.myConfiguration.dispose();
            this.myConfiguration = null;
        }
        super.stop(context);
    }

    public static URI createURI(String bundledFileName) throws IOException {
        assert (bundledFileName.charAt(0) == '/');
        return URI.createURI((String)("platform:/plugin/" + Plugin.getPluginID() + bundledFileName));
    }

    public static Plugin getInstance() {
        return ourInstance;
    }

    public static BundleContext getBundleContext() {
        return Plugin.ourInstance.myContext;
    }

    public static void logError(String errorsMsg) {
        Plugin.logError(errorsMsg, null);
    }

    public static void logError(String errorsMsg, Exception ex) {
        Plugin.getInstance().getLog().log((IStatus)new Status(4, Plugin.getPluginID(), 0, errorsMsg, (Throwable)ex));
    }

    public static String getPluginID() {
        return Plugin.getInstance().getBundle().getSymbolicName();
    }

    public static Configurator getConfig() {
        if (Plugin.ourInstance.myConfiguration == null) {
            Plugin.ourInstance.myConfiguration = new Configurator();
            AllTests.populate(Plugin.ourInstance.myConfiguration);
        }
        return Plugin.ourInstance.myConfiguration;
    }
}

