/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.ui.properties.sections;

import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.TriggeredOperations;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.ui.properties.commands.RestoreDefaultPropertyValueCommand;
import org.eclipse.gmf.runtime.emf.ui.properties.commands.SetModelPropertyValueCommand;
import org.eclipse.gmf.runtime.emf.ui.properties.internal.EMFPropertiesDebugOptions;
import org.eclipse.gmf.runtime.emf.ui.properties.internal.EMFPropertiesPlugin;
import org.eclipse.gmf.runtime.emf.ui.properties.internal.l10n.EMFUIPropertiesMessages;
import org.eclipse.gmf.runtime.emf.ui.properties.sections.PropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySource;

public class UndoableModelPropertySheetEntry
extends PropertySheetEntry {
    private final IOperationHistory operationHistory;
    private TransactionalEditingDomain editingDomain;

    public UndoableModelPropertySheetEntry(IOperationHistory operationHistory) {
        this.operationHistory = operationHistory;
    }

    public void setEditingDomain(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public TransactionalEditingDomain getEditingDomain() {
        UndoableModelPropertySheetEntry parentEntry = this.getParentEntry();
        if (parentEntry == null || this.editingDomain != null) {
            return this.editingDomain;
        }
        return parentEntry.getEditingDomain();
    }

    public void applyEditorValue() {
        if (this.editor == null) {
            return;
        }
        if (!this.editor.isValueValid()) {
            this.setErrorText(this.editor.getErrorMessage());
            return;
        }
        this.setErrorText(null);
        Object newValue = this.editor.getValue();
        boolean changed = false;
        if (this.values.length > 1) {
            changed = true;
        } else if (this.editValue == null) {
            if (newValue != null) {
                changed = true;
            }
        } else if (!this.editValue.equals(newValue)) {
            changed = true;
        }
        if (changed) {
            this.setValue(newValue);
        }
    }

    public void resetPropertyValue() {
        if (this.parent == null) {
            return;
        }
        String propertyName = this.getDescriptor().getDisplayName();
        Object propertyId = this.getDescriptor().getId();
        CompositeCommand cc = new CompositeCommand(propertyName);
        boolean executeCommand = false;
        Object[] parentValues = this.getParentEntry().getValues();
        int i = 0;
        while (i < parentValues.length) {
            IPropertySource source = this.getPropertySource(parentValues[i]);
            if (source.isPropertySet(propertyId)) {
                RestoreDefaultPropertyValueCommand restoreCommand = new RestoreDefaultPropertyValueCommand(this.getEditingDomain(), propertyName, parentValues[i], source, propertyId);
                cc.compose((IUndoableOperation)restoreCommand);
                executeCommand = true;
            }
            ++i;
        }
        if (executeCommand) {
            try {
                TriggeredOperations triggerOperation = new TriggeredOperations((IUndoableOperation)cc, this.getOperationHistory());
                this.getOperationHistory().execute((IUndoableOperation)triggerOperation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Trace.catching((Plugin)EMFPropertiesPlugin.getDefault(), (String)EMFPropertiesDebugOptions.EXCEPTIONS_CATCHING, UndoableModelPropertySheetEntry.class, (String)"resetPropertyValue", (Throwable)e);
                Log.error((Plugin)EMFPropertiesPlugin.getDefault(), (int)4, (String)e.getLocalizedMessage(), (Throwable)e);
            }
            this.refreshValues();
        }
    }

    protected void setValue(Object newValue) {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = newValue;
            ++i;
        }
        this.getParentEntry().valueChanged(this, (ICommand)this.getCompositeCommand(MessageFormat.format(EMFUIPropertiesMessages.UndoablePropertySheetEntry_commandName, this.getDescriptor().getDisplayName())));
        this.editValue = newValue;
    }

    protected void valueChanged(UndoableModelPropertySheetEntry child, ICommand command) {
        String propertyName = child.getDescriptor().getDisplayName();
        Object propertyId = child.getDescriptor().getId();
        int i = 0;
        while (i < this.values.length) {
            command.compose((IUndoableOperation)this.getPropertyCommand(propertyName, this.values[i], propertyId, child.getEditValue(i)));
            ++i;
        }
        if (this.getParentEntry() != null) {
            this.getParentEntry().valueChanged(this, command);
        } else {
            try {
                TriggeredOperations triggerOperation = new TriggeredOperations((IUndoableOperation)command, this.getOperationHistory());
                this.getOperationHistory().execute((IUndoableOperation)triggerOperation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Trace.catching((Plugin)EMFPropertiesPlugin.getDefault(), (String)EMFPropertiesDebugOptions.EXCEPTIONS_CATCHING, UndoableModelPropertySheetEntry.class, (String)"valueChanged", (Throwable)e);
                Log.error((Plugin)EMFPropertiesPlugin.getDefault(), (int)4, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void setValues(Object[] objects) {
        super.setValues(objects);
        if (this.getParentEntry() == null) {
            int i = 0;
            while (i < objects.length) {
                EObject eObject = null;
                if (objects[i] instanceof EObject) {
                    eObject = (EObject)objects[i];
                } else if (objects[i] instanceof IAdaptable) {
                    eObject = (EObject)((IAdaptable)objects[i]).getAdapter(EObject.class);
                }
                if (eObject != null) {
                    this.setEditingDomain(TransactionUtil.getEditingDomain((EObject)eObject));
                }
                ++i;
            }
        }
    }

    protected final IOperationHistory getOperationHistory() {
        return this.operationHistory;
    }

    protected UndoableModelPropertySheetEntry getParentEntry() {
        return (UndoableModelPropertySheetEntry)this.parent;
    }

    protected ICommand getPropertyCommand(String propertyName, Object object, Object propertyId, Object value) {
        return new SetModelPropertyValueCommand(this.getEditingDomain(), propertyName, object, this.getPropertySource(object), propertyId, value);
    }

    protected ICompositeCommand getCompositeCommand(String propertyName) {
        return new CompositeTransactionalCommand(this.getEditingDomain(), propertyName);
    }

    protected PropertySheetEntry[] createChildEntries(int size) {
        return new UndoableModelPropertySheetEntry[size];
    }

    protected PropertySheetEntry createChildEntry() {
        return new UndoableModelPropertySheetEntry(this.getOperationHistory());
    }
}

