/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.codegen.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.codegen.gmfgen.CustomParser;
import org.eclipse.gmf.codegen.gmfgen.ElementType;
import org.eclipse.gmf.codegen.gmfgen.ExpressionLabelParser;
import org.eclipse.gmf.codegen.gmfgen.ExternalParser;
import org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GMFGenPackage;
import org.eclipse.gmf.codegen.gmfgen.GenAction;
import org.eclipse.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.gmf.codegen.gmfgen.GenChildContainer;
import org.eclipse.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.gmf.codegen.gmfgen.GenContributionItem;
import org.eclipse.gmf.codegen.gmfgen.GenContributionManager;
import org.eclipse.gmf.codegen.gmfgen.GenCustomAction;
import org.eclipse.gmf.codegen.gmfgen.GenCustomPreferencePage;
import org.eclipse.gmf.codegen.gmfgen.GenCustomPropertyTab;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenEditorView;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderContainer;
import org.eclipse.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenLanguage;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.gmf.codegen.gmfgen.GenNavigatorChildReference;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenParserImplementation;
import org.eclipse.gmf.codegen.gmfgen.GenPreferencePage;
import org.eclipse.gmf.codegen.gmfgen.GenPropertyTab;
import org.eclipse.gmf.codegen.gmfgen.GenSharedContributionItem;
import org.eclipse.gmf.codegen.gmfgen.GenStandardPreferencePage;
import org.eclipse.gmf.codegen.gmfgen.InitDiagramAction;
import org.eclipse.gmf.codegen.gmfgen.MetamodelType;
import org.eclipse.gmf.codegen.gmfgen.OpenDiagramBehaviour;
import org.eclipse.gmf.codegen.gmfgen.PredefinedParser;
import org.eclipse.gmf.codegen.gmfgen.SpecializationType;
import org.eclipse.gmf.codegen.gmfgen.StandardPreferencePages;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.gmf.codegen.util.CodegenEmitters;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.internal.common.codegen.GeneratorBase;
import org.eclipse.gmf.internal.common.codegen.ImportUtil;
import org.eclipse.gmf.internal.common.codegen.TextEmitter;
import org.eclipse.gmf.internal.common.codegen.TextMerger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
extends GeneratorBase
implements Runnable {
    private final GenEditorGenerator myEditorGen;
    private final GenDiagram myDiagram;
    private final CodegenEmitters myEmitters;

    public Generator(GenEditorGenerator genModel, CodegenEmitters emitters) {
        assert (genModel != null && emitters != null);
        this.myEditorGen = genModel;
        this.myDiagram = genModel.getDiagram();
        this.myEmitters = emitters;
    }

    protected TextMerger createMergeService() {
        TextMerger service = this.myEmitters.createMergeService();
        if (service != null) {
            return service;
        }
        return super.createMergeService();
    }

    protected void customRun() throws InterruptedException, UnexpectedBehaviourException {
        Path pluginDirectory = new Path(this.myEditorGen.getPluginDirectory());
        this.initializeEditorProject((IPath)pluginDirectory, this.guessProjectLocation(pluginDirectory.segment(0)), Collections.emptyList());
        if (this.myEditorGen.getModelAccess() != null) {
            this.myEmitters.setGlobals(Collections.singletonMap("DynamicModelAccess", this.myEditorGen.getModelAccess()));
            this.generateModelAccessFacility();
        }
        this.generateExternalizationSupport();
        this.generateReorientLinkViewCommand();
        this.generateBaseEditHelper();
        this.generateParsers();
        for (GenNode node : this.myDiagram.getTopLevelNodes()) {
            this.generateNode(node);
        }
        for (GenNode node : this.myDiagram.getChildNodes()) {
            if (node instanceof GenChildLabelNode) {
                this.generateChildLabelNode((GenChildLabelNode)node);
                continue;
            }
            this.generateNode(node);
        }
        for (GenCompartment compartment : this.myDiagram.getCompartments()) {
            this.generateCompartmentEditPart(compartment);
            this.generateCompartmentItemSemanticEditPolicy(compartment);
            if (!compartment.needsCanonicalEditPolicy()) continue;
            this.generateChildContainerCanonicalEditPolicy(compartment);
        }
        for (GenLink next : this.myDiagram.getLinks()) {
            this.generateEditSupport(next);
            this.generateLinkEditPart(next);
            this.generateBehaviours(next);
            this.generateLinkItemSemanticEditPolicy(next);
            if (next.getModelFacet() != null && (next.isIncomingCreationAllowed() || next.isOutgoingCreationAllowed())) {
                this.generateCreateLinkCommand(next);
            }
            if (next.getModelFacet() instanceof TypeLinkModelFacet) {
                if (next.isTargetReorientingAllowed() || next.isSourceReorientingAllowed()) {
                    this.generateReorientLinkCommand(next);
                }
            } else if (next.getModelFacet() instanceof FeatureLinkModelFacet && (next.isTargetReorientingAllowed() || next.isSourceReorientingAllowed())) {
                this.generateReorientRefLinkCommand(next);
            }
            for (GenLinkLabel label : next.getLabels()) {
                this.generateLinkLabelEditPart(label);
            }
        }
        this.generateDiagram();
        this.generateBaseItemSemanticEditPolicy();
        this.generateTextSelectionEditPolicy();
        this.generateTextNonResizableEditPolicy();
        this.generateEditPartFactory();
        this.generateElementInitializers();
        this.generateElementTypes();
        this.generateViewProvider();
        this.generateEditPartProvider();
        this.generateModelingAssistantProvider();
        this.generateIconProvider();
        this.generateParserProvider();
        if (this.myDiagram.isValidationEnabled() || this.myEditorGen.hasAudits()) {
            this.generateValidationProvider();
            this.generateValidateAction();
            if (this.myEditorGen.getApplication() == null) {
                this.generateMarkerNavigationProvider();
            } else {
                this.generateValidationMarker();
            }
            if (this.myDiagram.isValidationDecorators()) {
                this.generateValidationDecoratorProvider();
            }
        }
        if (this.myEditorGen.getMetrics() != null) {
            this.generateMetricProvider();
        }
        if (this.myEditorGen.getExpressionProviders() != null) {
            this.generateExpressionProviders();
        }
        this.generatePreferenceInitializer();
        this.generatePreferencePages((List<GenPreferencePage>)this.myDiagram.getPreferencePages());
        this.generatePalette();
        this.generateDiagramEditorUtil();
        this.generateVisualIDRegistry();
        this.generateCreationWizard();
        this.generateCreationWizardPage();
        this.generateDeleteElementAction();
        this.generateDiagramEditorContextMenuProvider();
        this.generateEditor();
        this.generateActionBarContributor();
        this.generateMatchingStrategy();
        this.generateDocumentProvider();
        if (this.myDiagram.generateInitDiagramAction() || this.myDiagram.generateCreateShortcutAction()) {
            this.generateModelElementSelectionPage();
        }
        if (this.myDiagram.generateInitDiagramAction()) {
            InitDiagramAction fakeAction = GMFGenFactory.eINSTANCE.createInitDiagramAction();
            fakeAction.setQualifiedClassName(this.myDiagram.getInitDiagramFileActionQualifiedClassName());
            this.doGenerateJavaClass(this.myEmitters.getPredefinedActionEmitter(), fakeAction.getQualifiedClassName(), new Object[]{fakeAction, this.myEditorGen});
            this.generateNewDiagramFileWizard();
        }
        if (this.myDiagram.generateCreateShortcutAction()) {
            this.generateCreateShortcutDecorationsCommand();
            if (this.myEditorGen.getApplication() == null) {
                this.generateElementChooser();
            } else {
                this.generateShortcutCreationWizard();
            }
        }
        this.generateDiagramUpdater();
        this.generateUpdateCommand();
        this.generateNodeDescriptor();
        this.generateLinkDescriptor();
        if (this.myEditorGen.getNavigator() != null) {
            this.generateNavigatorContentProvider();
            this.generateNavigatorLabelProvider();
            this.generateNavigatorLinkHelper();
            this.generateNavigatorSorter();
            this.generateNavigatorActionProvider();
            this.generateAbstractNavigatorItem();
            this.generateNavigatorGroup();
            this.generateNavigatorItem();
            this.generateNavigatorGroupIcons();
            if (this.myEditorGen.getDomainGenModel() != null && this.myEditorGen.getNavigator().isGenerateDomainModelNavigator()) {
                this.generateDomainNavigatorContentProvider();
                this.generateDomainNavigatorLabelProvider();
                this.generateDomainNavigatorItem();
                this.generateURIEditorInputTester();
            }
        }
        if (this.myEditorGen.getPropertySheet() != null) {
            this.generatePropertySheetSections();
        }
        if (this.myDiagram.generateShortcutIcon()) {
            this.generateShortcutIcon();
            this.generateShortcutsDecoratorProvider();
            this.generateShortcutPropertyTester();
        }
        if (Generator.isPathInsideGenerationTarget(this.myDiagram.getCreationWizardIconPathX())) {
            this.generateDiagramIcon(this.myDiagram.getCreationWizardIconPathX());
        }
        if (Generator.isPathInsideGenerationTarget(this.myEditorGen.getEditor().getIconPathX())) {
            this.generateDiagramIcon(this.myEditorGen.getEditor().getIconPathX());
        }
        this.generateWizardBanner();
        this.generatePlugin();
        this.generateApplication();
        this.generateActions();
    }

    private static boolean isPathInsideGenerationTarget(String path) {
        assert (path != null);
        Path p = new Path(path);
        return !p.isAbsolute() && !p.segment(0).equals("..");
    }

    private void generateDiagram() throws UnexpectedBehaviourException, InterruptedException {
        this.generateBehaviours(this.myDiagram);
        if (this.myDiagram.needsCanonicalEditPolicy()) {
            this.generateDiagramCanonicalEditPolicy();
        }
        this.generateDiagramItemSemanticEditPolicy();
        this.generateEditSupport(this.myDiagram);
        this.generateDiagramEditPart();
    }

    private void generateNode(GenNode node) throws UnexpectedBehaviourException, InterruptedException {
        this.generateNodeItemSemanticEditPolicy(node);
        if (node.getModelFacet() != null) {
            this.generateCreateNodeCommand(node);
        }
        this.generateEditSupport(node);
        this.generateNodeEditPart(node);
        this.generateBehaviours(node);
        if (node.needsCanonicalEditPolicy()) {
            this.generateChildContainerCanonicalEditPolicy(node);
        }
        if (Generator.needsGraphicalNodeEditPolicy(node)) {
            this.generateGraphicalNodeEditPolicy(node);
        }
        for (GenNodeLabel label : node.getLabels()) {
            if (label instanceof GenExternalNodeLabel) {
                GenExternalNodeLabel extLabel = (GenExternalNodeLabel)label;
                this.generateExternalNodeLabelEditPart(extLabel);
                continue;
            }
            this.generateNodeLabelEditPart(label);
        }
    }

    private void generateChildLabelNode(GenChildLabelNode child) throws UnexpectedBehaviourException, InterruptedException {
        this.generateNodeItemSemanticEditPolicy(child);
        if (child.getModelFacet() != null) {
            this.generateCreateNodeCommand(child);
        }
        this.generateEditSupport(child);
        this.generateBehaviours(child);
        this.generateChildNodeLabelEditPart(child);
    }

    private void generateReorientLinkViewCommand() throws UnexpectedBehaviourException, InterruptedException {
        for (GenNode n : this.myDiagram.getAllNodes()) {
            if (!Generator.needsGraphicalNodeEditPolicy(n)) continue;
            this.doGenerateJavaClass(this.myEmitters.getReorientLinkViewCommandEmitter(), this.myDiagram.getReorientConnectionViewCommandQualifiedClassName(), new Object[]{this.myDiagram});
            break;
        }
    }

    private void generateCreateNodeCommand(GenNode node) throws InterruptedException, UnexpectedBehaviourException {
        this.doGenerateJavaClass(this.myEmitters.getCreateNodeCommandEmitter(), node.getCreateCommandQualifiedClassName(), new Object[]{node});
    }

    private void generateCreateLinkCommand(GenLink link) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getCreateLinkCommandEmitter(), link.getCreateCommandQualifiedClassName(), new Object[]{link});
    }

    private void generateReorientLinkCommand(GenLink link) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getReorientLinkCommandEmitter(), link.getReorientCommandQualifiedClassName(), new Object[]{link});
    }

    private void generateReorientRefLinkCommand(GenLink link) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getReorientRefLinkCommandEmitter(), link.getReorientCommandQualifiedClassName(), new Object[]{link});
    }

    private void generateCreateShortcutDecorationsCommand() throws InterruptedException, UnexpectedBehaviourException {
        this.doGenerateJavaClass(this.myEmitters.getCreateShortcutDecorationsCommandEmitter(), this.myDiagram.getCreateShortcutDecorationsCommandQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateBaseEditHelper() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getBaseEditHelperEmitter(), this.myDiagram.getBaseEditHelperQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateEditSupport(GenCommonBase diagramElement) throws UnexpectedBehaviourException, InterruptedException {
        ElementType genType = diagramElement.getElementType();
        if (genType.isDefinedExternally()) {
            return;
        }
        if (genType instanceof SpecializationType) {
            this.generateEditHelperAdvice((SpecializationType)genType);
        } else if (genType instanceof MetamodelType) {
            this.generateEditHelper((MetamodelType)genType);
        }
    }

    private void generateEditHelper(MetamodelType genType) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getEditHelperEmitter(), genType.getEditHelperQualifiedClassName(), new Object[]{genType});
    }

    private void generateEditHelperAdvice(SpecializationType genType) throws UnexpectedBehaviourException, InterruptedException {
        if (!genType.eIsSet((EStructuralFeature)GMFGenPackage.eINSTANCE.getSpecializationType_EditHelperAdviceClassName())) {
            return;
        }
        this.doGenerateJavaClass(this.myEmitters.getEditHelperAdviceEmitter(), genType.getEditHelperAdviceQualifiedClassName(), new Object[]{genType});
    }

    private void generateDiagramEditPart() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDiagramEditPartEmitter(), this.myDiagram.getEditPartQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateNodeEditPart(GenNode node) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNodeEditPartEmitter(), node.getEditPartQualifiedClassName(), new Object[]{node});
    }

    private void generateNodeLabelEditPart(GenNodeLabel label) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNodeLabelEditPartEmitter(), label.getEditPartQualifiedClassName(), new Object[]{label});
    }

    private void generateExternalNodeLabelEditPart(GenExternalNodeLabel label) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getExternalNodeLabelEditPartEmitter(), label.getEditPartQualifiedClassName(), new Object[]{label});
    }

    private void generateChildNodeLabelEditPart(GenChildLabelNode node) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getChildNodeLabelEditPartEmitter(), node.getEditPartQualifiedClassName(), new Object[]{node});
    }

    private void generateCompartmentEditPart(GenCompartment compartment) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getCompartmentEditPartEmitter(), compartment.getEditPartQualifiedClassName(), new Object[]{compartment});
    }

    private void generateLinkEditPart(GenLink link) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getLinkEditPartEmitter(), link.getEditPartQualifiedClassName(), new Object[]{link});
    }

    private void generateLinkLabelEditPart(GenLinkLabel label) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getLinkLabelEditPartEmitter(), label.getEditPartQualifiedClassName(), new Object[]{label});
    }

    private void generateEditPartFactory() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getEditPartFactoryEmitter(), this.myDiagram.getEditPartFactoryQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateBaseItemSemanticEditPolicy() throws InterruptedException {
        ArrayList<GenContainerBase> allSemanticElements = new ArrayList<GenContainerBase>((Collection<GenContainerBase>)this.myDiagram.getAllContainers());
        allSemanticElements.addAll((Collection<GenContainerBase>)this.myDiagram.getLinks());
        boolean isSansDomainModel = true;
        Iterator it = allSemanticElements.iterator();
        while (it.hasNext() && isSansDomainModel) {
            GenCommonBase nextCommonBase = (GenCommonBase)it.next();
            if (nextCommonBase.isSansDomain()) continue;
            isSansDomainModel = false;
        }
        if (isSansDomainModel) {
            return;
        }
        this.doGenerateJavaClass(this.myEmitters.getBaseItemSemanticEditPolicyEmitter(), this.myDiagram.getBaseItemSemanticEditPolicyQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateBehaviours(GenCommonBase commonBase) throws UnexpectedBehaviourException, InterruptedException {
        for (OpenDiagramBehaviour behaviour : commonBase.getBehaviour(OpenDiagramBehaviour.class)) {
            if (behaviour.getSubject() != commonBase) continue;
            this.generateOpenDiagramEditPolicy(behaviour);
        }
    }

    private void generateOpenDiagramEditPolicy(OpenDiagramBehaviour behaviour) throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getOpenDiagramEditPolicyEmitter(), behaviour.getEditPolicyQualifiedClassName(), behaviour);
    }

    private void generateDiagramCanonicalEditPolicy() throws InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getDiagramCanonicalEditPolicyEmitter(), this.myDiagram.getCanonicalEditPolicyQualifiedClassName(), this.myDiagram);
    }

    private void generateChildContainerCanonicalEditPolicy(GenChildContainer genContainer) throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getChildContainerCanonicalEditPolicyEmitter(), genContainer.getCanonicalEditPolicyQualifiedClassName(), new Object[]{genContainer});
    }

    private void generateDiagramItemSemanticEditPolicy() throws InterruptedException {
        if (this.myDiagram.isSansDomain()) {
            return;
        }
        this.doGenerateJavaClass(this.myEmitters.getDiagramItemSemanticEditPolicyEmitter(), this.myDiagram.getItemSemanticEditPolicyQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateCompartmentItemSemanticEditPolicy(GenCompartment genCompartment) throws InterruptedException {
        if (genCompartment.isSansDomain()) {
            return;
        }
        this.doGenerateJavaClass(this.myEmitters.getCompartmentItemSemanticEditPolicyEmitter(), genCompartment.getItemSemanticEditPolicyQualifiedClassName(), new Object[]{genCompartment});
    }

    private void generateGraphicalNodeEditPolicy(GenNode genNode) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getGraphicalNodeEditPolicyEmitter(), genNode.getGraphicalNodeEditPolicyQualifiedClassName(), new Object[]{genNode});
    }

    private void generateNodeItemSemanticEditPolicy(GenNode genNode) throws InterruptedException {
        if (genNode.isSansDomain()) {
            return;
        }
        this.doGenerateJavaClass(this.myEmitters.getNodeItemSemanticEditPolicyEmitter(), genNode.getItemSemanticEditPolicyQualifiedClassName(), new Object[]{genNode});
    }

    private void generateLinkItemSemanticEditPolicy(GenLink genLink) throws InterruptedException {
        if (genLink.isSansDomain()) {
            return;
        }
        this.doGenerateJavaClass(this.myEmitters.getLinkItemSemanticEditPolicyEmitter(), genLink.getItemSemanticEditPolicyQualifiedClassName(), new Object[]{genLink});
    }

    private void generateTextSelectionEditPolicy() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getTextSelectionEditPolicyEmitter(), this.myDiagram.getTextSelectionEditPolicyQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateTextNonResizableEditPolicy() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getTextNonResizableEditPolicyEmitter(), this.myDiagram.getTextNonResizableEditPolicyQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generatePreferenceInitializer() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getPreferenceInitializerEmitter(), this.myEmitters.getPreferenceInitializerName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generatePreferencePages(List<GenPreferencePage> pages) throws UnexpectedBehaviourException, InterruptedException {
        for (GenPreferencePage p : pages) {
            if (p instanceof GenCustomPreferencePage) {
                if (((GenCustomPreferencePage)p).isGenerateBoilerplate()) {
                    this.doGenerateJavaClass(this.myEmitters.getCustomPreferencePageEmitter(), p.getQualifiedClassName(), new Object[]{p});
                }
            } else if (p instanceof GenStandardPreferencePage) {
                if (((GenStandardPreferencePage)p).getKind() != StandardPreferencePages.PATHMAPS_LITERAL) {
                    this.doGenerateJavaClass(this.myEmitters.getStandardPreferencePageEmitter(), p.getQualifiedClassName(), new Object[]{p});
                }
            } else {
                throw new UnexpectedBehaviourException("No idea how to handle GenPreferencePage subclass:" + p);
            }
            this.generatePreferencePages((List<GenPreferencePage>)p.getChildren());
        }
    }

    private void generateParsers() throws UnexpectedBehaviourException, InterruptedException {
        if (this.myEditorGen.getLabelParsers() == null) {
            return;
        }
        boolean needsAbstractParser = false;
        for (GenParserImplementation pi : this.myEditorGen.getLabelParsers().getImplementations()) {
            if (pi instanceof PredefinedParser) {
                needsAbstractParser = true;
                this.doGenerateJavaClass(this.myEmitters.getPredefinedParserEmitter(), ((PredefinedParser)pi).getQualifiedClassName(), new Object[]{pi});
                continue;
            }
            if (pi instanceof CustomParser && ((CustomParser)pi).isGenerateBoilerplate()) {
                this.doGenerateJavaClass(this.myEmitters.getCustomParserEmitter(), ((CustomParser)pi).getQualifiedName(), new Object[]{pi});
                continue;
            }
            if (!(pi instanceof ExpressionLabelParser)) continue;
            this.doGenerateJavaClass(this.myEmitters.getExpressionLabelParserEmitter(), ((ExpressionLabelParser)pi).getQualifiedClassName(), new Object[]{pi});
        }
        if (needsAbstractParser) {
            this.doGenerateJavaClass(this.myEmitters.getAbstractParserEmitter(), this.myEmitters.getAbstractParserName(this.myEditorGen.getLabelParsers()), new Object[]{this.myEditorGen.getLabelParsers()});
        }
    }

    private void generateParserProvider() throws UnexpectedBehaviourException, InterruptedException {
        if (this.myEditorGen.getLabelParsers() != null && (this.myEditorGen.getLabelParsers().isExtensibleViaService() || this.existsNonExternalParser())) {
            this.doGenerateJavaClass(this.myEmitters.getParserProviderEmitter(), this.myEditorGen.getLabelParsers().getQualifiedClassName(), new Object[]{this.myEditorGen.getLabelParsers()});
        }
    }

    private boolean existsNonExternalParser() {
        for (GenParserImplementation pi : this.myEditorGen.getLabelParsers().getImplementations()) {
            if (pi instanceof ExternalParser) continue;
            return true;
        }
        return false;
    }

    private void generateElementInitializers() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getElementInitializersEmitter(), String.valueOf(this.myDiagram.getElementInitializersPackageName()) + '.' + this.myDiagram.getElementInitializersClassName(), new Object[]{this.myDiagram});
    }

    private void generateElementTypes() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getElementTypesEmitter(), this.myDiagram.getElementTypesQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateViewProvider() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getViewProviderEmitter(), this.myDiagram.getNotationViewProviderQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateEditPartProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getEditPartProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getEditPartProviderClassName(), this.myDiagram);
    }

    private void generateModelingAssistantProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getModelingAssistantProviderEmitter(), this.myDiagram.getModelingAssistantProviderQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateIconProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getIconProviderEmitter(), this.myDiagram.getIconProviderQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateValidationProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getValidationProviderEmitter(), this.myDiagram.getValidationProviderQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateValidationDecoratorProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getValidationDecoratorProviderEmitter(), this.myDiagram.getValidationDecoratorProviderQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateShortcutsDecoratorProvider() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getShortcutsDecoratorProviderEmitter(), this.myDiagram.getShortcutsDecoratorProviderQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateShortcutPropertyTester() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getShortcutPropertyTesterEmitter(), this.myDiagram.getShortcutPropertyTesterQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateMetricProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getMetricProviderEmitter(), this.myDiagram.getMetricProviderQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateMarkerNavigationProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getMarkerNavigationProviderEmitter(), this.myDiagram.getMarkerNavigationProviderQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateValidateAction() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getValidateActionEmitter(), this.myEmitters.getValidateActionName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generateValidationMarker() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getValidationMarkerEmitter(), this.myEmitters.getValidationMarkerName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generateModelElementSelectionPage() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getModelElementSelectionPageEmitter(), this.myEmitters.getModelElementSelectionPageName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generateNewDiagramFileWizard() throws UnexpectedBehaviourException, InterruptedException {
        if (!this.myDiagram.isSynchronized()) {
            this.doGenerateJavaClass(this.myEmitters.getDiagramContentInitializerEmitter(), this.myDiagram.getDiagramContentInitializerQualifiedClassName(), new Object[]{this.myDiagram});
        }
        this.doGenerateJavaClass(this.myEmitters.getNewDiagramFileWizardEmitter(), this.myEmitters.getNewDiagramFileWizardName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generatePalette() throws UnexpectedBehaviourException, InterruptedException {
        if (this.myDiagram.getPalette() == null) {
            return;
        }
        this.doGenerateJavaClass(this.myEmitters.getPaletteEmitter(), this.myDiagram.getPalette().getFactoryQualifiedClassName(), new Object[]{this.myDiagram.getPalette()});
    }

    private void generateDiagramEditorUtil() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getDiagramEditorUtilEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getDiagramEditorUtilClassName(), this.myDiagram);
    }

    private void generateVisualIDRegistry() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getVisualIDRegistryEmitter(), this.myDiagram.getVisualIDRegistryQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateCreationWizard() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getCreationWizardEmitter(), this.myDiagram.getCreationWizardQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateCreationWizardPage() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getCreationWizardPageEmitter(), this.myDiagram.getCreationWizardPageQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateDeleteElementAction() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDeleteElementActionEmitter(), this.myEmitters.getDeleteElementActionName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generateDiagramEditorContextMenuProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDiagramEditorContextMenuProviderEmitter(), this.myEmitters.getDiagramEditorContextMenuProviderName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generateEditor() throws InterruptedException {
        GenEditorView editor = this.myEditorGen.getEditor();
        this.doGenerateJavaClass(this.myEmitters.getEditorEmitter(), editor.getQualifiedClassName(), new Object[]{editor});
    }

    private void generateElementChooser() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getElementChooserEmitter(), this.myDiagram.getElementChooserQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateShortcutCreationWizard() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getShortcutCreationWizardEmitter(), this.myEmitters.getShortcutCreationWizardName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generateDocumentProvider() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDocumentProviderEmitter(), this.myDiagram.getDocumentProviderQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateDiagramUpdater() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDiagramUpdaterEmitter(), this.myEditorGen.getDiagramUpdater().getDiagramUpdaterQualifiedClassName(), new Object[]{this.myEditorGen.getDiagramUpdater()});
    }

    private void generateUpdateCommand() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getUpdateCommandEmitter(), this.myEditorGen.getDiagramUpdater().getUpdateCommandQualifiedClassName(), new Object[]{this.myEditorGen.getDiagramUpdater()});
    }

    private void generateNodeDescriptor() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNodeDescriptorEmitter(), this.myEditorGen.getDiagramUpdater().getNodeDescriptorQualifiedClassName(), new Object[]{this.myEditorGen.getDiagramUpdater()});
    }

    private void generateLinkDescriptor() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getLinkDescriptorEmitter(), this.myEditorGen.getDiagramUpdater().getLinkDescriptorQualifiedClassName(), new Object[]{this.myEditorGen.getDiagramUpdater()});
    }

    private void generateActionBarContributor() throws UnexpectedBehaviourException, InterruptedException {
        GenEditorView editor = this.myEditorGen.getEditor();
        this.doGenerateJavaClass(this.myEmitters.getActionBarContributorEmitter(), editor.getActionBarContributorQualifiedClassName(), new Object[]{editor});
    }

    private void generateMatchingStrategy() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getMatchingStrategyEmitter(), this.myDiagram.getMatchingStrategyQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateNavigatorContentProvider() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNavigatorContentProviderEmitter(), this.myEditorGen.getNavigator().getContentProviderQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateDomainNavigatorContentProvider() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDomainNavigatorContentProviderEmitter(), this.myEditorGen.getNavigator().getDomainContentProviderQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateDomainNavigatorLabelProvider() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDomainNavigatorLabelProviderEmitter(), this.myEditorGen.getNavigator().getDomainLabelProviderQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateDomainNavigatorItem() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDomainNavigatorItemEmitter(), this.myEditorGen.getNavigator().getDomainNavigatorItemQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateURIEditorInputTester() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getURIEditorInputTesterEmitter(), this.myEditorGen.getNavigator().getUriInputTesterQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateNavigatorLabelProvider() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNavigatorLabelProviderEmitter(), this.myEditorGen.getNavigator().getLabelProviderQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateNavigatorLinkHelper() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNavigatorLinkHelperEmitter(), this.myEditorGen.getNavigator().getLinkHelperQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateNavigatorSorter() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNavigatorSorterEmitter(), this.myEditorGen.getNavigator().getSorterQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateNavigatorActionProvider() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNavigatorActionProviderEmitter(), this.myEditorGen.getNavigator().getActionProviderQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateAbstractNavigatorItem() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getAbstractNavigatorItemEmitter(), this.myEditorGen.getNavigator().getAbstractNavigatorItemQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateNavigatorGroup() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNavigatorGroupEmitter(), this.myEditorGen.getNavigator().getNavigatorGroupQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateNavigatorItem() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNavigatorItemEmitter(), this.myEditorGen.getNavigator().getNavigatorItemQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateNavigatorGroupIcons() throws InterruptedException, UnexpectedBehaviourException {
        HashSet<String> groupIcons = new HashSet<String>();
        for (GenNavigatorChildReference nextReference : this.myEditorGen.getNavigator().getChildReferences()) {
            if (nextReference.getGroupIcon() == null || nextReference.getGroupIcon().length() <= 0) continue;
            groupIcons.add(nextReference.getGroupIcon());
        }
        for (String iconPath : groupIcons) {
            this.generateGroupIcon(new Path(iconPath));
        }
    }

    protected void generatePropertySheetSections() throws UnexpectedBehaviourException, InterruptedException {
        if (this.myEditorGen.getPropertySheet().isNeedsCaption()) {
            this.internalGenerateJavaClass(this.myEmitters.getPropertySheetLabelProviderEmitter(), this.myEditorGen.getPropertySheet().getLabelProviderQualifiedClassName(), this.myEditorGen.getPropertySheet());
        }
        for (GenPropertyTab tab : this.myEditorGen.getPropertySheet().getTabs()) {
            if (!(tab instanceof GenCustomPropertyTab) || !((GenCustomPropertyTab)tab).isGenerateBoilerplate()) continue;
            this.internalGenerateJavaClass(this.myEmitters.getPropertySectionEmitter(), ((GenCustomPropertyTab)tab).getQualifiedClassName(), tab);
        }
    }

    private void generateExpressionProviders() throws UnexpectedBehaviourException, InterruptedException {
        GenExpressionProviderContainer providerContainer = this.myEditorGen.getExpressionProviders();
        boolean needAbstractExpression = false;
        for (GenExpressionProviderBase nextProvider : providerContainer.getProviders()) {
            if (!(nextProvider instanceof GenExpressionInterpreter)) continue;
            TextEmitter providerEmitter = null;
            if (GenLanguage.OCL_LITERAL.equals((Object)nextProvider.getLanguage())) {
                providerEmitter = this.myEmitters.getOCLExpressionFactoryEmitter();
                needAbstractExpression = true;
            } else if (GenLanguage.REGEXP_LITERAL.equals((Object)nextProvider.getLanguage()) || GenLanguage.NREGEXP_LITERAL.equals((Object)nextProvider.getLanguage())) {
                providerEmitter = this.myEmitters.getRegexpExpressionFactoryEmitter();
                needAbstractExpression = true;
            }
            GenExpressionInterpreter interpreter = (GenExpressionInterpreter)nextProvider;
            if (providerEmitter == null) continue;
            this.doGenerateJavaClass(providerEmitter, interpreter.getQualifiedClassName(), new Object[]{interpreter});
        }
        if (needAbstractExpression) {
            this.doGenerateJavaClass(this.myEmitters.getAbstractExpressionEmitter(), providerContainer.getAbstractExpressionQualifiedClassName(), new Object[]{this.myDiagram});
        }
    }

    private void generateModelAccessFacility() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getModelAccessFacilityEmitter(), this.myEditorGen.getModelAccess().getQualifiedClassName(), new Object[]{this.myEditorGen.getModelAccess()});
    }

    private void generateShortcutIcon() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateBinaryFile(this.myEmitters.getShortcutImageEmitter(), new Path("icons/shortcut.gif"), null);
    }

    private void generateGroupIcon(Path groupIconPath) throws InterruptedException, UnexpectedBehaviourException {
        this.doGenerateBinaryFile(this.myEmitters.getGroupIconEmitter(), groupIconPath, null);
    }

    private void generateDiagramIcon(String path) throws UnexpectedBehaviourException, InterruptedException {
        Object[] args = new Object[]{this.myDiagram.getDomainDiagramElement() == null ? this.myEditorGen.getDiagramFileExtension() : this.myDiagram.getDomainDiagramElement().getGenPackage().getPrefix()};
        this.doGenerateBinaryFile(this.myEmitters.getDiagramIconEmitter(), new Path(path), args);
    }

    private void generateWizardBanner() throws UnexpectedBehaviourException, InterruptedException {
        String stem = this.myDiagram.getDomainDiagramElement() == null ? "" : this.myDiagram.getDomainDiagramElement().getGenPackage().getPrefix();
        Object[] args = new Object[]{stem.length() == 0 ? this.myEditorGen.getDiagramFileExtension() : stem};
        this.doGenerateBinaryFile(this.myEmitters.getWizardBannerImageEmitter(), new Path("icons/wizban/New" + stem + "Wizard.gif"), args);
    }

    private void generateExternalizationSupport() throws UnexpectedBehaviourException, InterruptedException {
        String packageName = this.myEditorGen.getEditor().getPackageName();
        String messagesClassName = "Messages";
        this.doGenerateJavaClass(this.myEmitters.getExternalizeEmitter(), packageName, messagesClassName, new Object[]{this.myEditorGen});
        this.doGenerateFile(this.myEmitters.getMessagesEmitter(), (IPath)new Path(String.valueOf(messagesClassName.toLowerCase()) + ".properties"), new Object[]{this.myEditorGen});
    }

    private void generatePlugin() throws UnexpectedBehaviourException, InterruptedException {
        this.generateActivator();
        this.generateBundleManifest();
        this.generatePluginXml();
        this.generatePluginProperties();
        this.generateBuildProperties();
        this.generateOptionsFile();
    }

    private void generateActivator() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getActivatorEmitter(), this.myEditorGen.getPlugin().getActivatorQualifiedClassName(), new Object[]{this.myEditorGen.getPlugin()});
    }

    private void generateBundleManifest() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateFile(this.myEmitters.getBundleManifestEmitter(), (IPath)new Path("META-INF/MANIFEST.MF"), new Object[]{this.myDiagram.getEditorGen().getPlugin()});
    }

    private void generatePluginXml() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateFile(this.myEmitters.getPluginXmlEmitter(), (IPath)new Path("plugin.xml"), new Object[]{this.myDiagram.getEditorGen().getPlugin()});
    }

    private void generatePluginProperties() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateFile(this.myEmitters.getPluginPropertiesEmitter(), (IPath)new Path("plugin.properties"), new Object[]{this.myDiagram.getEditorGen().getPlugin()});
    }

    private void generateBuildProperties() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateFile(this.myEmitters.getBuildPropertiesEmitter(), (IPath)new Path("build.properties"), new Object[]{this.myEditorGen.getPlugin()});
    }

    private void generateOptionsFile() throws InterruptedException, UnexpectedBehaviourException {
        this.doGenerateFile(this.myEmitters.getOptionsFileEmitter(), (IPath)new Path(".options"), new Object[]{this.myEditorGen.getPlugin()});
    }

    private void generateApplication() throws UnexpectedBehaviourException, InterruptedException {
        GenApplication application = this.myEditorGen.getApplication();
        if (application != null) {
            this.generateApplication(application);
            this.generateActionBarAdvisor(application);
            this.generatePerspective(application);
            this.generateWorkbenchAdvisor(application);
            this.generateWorkbenchWindowAdvisor(application);
            this.generateWizardNewFileCreationPage(application);
        }
    }

    private void generateApplication(GenApplication application) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getApplicationEmitter(), application.getQualifiedClassName(), new Object[]{application});
    }

    private void generateActionBarAdvisor(GenApplication application) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getActionBarAdvisorEmitter(), application.getActionBarAdvisorQualifiedClassName(), new Object[]{application});
    }

    private void generatePerspective(GenApplication application) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getPerspectiveEmitter(), application.getPerspectiveQualifiedClassName(), new Object[]{application});
    }

    private void generateWorkbenchAdvisor(GenApplication application) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getWorkbenchAdvisorEmitter(), application.getWorkbenchAdvisorQualifiedClassName(), new Object[]{application});
    }

    private void generateWorkbenchWindowAdvisor(GenApplication application) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getWorkbenchWindowAdvisorEmitter(), application.getWorkbenchWindowAdvisorQualifiedClassName(), new Object[]{application});
    }

    private void generateWizardNewFileCreationPage(GenApplication application) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getWizardNewFileCreationPageEmitter(), application.getPackageName(), "WizardNewFileCreationPage", new Object[]{application});
    }

    private void generateActions() throws UnexpectedBehaviourException, InterruptedException {
        HashSet<GenContributionItem> processedItems = new HashSet<GenContributionItem>();
        for (GenContributionManager m : this.myEditorGen.getContextMenus()) {
            LinkedList<GenContributionItem> items = new LinkedList<GenContributionItem>((Collection<GenContributionItem>)m.getItems());
            while (!items.isEmpty()) {
                GenContributionItem ci = items.removeFirst();
                if (ci instanceof GenCustomAction && ((GenCustomAction)ci).isGenerateBoilerplate() && !processedItems.contains(ci)) {
                    this.doGenerateJavaClass(this.myEmitters.getCustomActionEmitter(), ((GenCustomAction)ci).getQualifiedClassName(), new Object[]{ci});
                    processedItems.add(ci);
                    continue;
                }
                if (ci instanceof GenContributionManager) {
                    items.addAll((Collection<GenContributionItem>)((GenContributionManager)((Object)ci)).getItems());
                    continue;
                }
                if (ci instanceof GenSharedContributionItem) {
                    items.addLast(((GenSharedContributionItem)ci).getActualItem());
                    continue;
                }
                if (!(ci instanceof GenAction)) continue;
                this.doGenerateJavaClass(this.myEmitters.getPredefinedActionEmitter(), ((GenAction)ci).getQualifiedClassName(), new Object[]{ci});
                processedItems.add(ci);
            }
        }
    }

    private void internalGenerateJavaClass(TextEmitter emitter, String packageName, String className, Object argument) throws InterruptedException {
        ImportUtil importUtil = new ImportUtil(packageName, className);
        this.doGenerateJavaClass(emitter, packageName, className, new Object[]{argument, importUtil});
    }

    private void internalGenerateJavaClass(TextEmitter emitter, String qualifiedName, Object argument) throws InterruptedException {
        this.internalGenerateJavaClass(emitter, CodeGenUtil.getPackageName((String)qualifiedName), CodeGenUtil.getSimpleClassName((String)qualifiedName), argument);
    }

    private IPath guessProjectLocation(String projectName) {
        if (this.myEditorGen.getDomainGenModel() == null) {
            return null;
        }
        Path modelProjectPath = new Path(this.myEditorGen.getDomainGenModel().getModelDirectory());
        return this.guessNewProjectLocation(modelProjectPath, projectName);
    }

    protected void setupProgressMonitor() {
        GeneratorBase.Counter c = new GeneratorBase.Counter();
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenNode(), 7);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenChildLabelNode(), 5);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenLink(), 6);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenLinkLabel(), 2);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenCompartment(), 3);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenDiagram(), 30);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenEditorGenerator(), 2);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenPlugin(), 6);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenNavigator(), 3);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenNavigatorChildReference(), 1);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenCustomPropertyTab(), 1);
        c.registerFactor(GMFGenPackage.eINSTANCE.getBehaviour(), 1);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenMetricContainer(), 1);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenExpressionProviderContainer(), 1);
        c.registerFactor(GMFGenPackage.eINSTANCE.getPalette(), 1);
        this.setupProgressMonitor(null, c.getTotal((EObject)this.myEditorGen));
    }

    private static boolean needsGraphicalNodeEditPolicy(GenNode node) {
        return node.getModelFacet() != null && !node.getReorientedIncomingLinks().isEmpty();
    }
}

