/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.tr;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.Palette;
import org.eclipse.gmf.codegen.gmfgen.ToolEntry;
import org.eclipse.gmf.codegen.gmfgen.ToolGroup;
import org.eclipse.gmf.codegen.gmfgen.ToolGroupItem;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramGenModelTransformer;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.naming.NamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediator;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediatorImpl;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.gmf.tests.Utils;
import org.eclipse.gmf.tests.tr.AbstractMappingTransformerTest;

public abstract class GenModelTransformerTest
extends AbstractMappingTransformerTest {
    private NamingStrategy myNamingStrategy;
    protected GenEditorGenerator transformationResult;

    public GenModelTransformerTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        DiagramRunTimeModelHelper drtModelHelper = this.getRTHelper();
        Mapping m = this.getMapping();
        GenModelNamingMediatorImpl namingMediator = new GenModelNamingMediatorImpl();
        this.myNamingStrategy = namingMediator.getEditPart();
        DiagramGenModelTransformer t = new DiagramGenModelTransformer(drtModelHelper, (GenModelNamingMediator)namingMediator);
        t.setEMFGenModel(Utils.createGenModel(m.getDiagram().getDomainModel(), Utils.createUniquePluginID()));
        t.transform(m);
        this.transformationResult = t.getResult();
        namingMediator.reset();
    }

    public void testGenModelTransform() {
        GenModelTransformerTest.assertNotNull((String)"GenEditorGenerator is expected as result of mapping transformation", (Object)this.transformationResult);
        GenModelTransformerTest.assertNotNull((String)"GenDiagram is expected to be set...", (Object)this.transformationResult.getDiagram());
        GenModelTransformerTest.assertNotNull((String)"... as well as GenPlugin is expected to be set", (Object)this.transformationResult.getPlugin());
        GenModelTransformerTest.assertNotNull((String)"Diagram filename extension not set", (Object)this.transformationResult.getDiagramFileExtension());
        GenNode genNode = (GenNode)this.findGenBaseElement(this.transformationResult.getDiagram().getTopLevelNodes(), this.getEditPartNameStrategy().get(this.getNodeMapping()));
        GenModelTransformerTest.assertNotNull((String)"Result model contains no GenNode for nodeMapping", (Object)genNode);
        GenLink genLink = (GenLink)this.findGenBaseElement(this.transformationResult.getDiagram().getLinks(), this.getEditPartNameStrategy().get(this.getLinkMapping()));
        GenModelTransformerTest.assertNotNull((String)"Result model contains no GenLink for linkMapping", (Object)genLink);
    }

    public void testCreatedPalette() {
        Palette palette = this.transformationResult.getDiagram().getPalette();
        Iterator itN = this.getMapping().getNodes().iterator();
        while (itN.hasNext()) {
            TopNodeReference topNode = (TopNodeReference)itN.next();
            NodeMapping nodeMapping = topNode.getChild();
            GenModelTransformerTest.assertEquals((int)(nodeMapping.getTool() != null ? 1 : 0), (int)this.countUses(nodeMapping, palette));
        }
        Iterator itL = this.getMapping().getLinks().iterator();
        while (itL.hasNext()) {
            LinkMapping linkMapping = (LinkMapping)itL.next();
            GenModelTransformerTest.assertEquals((int)(linkMapping.getTool() != null ? 1 : 0), (int)this.countUses(linkMapping, palette));
        }
    }

    private GenCommonBase findGenBaseElement(EList genBaseElements, String epName) {
        Iterator it = genBaseElements.iterator();
        while (it.hasNext()) {
            GenCommonBase next = (GenCommonBase)it.next();
            if (!next.getEditPartClassName().equals(epName)) continue;
            return next;
        }
        return null;
    }

    private int countUses(NodeMapping mappingEntry, Palette palette) {
        int uses = 0;
        String epName = this.getEditPartNameStrategy().get(mappingEntry);
        Iterator itG = palette.getGroups().iterator();
        while (itG.hasNext()) {
            ToolGroup nextGroup = (ToolGroup)itG.next();
            Iterator itE = nextGroup.getEntries().iterator();
            while (itE.hasNext()) {
                ToolGroupItem item = (ToolGroupItem)itE.next();
                if (!(item instanceof ToolEntry)) continue;
                Iterator itN = ((ToolEntry)item).getGenNodes().iterator();
                while (itN.hasNext()) {
                    GenNode genNode = (GenNode)itN.next();
                    if (!genNode.getEditPartClassName().equals(epName)) continue;
                    ++uses;
                }
            }
        }
        return uses;
    }

    private int countUses(LinkMapping mappingEntry, Palette palette) {
        int uses = 0;
        String epName = this.getEditPartNameStrategy().get(mappingEntry);
        Iterator itG = palette.getGroups().iterator();
        while (itG.hasNext()) {
            ToolGroup nextGroup = (ToolGroup)itG.next();
            Iterator itE = nextGroup.getEntries().iterator();
            while (itE.hasNext()) {
                ToolGroupItem item = (ToolGroupItem)itE.next();
                if (!(item instanceof ToolEntry)) continue;
                Iterator itL = ((ToolEntry)item).getGenLinks().iterator();
                while (itL.hasNext()) {
                    GenLink genLink = (GenLink)itL.next();
                    if (!genLink.getEditPartClassName().equals(epName)) continue;
                    ++uses;
                }
            }
        }
        return uses;
    }

    protected abstract DiagramRunTimeModelHelper getRTHelper();

    protected final NamingStrategy getEditPartNameStrategy() {
        return this.myNamingStrategy;
    }
}

