/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.graphdef.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureAccessor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.util.FigureQualifiedNameSwitch;
import org.eclipse.gmf.graphdef.codegen.NamingStrategy;
import org.eclipse.gmf.graphdef.codegen.StandaloneGenerator;
import org.eclipse.gmf.internal.graphdef.codegen.DiagramElementsCopier;

public class CanvasProcessor
extends StandaloneGenerator.Processor {
    private final DiagramElementsCopier myElementCopier;
    private StandaloneGenerator.ProcessorCallback myCallback;
    final Canvas myInput;
    private Canvas myOutcome;
    private FigureGallery myOutcomeGallery;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.graphdef.codegen.CanvasProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public CanvasProcessor(Canvas input) {
        if (!$assertionsDisabled && input == null) {
            throw new AssertionError();
        }
        this.myInput = input;
        this.myElementCopier = new DiagramElementsCopier();
    }

    public Canvas getOutcome() {
        return this.myOutcome;
    }

    public void go(StandaloneGenerator.ProcessorCallback callback, StandaloneGenerator.Config config) throws InterruptedException {
        this.myCallback = callback;
        this.myOutcomeGallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
        this.myOutcomeGallery.setName(this.myInput.getFigures().size() == 1 ? ((FigureGallery)this.myInput.getFigures().get(0)).getName() : "GeneratedGallery");
        this.myOutcomeGallery.setImplementationBundle(config.getPluginID());
        this.handleNodes();
        this.handleLinks();
        this.handleCompartments();
        this.handleLabels();
        this.myOutcome = GMFGraphFactory.eINSTANCE.createCanvas();
        this.myOutcome.setName(this.myInput.getName());
        this.myOutcome.getFigures().add((Object)this.myOutcomeGallery);
        this.myOutcome.getCompartments().addAll(this.myElementCopier.copyAll((Collection)this.myInput.getCompartments()));
        this.myOutcome.getLabels().addAll(this.myElementCopier.copyAll((Collection)this.myInput.getLabels()));
        this.myOutcome.getNodes().addAll(this.myElementCopier.copyAll((Collection)this.myInput.getNodes()));
        this.myOutcome.getConnections().addAll(this.myElementCopier.copyAll((Collection)this.myInput.getConnections()));
        if (!this.myOutcome.eContents().isEmpty()) {
            this.myElementCopier.copyReferences();
        }
        this.myCallback = null;
    }

    public String[] getRequiredBundles(FigureQualifiedNameSwitch fqnSwitch) {
        ArrayList<String> rv = new ArrayList<String>();
        Iterator galleries = this.myInput.getFigures().iterator();
        while (galleries.hasNext()) {
            FigureGallery next = (FigureGallery)galleries.next();
            rv.addAll(Arrays.asList(fqnSwitch.getDependencies(next)));
        }
        return rv.toArray(new String[rv.size()]);
    }

    private void handleNodes() throws InterruptedException {
        Iterator it = this.myInput.getNodes().iterator();
        while (it.hasNext()) {
            Node next = (Node)it.next();
            this.handleFigure(next.getNodeFigure());
        }
    }

    private void handleLinks() throws InterruptedException {
        Iterator it = this.myInput.getConnections().iterator();
        while (it.hasNext()) {
            Connection next = (Connection)it.next();
            this.handleFigure(next.getConnectionFigure());
        }
    }

    private void handleCompartments() throws InterruptedException {
        Iterator it = this.myInput.getCompartments().iterator();
        while (it.hasNext()) {
            Compartment next = (Compartment)it.next();
            if (next.getFigure() instanceof Figure) {
                this.handleFigure((Figure)next.getFigure());
                continue;
            }
            throw new IllegalStateException("Don't support accessors for compartments yet");
        }
    }

    private void handleLabels() throws InterruptedException {
        Iterator it = this.myInput.getLabels().iterator();
        while (it.hasNext()) {
            DiagramLabel next = (DiagramLabel)it.next();
            if (next.getFigure() instanceof FigureAccessor) {
                if (!$assertionsDisabled && !this.myElementCopier.containsKey(next.getFigure())) {
                    throw new AssertionError((Object)"Should be copied as part of previously referenced CustomFigure");
                }
                continue;
            }
            if (!$assertionsDisabled && !(next.getFigure() instanceof Figure)) {
                throw new AssertionError();
            }
            Figure f = (Figure)next.getFigure();
            if (this.isInsideProcessedFigure(f)) {
                FigureAccessor accessor = GMFGraphFactory.eINSTANCE.createFigureAccessor();
                accessor.setAccessor(NamingStrategy.INSTANCE.getChildFigureGetterName(f));
                this.myElementCopier.put(f, accessor);
                Figure parent = f;
                while (!this.myElementCopier.containsKey(parent = parent.getParent())) {
                }
                if (!$assertionsDisabled && !(this.myElementCopier.get(parent) instanceof CustomFigure)) {
                    throw new AssertionError((Object)"We used to keep custom figures only in the mirrored gallery");
                }
                ((CustomFigure)this.myElementCopier.get(parent)).getCustomChildren().add((Object)accessor);
                continue;
            }
            this.handleFigure(f);
        }
    }

    private boolean isInsideProcessedFigure(Figure f) {
        return EcoreUtil.isAncestor((Collection)this.myElementCopier.keySet(), (EObject)f);
    }

    private void handleFigure(Figure figure) throws InterruptedException {
        if (figure instanceof CustomFigure && CanvasProcessor.isPlainBareCustomFigure((CustomFigure)figure)) {
            this.myOutcomeGallery.getFigures().add((Object)this.myElementCopier.copy((EObject)figure));
        } else {
            String fqn = this.myCallback.visitFigure(figure);
            this.myElementCopier.registerSubstitution(figure, this.createCustomFigure(figure, fqn));
        }
    }

    private static boolean isPlainBareCustomFigure(CustomFigure figure) {
        if (!figure.getChildren().isEmpty()) {
            return false;
        }
        LinkedList featuresToCheck = new LinkedList(figure.eClass().getEAllStructuralFeatures());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getIdentity_Name());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getFigure_Children());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getFigureMarker_Parent());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getFigureHandle_ReferencingElements());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getCustomClass_BundleName());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getCustomClass_QualifiedClassName());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getCustomFigure_CustomChildren());
        Iterator it = featuresToCheck.iterator();
        while (it.hasNext()) {
            EStructuralFeature next = (EStructuralFeature)it.next();
            if (next.isDerived() || !figure.eIsSet(next)) continue;
            return false;
        }
        return true;
    }

    private CustomFigure createCustomFigure(Figure original, String fqn) {
        CustomFigure cf = DiagramElementsCopier.createCustomFigure(original);
        cf.setName(original.getName());
        cf.setQualifiedClassName(fqn);
        this.myOutcomeGallery.getFigures().add((Object)cf);
        return cf;
    }
}

