/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.lite.svg;

import junit.framework.TestCase;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class AbstractSVGFigureTest
extends TestCase {
    private static final int HEIGHT = 200;
    private static final int WIDTH = 200;
    public static final String BOX_URI = "platform:/plugin/org.eclipse.gmf.tests.lite/images/box.svg";
    public static final String GROUP_URI = "platform:/plugin/org.eclipse.gmf.tests.lite/images/group.svg";
    private Image image;
    private SWTGraphics graphics;
    protected RectangleFigure parentFigure;
    private GC gc;
    private LightweightSystem lws;

    public AbstractSVGFigureTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.lws = new LightweightSystem();
        this.lws.getRootFigure().setSize(200, 200);
        this.image = new Image((Device)Display.getDefault(), 200, 200);
        this.gc = new GC((Drawable)this.image);
        this.gc.setAntialias(0);
        this.graphics = new SWTGraphics(this.gc);
        this.parentFigure = new RectangleFigure();
        this.parentFigure.setLayoutManager((LayoutManager)new FlowLayout());
        this.parentFigure.setBackgroundColor(ColorConstants.yellow);
        this.parentFigure.setForegroundColor(ColorConstants.green);
        this.parentFigure.setLineWidth(1);
        this.lws.getRootFigure().add((IFigure)this.parentFigure);
    }

    protected IFigure getParentFigure() {
        return this.parentFigure;
    }

    protected void tearDown() throws Exception {
        this.graphics.dispose();
        this.gc.dispose();
        this.image.dispose();
    }

    protected void paintImage() {
        this.lws.getUpdateManager().performUpdate();
        this.lws.getRootFigure().paint((Graphics)this.graphics);
    }

    protected final void dumpCanvas() {
        this.dumpCanvas("canvas" + System.currentTimeMillis());
    }

    protected void dumpCanvas(String filePrefix) {
        String fileName = String.valueOf(filePrefix) + ".png";
        IPath root = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (root != null) {
            fileName = root.append(fileName).toString();
        }
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{this.image.getImageData()};
        loader.save(fileName, 5);
    }

    protected void assertColor(int x, int y, RGB expectedColor) {
        ImageData data = this.image.getImageData();
        int pixel = data.getPixel(x, y);
        RGB currentColor = data.palette.getRGB(pixel);
        AbstractSVGFigureTest.assertEquals((Object)expectedColor, (Object)currentColor);
    }
}

