/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.CSSEngineListener;
import org.apache.batik.css.engine.CSSEngineUserAgent;
import org.apache.batik.css.engine.CSSImportNode;
import org.apache.batik.css.engine.CSSImportedElementRoot;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.CSSStyleSheetNode;
import org.apache.batik.css.engine.FontFaceRule;
import org.apache.batik.css.engine.ImportRule;
import org.apache.batik.css.engine.MediaRule;
import org.apache.batik.css.engine.Messages;
import org.apache.batik.css.engine.Rule;
import org.apache.batik.css.engine.StringIntMap;
import org.apache.batik.css.engine.StyleDeclaration;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.StyleRule;
import org.apache.batik.css.engine.StyleSheet;
import org.apache.batik.css.engine.sac.CSSConditionFactory;
import org.apache.batik.css.engine.sac.CSSSelectorFactory;
import org.apache.batik.css.engine.sac.ExtendedSelector;
import org.apache.batik.css.engine.value.ComputedValue;
import org.apache.batik.css.engine.value.InheritValue;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.util.ParsedURL;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public abstract class CSSEngine {
    protected List fontFaces = new LinkedList();
    CSSEngineUserAgent userAgent = null;
    protected CSSContext cssContext;
    protected Document document;
    protected URL documentURI;
    protected StringIntMap indexes;
    protected StringIntMap shorthandIndexes;
    protected ValueManager[] valueManagers;
    protected ShorthandManager[] shorthandManagers;
    protected ExtendedParser parser;
    protected String[] pseudoElementNames;
    protected int fontSizeIndex = -1;
    protected int lineHeightIndex = -1;
    protected int colorIndex = -1;
    protected StyleSheet userAgentStyleSheet;
    protected StyleSheet userStyleSheet;
    protected SACMediaList media;
    protected List styleSheetNodes;
    protected String styleNamespaceURI;
    protected String styleLocalName;
    protected String classNamespaceURI;
    protected String classLocalName;
    protected Set nonCSSPresentationalHints;
    protected String nonCSSPresentationalHintsNamespaceURI;
    protected StyleDeclarationDocumentHandler styleDeclarationDocumentHandler = new StyleDeclarationDocumentHandler();
    protected StyleDeclarationUpdateHandler styleDeclarationUpdateHandler;
    protected StyleSheetDocumentHandler styleSheetDocumentHandler = new StyleSheetDocumentHandler();
    protected StyleDeclarationBuilder styleDeclarationBuilder = new StyleDeclarationBuilder();
    protected CSSStylableElement element;
    protected URL cssBaseURI;
    protected String alternateStyleSheet;
    protected EventListener domAttrModifiedListener;
    protected EventListener domNodeInsertedListener;
    protected EventListener domNodeRemovedListener;
    protected EventListener domSubtreeModifiedListener;
    protected EventListener domCharacterDataModifiedListener;
    protected boolean styleSheetRemoved;
    protected Node removedStylableElementSibling;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected Set selectorAttributes;
    protected final int[] ALL_PROPERTIES;
    protected CSSConditionFactory cssConditionFactory;
    protected static final CSSEngineListener[] LISTENER_ARRAY = new CSSEngineListener[0];

    public List getFontFaces() {
        return this.fontFaces;
    }

    public static CSSStylableElement getParentCSSStylableElement(Element element) {
        Element element2 = CSSEngine.getParentElement(element);
        while (element2 != null) {
            if (element2 instanceof CSSStylableElement) {
                return (CSSStylableElement)element2;
            }
            element2 = CSSEngine.getParentElement(element2);
        }
        return null;
    }

    public static Element getParentElement(Element element) {
        Node node = element.getParentNode();
        while (node != null) {
            if ((node = CSSEngine.getLogicalParentNode(node)).getNodeType() == 1) {
                return (Element)node;
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static Node getLogicalParentNode(Node node) {
        Node node2 = node;
        if (node2 != null) {
            if (node2 instanceof CSSImportedElementRoot) {
                return ((CSSImportedElementRoot)node2).getCSSParentElement();
            }
            return node2;
        }
        return null;
    }

    public static CSSImportedElementRoot getImportedChild(Node node) {
        if (node instanceof CSSImportNode) {
            CSSImportNode cSSImportNode = (CSSImportNode)node;
            CSSImportedElementRoot cSSImportedElementRoot = cSSImportNode.getCSSImportedElementRoot();
            return cSSImportedElementRoot;
        }
        return null;
    }

    protected CSSEngine(Document document, URL uRL, ExtendedParser extendedParser, ValueManager[] valueManagerArray, ShorthandManager[] shorthandManagerArray, String[] stringArray, String string, String string2, String string3, String string4, boolean bl, String string5, CSSContext cSSContext) {
        this.document = document;
        this.documentURI = uRL;
        this.parser = extendedParser;
        this.pseudoElementNames = stringArray;
        this.styleNamespaceURI = string;
        this.styleLocalName = string2;
        this.classNamespaceURI = string3;
        this.classLocalName = string4;
        this.cssContext = cSSContext;
        this.cssConditionFactory = new CSSConditionFactory(string3, string4, null, "id");
        int n = valueManagerArray.length;
        this.indexes = new StringIntMap(n);
        this.valueManagers = valueManagerArray;
        int n2 = n - 1;
        while (n2 >= 0) {
            String string6 = valueManagerArray[n2].getPropertyName();
            this.indexes.put(string6, n2);
            if (this.fontSizeIndex == -1 && string6.equals("font-size")) {
                this.fontSizeIndex = n2;
            }
            if (this.lineHeightIndex == -1 && string6.equals("line-height")) {
                this.lineHeightIndex = n2;
            }
            if (this.colorIndex == -1 && string6.equals("color")) {
                this.colorIndex = n2;
            }
            --n2;
        }
        n = shorthandManagerArray.length;
        this.shorthandIndexes = new StringIntMap(n);
        this.shorthandManagers = shorthandManagerArray;
        int n3 = n - 1;
        while (n3 >= 0) {
            this.shorthandIndexes.put(shorthandManagerArray[n3].getPropertyName(), n3);
            --n3;
        }
        if (bl) {
            this.nonCSSPresentationalHints = new HashSet(valueManagerArray.length + shorthandManagerArray.length);
            this.nonCSSPresentationalHintsNamespaceURI = string5;
            n = valueManagerArray.length;
            int n4 = 0;
            while (n4 < n) {
                String string7 = valueManagerArray[n4].getPropertyName();
                this.nonCSSPresentationalHints.add(string7);
                ++n4;
            }
            n = shorthandManagerArray.length;
            int n5 = 0;
            while (n5 < n) {
                String string8 = shorthandManagerArray[n5].getPropertyName();
                this.nonCSSPresentationalHints.add(string8);
                ++n5;
            }
        }
        if (this.cssContext.isDynamic() && this.document instanceof EventTarget) {
            EventTarget eventTarget = (EventTarget)((Object)this.document);
            this.domAttrModifiedListener = new DOMAttrModifiedListener();
            eventTarget.addEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            this.domNodeInsertedListener = new DOMNodeInsertedListener();
            eventTarget.addEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            this.domNodeRemovedListener = new DOMNodeRemovedListener();
            eventTarget.addEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            this.domSubtreeModifiedListener = new DOMSubtreeModifiedListener();
            eventTarget.addEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            this.domCharacterDataModifiedListener = new DOMCharacterDataModifiedListener();
            eventTarget.addEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
            this.styleDeclarationUpdateHandler = new StyleDeclarationUpdateHandler();
        }
        this.ALL_PROPERTIES = new int[this.getNumberOfProperties()];
        int n6 = this.getNumberOfProperties() - 1;
        while (n6 >= 0) {
            this.ALL_PROPERTIES[n6] = n6;
            --n6;
        }
    }

    public void dispose() {
        this.setCSSEngineUserAgent(null);
        this.disposeStyleMaps(this.document.getDocumentElement());
        if (this.document instanceof EventTarget) {
            EventTarget eventTarget = (EventTarget)((Object)this.document);
            eventTarget.removeEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            eventTarget.removeEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            eventTarget.removeEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            eventTarget.removeEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            eventTarget.removeEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
        }
    }

    private void disposeStyleMaps(Node node) {
        if (node instanceof CSSStylableElement) {
            ((CSSStylableElement)node).setComputedStyleMap(null, null);
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            CSSImportedElementRoot cSSImportedElementRoot;
            if (node2.getNodeType() == 1) {
                this.disposeStyleMaps(node2);
            }
            if ((cSSImportedElementRoot = CSSEngine.getImportedChild(node2)) != null) {
                this.disposeStyleMaps(cSSImportedElementRoot);
            }
            node2 = node2.getNextSibling();
        }
    }

    public CSSContext getCSSContext() {
        return this.cssContext;
    }

    public Document getDocument() {
        return this.document;
    }

    public int getFontSizeIndex() {
        return this.fontSizeIndex;
    }

    public int getLineHeightIndex() {
        return this.lineHeightIndex;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public int getNumberOfProperties() {
        return this.valueManagers.length;
    }

    public int getPropertyIndex(String string) {
        return this.indexes.get(string);
    }

    public int getShorthandIndex(String string) {
        return this.shorthandIndexes.get(string);
    }

    public String getPropertyName(int n) {
        return this.valueManagers[n].getPropertyName();
    }

    public void setCSSEngineUserAgent(CSSEngineUserAgent cSSEngineUserAgent) {
        this.userAgent = cSSEngineUserAgent;
    }

    public CSSEngineUserAgent getCSSEngineUserAgent() {
        return this.userAgent;
    }

    public void setUserAgentStyleSheet(StyleSheet styleSheet) {
        this.userAgentStyleSheet = styleSheet;
    }

    public void setUserStyleSheet(StyleSheet styleSheet) {
        this.userStyleSheet = styleSheet;
    }

    public ValueManager[] getValueManagers() {
        return this.valueManagers;
    }

    public void setMedia(String string) {
        try {
            this.media = this.parser.parseMedia(string);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = Messages.formatMessage("media.error", new Object[]{string, string2});
            throw new DOMException(12, string3);
        }
    }

    public void setAlternateStyleSheet(String string) {
        this.alternateStyleSheet = string;
    }

    public void importCascadedStyleMaps(Element element, CSSEngine cSSEngine, Element element2) {
        Node node;
        Node node2;
        if (element instanceof CSSStylableElement) {
            node2 = (CSSStylableElement)element;
            node = (CSSStylableElement)element2;
            StyleMap styleMap = cSSEngine.getCascadedStyleMap((CSSStylableElement)node2, null);
            styleMap.setFixedCascadedStyle(true);
            node.setComputedStyleMap(null, styleMap);
            if (this.pseudoElementNames != null) {
                int n = this.pseudoElementNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = this.pseudoElementNames[n2];
                    styleMap = cSSEngine.getCascadedStyleMap((CSSStylableElement)node2, string);
                    node.setComputedStyleMap(string, styleMap);
                    ++n2;
                }
            }
        }
        node2 = element2.getFirstChild();
        node = element.getFirstChild();
        while (node2 != null) {
            if (node.getNodeType() == 1) {
                this.importCascadedStyleMaps((Element)node, cSSEngine, (Element)node2);
            }
            node2 = node2.getNextSibling();
            node = node.getNextSibling();
        }
    }

    public URL getCSSBaseURI() {
        if (this.cssBaseURI == null) {
            this.cssBaseURI = this.element.getCSSBase();
        }
        return this.cssBaseURI;
    }

    public StyleMap getCascadedStyleMap(CSSStylableElement cSSStylableElement, String string) {
        Object object;
        int n = this.getNumberOfProperties();
        final StyleMap styleMap = new StyleMap(n);
        if (this.userAgentStyleSheet != null) {
            object = new ArrayList();
            this.addMatchingRules((List)object, this.userAgentStyleSheet, cSSStylableElement, string);
            this.addRules(cSSStylableElement, string, styleMap, (List)object, (short)0);
        }
        if (this.userStyleSheet != null) {
            object = new ArrayList();
            this.addMatchingRules((List)object, this.userStyleSheet, cSSStylableElement, string);
            this.addRules(cSSStylableElement, string, styleMap, (List)object, (short)8192);
        }
        this.element = cSSStylableElement;
        try {
            String string2;
            Object object2;
            String string3;
            Object object3;
            Object object4;
            int n2;
            Object object5;
            object = new ShorthandManager.PropertyHandler(){

                public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
                    int n = CSSEngine.this.getPropertyIndex(string);
                    if (n != -1) {
                        ValueManager valueManager = CSSEngine.this.valueManagers[n];
                        Value value = valueManager.createValue(lexicalUnit, CSSEngine.this);
                        CSSEngine.this.putAuthorProperty(styleMap, n, value, bl, (short)16384);
                        return;
                    }
                    n = CSSEngine.this.getShorthandIndex(string);
                    if (n == -1) {
                        return;
                    }
                    CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
                }
            };
            if (this.nonCSSPresentationalHints != null) {
                object5 = cSSStylableElement.getAttributes();
                n2 = object5.getLength();
                int n3 = 0;
                while (n3 < n2) {
                    Node node = object5.item(n3);
                    object4 = node.getNodeName();
                    if (this.nonCSSPresentationalHints.contains(object4)) {
                        try {
                            object3 = this.parser.parsePropertyValue(node.getNodeValue());
                            object.property((String)object4, (LexicalUnit)object3, false);
                        }
                        catch (Exception exception) {
                            string3 = exception.getMessage();
                            if (string3 == null) {
                                string3 = "";
                            }
                            object2 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                            String string4 = Messages.formatMessage("property.syntax.error.at", new Object[]{object2, object4, node.getNodeValue(), string3});
                            DOMException dOMException = new DOMException(12, string4);
                            if (this.userAgent == null) {
                                throw dOMException;
                            }
                            this.userAgent.displayError(dOMException);
                        }
                    }
                    ++n3;
                }
            }
            if ((n2 = (object5 = this.getStyleSheetNodes()).size()) > 0) {
                ArrayList arrayList = new ArrayList();
                int n4 = 0;
                while (n4 < n2) {
                    object4 = (CSSStyleSheetNode)object5.get(n4);
                    object3 = object4.getCSSStyleSheet();
                    if (object3 != null && (!((StyleSheet)object3).isAlternate() || ((StyleSheet)object3).getTitle() == null || ((StyleSheet)object3).getTitle().equals(this.alternateStyleSheet)) && this.mediaMatch(((StyleSheet)object3).getMedia())) {
                        this.addMatchingRules(arrayList, (StyleSheet)object3, cSSStylableElement, string);
                    }
                    ++n4;
                }
                this.addRules(cSSStylableElement, string, styleMap, arrayList, (short)24576);
            }
            if (this.styleLocalName != null && (string2 = cSSStylableElement.getAttributeNS(this.styleNamespaceURI, this.styleLocalName)).length() > 0) {
                try {
                    this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                    this.parser.setConditionFactory(this.cssConditionFactory);
                    this.styleDeclarationDocumentHandler.styleMap = styleMap;
                    this.parser.setDocumentHandler(this.styleDeclarationDocumentHandler);
                    this.parser.parseStyleDeclaration(string2);
                    this.styleDeclarationDocumentHandler.styleMap = null;
                }
                catch (Exception exception) {
                    object4 = exception.getMessage();
                    if (object4 == null) {
                        object4 = "";
                    }
                    object3 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                    string3 = Messages.formatMessage("style.syntax.error.at", new Object[]{object3, this.styleLocalName, string2, object4});
                    object2 = new DOMException(12, string3);
                    if (this.userAgent == null) {
                        throw object2;
                    }
                    this.userAgent.displayError((Exception)object2);
                }
            }
            Object var17_21 = null;
            this.element = null;
            this.cssBaseURI = null;
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            this.element = null;
            this.cssBaseURI = null;
            throw throwable;
        }
        return styleMap;
    }

    public Value getComputedStyle(CSSStylableElement cSSStylableElement, String string, int n) {
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(string);
        if (styleMap == null) {
            styleMap = this.getCascadedStyleMap(cSSStylableElement, string);
            cSSStylableElement.setComputedStyleMap(string, styleMap);
        }
        Value value = styleMap.getValue(n);
        if (styleMap.isComputed(n)) {
            return value;
        }
        Value value2 = value;
        ValueManager valueManager = this.valueManagers[n];
        CSSStylableElement cSSStylableElement2 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
        if (value == null) {
            if (cSSStylableElement2 == null || !valueManager.isInheritedProperty()) {
                value2 = valueManager.getDefaultValue();
            }
        } else if (cSSStylableElement2 != null && value == InheritValue.INSTANCE) {
            value2 = null;
        }
        if (value2 == null) {
            value2 = this.getComputedStyle(cSSStylableElement2, null, n);
            styleMap.putParentRelative(n, true);
            styleMap.putInherited(n, true);
        } else {
            value2 = valueManager.computeValue(cSSStylableElement, string, this, n, styleMap, value2);
        }
        if (value == null) {
            styleMap.putValue(n, value2);
            styleMap.putNullCascaded(n, true);
        } else if (value2 != value) {
            ComputedValue computedValue = new ComputedValue(value);
            computedValue.setComputedValue(value2);
            styleMap.putValue(n, computedValue);
            value2 = computedValue;
        }
        styleMap.putComputed(n, true);
        return value2;
    }

    public List getStyleSheetNodes() {
        if (this.styleSheetNodes == null) {
            this.styleSheetNodes = new ArrayList();
            this.selectorAttributes = new HashSet();
            this.findStyleSheetNodes(this.document);
            int n = this.styleSheetNodes.size();
            int n2 = 0;
            while (n2 < n) {
                CSSStyleSheetNode cSSStyleSheetNode = (CSSStyleSheetNode)this.styleSheetNodes.get(n2);
                StyleSheet styleSheet = cSSStyleSheetNode.getCSSStyleSheet();
                if (styleSheet != null) {
                    this.findSelectorAttributes(this.selectorAttributes, styleSheet);
                }
                ++n2;
            }
        }
        return this.styleSheetNodes;
    }

    protected void findStyleSheetNodes(Node node) {
        if (node instanceof CSSStyleSheetNode) {
            this.styleSheetNodes.add(node);
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this.findStyleSheetNodes(node2);
            node2 = node2.getNextSibling();
        }
    }

    protected void findSelectorAttributes(Set set, StyleSheet styleSheet) {
        int n = styleSheet.getSize();
        int n2 = 0;
        while (n2 < n) {
            Rule rule = styleSheet.getRule(n2);
            switch (rule.getType()) {
                case 0: {
                    Object object;
                    StyleRule styleRule = (StyleRule)rule;
                    SelectorList selectorList = styleRule.getSelectorList();
                    int n3 = selectorList.getLength();
                    int n4 = 0;
                    while (n4 < n3) {
                        object = (ExtendedSelector)selectorList.item(n4);
                        object.fillAttributeSet(set);
                        ++n4;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    Object object = (MediaRule)rule;
                    if (!this.mediaMatch(((MediaRule)object).getMediaList())) break;
                    this.findSelectorAttributes(set, (StyleSheet)object);
                }
            }
            ++n2;
        }
    }

    public void setMainProperties(CSSStylableElement cSSStylableElement, final MainPropertyReceiver mainPropertyReceiver, String string, String string2, boolean bl) {
        try {
            try {
                this.element = cSSStylableElement;
                LexicalUnit lexicalUnit = this.parser.parsePropertyValue(string2);
                ShorthandManager.PropertyHandler propertyHandler = new ShorthandManager.PropertyHandler(){

                    public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
                        int n = CSSEngine.this.getPropertyIndex(string);
                        if (n != -1) {
                            ValueManager valueManager = CSSEngine.this.valueManagers[n];
                            Value value = valueManager.createValue(lexicalUnit, CSSEngine.this);
                            mainPropertyReceiver.setMainProperty(string, value, bl);
                            return;
                        }
                        n = CSSEngine.this.getShorthandIndex(string);
                        if (n == -1) {
                            return;
                        }
                        CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
                    }
                };
                propertyHandler.property(string, lexicalUnit, bl);
            }
            catch (Exception exception) {
                String string3 = exception.getMessage();
                if (string3 == null) {
                    string3 = "";
                }
                String string4 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                String string5 = Messages.formatMessage("property.syntax.error.at", new Object[]{string4, string, string2, string3});
                DOMException dOMException = new DOMException(12, string5);
                if (this.userAgent == null) {
                    throw dOMException;
                }
                this.userAgent.displayError(dOMException);
                Object var12_11 = null;
                this.element = null;
                this.cssBaseURI = null;
            }
            Object var12_10 = null;
            this.element = null;
            this.cssBaseURI = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.element = null;
            this.cssBaseURI = null;
            throw throwable;
        }
    }

    public Value parsePropertyValue(CSSStylableElement cSSStylableElement, String string, String string2) {
        int n = this.getPropertyIndex(string);
        if (n == -1) {
            return null;
        }
        ValueManager valueManager = this.valueManagers[n];
        try {
            try {
                this.element = cSSStylableElement;
                LexicalUnit lexicalUnit = this.parser.parsePropertyValue(string2);
                Value value = valueManager.createValue(lexicalUnit, this);
                Object var12_10 = null;
                this.element = null;
                this.cssBaseURI = null;
                return value;
            }
            catch (Exception exception) {
                String string3 = exception.getMessage();
                if (string3 == null) {
                    string3 = "";
                }
                String string4 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                String string5 = Messages.formatMessage("property.syntax.error.at", new Object[]{string4, string, string2, string3});
                DOMException dOMException = new DOMException(12, string5);
                if (this.userAgent == null) {
                    throw dOMException;
                }
                this.userAgent.displayError(dOMException);
                Object var12_11 = null;
                this.element = null;
                this.cssBaseURI = null;
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.element = null;
            this.cssBaseURI = null;
            throw throwable;
        }
        return valueManager.getDefaultValue();
    }

    public StyleDeclaration parseStyleDeclaration(CSSStylableElement cSSStylableElement, String string) {
        this.styleDeclarationBuilder.styleDeclaration = new StyleDeclaration();
        try {
            try {
                this.element = cSSStylableElement;
                this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                this.parser.setConditionFactory(this.cssConditionFactory);
                this.parser.setDocumentHandler(this.styleDeclarationBuilder);
                this.parser.parseStyleDeclaration(string);
            }
            catch (Exception exception) {
                String string2 = exception.getMessage();
                if (string2 == null) {
                    string2 = "";
                }
                String string3 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                String string4 = Messages.formatMessage("syntax.error.at", new Object[]{string3, string2});
                DOMException dOMException = new DOMException(12, string4);
                if (this.userAgent == null) {
                    throw dOMException;
                }
                this.userAgent.displayError(dOMException);
                Object var9_4 = null;
                this.element = null;
                this.cssBaseURI = null;
            }
            Object var9_3 = null;
            this.element = null;
            this.cssBaseURI = null;
        }
        catch (Throwable throwable) {
            Object var9_5 = null;
            this.element = null;
            this.cssBaseURI = null;
            throw throwable;
        }
        return this.styleDeclarationBuilder.styleDeclaration;
    }

    public StyleSheet parseStyleSheet(URL uRL, String string) throws DOMException {
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.setMedia(this.parser.parseMedia(string));
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string4 = Messages.formatMessage("syntax.error.at", new Object[]{string3, string2});
            DOMException dOMException = new DOMException(12, string4);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
            return styleSheet;
        }
        this.parseStyleSheet(styleSheet, uRL);
        return styleSheet;
    }

    public StyleSheet parseStyleSheet(InputSource inputSource, URL uRL, String string) throws DOMException {
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.setMedia(this.parser.parseMedia(string));
            this.parseStyleSheet(styleSheet, inputSource, uRL);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string4 = Messages.formatMessage("syntax.error.at", new Object[]{string3, string2});
            DOMException dOMException = new DOMException(12, string4);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
        return styleSheet;
    }

    public void parseStyleSheet(StyleSheet styleSheet, URL uRL) throws DOMException {
        if (uRL == null) {
            String string = Messages.formatMessage("syntax.error.at", new Object[]{"Null Document reference", ""});
            DOMException dOMException = new DOMException(12, string);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
            return;
        }
        try {
            ParsedURL parsedURL = null;
            if (this.documentURI != null) {
                parsedURL = new ParsedURL(this.documentURI);
            }
            ParsedURL parsedURL2 = new ParsedURL(uRL);
            this.cssContext.checkLoadExternalResource(parsedURL2, parsedURL);
            this.parseStyleSheet(styleSheet, new InputSource(uRL.toString()), uRL);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "";
            }
            String string2 = Messages.formatMessage("syntax.error.at", new Object[]{uRL.toString(), string});
            DOMException dOMException = new DOMException(12, string2);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
    }

    public StyleSheet parseStyleSheet(String string, URL uRL, String string2) throws DOMException {
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.setMedia(this.parser.parseMedia(string2));
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            String string4 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string5 = Messages.formatMessage("syntax.error.at", new Object[]{string4, string3});
            DOMException dOMException = new DOMException(12, string5);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
            return styleSheet;
        }
        this.parseStyleSheet(styleSheet, string, uRL);
        return styleSheet;
    }

    public void parseStyleSheet(StyleSheet styleSheet, String string, URL uRL) throws DOMException {
        try {
            this.parseStyleSheet(styleSheet, new InputSource((Reader)new StringReader(string)), uRL);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = Messages.formatMessage("stylesheet.syntax.error", new Object[]{uRL.toString(), string, string2});
            DOMException dOMException = new DOMException(12, string3);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
    }

    protected void parseStyleSheet(StyleSheet styleSheet, InputSource inputSource, URL uRL) throws IOException {
        this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
        this.parser.setConditionFactory(this.cssConditionFactory);
        try {
            this.cssBaseURI = uRL;
            this.styleSheetDocumentHandler.styleSheet = styleSheet;
            this.parser.setDocumentHandler(this.styleSheetDocumentHandler);
            this.parser.parseStyleSheet(inputSource);
            int n = styleSheet.getSize();
            int n2 = 0;
            while (n2 < n) {
                Rule rule = styleSheet.getRule(n2);
                if (rule.getType() != 2) break;
                ImportRule importRule = (ImportRule)rule;
                this.parseStyleSheet(importRule, importRule.getURI());
                ++n2;
            }
            Object var9_8 = null;
            this.cssBaseURI = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.cssBaseURI = null;
            throw throwable;
        }
    }

    protected void putAuthorProperty(StyleMap styleMap, int n, Value value, boolean bl, short s) {
        boolean bl2;
        Value value2 = styleMap.getValue(n);
        short s2 = styleMap.getOrigin(n);
        boolean bl3 = styleMap.isImportant(n);
        boolean bl4 = bl2 = value2 == null;
        if (!bl2) {
            switch (s2) {
                case 8192: {
                    bl2 = !bl3;
                    break;
                }
                case 24576: {
                    bl2 = !bl3 || bl;
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            styleMap.putValue(n, value);
            styleMap.putImportant(n, bl);
            styleMap.putOrigin(n, s);
        }
    }

    protected void addMatchingRules(List list, StyleSheet styleSheet, Element element, String string) {
        int n = styleSheet.getSize();
        int n2 = 0;
        while (n2 < n) {
            Rule rule = styleSheet.getRule(n2);
            switch (rule.getType()) {
                case 0: {
                    Object object;
                    StyleRule styleRule = (StyleRule)rule;
                    SelectorList selectorList = styleRule.getSelectorList();
                    int n3 = selectorList.getLength();
                    int n4 = 0;
                    while (n4 < n3) {
                        object = (ExtendedSelector)selectorList.item(n4);
                        if (object.match(element, string)) {
                            list.add(styleRule);
                        }
                        ++n4;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    Object object = (MediaRule)rule;
                    if (!this.mediaMatch(((MediaRule)object).getMediaList())) break;
                    this.addMatchingRules(list, (StyleSheet)object, element, string);
                }
            }
            ++n2;
        }
    }

    protected void addRules(Element element, String string, StyleMap styleMap, List list, short s) {
        this.sortRules(list, element, string);
        int n = list.size();
        if (s == 24576) {
            int n2 = 0;
            while (n2 < n) {
                StyleRule styleRule = (StyleRule)list.get(n2);
                StyleDeclaration styleDeclaration = styleRule.getStyleDeclaration();
                int n3 = styleDeclaration.size();
                int n4 = 0;
                while (n4 < n3) {
                    this.putAuthorProperty(styleMap, styleDeclaration.getIndex(n4), styleDeclaration.getValue(n4), styleDeclaration.getPriority(n4), s);
                    ++n4;
                }
                ++n2;
            }
        } else {
            int n5 = 0;
            while (n5 < n) {
                StyleRule styleRule = (StyleRule)list.get(n5);
                StyleDeclaration styleDeclaration = styleRule.getStyleDeclaration();
                int n6 = styleDeclaration.size();
                int n7 = 0;
                while (n7 < n6) {
                    int n8 = styleDeclaration.getIndex(n7);
                    styleMap.putValue(n8, styleDeclaration.getValue(n7));
                    styleMap.putImportant(n8, styleDeclaration.getPriority(n7));
                    styleMap.putOrigin(n8, s);
                    ++n7;
                }
                ++n5;
            }
        }
    }

    protected void sortRules(List list, Element element, String string) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n - 1) {
            StyleRule styleRule;
            int n3 = n2;
            int n4 = Integer.MAX_VALUE;
            int n5 = n2;
            while (n5 < n) {
                styleRule = (StyleRule)list.get(n5);
                SelectorList selectorList = styleRule.getSelectorList();
                int n6 = 0;
                int n7 = selectorList.getLength();
                int n8 = 0;
                while (n8 < n7) {
                    int n9;
                    ExtendedSelector extendedSelector = (ExtendedSelector)selectorList.item(n8);
                    if (extendedSelector.match(element, string) && (n9 = extendedSelector.getSpecificity()) > n6) {
                        n6 = n9;
                    }
                    ++n8;
                }
                if (n6 < n4) {
                    n4 = n6;
                    n3 = n5;
                }
                ++n5;
            }
            if (n2 != n3) {
                styleRule = list.get(n2);
                list.set(n2, list.get(n3));
                list.set(n3, styleRule);
            }
            ++n2;
        }
    }

    protected boolean mediaMatch(SACMediaList sACMediaList) {
        if (this.media == null || sACMediaList == null || this.media.getLength() == 0 || sACMediaList.getLength() == 0) {
            return true;
        }
        int n = 0;
        while (n < sACMediaList.getLength()) {
            if (sACMediaList.item(n).equalsIgnoreCase("all")) {
                return true;
            }
            int n2 = 0;
            while (n2 < this.media.getLength()) {
                if (this.media.item(n2).equalsIgnoreCase("all") || sACMediaList.item(n).equalsIgnoreCase(this.media.item(n2))) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public void addCSSEngineListener(CSSEngineListener cSSEngineListener) {
        this.listeners.add(cSSEngineListener);
    }

    public void removeCSSEngineListener(CSSEngineListener cSSEngineListener) {
        this.listeners.remove(cSSEngineListener);
    }

    protected void firePropertiesChangedEvent(Element element, int[] nArray) {
        CSSEngineListener[] cSSEngineListenerArray = this.listeners.toArray(LISTENER_ARRAY);
        int n = cSSEngineListenerArray.length;
        if (n > 0) {
            CSSEngineEvent cSSEngineEvent = new CSSEngineEvent(this, element, nArray);
            int n2 = 0;
            while (n2 < n) {
                cSSEngineListenerArray[n2].propertiesChanged(cSSEngineEvent);
                ++n2;
            }
        }
    }

    protected void inlineStyleAttributeUpdated(CSSStylableElement cSSStylableElement, StyleMap styleMap, MutationEvent mutationEvent) {
        boolean[] blArray = this.styleDeclarationUpdateHandler.updatedProperties;
        int n = this.getNumberOfProperties() - 1;
        while (n >= 0) {
            blArray[n] = false;
            --n;
        }
        switch (mutationEvent.getAttrChange()) {
            case 1: 
            case 2: {
                int[] nArray;
                String string = mutationEvent.getNewValue();
                if (string.length() > 0) {
                    this.element = cSSStylableElement;
                    try {
                        try {
                            this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                            this.parser.setConditionFactory(this.cssConditionFactory);
                            this.styleDeclarationUpdateHandler.styleMap = styleMap;
                            this.parser.setDocumentHandler(this.styleDeclarationUpdateHandler);
                            this.parser.parseStyleDeclaration(string);
                            this.styleDeclarationUpdateHandler.styleMap = null;
                        }
                        catch (Exception exception) {
                            String string2 = exception.getMessage();
                            if (string2 == null) {
                                string2 = "";
                            }
                            String string3 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                            String string4 = Messages.formatMessage("style.syntax.error.at", new Object[]{string3, this.styleLocalName, string, string2});
                            DOMException dOMException = new DOMException(12, string4);
                            if (this.userAgent == null) {
                                throw dOMException;
                            }
                            this.userAgent.displayError(dOMException);
                            nArray = null;
                            this.element = null;
                            this.cssBaseURI = null;
                        }
                        nArray = null;
                        this.element = null;
                        this.cssBaseURI = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_8 = null;
                        this.element = null;
                        this.cssBaseURI = null;
                        throw throwable;
                    }
                }
            }
            case 3: {
                boolean bl = false;
                if (mutationEvent.getPrevValue() != null && mutationEvent.getPrevValue().length() > 0) {
                    int n2 = this.getNumberOfProperties() - 1;
                    while (n2 >= 0) {
                        if (styleMap.isComputed(n2) && styleMap.getOrigin(n2) == Short.MIN_VALUE && !blArray[n2]) {
                            bl = true;
                            blArray[n2] = true;
                        }
                        --n2;
                    }
                }
                if (bl) {
                    this.invalidateProperties(cSSStylableElement, null, blArray, true);
                    break;
                }
                int n3 = 0;
                boolean bl2 = this.fontSizeIndex == -1 ? false : blArray[this.fontSizeIndex];
                boolean bl3 = this.lineHeightIndex == -1 ? false : blArray[this.lineHeightIndex];
                boolean bl4 = this.colorIndex == -1 ? false : blArray[this.colorIndex];
                int n4 = this.getNumberOfProperties() - 1;
                while (n4 >= 0) {
                    if (blArray[n4]) {
                        ++n3;
                    } else if (bl2 && styleMap.isFontSizeRelative(n4) || bl3 && styleMap.isLineHeightRelative(n4) || bl4 && styleMap.isColorRelative(n4)) {
                        blArray[n4] = true;
                        CSSEngine.clearComputedValue(styleMap, n4);
                        ++n3;
                    }
                    --n4;
                }
                if (n3 <= 0) break;
                int[] nArray = new int[n3];
                n3 = 0;
                int n5 = this.getNumberOfProperties() - 1;
                while (n5 >= 0) {
                    if (blArray[n5]) {
                        nArray[n3++] = n5;
                    }
                    --n5;
                }
                this.invalidateProperties(cSSStylableElement, nArray, null, true);
                break;
            }
            default: {
                throw new InternalError("Invalid attrChangeType");
            }
        }
    }

    private static void clearComputedValue(StyleMap styleMap, int n) {
        if (styleMap.isNullCascaded(n)) {
            styleMap.putValue(n, null);
        } else {
            Value value = styleMap.getValue(n);
            if (value instanceof ComputedValue) {
                ComputedValue computedValue = (ComputedValue)value;
                value = computedValue.getCascadedValue();
                styleMap.putValue(n, value);
            }
        }
        styleMap.putComputed(n, false);
    }

    protected void invalidateProperties(Node node, int[] nArray, boolean[] blArray, boolean bl) {
        int n;
        int n2;
        boolean[] blArray2;
        CSSStylableElement cSSStylableElement;
        block17: {
            StyleMap styleMap;
            block16: {
                if (!(node instanceof CSSStylableElement)) {
                    return;
                }
                cSSStylableElement = (CSSStylableElement)node;
                styleMap = cSSStylableElement.getComputedStyleMap(null);
                if (styleMap == null) {
                    return;
                }
                blArray2 = new boolean[this.getNumberOfProperties()];
                if (blArray != null) {
                    n2 = 0;
                    while (n2 < blArray.length) {
                        blArray2[n2] = blArray[n2];
                        ++n2;
                    }
                }
                if (nArray != null) {
                    n2 = 0;
                    while (n2 < nArray.length) {
                        blArray2[nArray[n2]] = true;
                        ++n2;
                    }
                }
                n2 = 0;
                if (bl) break block16;
                int n3 = 0;
                while (n3 < blArray2.length) {
                    if (blArray2[n3]) {
                        ++n2;
                    }
                    ++n3;
                }
                break block17;
            }
            StyleMap styleMap2 = this.getCascadedStyleMap(cSSStylableElement, null);
            cSSStylableElement.setComputedStyleMap(null, styleMap2);
            n = 0;
            while (n < blArray2.length) {
                block19: {
                    block20: {
                        block18: {
                            if (!blArray2[n]) break block18;
                            ++n2;
                            break block19;
                        }
                        Value value = styleMap2.getValue(n);
                        Value value2 = null;
                        if (!styleMap.isNullCascaded(n) && (value2 = styleMap.getValue(n)) instanceof ComputedValue) {
                            value2 = ((ComputedValue)value2).getCascadedValue();
                        }
                        if (value == value2) break block19;
                        if (value == null || value2 == null) break block20;
                        if (value.equals(value2)) break block19;
                        String string = value2.getCssText();
                        String string2 = value.getCssText();
                        if (string2 == string || string2 != null && string2.equals(string)) break block19;
                    }
                    ++n2;
                    blArray2[n] = true;
                }
                ++n;
            }
        }
        int[] nArray2 = null;
        if (n2 != 0) {
            nArray2 = new int[n2];
            n2 = 0;
            n = 0;
            while (n < blArray2.length) {
                if (blArray2[n]) {
                    nArray2[n2++] = n;
                }
                ++n;
            }
        }
        this.propagateChanges(cSSStylableElement, nArray2, bl);
    }

    protected void propagateChanges(Node node, int[] nArray, boolean bl) {
        CSSImportedElementRoot cSSImportedElementRoot;
        int n;
        int n2;
        Object[] objectArray;
        if (!(node instanceof CSSStylableElement)) {
            return;
        }
        CSSStylableElement cSSStylableElement = (CSSStylableElement)node;
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(null);
        if (styleMap != null) {
            int n3;
            objectArray = this.styleDeclarationUpdateHandler.updatedProperties;
            n2 = this.getNumberOfProperties() - 1;
            while (n2 >= 0) {
                objectArray[n2] = 0;
                --n2;
            }
            if (nArray != null) {
                n = nArray.length - 1;
                while (n >= 0) {
                    n3 = nArray[n];
                    objectArray[n3] = 1;
                    --n;
                }
            }
            n = this.fontSizeIndex == -1 ? 0 : objectArray[this.fontSizeIndex];
            n3 = this.lineHeightIndex == -1 ? 0 : objectArray[this.lineHeightIndex];
            int n4 = this.colorIndex == -1 ? 0 : objectArray[this.colorIndex];
            int n5 = 0;
            int n6 = this.getNumberOfProperties() - 1;
            while (n6 >= 0) {
                if (objectArray[n6] != 0) {
                    ++n5;
                } else if (n != 0 && styleMap.isFontSizeRelative(n6) || n3 != 0 && styleMap.isLineHeightRelative(n6) || n4 != 0 && styleMap.isColorRelative(n6)) {
                    objectArray[n6] = 1;
                    CSSEngine.clearComputedValue(styleMap, n6);
                    ++n5;
                }
                --n6;
            }
            if (n5 == 0) {
                nArray = null;
            } else {
                nArray = new int[n5];
                n5 = 0;
                int n7 = this.getNumberOfProperties() - 1;
                while (n7 >= 0) {
                    if (objectArray[n7] != 0) {
                        nArray[n5++] = n7;
                    }
                    --n7;
                }
                this.firePropertiesChangedEvent(cSSStylableElement, nArray);
            }
        }
        objectArray = nArray;
        if (nArray != null) {
            n2 = 0;
            n = 0;
            while (n < nArray.length) {
                ValueManager valueManager = this.valueManagers[nArray[n]];
                if (valueManager.isInheritedProperty()) {
                    ++n2;
                } else {
                    nArray[n] = -1;
                }
                ++n;
            }
            if (n2 == 0) {
                objectArray = null;
            } else {
                objectArray = new int[n2];
                n2 = 0;
                int n8 = 0;
                while (n8 < nArray.length) {
                    if (nArray[n8] != -1) {
                        objectArray[n2++] = nArray[n8];
                    }
                    ++n8;
                }
            }
        }
        if ((cSSImportedElementRoot = CSSEngine.getImportedChild(node)) != null) {
            Element element = (Element)cSSImportedElementRoot.getFirstChild();
            CSSEngine cSSEngine = this.cssContext.getCSSEngineForElement(element);
            cSSEngine.invalidateProperties(element, (int[])objectArray, null, bl);
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this.invalidateProperties(node2, (int[])objectArray, null, bl);
            node2 = node2.getNextSibling();
        }
    }

    protected void nonCSSPresentationalHintUpdated(CSSStylableElement cSSStylableElement, StyleMap styleMap, String string, MutationEvent mutationEvent) {
        Object object;
        int n = this.getPropertyIndex(string);
        if (styleMap.isImportant(n)) {
            return;
        }
        switch (styleMap.getOrigin(n)) {
            case -32768: 
            case 24576: {
                return;
            }
        }
        switch (mutationEvent.getAttrChange()) {
            case 1: 
            case 2: {
                this.element = cSSStylableElement;
                try {
                    Object var12_13;
                    Object object2;
                    Object object3;
                    try {
                        object = this.parser.parsePropertyValue(mutationEvent.getNewValue());
                        object3 = this.valueManagers[n];
                        object2 = object3.createValue((LexicalUnit)object, this);
                        styleMap.putMask(n, (short)0);
                        styleMap.putValue(n, (Value)object2);
                        styleMap.putOrigin(n, (short)16384);
                    }
                    catch (Exception exception) {
                        object3 = exception.getMessage();
                        if (object3 == null) {
                            object3 = "";
                        }
                        object2 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                        String string2 = Messages.formatMessage("property.syntax.error.at", new Object[]{object2, string, mutationEvent.getNewValue(), object3});
                        DOMException dOMException = new DOMException(12, string2);
                        if (this.userAgent == null) {
                            throw dOMException;
                        }
                        this.userAgent.displayError(dOMException);
                        var12_13 = null;
                        this.element = null;
                        this.cssBaseURI = null;
                        break;
                    }
                    var12_13 = null;
                    this.element = null;
                    this.cssBaseURI = null;
                    break;
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    this.element = null;
                    this.cssBaseURI = null;
                    throw throwable;
                }
            }
            case 3: {
                int[] nArray = new int[]{n};
                this.invalidateProperties(cSSStylableElement, nArray, null, true);
                return;
            }
        }
        object = this.styleDeclarationUpdateHandler.updatedProperties;
        int n2 = this.getNumberOfProperties() - 1;
        while (n2 >= 0) {
            object[n2] = false;
            --n2;
        }
        object[n] = true;
        boolean bl = n == this.fontSizeIndex;
        boolean bl2 = n == this.lineHeightIndex;
        boolean bl3 = n == this.colorIndex;
        int n3 = 0;
        int n4 = this.getNumberOfProperties() - 1;
        while (n4 >= 0) {
            if (object[n4]) {
                ++n3;
            } else if (bl && styleMap.isFontSizeRelative(n4) || bl2 && styleMap.isLineHeightRelative(n4) || bl3 && styleMap.isColorRelative(n4)) {
                object[n4] = true;
                CSSEngine.clearComputedValue(styleMap, n4);
                ++n3;
            }
            --n4;
        }
        int[] nArray = new int[n3];
        n3 = 0;
        int n5 = this.getNumberOfProperties() - 1;
        while (n5 >= 0) {
            if (object[n5]) {
                nArray[n3++] = n5;
            }
            --n5;
        }
        this.invalidateProperties(cSSStylableElement, nArray, null, true);
    }

    protected class DOMAttrModifiedListener
    implements EventListener {
        protected DOMAttrModifiedListener() {
        }

        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (!(eventTarget instanceof CSSStylableElement)) {
                return;
            }
            MutationEvent mutationEvent = (MutationEvent)event;
            if (mutationEvent.getNewValue().equals(mutationEvent.getPrevValue())) {
                return;
            }
            Node node = mutationEvent.getRelatedNode();
            String string = node.getNamespaceURI();
            String string2 = string == null ? node.getNodeName() : node.getLocalName();
            CSSStylableElement cSSStylableElement = (CSSStylableElement)((Object)eventTarget);
            StyleMap styleMap = cSSStylableElement.getComputedStyleMap(null);
            if (styleMap != null) {
                if ((string == CSSEngine.this.styleNamespaceURI || string != null && string.equals(CSSEngine.this.styleNamespaceURI)) && string2.equals(CSSEngine.this.styleLocalName)) {
                    CSSEngine.this.inlineStyleAttributeUpdated(cSSStylableElement, styleMap, mutationEvent);
                    return;
                }
                if (CSSEngine.this.nonCSSPresentationalHints != null && (string == CSSEngine.this.nonCSSPresentationalHintsNamespaceURI || string != null && string.equals(CSSEngine.this.nonCSSPresentationalHintsNamespaceURI)) && CSSEngine.this.nonCSSPresentationalHints.contains(string2)) {
                    CSSEngine.this.nonCSSPresentationalHintUpdated(cSSStylableElement, styleMap, string2, mutationEvent);
                    return;
                }
            }
            if (CSSEngine.this.selectorAttributes != null && CSSEngine.this.selectorAttributes.contains(string2)) {
                CSSEngine.this.invalidateProperties(cSSStylableElement, null, null, true);
                Node node2 = cSSStylableElement.getNextSibling();
                while (node2 != null) {
                    CSSEngine.this.invalidateProperties(node2, null, null, true);
                    node2 = node2.getNextSibling();
                }
            }
        }
    }

    protected class DOMCharacterDataModifiedListener
    implements EventListener {
        protected DOMCharacterDataModifiedListener() {
        }

        public void handleEvent(Event event) {
            Node node = (Node)((Object)event.getTarget());
            if (node.getParentNode() instanceof CSSStyleSheetNode) {
                CSSEngine.this.styleSheetNodes = null;
                CSSEngine.this.invalidateProperties(CSSEngine.this.document.getDocumentElement(), null, null, true);
            }
        }
    }

    protected class DOMNodeInsertedListener
    implements EventListener {
        protected DOMNodeInsertedListener() {
        }

        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (eventTarget instanceof CSSStyleSheetNode) {
                CSSEngine.this.styleSheetNodes = null;
                CSSEngine.this.invalidateProperties(CSSEngine.this.document.getDocumentElement(), null, null, true);
                return;
            }
            if (eventTarget instanceof CSSStylableElement) {
                Node node = ((Node)((Object)event.getTarget())).getNextSibling();
                while (node != null) {
                    CSSEngine.this.invalidateProperties(node, null, null, true);
                    node = node.getNextSibling();
                }
            }
        }
    }

    protected class DOMNodeRemovedListener
    implements EventListener {
        protected DOMNodeRemovedListener() {
        }

        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (eventTarget instanceof CSSStyleSheetNode) {
                CSSEngine.this.styleSheetRemoved = true;
            } else if (eventTarget instanceof CSSStylableElement) {
                CSSEngine.this.removedStylableElementSibling = ((Node)((Object)eventTarget)).getNextSibling();
            }
            CSSEngine.this.disposeStyleMaps((Node)((Object)eventTarget));
        }
    }

    protected class DOMSubtreeModifiedListener
    implements EventListener {
        protected DOMSubtreeModifiedListener() {
        }

        public void handleEvent(Event event) {
            if (CSSEngine.this.styleSheetRemoved) {
                CSSEngine.this.styleSheetRemoved = false;
                CSSEngine.this.styleSheetNodes = null;
                CSSEngine.this.invalidateProperties(CSSEngine.this.document.getDocumentElement(), null, null, true);
            } else if (CSSEngine.this.removedStylableElementSibling != null) {
                Node node = CSSEngine.this.removedStylableElementSibling;
                while (node != null) {
                    CSSEngine.this.invalidateProperties(node, null, null, true);
                    node = node.getNextSibling();
                }
                CSSEngine.this.removedStylableElementSibling = null;
            }
        }
    }

    protected static class DocumentAdapter
    implements DocumentHandler {
        protected DocumentAdapter() {
        }

        public void startDocument(InputSource inputSource) throws CSSException {
            throw new InternalError();
        }

        public void endDocument(InputSource inputSource) throws CSSException {
            throw new InternalError();
        }

        public void comment(String string) throws CSSException {
        }

        public void ignorableAtRule(String string) throws CSSException {
            throw new InternalError();
        }

        public void namespaceDeclaration(String string, String string2) throws CSSException {
            throw new InternalError();
        }

        public void importStyle(String string, SACMediaList sACMediaList, String string2) throws CSSException {
            throw new InternalError();
        }

        public void startMedia(SACMediaList sACMediaList) throws CSSException {
            throw new InternalError();
        }

        public void endMedia(SACMediaList sACMediaList) throws CSSException {
            throw new InternalError();
        }

        public void startPage(String string, String string2) throws CSSException {
            throw new InternalError();
        }

        public void endPage(String string, String string2) throws CSSException {
            throw new InternalError();
        }

        public void startFontFace() throws CSSException {
            throw new InternalError();
        }

        public void endFontFace() throws CSSException {
            throw new InternalError();
        }

        public void startSelector(SelectorList selectorList) throws CSSException {
            throw new InternalError();
        }

        public void endSelector(SelectorList selectorList) throws CSSException {
            throw new InternalError();
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            throw new InternalError();
        }
    }

    public static interface MainPropertyReceiver {
        public void setMainProperty(String var1, Value var2, boolean var3);
    }

    protected class StyleDeclarationBuilder
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleDeclaration styleDeclaration;

        protected StyleDeclarationBuilder() {
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n == -1) {
                n = CSSEngine.this.getShorthandIndex(string);
                if (n == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
            } else {
                Value value = CSSEngine.this.valueManagers[n].createValue(lexicalUnit, CSSEngine.this);
                this.styleDeclaration.append(value, n, bl);
            }
        }
    }

    protected class StyleDeclarationDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;

        protected StyleDeclarationDocumentHandler() {
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n == -1) {
                n = CSSEngine.this.getShorthandIndex(string);
                if (n == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
            } else {
                Value value = CSSEngine.this.valueManagers[n].createValue(lexicalUnit, CSSEngine.this);
                CSSEngine.this.putAuthorProperty(this.styleMap, n, value, bl, (short)Short.MIN_VALUE);
            }
        }
    }

    protected class StyleDeclarationUpdateHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;
        public boolean[] updatedProperties;

        protected StyleDeclarationUpdateHandler() {
            this.updatedProperties = new boolean[CSSEngine.this.getNumberOfProperties()];
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n == -1) {
                n = CSSEngine.this.getShorthandIndex(string);
                if (n == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
            } else {
                if (this.styleMap.isImportant(n)) {
                    return;
                }
                this.updatedProperties[n] = true;
                Value value = CSSEngine.this.valueManagers[n].createValue(lexicalUnit, CSSEngine.this);
                this.styleMap.putMask(n, (short)0);
                this.styleMap.putValue(n, value);
                this.styleMap.putOrigin(n, (short)Short.MIN_VALUE);
            }
        }
    }

    protected class StyleSheetDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleSheet styleSheet;
        protected StyleRule styleRule;
        protected StyleDeclaration styleDeclaration;

        protected StyleSheetDocumentHandler() {
        }

        public void startDocument(InputSource inputSource) throws CSSException {
        }

        public void endDocument(InputSource inputSource) throws CSSException {
        }

        public void ignorableAtRule(String string) throws CSSException {
        }

        public void importStyle(String string, SACMediaList sACMediaList, String string2) throws CSSException {
            ImportRule importRule = new ImportRule();
            importRule.setMediaList(sACMediaList);
            importRule.setParent(this.styleSheet);
            try {
                URL uRL = CSSEngine.this.getCSSBaseURI();
                URL uRL2 = uRL == null ? new URL(string) : new URL(uRL, string);
                importRule.setURI(uRL2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.styleSheet.append(importRule);
        }

        public void startMedia(SACMediaList sACMediaList) throws CSSException {
            MediaRule mediaRule = new MediaRule();
            mediaRule.setMediaList(sACMediaList);
            mediaRule.setParent(this.styleSheet);
            this.styleSheet.append(mediaRule);
            this.styleSheet = mediaRule;
        }

        public void endMedia(SACMediaList sACMediaList) throws CSSException {
            this.styleSheet = this.styleSheet.getParent();
        }

        public void startPage(String string, String string2) throws CSSException {
        }

        public void endPage(String string, String string2) throws CSSException {
        }

        public void startFontFace() throws CSSException {
            this.styleDeclaration = new StyleDeclaration();
        }

        public void endFontFace() throws CSSException {
            int n;
            StyleMap styleMap = new StyleMap(CSSEngine.this.getNumberOfProperties());
            int n2 = this.styleDeclaration.size();
            int n3 = 0;
            while (n3 < n2) {
                n = this.styleDeclaration.getIndex(n3);
                styleMap.putValue(n, this.styleDeclaration.getValue(n3));
                styleMap.putImportant(n, this.styleDeclaration.getPriority(n3));
                styleMap.putOrigin(n, (short)24576);
                ++n3;
            }
            this.styleDeclaration = null;
            n = CSSEngine.this.getPropertyIndex("font-family");
            Value value = styleMap.getValue(n);
            if (value == null) {
                return;
            }
            URL uRL = CSSEngine.this.getCSSBaseURI();
            ParsedURL parsedURL = null;
            if (uRL != null) {
                parsedURL = new ParsedURL(uRL);
            }
            CSSEngine.this.fontFaces.add(new FontFaceRule(styleMap, parsedURL));
        }

        public void startSelector(SelectorList selectorList) throws CSSException {
            this.styleRule = new StyleRule();
            this.styleRule.setSelectorList(selectorList);
            this.styleDeclaration = new StyleDeclaration();
            this.styleRule.setStyleDeclaration(this.styleDeclaration);
            this.styleSheet.append(this.styleRule);
        }

        public void endSelector(SelectorList selectorList) throws CSSException {
            this.styleRule = null;
            this.styleDeclaration = null;
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n == -1) {
                n = CSSEngine.this.getShorthandIndex(string);
                if (n == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
            } else {
                Value value = CSSEngine.this.valueManagers[n].createValue(lexicalUnit, CSSEngine.this);
                this.styleDeclaration.append(value, n, bl);
            }
        }
    }
}

