/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.NoteAttachmentReorientEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IAnchorableFigure;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public abstract class ConnectionNodeEditPart
extends ConnectionEditPart
implements INodeEditPart {
    public ConnectionNodeEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new GraphicalNodeEditPolicy());
        this.installEditPolicy("NoteAttachmentReorient", (EditPolicy)new NoteAttachmentReorientEditPolicy());
    }

    protected List getModelSourceConnections() {
        return ViewUtil.getSourceConnections((View)this.getEdge());
    }

    protected List getModelTargetConnections() {
        return ViewUtil.getTargetConnections((View)this.getEdge());
    }

    protected ConnectionAnchor getSourceConnectionAnchor() {
        if (this.getSource() != null && this.getSource() instanceof NodeEditPart) {
            NodeEditPart editPart = (NodeEditPart)this.getSource();
            return editPart.getSourceConnectionAnchor((org.eclipse.gef.ConnectionEditPart)this);
        }
        return super.getSourceConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(org.eclipse.gef.ConnectionEditPart connEditPart) {
        final ConnectionNodeEditPart connection = (ConnectionNodeEditPart)connEditPart;
        String t = "";
        try {
            t = (String)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    Anchor a = connection.getEdge().getSourceAnchor();
                    if (a instanceof IdentityAnchor) {
                        this.setResult(((IdentityAnchor)a).getId());
                    } else {
                        this.setResult("");
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getSourceConnectionAnchor", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getSourceConnectionAnchor", (Throwable)e);
        }
        return ((IAnchorableFigure)this.getFigure()).getConnectionAnchor(t);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        Point pt;
        Point center = this.getFigure().getBounds().getCenter();
        this.getFigure().translateToAbsolute((Translatable)center);
        Point point = pt = ((DropRequest)request).getLocation() == null ? center : new Point(((DropRequest)request).getLocation());
        if (request instanceof CreateRequest) {
            this.getFigure().translateToRelative((Translatable)pt);
        }
        return ((IAnchorableFigure)this.getFigure()).getSourceConnectionAnchorAt(pt);
    }

    protected ConnectionAnchor getTargetConnectionAnchor() {
        if (this.getTarget() instanceof NodeEditPart) {
            NodeEditPart editPart = (NodeEditPart)this.getTarget();
            return editPart.getTargetConnectionAnchor((org.eclipse.gef.ConnectionEditPart)this);
        }
        return super.getTargetConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(org.eclipse.gef.ConnectionEditPart connEditPart) {
        final ConnectionNodeEditPart connection = (ConnectionNodeEditPart)connEditPart;
        String t = "";
        try {
            t = (String)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    Anchor a = connection.getEdge().getTargetAnchor();
                    if (a instanceof IdentityAnchor) {
                        this.setResult(((IdentityAnchor)a).getId());
                    } else {
                        this.setResult("");
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getTargetConnectionAnchor", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getTargetConnectionAnchor", (Throwable)e);
        }
        return ((IAnchorableFigure)this.getFigure()).getConnectionAnchor(t);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point pt;
        Point center = this.getFigure().getBounds().getCenter();
        this.getFigure().translateToAbsolute((Translatable)center);
        Point point = pt = ((DropRequest)request).getLocation() == null ? center : new Point(((DropRequest)request).getLocation());
        if (request instanceof CreateRequest) {
            this.getFigure().translateToRelative((Translatable)pt);
        }
        return ((IAnchorableFigure)this.getFigure()).getTargetConnectionAnchorAt(pt);
    }

    public final String mapConnectionAnchorToTerminal(ConnectionAnchor c) {
        return ((IAnchorableFigure)this.getFigure()).getConnectionAnchorTerminal(c);
    }

    public final ConnectionAnchor mapTerminalToConnectionAnchor(String terminal) {
        return ((IAnchorableFigure)this.getFigure()).getConnectionAnchor(terminal);
    }

    public boolean canAttachNote() {
        return true;
    }

    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (NotationPackage.eINSTANCE.getView_SourceEdges().equals(feature)) {
            this.refreshSourceConnections();
        } else if (NotationPackage.eINSTANCE.getView_TargetEdges().equals(feature)) {
            this.refreshTargetConnections();
        } else {
            super.handleNotificationEvent(notification);
        }
        if (NotationPackage.eINSTANCE.getIdentityAnchor_Id().equals(feature) || notification.getNewValue() instanceof IdentityAnchor || notification.getOldValue() instanceof IdentityAnchor) {
            this.anchorChange();
        }
    }

    public void anchorChange() {
        this.refreshSourceAnchor();
        this.refreshTargetAnchor();
    }

    private void getSourceAndTargetConnections(HashSet set, org.eclipse.gef.ConnectionEditPart connectionEditPart) {
        if (connectionEditPart == null || set == null) {
            return;
        }
        for (org.eclipse.gef.ConnectionEditPart next : connectionEditPart.getSourceConnections()) {
            Connection sourceConnection = (Connection)next.getFigure();
            set.add(sourceConnection);
            this.getSourceAndTargetConnections(set, next);
        }
        for (org.eclipse.gef.ConnectionEditPart next : connectionEditPart.getTargetConnections()) {
            Connection targetConnection = (Connection)next.getFigure();
            set.add(targetConnection);
            this.getSourceAndTargetConnections(set, next);
        }
    }

    private boolean isCyclicConnectionRequest(org.eclipse.gef.ConnectionEditPart targetCEP, org.eclipse.gef.ConnectionEditPart sourceCEP, boolean checkSourceAndTargetEditParts, boolean doNotCheckSourceEditPart) {
        if (targetCEP == null || sourceCEP == null) {
            return false;
        }
        if (sourceCEP == targetCEP) {
            return true;
        }
        HashSet set = new HashSet();
        this.getSourceAndTargetConnections(set, sourceCEP);
        if (set.contains(targetCEP.getFigure())) {
            return true;
        }
        EditPart sourceEP = sourceCEP.getSource();
        EditPart targetEP = sourceCEP.getTarget();
        if (sourceEP == targetCEP || targetEP == targetCEP) {
            return true;
        }
        if ((checkSourceAndTargetEditParts || !doNotCheckSourceEditPart) && sourceEP instanceof org.eclipse.gef.ConnectionEditPart && this.isCyclicConnectionRequest(targetCEP, (org.eclipse.gef.ConnectionEditPart)sourceEP, true, doNotCheckSourceEditPart)) {
            return true;
        }
        return (checkSourceAndTargetEditParts || doNotCheckSourceEditPart) && targetEP instanceof org.eclipse.gef.ConnectionEditPart && this.isCyclicConnectionRequest(targetCEP, (org.eclipse.gef.ConnectionEditPart)targetEP, true, doNotCheckSourceEditPart);
    }

    public EditPart getTargetEditPart(Request request) {
        EditPart ep = super.getTargetEditPart(request);
        if (ep != null && ep instanceof org.eclipse.gef.ConnectionEditPart && request instanceof ReconnectRequest) {
            ReconnectRequest rRequest = (ReconnectRequest)request;
            if (rRequest.isMovingStartAnchor() ? rRequest.getConnectionEditPart().getSource() == ep : rRequest.getConnectionEditPart().getTarget() == ep) {
                return ep;
            }
            if (this.isCyclicConnectionRequest((org.eclipse.gef.ConnectionEditPart)ep, rRequest.getConnectionEditPart(), false, rRequest.isMovingStartAnchor())) {
                return null;
            }
        }
        return ep;
    }
}

