/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.validate.expressions.AbstractExpression;
import org.eclipse.gmf.internal.validate.expressions.IModelExpression;
import org.eclipse.gmf.internal.validate.expressions.IParseEnvironment;

public abstract class ExpressionCache {
    private Map body2Entries = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.validate.ExpressionCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected ExpressionCache() {
    }

    protected abstract IModelExpression createExpressionEntry(String var1, EClassifier var2, IParseEnvironment var3);

    public IModelExpression getExpression(String body, EClassifier context) {
        return this.getExpression(body, context, null);
    }

    public IModelExpression getExpression(String body, EClassifier context, IParseEnvironment env) {
        if (body == null || context == null) {
            throw new IllegalArgumentException("Null expression body or context");
        }
        IModelExpression resultEntry = null;
        if (this.body2Entries.containsKey(body)) {
            List cachedEntries;
            AbstractExpression prevEntry;
            Object prev = this.body2Entries.get(body);
            if (prev instanceof AbstractExpression && (prevEntry = (AbstractExpression)prev).getContext() == context) {
                return prevEntry;
            }
            List list = cachedEntries = prev instanceof List ? (List)prev : new LinkedList();
            if (cachedEntries.isEmpty()) {
                cachedEntries.add(prev);
                this.body2Entries.put(body, cachedEntries);
            } else {
                Iterator it = cachedEntries.iterator();
                while (it.hasNext()) {
                    AbstractExpression nextConstraint = (AbstractExpression)it.next();
                    if (nextConstraint.getContext() != context) continue;
                    return nextConstraint;
                }
            }
            resultEntry = this.createExpressionEntry(body, context, env);
            cachedEntries.add(resultEntry);
            if (!$assertionsDisabled && resultEntry == null) {
                throw new AssertionError();
            }
            return resultEntry;
        }
        resultEntry = this.createExpressionEntry(body, context, env);
        this.body2Entries.put(body, resultEntry);
        return resultEntry;
    }
}

