/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.internal.bridge.genmodel.ViewmapProducer;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.gmf.tests.setup.DiaDefSetup;
import org.eclipse.gmf.tests.setup.DiaGenSetup;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.DomainModelFileSetup;
import org.eclipse.gmf.tests.setup.DomainModelSetup;
import org.eclipse.gmf.tests.setup.DomainModelSetupInstanceClassName;
import org.eclipse.gmf.tests.setup.DomainModelSource;
import org.eclipse.gmf.tests.setup.GenProjectBaseSetup;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.gmf.tests.setup.MapSetup;
import org.eclipse.gmf.tests.setup.MultiPackageGenSetup;
import org.eclipse.gmf.tests.setup.MultiplePackagesDomainModelSetup;
import org.eclipse.gmf.tests.setup.ToolDefSetup;
import org.eclipse.gmf.tests.setup.annotated.GenASetup;
import org.eclipse.gmf.tests.setup.annotated.GraphDefASetup;
import org.eclipse.gmf.tests.setup.annotated.MapDefASetup;
import org.eclipse.gmf.tests.setup.annotated.ToolDefASetup;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompilationTest
extends TestCase {
    protected static final IGenDiagramMutator SAME_FILE_MUTATOR = new IGenDiagramMutator(){
        private boolean myIsSameFileForDiagramAndModel;
        private String myPluginId;

        public void doMutation(GenDiagram d) {
            this.myIsSameFileForDiagramAndModel = d.getEditorGen().isSameFileForDiagramAndModel();
            d.getEditorGen().setSameFileForDiagramAndModel(!this.myIsSameFileForDiagramAndModel);
            this.myPluginId = d.getEditorGen().getPlugin().getID();
            d.getEditorGen().getPlugin().setID(String.valueOf(this.myPluginId) + ".sameFileForDiagramAndModel");
        }

        public void undoMutation(GenDiagram d) {
            d.getEditorGen().setSameFileForDiagramAndModel(this.myIsSameFileForDiagramAndModel);
            d.getEditorGen().getPlugin().setID(this.myPluginId);
        }
    };
    protected static final IGenDiagramMutator SYNCHRONIZED_MUTATOR = new IGenDiagramMutator(){
        private boolean myIsSynchronized;
        private String myPluginId;

        public void doMutation(GenDiagram d) {
            this.myIsSynchronized = d.isSynchronized();
            d.setSynchronized(!this.myIsSynchronized);
            this.myPluginId = d.getEditorGen().getPlugin().getID();
            d.getEditorGen().getPlugin().setID(String.valueOf(this.myPluginId) + ".synchronized");
        }

        public void undoMutation(GenDiagram d) {
            d.setSynchronized(this.myIsSynchronized);
            d.getEditorGen().getPlugin().setID(this.myPluginId);
        }
    };
    protected static final IGenDiagramMutator SHORTCUT_STUFF_MUTATOR = new IGenDiagramMutator(){
        private List<String> myShortcutsTo;
        private String myPluginId;

        public void doMutation(GenDiagram d) {
            this.myShortcutsTo = new ArrayList<String>((Collection<String>)d.getContainsShortcutsTo());
            d.getContainsShortcutsTo().clear();
            d.getContainsShortcutsTo().add((Object)d.getEditorGen().getModelID());
            this.myPluginId = d.getEditorGen().getPlugin().getID();
            d.getEditorGen().getPlugin().setID(String.valueOf(this.myPluginId) + ".shortcuts");
        }

        public void undoMutation(GenDiagram d) {
            d.getContainsShortcutsTo().clear();
            d.getContainsShortcutsTo().addAll(this.myShortcutsTo);
            d.getEditorGen().getPlugin().setID(this.myPluginId);
        }
    };
    protected static final Collection<IGenDiagramMutator> NO_MUTATORS = Collections.emptyList();

    public CompilationTest(String name) {
        super(name);
    }

    protected abstract GeneratorConfiguration getGeneratorConfiguration();

    protected abstract ViewmapProducer getViewmapProducer();

    protected MapDefASetup getLibraryMap() throws Exception {
        URI selected = Plugin.createURI("/models/library/library.ecore");
        DomainModelSource dmSource = new DomainModelFileSetup().init(selected);
        ToolDefASetup tdmSource = new ToolDefASetup(dmSource.getModel());
        GraphDefASetup gdmSource = new GraphDefASetup(dmSource.getModel());
        return new MapDefASetup(dmSource.getModel(), tdmSource.getRegistry(), gdmSource.getCanvasDef());
    }

    protected DiaGenSource getLibraryGen(boolean rcp) throws Exception {
        MapDefASetup mmSource = this.getLibraryMap();
        return new GenASetup(mmSource.getMapping(), this.getViewmapProducer(), rcp);
    }

    public void testCompileWithStrictOptions() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.jdt.core.compiler.problem.emptyStatement", "error");
        CompilationTest.switchJavaOptions(options);
        try {
            this.testCompileMultiPackageDomain();
        }
        finally {
            CompilationTest.switchJavaOptions(options);
        }
    }

    private static void switchJavaOptions(HashMap<String, String> options) {
        Hashtable settings = JavaCore.getOptions();
        for (String key : options.keySet()) {
            String originalValue = (String)settings.get(key);
            settings.put(key, options.get(key));
            options.put(key, originalValue);
        }
        JavaCore.setOptions((Hashtable)settings);
    }

    public void testRCPCompile() throws Exception {
        DiaGenSource gmfGenSource = this.getLibraryGen(true);
        gmfGenSource.getGenDiagram().getEditorGen().setSameFileForDiagramAndModel(false);
        this.generateAndCompile(gmfGenSource, this.getMutatorsForRCP());
    }

    public void testCompileDiagram() throws Exception {
        DiaGenSource gmfGenSource = this.getLibraryGen(false);
        this.generateAndCompile(gmfGenSource, this.getMutators());
    }

    public void testCompilePotentialNameClashes() throws Exception {
        DomainModelSetup domainModel = new DomainModelSetup().init();
        domainModel.getNodeA().getEClass().setName("Node");
        domainModel.getNodeB().getEClass().setName("ShapeNode");
        domainModel.getLinkAsClass().getEClass().setName("ConnectionNode");
        domainModel.getNodeA().getNameAttr().setName("attribute");
        domainModel.getNodeB().getNameAttr().setName("class");
        domainModel.getDiagramElement().setName("Diagram");
        MapSetup mapSource = new MapSetup().init(new DiaDefSetup().init(), domainModel, new ToolDefSetup());
        DiaGenSetup gmfGenSource = new DiaGenSetup(this.getViewmapProducer()).init(mapSource);
        this.generateAndCompile(gmfGenSource, NO_MUTATORS);
    }

    public void testCompileInstanceClassNames() throws Exception {
        DomainModelSetup domainModelSetup = new DomainModelSetupInstanceClassName().init();
        MapSetup mapSource = new MapSetup().init(new DiaDefSetup().init(), domainModelSetup, new ToolDefSetup());
        DiaGenSetup gmfGenSource = new DiaGenSetup(this.getViewmapProducer()).init(mapSource);
        this.generateAndCompile(gmfGenSource, this.getMutatorsForInstanceClassNames());
    }

    public void testCompileMultiPackageDomain() throws Exception {
        MultiplePackagesDomainModelSetup ds = new MultiplePackagesDomainModelSetup().init();
        MapSetup ms = new MapSetup().init(new DiaDefSetup().init(), ds, new ToolDefSetup());
        LinkedHashSet<EPackage> additionalPacks = new LinkedHashSet<EPackage>(8);
        additionalPacks.add(ds.getNodeA().getEClass().getEPackage());
        additionalPacks.add(ds.getNodeB().getEClass().getEPackage());
        additionalPacks.add(ds.getLinkAsClass().getEClass().getEPackage());
        DiaGenSetup gmfGenSource = new MultiPackageGenSetup(additionalPacks).init(ms);
        this.generateAndCompile(gmfGenSource, NO_MUTATORS);
    }

    protected void generateAndCompile(DiaGenSource genSource, final Collection<IGenDiagramMutator> mutators) throws Exception {
        new GenProjectBaseSetup(this.getGeneratorConfiguration()){

            protected void generateDiagramPlugin(GenDiagram d) throws Exception {
                super.generateDiagramPlugin(d);
                for (IGenDiagramMutator next : mutators) {
                    next.doMutation(d);
                    try {
                        super.generateDiagramPlugin(d);
                    }
                    finally {
                        next.undoMutation(d);
                    }
                }
            }
        }.generateAndCompile(genSource);
    }

    protected Collection<IGenDiagramMutator> getMutators() {
        ArrayList<IGenDiagramMutator> result = new ArrayList<IGenDiagramMutator>();
        Collections.addAll(result, SAME_FILE_MUTATOR, SYNCHRONIZED_MUTATOR, SHORTCUT_STUFF_MUTATOR);
        return result;
    }

    protected Collection<IGenDiagramMutator> getMutatorsForRCP() {
        ArrayList<IGenDiagramMutator> result = new ArrayList<IGenDiagramMutator>();
        Collections.addAll(result, SAME_FILE_MUTATOR, SHORTCUT_STUFF_MUTATOR);
        return result;
    }

    protected Collection<IGenDiagramMutator> getMutatorsForInstanceClassNames() {
        ArrayList<IGenDiagramMutator> result = new ArrayList<IGenDiagramMutator>();
        result.add(SYNCHRONIZED_MUTATOR);
        return result;
    }

    protected static interface IGenDiagramMutator {
        public void doMutation(GenDiagram var1);

        public void undoMutation(GenDiagram var1);
    }
}

