/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.gmf.codegen.gmfgen.InnerClassViewmap;
import org.eclipse.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.gmf.codegen.gmfgen.ResizeConstraints;
import org.eclipse.gmf.codegen.gmfgen.StyleAttributes;
import org.eclipse.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.gmf.codegen.gmfgen.ViewmapLayoutType;
import org.eclipse.gmf.gmfgraph.BasicFont;
import org.eclipse.gmf.gmfgraph.Color;
import org.eclipse.gmf.gmfgraph.ColorConstants;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.ConnectionFigure;
import org.eclipse.gmf.gmfgraph.ConstantColor;
import org.eclipse.gmf.gmfgraph.CustomConnection;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Direction;
import org.eclipse.gmf.gmfgraph.Ellipse;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureAccessor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.FigureHandle;
import org.eclipse.gmf.gmfgraph.FlowLayout;
import org.eclipse.gmf.gmfgraph.Font;
import org.eclipse.gmf.gmfgraph.FontStyle;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.Layout;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.PolylineConnection;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.gmf.gmfgraph.util.FigureQualifiedNameSwitch;
import org.eclipse.gmf.gmfgraph.util.RuntimeFQNSwitch;
import org.eclipse.gmf.graphdef.codegen.NamingStrategy;
import org.eclipse.gmf.internal.bridge.genmodel.InnerClassViewmapProducer;
import org.eclipse.gmf.internal.bridge.genmodel.ViewmapProducer;
import org.eclipse.gmf.tests.gen.ViewmapProducersTest;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class ViewmapProducersTest
extends TestCase {
    private ViewmapProducer myProducer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ViewmapProducersTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.myProducer = new InnerClassViewmapProducer();
    }

    private FigureQualifiedNameSwitch getFigureSwitch() {
        return new RuntimeFQNSwitch();
    }

    public void testInnerViewmapProducerBareFigure() {
        Node n = this.createNode("n1", (Figure)GMFGraphFactory.eINSTANCE.createEllipse());
        n.getNodeFigure().setName("elli");
        Viewmap v = this.getProducer().create(n);
        ViewmapProducersTest.assertNotNull((Object)v);
        ViewmapProducersTest.assertTrue((String)v.getClass().getName(), (boolean)(v instanceof FigureViewmap));
        ViewmapProducersTest.assertEquals((String)this.getFigureSwitch().get((EObject)n.getFigure()), (String)((FigureViewmap)v).getFigureQualifiedClassName());
    }

    public void testAbleToProcessFigureAccessor() {
        CustomFigure nodeFigure = GMFGraphFactory.eINSTANCE.createCustomFigure();
        Node n = this.createNode("n1", (Figure)nodeFigure);
        nodeFigure.setName("ScrollPane");
        nodeFigure.setQualifiedClassName("org.eclipse.draw2d.ScrollPane");
        FigureAccessor figureAccess1 = GMFGraphFactory.eINSTANCE.createFigureAccessor();
        figureAccess1.setAccessor("getContents");
        nodeFigure.getCustomChildren().add((Object)figureAccess1);
        CustomFigure accessor2Type = GMFGraphFactory.eINSTANCE.createCustomFigure();
        accessor2Type.setName("Accessor2Type");
        accessor2Type.setQualifiedClassName("org.eclipse.draw2d.Viewport");
        FigureAccessor figureAccess2 = GMFGraphFactory.eINSTANCE.createFigureAccessor();
        figureAccess2.setAccessor("getViewport");
        figureAccess2.setTypedFigure(accessor2Type);
        nodeFigure.getCustomChildren().add((Object)figureAccess1);
        nodeFigure.getCustomChildren().add((Object)figureAccess2);
        DiagramLabel l1 = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        l1.setName("L1");
        l1.setFigure((FigureHandle)figureAccess1);
        DiagramLabel l2 = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        l2.setName("L2");
        l2.setFigure((FigureHandle)figureAccess2);
        Viewmap nodeViewmap = this.getProducer().create(n);
        Viewmap label1Viewmap = this.getProducer().create(l1);
        Viewmap label2Viewmap = this.getProducer().create(l2);
        ViewmapProducersTest.assertNotNull((Object)nodeViewmap);
        ViewmapProducersTest.assertNotNull((Object)label1Viewmap);
        ViewmapProducersTest.assertNotNull((Object)label2Viewmap);
        ViewmapProducersTest.assertTrue((String)label1Viewmap.getClass().getName(), (boolean)(label1Viewmap instanceof ParentAssignedViewmap));
        ViewmapProducersTest.assertTrue((String)label2Viewmap.getClass().getName(), (boolean)(label2Viewmap instanceof ParentAssignedViewmap));
        ViewmapProducersTest.assertEquals((String)figureAccess1.getAccessor(), (String)((ParentAssignedViewmap)label1Viewmap).getGetterName());
        ViewmapProducersTest.assertNull((Object)((ParentAssignedViewmap)label1Viewmap).getFigureQualifiedClassName());
        ViewmapProducersTest.assertNull((Object)((ParentAssignedViewmap)label1Viewmap).getSetterName());
        ViewmapProducersTest.assertEquals((String)figureAccess2.getAccessor(), (String)((ParentAssignedViewmap)label2Viewmap).getGetterName());
        ViewmapProducersTest.assertNotNull((Object)((ParentAssignedViewmap)label2Viewmap).getFigureQualifiedClassName());
        ViewmapProducersTest.assertEquals((String)figureAccess2.getTypedFigure().getQualifiedClassName(), (String)((ParentAssignedViewmap)label2Viewmap).getFigureQualifiedClassName());
        ViewmapProducersTest.assertNull((Object)((ParentAssignedViewmap)label2Viewmap).getSetterName());
    }

    public void testRecognizesParentAssignedCases() {
        Node n = this.createNode("n1", (Figure)GMFGraphFactory.eINSTANCE.createRoundedRectangle());
        n.getNodeFigure().setName("RouRe");
        Label lf = GMFGraphFactory.eINSTANCE.createLabel();
        lf.setName("Lf");
        n.getNodeFigure().getChildren().add((Object)lf);
        DiagramLabel innerLabel = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        innerLabel.setName("DL1");
        innerLabel.setFigure((FigureHandle)lf);
        Label topLevelLabelFigure = GMFGraphFactory.eINSTANCE.createLabel();
        topLevelLabelFigure.setName("topLevelLabelFigure");
        DiagramLabel externalLabel = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        externalLabel.setName("DL2");
        externalLabel.setFigure((FigureHandle)topLevelLabelFigure);
        ViewmapProducer p = this.getProducer();
        p.create(n);
        Viewmap innerLabelViewmap = p.create(innerLabel);
        Viewmap externalLabelViewmap = p.create(externalLabel);
        ViewmapProducersTest.assertNotNull((Object)innerLabelViewmap);
        ViewmapProducersTest.assertTrue((String)innerLabelViewmap.getClass().getName(), (boolean)(innerLabelViewmap instanceof ParentAssignedViewmap));
        ParentAssignedViewmap pav = (ParentAssignedViewmap)innerLabelViewmap;
        ViewmapProducersTest.assertEquals((String)NamingStrategy.INSTANCE.getChildFigureGetterName((Figure)lf), (String)pav.getGetterName());
        ViewmapProducersTest.assertNotNull((Object)pav.getFigureQualifiedClassName());
        ViewmapProducersTest.assertEquals((String)this.getFigureSwitch().get((EObject)lf), (String)pav.getFigureQualifiedClassName());
        ViewmapProducersTest.assertNotNull((Object)externalLabelViewmap);
        ViewmapProducersTest.assertFalse((boolean)(externalLabelViewmap instanceof ParentAssignedViewmap));
    }

    public void testFindAncestorGallery() {
        Rectangle external = GMFGraphFactory.eINSTANCE.createRectangle();
        ViewmapProducersTest.assertNull((Object)InnerClassViewmapProducer.findAncestorFigureGallery((Figure)external));
        FigureGallery figureGallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
        figureGallery.setName("Any");
        Rectangle normal = GMFGraphFactory.eINSTANCE.createRectangle();
        normal.setName("Normal");
        figureGallery.getFigures().add((Object)normal);
        Rectangle deep = GMFGraphFactory.eINSTANCE.createRectangle();
        deep.setName("Deep");
        normal.getChildren().add((Object)deep);
        ViewmapProducersTest.assertSame((Object)figureGallery, (Object)InnerClassViewmapProducer.findAncestorFigureGallery((Figure)normal));
        ViewmapProducersTest.assertSame((Object)figureGallery, (Object)InnerClassViewmapProducer.findAncestorFigureGallery((Figure)deep));
    }

    public void testViewmapRequiredPluginIDs() {
        FigureGallery figureGallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
        figureGallery.setName("Any");
        figureGallery.setImplementationBundle("com.mycompany.figures");
        CustomFigure customFigure = GMFGraphFactory.eINSTANCE.createCustomFigure();
        customFigure.setName("ExternalFigure");
        customFigure.setQualifiedClassName("com.mycompany.figures.TheFigure");
        customFigure.setBundleName("com.mycompany.figures");
        figureGallery.getFigures().add((Object)customFigure);
        Node node = GMFGraphFactory.eINSTANCE.createNode();
        node.setName("Node");
        node.setFigure((FigureHandle)customFigure);
        Compartment compartment = GMFGraphFactory.eINSTANCE.createCompartment();
        compartment.setName("Compartment");
        compartment.setFigure((FigureHandle)customFigure);
        Connection connection = GMFGraphFactory.eINSTANCE.createConnection();
        connection.setName("Link");
        CustomConnection customLinkFigure = GMFGraphFactory.eINSTANCE.createCustomConnection();
        customLinkFigure.setName("ExternalLink");
        customLinkFigure.setQualifiedClassName("com.mycompany.figures.TheLink");
        customLinkFigure.setBundleName("com.mycompany.figures");
        connection.setFigure((FigureHandle)customLinkFigure);
        figureGallery.getFigures().add((Object)customLinkFigure);
        class Checker
        extends Assert {
            final /* synthetic */ ViewmapProducersTest this$0;

            Checker(ViewmapProducersTest viewmapProducersTest) {
                this.this$0 = viewmapProducersTest;
            }

            public void checkViewmap(Viewmap viewmap) {
                Checker.assertNotNull((Object)viewmap);
                Checker.assertTrue((boolean)viewmap.getRequiredPluginIDs().contains((Object)"com.mycompany.figures"));
            }
        }
        Checker checker = new Checker(this);
        checker.checkViewmap(this.getProducer().create(node));
        checker.checkViewmap(this.getProducer().create(compartment));
        checker.checkViewmap(this.getProducer().create(connection));
    }

    public void testInnerViewmapProducerForNode() {
        Node node = this.createNode("n1", (Figure)GMFGraphFactory.eINSTANCE.createRoundedRectangle());
        ConstantColor c = GMFGraphFactory.eINSTANCE.createConstantColor();
        c.setValue(ColorConstants.CYAN_LITERAL);
        Figure figure = node.getNodeFigure();
        figure.setBackgroundColor((Color)c);
        figure.setName("RouRec1");
        node.setFigure((FigureHandle)figure);
        Viewmap v = this.getProducer().create(node);
        ViewmapProducersTest.assertNotNull((Object)v);
        ViewmapProducersTest.assertTrue((boolean)(v instanceof InnerClassViewmap));
        InnerClassViewmap icv = (InnerClassViewmap)v;
        ViewmapProducersTest.assertNotNull((Object)icv.getClassName());
        ViewmapProducersTest.assertNotNull((Object)icv.getClassBody());
        TypeDeclaration typeDecl = this.parseFirstType(icv.getClassBody());
        ViewmapProducersTest.assertNotNull((Object)typeDecl);
        String innerClassGenName = typeDecl.getName().getFullyQualifiedName();
        ViewmapProducersTest.assertEquals((String)icv.getClassName(), (String)innerClassGenName);
    }

    public void testPinnedCompartment() {
        Node rootNode = this.createNode("Root", (Figure)GMFGraphFactory.eINSTANCE.createRectangle());
        rootNode.getNodeFigure().setName("RootFig");
        Rectangle compartmentPaneA = GMFGraphFactory.eINSTANCE.createRectangle();
        compartmentPaneA.setName("CompartmentA");
        rootNode.getNodeFigure().getChildren().add((Object)compartmentPaneA);
        Ellipse intermediate = GMFGraphFactory.eINSTANCE.createEllipse();
        intermediate.setName("Intermediate");
        rootNode.getNodeFigure().getChildren().add((Object)intermediate);
        Rectangle compartmentPaneB = GMFGraphFactory.eINSTANCE.createRectangle();
        compartmentPaneB.setName("CompartmentB");
        intermediate.getChildren().add((Object)compartmentPaneB);
        Compartment compartmentA = this.createCompartment("CompartmentA", (Figure)compartmentPaneA);
        Compartment compartmentB = this.createCompartment("CompartmentB", (Figure)compartmentPaneB);
        this.getProducer().create(rootNode);
        Viewmap viewmapA = this.getProducer().create(compartmentA);
        Viewmap viewmapB = this.getProducer().create(compartmentB);
        ViewmapProducersTest.assertNotNull((Object)viewmapA);
        ViewmapProducersTest.assertNotNull((Object)viewmapB);
        ViewmapProducersTest.assertTrue((String)viewmapA.getClass().getName(), (boolean)(viewmapA instanceof ParentAssignedViewmap));
        ViewmapProducersTest.assertTrue((String)viewmapB.getClass().getName(), (boolean)(viewmapB instanceof ParentAssignedViewmap));
        ViewmapProducersTest.assertEquals((String)((ParentAssignedViewmap)viewmapA).getGetterName(), (String)NamingStrategy.INSTANCE.getChildFigureGetterName((Figure)compartmentPaneA));
        ViewmapProducersTest.assertEquals((String)((ParentAssignedViewmap)viewmapB).getGetterName(), (String)NamingStrategy.INSTANCE.getChildFigureGetterName((Figure)compartmentPaneB));
    }

    public void testFloatingCompartment() {
        Compartment compartment = this.createCompartment("Floating", (Figure)GMFGraphFactory.eINSTANCE.createEllipse());
        Viewmap viewmapFloat = this.getProducer().create(compartment);
        ViewmapProducersTest.assertNotNull((Object)viewmapFloat);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.codegen.gmfgen.ParentAssignedViewmap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ViewmapProducersTest.assertFalse((String)clazz.getName(), (boolean)(viewmapFloat instanceof ParentAssignedViewmap));
        Compartment noFigure = this.createCompartment("NoFigure", (Figure)GMFGraphFactory.eINSTANCE.createCustomFigure());
        noFigure.setFigure(null);
        Viewmap viewmapNoFigure = this.getProducer().create(noFigure);
        ViewmapProducersTest.assertNotNull((Object)viewmapNoFigure);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.gmf.codegen.gmfgen.ParentAssignedViewmap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ViewmapProducersTest.assertFalse((String)clazz2.getName(), (boolean)(viewmapNoFigure instanceof ParentAssignedViewmap));
    }

    public void testResizeConstaintsSingleDiagonals() {
        RoundedRectangle f = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        f.setName("Figure");
        new ResizeConstraintsChecker(new Direction[]{Direction.NORTH_LITERAL, Direction.WEST_LITERAL}).checkNode(this.createNode("NW", (Figure)f, Direction.NORTH_WEST_LITERAL));
        new ResizeConstraintsChecker(new Direction[]{Direction.NORTH_LITERAL, Direction.EAST_LITERAL}).checkNode(this.createNode("NE", (Figure)f, Direction.NORTH_EAST_LITERAL));
        new ResizeConstraintsChecker(new Direction[]{Direction.SOUTH_LITERAL, Direction.WEST_LITERAL}).checkNode(this.createNode("SW", (Figure)f, Direction.SOUTH_WEST_LITERAL));
        new ResizeConstraintsChecker(new Direction[]{Direction.SOUTH_LITERAL, Direction.EAST_LITERAL}).checkNode(this.createNode("SE", (Figure)f, Direction.SOUTH_EAST_LITERAL));
    }

    public void testResizeConstraintsMulty() {
        RoundedRectangle f = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        f.setName("Figure");
        Node explicitAny = this.createNode("ExplicitAll", (Figure)f, Direction.NSEW_LITERAL);
        Node implicitAny = this.createNode("ImplicitAll", (Figure)f, null);
        Node horizontal = this.createNode("Horizontal", (Figure)f, Direction.EAST_WEST_LITERAL);
        Node vertical = this.createNode("Vertical", (Figure)f, Direction.NORTH_SOUTH_LITERAL);
        NoUselessResizeConstraintsChecker allDirectionsChecker = new NoUselessResizeConstraintsChecker();
        allDirectionsChecker.checkNode(implicitAny);
        allDirectionsChecker.checkNode(explicitAny);
        new ResizeConstraintsChecker(new Direction[]{Direction.EAST_LITERAL, Direction.WEST_LITERAL}).checkNode(horizontal);
        new ResizeConstraintsChecker(new Direction[]{Direction.SOUTH_LITERAL, Direction.NORTH_LITERAL}).checkNode(vertical);
    }

    public void testResizeConstaintsSingleCartesians() {
        RoundedRectangle f = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        f.setName("Figure");
        Direction[] CARTESIANS = new Direction[]{Direction.NORTH_LITERAL, Direction.SOUTH_LITERAL, Direction.EAST_LITERAL, Direction.WEST_LITERAL};
        int i = 0;
        while (i < CARTESIANS.length) {
            Direction next = CARTESIANS[i];
            Node node = this.createNode("Single" + next.getName(), (Figure)f, next);
            new ResizeConstraintsChecker(next).checkNode(node);
            ++i;
        }
    }

    public void testViewmapLayoutType() {
        ViewmapLayoutTypeChecker checker = new ViewmapLayoutTypeChecker();
        GMFGraphFactory gmf = GMFGraphFactory.eINSTANCE;
        checker.check(null, ViewmapLayoutType.UNKNOWN_LITERAL);
        checker.check((Layout)gmf.createCustomLayout(), ViewmapLayoutType.UNKNOWN_LITERAL);
        checker.check((Layout)gmf.createGridLayout(), ViewmapLayoutType.UNKNOWN_LITERAL);
        checker.check((Layout)gmf.createBorderLayout(), ViewmapLayoutType.UNKNOWN_LITERAL);
        checker.check((Layout)gmf.createXYLayout(), ViewmapLayoutType.XY_LAYOUT_LITERAL);
        FlowLayout flow = gmf.createFlowLayout();
        flow.setForceSingleLine(false);
        checker.check((Layout)flow, ViewmapLayoutType.FLOW_LAYOUT_LITERAL);
        FlowLayout toolbar = gmf.createFlowLayout();
        toolbar.setForceSingleLine(true);
        checker.check((Layout)toolbar, ViewmapLayoutType.TOOLBAR_LAYOUT_LITERAL);
    }

    public void testStyleAttributes() {
        class Checker {
            final /* synthetic */ ViewmapProducersTest this$0;

            Checker(ViewmapProducersTest viewmapProducersTest) {
                this.this$0 = viewmapProducersTest;
            }

            public void check(Viewmap viewmap, boolean font, boolean fore, boolean back) {
                Class<?> clazz = ViewmapProducersTest.class$1;
                if (clazz == null) {
                    try {
                        clazz = ViewmapProducersTest.class$1 = Class.forName("org.eclipse.gmf.codegen.gmfgen.StyleAttributes");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StyleAttributes attributes = (StyleAttributes)viewmap.find((Class)clazz);
                if (font || fore || back) {
                    ViewmapProducersTest.assertNotNull((Object)attributes);
                    ViewmapProducersTest.assertEquals((boolean)font, (boolean)attributes.isFixedFont());
                    ViewmapProducersTest.assertEquals((boolean)fore, (boolean)attributes.isFixedForeground());
                    ViewmapProducersTest.assertEquals((boolean)back, (boolean)attributes.isFixedBackground());
                } else {
                    ViewmapProducersTest.assertNull((Object)attributes);
                }
            }

            public void check(Node node, boolean font, boolean fore, boolean back) {
                Viewmap viewmap = this.this$0.getProducer().create(node);
                this.check(viewmap, font, fore, back);
            }

            public void check(Connection link, boolean font, boolean fore, boolean back) {
                Viewmap viewmap = this.this$0.getProducer().create(link);
                this.check(viewmap, font, fore, back);
            }
        }
        Checker checker = new Checker(this);
        checker.check(this.createNode("NODE_Empty", (Figure)GMFGraphFactory.eINSTANCE.createRectangle()), false, false, false);
        checker.check(this.createLink("LINK_Empty", (ConnectionFigure)GMFGraphFactory.eINSTANCE.createPolylineConnection()), false, false, false);
        Rectangle hasFont = GMFGraphFactory.eINSTANCE.createRectangle();
        BasicFont font = GMFGraphFactory.eINSTANCE.createBasicFont();
        font.setFaceName("Arial");
        font.setHeight(12);
        font.setStyle(FontStyle.BOLD_LITERAL);
        hasFont.setFont((Font)font);
        checker.check(this.createNode("NODE_Font", (Figure)hasFont), true, false, false);
        Rectangle hasFore = GMFGraphFactory.eINSTANCE.createRectangle();
        hasFore.setForegroundColor(this.createColor(ColorConstants.GRAY_LITERAL));
        checker.check(this.createNode("NODE_Fore_Color", (Figure)hasFore), false, true, false);
        Rectangle hasBack = GMFGraphFactory.eINSTANCE.createRectangle();
        hasBack.setBackgroundColor(this.createColor(ColorConstants.LIGHT_BLUE_LITERAL));
        checker.check(this.createNode("NODE_Back_Color", (Figure)hasBack), false, false, true);
        PolylineConnection polylineWithFont = GMFGraphFactory.eINSTANCE.createPolylineConnection();
        polylineWithFont.setFont((Font)font);
        checker.check(this.createLink("Link_Font", (ConnectionFigure)polylineWithFont), true, false, false);
        PolylineConnection polylineWithColor = GMFGraphFactory.eINSTANCE.createPolylineConnection();
        polylineWithColor.setForegroundColor(this.createColor(ColorConstants.RED_LITERAL));
        checker.check(this.createLink("Link_Font", (ConnectionFigure)polylineWithColor), false, true, false);
        RoundedRectangle parent = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        parent.setName("ParentNoColor");
        Ellipse child = GMFGraphFactory.eINSTANCE.createEllipse();
        child.setName("ChildWithColor");
        child.setForegroundColor(this.createColor(ColorConstants.GREEN_LITERAL));
        parent.getChildren().add((Object)child);
        checker.check(this.createNode("ParentOfColoredChild", (Figure)parent), false, false, false);
        Label externalWithFont = GMFGraphFactory.eINSTANCE.createLabel();
        externalWithFont.setText("LabelText");
        externalWithFont.setName("ExternalWithFont");
        externalWithFont.setFont((Font)font);
        DiagramLabel diagramExternalLabel = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        diagramExternalLabel.setName("DiagramExternalLabelWithFont");
        diagramExternalLabel.setFigure((FigureHandle)externalWithFont);
        checker.check(this.getProducer().create(diagramExternalLabel), true, false, false);
        Rectangle labelParent = GMFGraphFactory.eINSTANCE.createRectangle();
        labelParent.setName("LabelParent");
        Label innerWithFont = (Label)EcoreUtil.copy((EObject)externalWithFont);
        labelParent.getChildren().add((Object)innerWithFont);
        DiagramLabel diagramInnerLabel = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        diagramInnerLabel.setName("DiagramInnerLabelWithFont");
        diagramInnerLabel.setFigure((FigureHandle)innerWithFont);
        checker.check(this.getProducer().create(diagramInnerLabel), true, false, false);
    }

    private TypeDeclaration parseFirstType(String classContents) {
        ASTParser p = ASTParser.newParser((int)3);
        p.setSource(classContents.toCharArray());
        p.setKind(8);
        ASTNode astNode = p.createAST(null);
        ViewmapProducersTest.assertEquals((int)15, (int)astNode.getNodeType());
        CompilationUnit cu = (CompilationUnit)astNode;
        ViewmapProducersTest.assertNull((Object)cu.getPackage());
        ViewmapProducersTest.assertTrue((cu.types().size() > 0 ? 1 : 0) != 0);
        ViewmapProducersTest.assertTrue((boolean)(cu.types().get(0) instanceof TypeDeclaration));
        return (TypeDeclaration)cu.types().get(0);
    }

    private Node createNode(String name, Figure figure) {
        return this.createNode(name, figure, null);
    }

    private Connection createLink(String name, ConnectionFigure connectionFigure) {
        Connection connection = GMFGraphFactory.eINSTANCE.createConnection();
        connectionFigure.setName(name);
        connection.setName(name);
        connection.setFigure((FigureHandle)connectionFigure);
        return connection;
    }

    private Compartment createCompartment(String name, Figure figure) {
        ViewmapProducersTest.assertNotNull((Object)name);
        ViewmapProducersTest.assertNotNull((Object)figure);
        Compartment result = GMFGraphFactory.eINSTANCE.createCompartment();
        result.setName(name);
        result.setFigure((FigureHandle)figure);
        return result;
    }

    private Node createNode(String name, Figure figure, Direction optionalConstaint) {
        ViewmapProducersTest.assertNotNull((Object)name);
        ViewmapProducersTest.assertNotNull((Object)figure);
        Node result = GMFGraphFactory.eINSTANCE.createNode();
        result.setName(name);
        figure.setName(name);
        result.setFigure((FigureHandle)figure);
        if (optionalConstaint != null) {
            result.setResizeConstraint(optionalConstaint);
        }
        return result;
    }

    protected ViewmapProducer getProducer() {
        return this.myProducer;
    }

    private Color createColor(ColorConstants color) {
        ConstantColor result = GMFGraphFactory.eINSTANCE.createConstantColor();
        result.setValue(color);
        return result;
    }

    private class ResizeConstraintsChecker {
        private final List myExpectedNames;
        static /* synthetic */ Class class$0;

        public ResizeConstraintsChecker(Direction[] expectedDirectionNames) {
            this.myExpectedNames = new ArrayList(expectedDirectionNames.length);
            int i = 0;
            while (i < expectedDirectionNames.length) {
                this.myExpectedNames.add(expectedDirectionNames[i].getName());
                ++i;
            }
        }

        public ResizeConstraintsChecker(Direction theOnly) {
            this(new Direction[]{theOnly});
        }

        protected ResizeConstraintsChecker() {
            this.myExpectedNames = Collections.EMPTY_LIST;
        }

        public void checkNode(Node node) {
            Viewmap viewmap = ViewmapProducersTest.this.getProducer().create(node);
            this.checkViewmap(node.getName(), viewmap);
        }

        public void checkViewmap(String nodeName, Viewmap v) {
            ViewmapProducersTest.assertNotNull((Object)v);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.codegen.gmfgen.ResizeConstraints");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResizeConstraints genConstraint = (ResizeConstraints)v.find((Class)clazz);
            ViewmapProducersTest.assertNotNull((String)("Problem node:" + nodeName), (Object)genConstraint);
            ViewmapProducersTest.assertEquals((String)("Problem node:" + nodeName), (int)this.myExpectedNames.size(), (int)genConstraint.getResizeHandleNames().size());
            ViewmapProducersTest.assertTrue((String)("Problem node:" + nodeName), (boolean)genConstraint.getResizeHandleNames().containsAll((Collection)this.myExpectedNames));
        }
    }

    private class NoUselessResizeConstraintsChecker
    extends ResizeConstraintsChecker {
        static /* synthetic */ Class class$0;

        public void checkViewmap(String nodeName, Viewmap v) {
            ViewmapProducersTest.assertNotNull((Object)v);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.codegen.gmfgen.ResizeConstraints");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResizeConstraints genConstraint = (ResizeConstraints)v.find((Class)clazz);
            ViewmapProducersTest.assertNull((String)("Problem node:" + nodeName), (Object)genConstraint);
        }
    }

    private class ViewmapLayoutTypeChecker {
        private final Figure myFigure;
        private final Node myNode;

        public ViewmapLayoutTypeChecker() {
            this((Figure)GMFGraphFactory.eINSTANCE.createRectangle(), GMFGraphFactory.eINSTANCE.createNode());
        }

        public ViewmapLayoutTypeChecker(Figure figure, Node node) {
            this.myFigure = figure;
            this.myFigure.setName("Figure");
            this.myNode = node;
            this.myNode.setName("Node");
            this.myNode.setFigure((FigureHandle)this.myFigure);
        }

        public void check(Layout graphLayout, ViewmapLayoutType expected) {
            this.myFigure.setLayout(graphLayout);
            ViewmapLayoutType actual = ViewmapProducersTest.this.getProducer().create(this.myNode).getLayoutType();
            ViewmapProducersTest.assertNotNull((Object)actual);
            ViewmapProducersTest.assertEquals((Object)expected, (Object)actual);
        }
    }
}

