/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.gmf.common.codegen.ImportAssistant;
import org.eclipse.gmf.gmfgraph.BasicFont;
import org.eclipse.gmf.gmfgraph.Color;
import org.eclipse.gmf.gmfgraph.ColorConstants;
import org.eclipse.gmf.gmfgraph.ConnectionFigure;
import org.eclipse.gmf.gmfgraph.ConstantColor;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.DecorationFigure;
import org.eclipse.gmf.gmfgraph.Ellipse;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.Font;
import org.eclipse.gmf.gmfgraph.FontStyle;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.LineKind;
import org.eclipse.gmf.gmfgraph.Point;
import org.eclipse.gmf.gmfgraph.Polygon;
import org.eclipse.gmf.gmfgraph.PolygonDecoration;
import org.eclipse.gmf.gmfgraph.PolylineConnection;
import org.eclipse.gmf.gmfgraph.RGBColor;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.gmf.gmfgraph.util.FigureQualifiedNameSwitch;
import org.eclipse.gmf.gmfgraph.util.RuntimeFQNSwitch;
import org.eclipse.gmf.graphdef.codegen.FigureGenerator;
import org.eclipse.gmf.graphdef.codegen.StandaloneGenerator;
import org.eclipse.gmf.internal.common.codegen.ImportUtil;
import org.eclipse.gmf.internal.graphdef.codegen.GalleryProcessor;
import org.eclipse.gmf.tests.CompileUtil;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.gmf.tests.gen.GenericFigureCheck;
import org.eclipse.gmf.tests.setup.SessionSetup;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class FigureCodegenTestBase
extends TestCase {
    protected static final String DRAW2D = "org.eclipse.draw2d";
    private FigureGenerator figureGenerator;
    protected String myFigurePackageName = "org.eclipse.gmf.tests.sample.figures";
    protected static final FigureCheck CHECK_CAN_CREATE_INSTANCE = new FigureCheck(){

        public void checkFigure(IFigure figure) {
        }
    };
    static /* synthetic */ Class class$0;

    public FigureCodegenTestBase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        SessionSetup.getRuntimeWorkspaceSetup();
    }

    protected final void setCustomFigureGenerator(FigureGenerator generator) {
        this.figureGenerator = generator;
    }

    protected void performTests(Figure f) {
        this.performTests(f, new GenericFigureCheck(f));
    }

    protected final void performTests(Figure f, FigureCheck check) {
        this.generateAndParse(f);
        Class figureClass = this.generateAndCompile(this.getGMFGraphGeneratorConfig(), f);
        if (check != null) {
            IFigure figure = check.instantiateFigure(figureClass);
            FigureCodegenTestBase.assertNotNull((Object)figure);
            check.checkFigure(figure);
        }
    }

    protected final void generateAndParse(Figure f) {
        String res = this.getGenerator().go(f, this.createImportManager(f));
        FigureCodegenTestBase.assertNotNull((String)"Generation should produce code", (Object)res);
        ASTParser p = ASTParser.newParser((int)3);
        p.setSource(res.toCharArray());
        ASTNode astNode = p.createAST(null);
        FigureCodegenTestBase.assertEquals((String)"Generator is expected to produce cu", (int)astNode.getNodeType(), (int)15);
        CompilationUnit cu = (CompilationUnit)astNode;
        if (this.getFigurePackageName() != null) {
            FigureCodegenTestBase.assertNotNull((String)"Generator initialized with packageName should produce package statement", (Object)cu.getPackage());
            FigureCodegenTestBase.assertEquals((String)"Package names are different", (String)this.getFigurePackageName(), (String)cu.getPackage().getName().getFullyQualifiedName());
        } else {
            FigureCodegenTestBase.assertNull((Object)cu.getPackage());
        }
        IProblem[] problems = cu.getProblems();
        int i = 0;
        while (i < problems.length) {
            FigureCodegenTestBase.assertFalse((String)(String.valueOf(problems[i].getMessage()) + ", line:" + problems[i].getSourceLineNumber() + ", pos:" + cu.getColumnNumber(problems[i].getSourceStart())), (boolean)problems[i].isError());
            ++i;
        }
    }

    protected StandaloneGenerator.Config getGMFGraphGeneratorConfig() {
        return new StandaloneGenerator.ConfigImpl(this.getTestPluginName(), this.getFigurePackageName());
    }

    protected final Class generateAndCompile(StandaloneGenerator.Config config, Figure figure) {
        FigureGallery gallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
        gallery.setName("bb");
        gallery.getFigures().add((Object)figure);
        gallery.setImplementationBundle(Plugin.getPluginID());
        GeneratedClassData[] theOnly = this.generateAndCompile(config, gallery);
        FigureCodegenTestBase.assertNotNull((Object)theOnly);
        FigureCodegenTestBase.assertEquals((int)1, (int)theOnly.length);
        return theOnly[0].getLoadedClass();
    }

    protected final GeneratedClassData[] generateAndCompile(StandaloneGenerator.Config config, FigureGallery gallery) {
        if (gallery.getName() == null) {
            gallery.setName("NameDoesNotMakeSense");
        }
        FigureCodegenTestBase.assertNotNull((Object)gallery.getImplementationBundle());
        FigureCodegenTestBase.assertFalse((boolean)gallery.getFigures().isEmpty());
        try {
            StandaloneGenerator generator = new StandaloneGenerator((StandaloneGenerator.Processor)new GalleryProcessor(gallery), config, (FigureQualifiedNameSwitch)new RuntimeFQNSwitch());
            generator.run();
            FigureCodegenTestBase.assertTrue((String)generator.getRunStatus().toString(), (generator.getRunStatus().getSeverity() < 4 ? 1 : 0) != 0);
            Bundle bundle = this.installPlugin(config.getPluginID());
            ArrayList<GeneratedClassData> result = new ArrayList<GeneratedClassData>();
            Iterator figures = gallery.getFigures().iterator();
            while (figures.hasNext()) {
                Figure next = (Figure)figures.next();
                String fqnName = config.getMainPackageName() == null || config.getMainPackageName().trim().length() == 0 ? next.getName() : String.valueOf(config.getMainPackageName()) + '.' + next.getName();
                result.add(new GeneratedClassData(next, bundle.loadClass(fqnName)));
            }
            return result.toArray(new GeneratedClassData[result.size()]);
        }
        catch (MalformedURLException e) {
            FigureCodegenTestBase.fail((String)e.getMessage());
        }
        catch (BundleException e) {
            FigureCodegenTestBase.fail((String)e.getMessage());
        }
        catch (ClassNotFoundException e) {
            FigureCodegenTestBase.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            FigureCodegenTestBase.fail((String)e.getMessage());
        }
        catch (Exception e) {
            FigureCodegenTestBase.fail((String)e.getMessage());
        }
        throw new InternalError("Impossible");
    }

    protected final Bundle installPlugin(String pluginId) throws CoreException, Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginId);
        SessionSetup.getRuntimeWorkspaceSetup().updateClassPath(project);
        IStatus compileStatus = new CompileUtil().build(project);
        FigureCodegenTestBase.assertTrue((String)compileStatus.getMessage(), (compileStatus.getSeverity() < 4 ? 1 : 0) != 0);
        String url = project.getLocation().toFile().toURL().toExternalForm();
        return Plugin.getBundleContext().installBundle(url);
    }

    protected final Figure figure1() {
        CustomFigure cf = GMFGraphFactory.eINSTANCE.createCustomFigure();
        cf.setName("MyRRectangleAsCustom");
        cf.setBundleName(DRAW2D);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.draw2d.RoundedRectangle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        cf.setQualifiedClassName(clazz.getName());
        Point p = GMFGraphFactory.eINSTANCE.createPoint();
        p.setX(1023);
        p.setY(33);
        cf.setSize(p);
        cf.getChildren().add((Object)this.figure2());
        Ellipse e = GMFGraphFactory.eINSTANCE.createEllipse();
        e.setName("Elli");
        e.setFill(true);
        cf.getChildren().add((Object)e);
        return cf;
    }

    protected final Figure figure2() {
        Rectangle r = GMFGraphFactory.eINSTANCE.createRectangle();
        r.setName("MyRect");
        r.setFill(true);
        r.setLineWidth(3);
        r.setLineKind(LineKind.LINE_DASHDOT_LITERAL);
        Label l1 = GMFGraphFactory.eINSTANCE.createLabel();
        l1.setText("aaaaa");
        l1.setName("L1");
        l1.setFont(FigureCodegenTestBase.createBasicFont("Arial", 9, FontStyle.ITALIC_LITERAL));
        l1.setForegroundColor((Color)FigureCodegenTestBase.createConstantColor(ColorConstants.CYAN_LITERAL));
        Label l2 = GMFGraphFactory.eINSTANCE.createLabel();
        l2.setText("bbbbb");
        l2.setName("L2");
        l2.setFont(FigureCodegenTestBase.createBasicFont("Helvetica", 12, FontStyle.BOLD_LITERAL));
        r.getChildren().add((Object)l1);
        r.getChildren().add((Object)l2);
        return r;
    }

    protected final Figure figure3() {
        RoundedRectangle r = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        r.setName("Rounded1");
        Polygon pg = GMFGraphFactory.eINSTANCE.createPolygon();
        pg.setName("Polygon1");
        Point p = GMFGraphFactory.eINSTANCE.createPoint();
        p.setX(1);
        p.setY(2);
        pg.getTemplate().add((Object)p);
        p = GMFGraphFactory.eINSTANCE.createPoint();
        p.setX(0);
        p.setY(3);
        pg.getTemplate().add((Object)p);
        p = GMFGraphFactory.eINSTANCE.createPoint();
        p.setX(-2);
        p.setY(-1);
        pg.getTemplate().add((Object)p);
        r.getChildren().add((Object)pg);
        r.getChildren().add((Object)this.figure1());
        return r;
    }

    protected final ConnectionFigure ecoreContainmentRef() {
        PolylineConnection cf = GMFGraphFactory.eINSTANCE.createPolylineConnection();
        cf.setName("ContainmentRef");
        PolygonDecoration df = this.createRhomb();
        df.setFill(true);
        cf.setSourceDecoration((DecorationFigure)df);
        return cf;
    }

    protected final PolygonDecoration createRhomb() {
        PolygonDecoration df = GMFGraphFactory.eINSTANCE.createPolygonDecoration();
        Point p = GMFGraphFactory.eINSTANCE.createPoint();
        p.setX(-1);
        p.setY(1);
        df.getTemplate().add((Object)p);
        p = GMFGraphFactory.eINSTANCE.createPoint();
        p.setX(0);
        p.setY(0);
        df.getTemplate().add((Object)p);
        p = GMFGraphFactory.eINSTANCE.createPoint();
        p.setX(-1);
        p.setY(-1);
        df.getTemplate().add((Object)p);
        p = GMFGraphFactory.eINSTANCE.createPoint();
        p.setX(-2);
        p.setY(0);
        df.getTemplate().add((Object)p);
        return df;
    }

    protected final String getFigurePackageName() {
        return this.myFigurePackageName;
    }

    protected final String getTestPluginName() {
        return "org.eclipse.gmf.tests.sample.figures." + this.getName() + ".t" + System.currentTimeMillis();
    }

    protected final String getPluginActivatorClassFQN() {
        return this.getFigurePackageName() == null ? "PluginActivator" : String.valueOf(this.getFigurePackageName()) + '.' + "PluginActivator";
    }

    protected ImportAssistant createImportManager(Figure f) {
        return new ImportUtil(this.getFigurePackageName(), CodeGenUtil.validJavaIdentifier((String)f.getName()));
    }

    private FigureGenerator getGenerator() {
        if (this.figureGenerator == null) {
            this.figureGenerator = new FigureGenerator((FigureQualifiedNameSwitch)new RuntimeFQNSwitch(), false);
        }
        return this.figureGenerator;
    }

    public static FigureCheck combineChecks(final FigureCheck[] checks) {
        FigureCodegenTestBase.assertNotNull((Object)checks);
        FigureCodegenTestBase.assertTrue((checks.length > 0 ? 1 : 0) != 0);
        return new FigureCheck(){

            protected IFigure instantiateFigure(Class figureClass) {
                return checks[0].instantiateFigure(figureClass);
            }

            public void checkFigure(IFigure figure) {
                int i = 0;
                while (i < checks.length) {
                    checks[i].checkFigure(figure);
                    ++i;
                }
            }
        };
    }

    public static FigureCheck combineChecks(FigureCheck first, FigureCheck second) {
        return FigureCodegenTestBase.combineChecks(new FigureCheck[]{first, second});
    }

    protected static final ConstantColor createConstantColor(ColorConstants constant) {
        ConstantColor result = GMFGraphFactory.eINSTANCE.createConstantColor();
        result.setValue(constant);
        return result;
    }

    protected static final RGBColor createRGBColor(int red, int green, int blue) {
        RGBColor result = GMFGraphFactory.eINSTANCE.createRGBColor();
        result.setRed(red);
        result.setGreen(green);
        result.setBlue(blue);
        return result;
    }

    protected static final Font createBasicFont(String name, int height, FontStyle style) {
        BasicFont result = GMFGraphFactory.eINSTANCE.createBasicFont();
        result.setFaceName(name);
        result.setHeight(height);
        result.setStyle(style);
        return result;
    }

    public static abstract class FigureCheck
    extends Assert {
        protected IFigure instantiateFigure(Class figureClass) {
            Object result = null;
            try {
                result = figureClass.newInstance();
            }
            catch (InstantiationException e) {
                FigureCheck.fail((String)e.getMessage());
            }
            catch (IllegalAccessException e) {
                FigureCheck.fail((String)e.getMessage());
            }
            FigureCheck.assertNotNull(result);
            FigureCheck.assertTrue((String)figureClass.getName(), (boolean)(result instanceof IFigure));
            return result;
        }

        public abstract void checkFigure(IFigure var1);
    }

    protected static class GeneratedClassData {
        private final Figure myFigureDef;
        private final Class myLoadedClass;

        public GeneratedClassData(Figure figureDef, Class loadedClass) {
            this.myFigureDef = figureDef;
            this.myLoadedClass = loadedClass;
        }

        public Class getLoadedClass() {
            return this.myLoadedClass;
        }

        public Figure getFigureDef() {
            return this.myFigureDef;
        }
    }
}

