/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.common.ui.action.IDisposableAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.AlignAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.SelectAllAction;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.ITestActionCallback;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;

public abstract class AbstractDiagramTests
extends AbstractTestBase {
    public AbstractDiagramTests(String arg0) {
        super(arg0);
    }

    protected ZoomManager getZoomManager() {
        RootEditPart root = this.getDiagramEditPart().getViewer().getRootEditPart();
        if (root instanceof DiagramRootEditPart) {
            return ((DiagramRootEditPart)root).getZoomManager();
        }
        return null;
    }

    public void testZoom() throws Exception {
        double state;
        this.getTestFixture().openDiagram();
        AbstractDiagramTests.assertNotNull((String)"no drawing surface", (Object)this.getDrawSurfaceEditPart());
        ZoomManager zoomManager = this.getZoomManager();
        AbstractDiagramTests.assertTrue((zoomManager != null ? 1 : 0) != 0);
        zoomManager.setZoom(zoomManager.getMinZoom());
        while (zoomManager.canZoomIn()) {
            state = zoomManager.getNextZoomLevel();
            AbstractDiagramTests.assertTrue((state <= zoomManager.getMaxZoom() ? 1 : 0) != 0);
            AbstractDiagramTests.assertTrue((state >= zoomManager.getMinZoom() ? 1 : 0) != 0);
            zoomManager.setZoom(state);
        }
        while (zoomManager.canZoomOut()) {
            state = zoomManager.getPreviousZoomLevel();
            AbstractDiagramTests.assertTrue((state <= zoomManager.getMaxZoom() ? 1 : 0) != 0);
            AbstractDiagramTests.assertTrue((state >= zoomManager.getMinZoom() ? 1 : 0) != 0);
            zoomManager.setZoom(state);
        }
        zoomManager.zoomTo(this.getDrawSurfaceFigure().getBounds());
    }

    public void testZoomToolFunctionality() throws Exception {
        this.getTestFixture().openDiagram();
        RootEditPart root = this.getDiagramEditPart().getViewer().getRootEditPart();
        DiagramRootEditPart dgrmRoot = (DiagramRootEditPart)root;
        double currentZoom = dgrmRoot.getZoomManager().getZoom();
        dgrmRoot.zoomIn(new Point(200, 200));
        double newZoom = dgrmRoot.getZoomManager().getZoom();
        AbstractDiagramTests.assertTrue((newZoom > currentZoom ? 1 : 0) != 0);
        currentZoom = newZoom;
        dgrmRoot.zoomOut(new Point(300, 300));
        newZoom = dgrmRoot.getZoomManager().getZoom();
        AbstractDiagramTests.assertTrue((newZoom < currentZoom ? 1 : 0) != 0);
        currentZoom = newZoom;
        dgrmRoot.zoomTo(new Rectangle(20, 20, 500, 500));
        newZoom = dgrmRoot.getZoomManager().getZoom();
        AbstractDiagramTests.assertTrue((newZoom < currentZoom ? 1 : 0) != 0);
    }

    protected List getSelectableShapesIn(IGraphicalEditPart parent) {
        AbstractDiagramTests.assertNotNull((Object)parent);
        ArrayList shapes = new ArrayList();
        for (Object child : parent.getChildren()) {
            if (child instanceof ShapeNodeEditPart && ((ShapeNodeEditPart)child).isSelectable()) {
                shapes.add(child);
            }
            shapes.addAll(this.getSelectableShapesIn((IGraphicalEditPart)child));
        }
        return shapes;
    }

    public void testSelect() throws Exception {
        this.getTestFixture().openDiagram();
        List connectors = this.getConnectors();
        List shapes = this.getSelectableShapesIn(this.getDrawSurfaceEditPart());
        ArrayList all = new ArrayList();
        all.addAll(connectors);
        all.addAll(shapes);
        this.selectAll(this.getDrawSurfaceEditPart(), all);
    }

    protected void selectAll(final IGraphicalEditPart currentSelection, final List shouldSelect) throws Exception {
        AbstractDiagramTests.assertNotNull((String)"no drawing surface", (Object)this.getDrawSurfaceEditPart());
        if (currentSelection != null) {
            this.getDiagramEditPart().getViewer().setSelection((ISelection)new StructuredSelection((Object)currentSelection));
        }
        SelectAllAction selectAction = SelectAllAction.createSelectAllAction((IWorkbenchPage)this.getWorkbenchPage());
        this.testAction((IDisposableAction)selectAction, new ITestActionCallback(){

            public void onRunExecution() {
                List selectedParts = AbstractDiagramTests.this.getDiagramEditPart().getViewer().getSelectedEditParts();
                if (!shouldSelect.isEmpty()) {
                    AbstractDiagramTests.assertTrue((shouldSelect.containsAll(selectedParts) && selectedParts.containsAll(shouldSelect) ? 1 : 0) != 0);
                } else {
                    AbstractDiagramTests.assertTrue((boolean)selectedParts.contains(currentSelection));
                }
            }
        });
    }

    public void testAlignment() throws Exception {
        this.getTestFixture().openDiagram();
        AbstractDiagramTests.assertNotNull((String)"no drawing surface", (Object)this.getDrawSurfaceEditPart());
        AlignAction a1 = new AlignAction(this.getWorkbenchPage(), "org.eclipse.gef.align_left", 1);
        AlignAction a2 = new AlignAction(this.getWorkbenchPage(), "org.eclipse.gef.align_right", 4);
        AlignAction a3 = new AlignAction(this.getWorkbenchPage(), "org.eclipse.gef.align_top", 8);
        AlignAction a4 = new AlignAction(this.getWorkbenchPage(), "org.eclipse.gef.align_bottom", 32);
        AlignAction a5 = new AlignAction(this.getWorkbenchPage(), "org.eclipse.gef.align_center", 2);
        AlignAction a6 = new AlignAction(this.getWorkbenchPage(), "org.eclipse.gef.align_middle", 16);
        EditPartViewer viewer = this.getDiagramEditPart().getRoot().getViewer();
        viewer.deselectAll();
        List shapeChildren = this.getDrawSurfaceEditPart().getChildren();
        int i = 0;
        while (i < shapeChildren.size()) {
            viewer.appendSelection((EditPart)shapeChildren.get(i));
            ++i;
        }
        this.testAction((IDisposableAction)a1, new ITestActionCallback(){

            public void onRunExecution() {
            }
        });
        this.testAction((IDisposableAction)a2, new ITestActionCallback(){

            public void onRunExecution() {
            }
        });
        this.testAction((IDisposableAction)a3, new ITestActionCallback(){

            public void onRunExecution() {
            }
        });
        this.testAction((IDisposableAction)a4, new ITestActionCallback(){

            public void onRunExecution() {
            }
        });
        this.testAction((IDisposableAction)a5, new ITestActionCallback(){

            public void onRunExecution() {
            }
        });
        this.testAction((IDisposableAction)a6, new ITestActionCallback(){

            public void onRunExecution() {
            }
        });
    }
}

