/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.NotationPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestroyElementCommand
extends CompoundCommand {
    protected EditingDomain domain;
    protected Collection<?> collection;
    protected static final String LABEL = "Delete";
    protected static final String DESCRIPTION = "Remove the objects and clean up references to them from within the editing domain";

    public static Command create(EditingDomain domain, Object object) {
        return DestroyElementCommand.create(domain, (Collection)Collections.singleton(object));
    }

    public static Command create(EditingDomain domain, Collection<?> collection) {
        return domain.createCommand(DestroyElementCommand.class, new CommandParameter(null, null, collection));
    }

    public DestroyElementCommand(EditingDomain domain, Collection<?> collection) {
        super(0, LABEL, DESCRIPTION);
        this.domain = domain;
        this.collection = collection;
    }

    public DestroyElementCommand(EditingDomain domain, CommandParameter commandParameter) {
        this(domain, commandParameter.getCollection());
    }

    protected boolean shouldRemoveReference(EStructuralFeature.Setting setting) {
        return NotationPackage.eINSTANCE.getView_Element() != setting.getEStructuralFeature();
    }

    protected boolean prepare() {
        this.prepareCommand();
        return super.prepare();
    }

    protected void prepareCommand() {
        HashMap<Resource, Collection> uncontainedObjects = null;
        BasicEList otherObjects = new BasicEList();
        for (Object obj : this.collection) {
            EObject nextEObject;
            if (obj instanceof EObject && (nextEObject = (EObject)obj).eContainer() == null && nextEObject.eResource() != null) {
                Collection uncontainedObjectsForResource;
                if (uncontainedObjects == null) {
                    uncontainedObjects = new HashMap<Resource, Collection>();
                }
                if ((uncontainedObjectsForResource = (Collection)uncontainedObjects.get(nextEObject.eResource())) == null) {
                    uncontainedObjectsForResource = new BasicEList();
                    uncontainedObjects.put(nextEObject.eResource(), uncontainedObjectsForResource);
                }
                uncontainedObjectsForResource.add(nextEObject);
                continue;
            }
            otherObjects.add(obj);
        }
        if (!otherObjects.isEmpty()) {
            this.append(RemoveCommand.create((EditingDomain)this.domain, (Collection)otherObjects));
        }
        if (uncontainedObjects != null) {
            for (Map.Entry entry : uncontainedObjects.entrySet()) {
                this.append((Command)new RemoveCommand(this.domain, ((Resource)entry.getKey()).getContents(), (Collection)entry.getValue()));
            }
        }
    }

    public void execute() {
        UniqueEList eObjects = new UniqueEList();
        Iterator<?> i = this.collection.iterator();
        while (i.hasNext()) {
            TreeIterator j;
            Object object = AdapterFactoryEditingDomain.unwrap(i.next());
            if (object instanceof EObject) {
                eObjects.add(object);
                j = ((EObject)object).eAllContents();
                while (j.hasNext()) {
                    eObjects.add(j.next());
                }
                continue;
            }
            if (!(object instanceof Resource)) continue;
            j = ((Resource)object).getAllContents();
            while (j.hasNext()) {
                eObjects.add(j.next());
            }
        }
        Map usages = EcoreUtil.UsageCrossReferencer.findAll((Collection)eObjects, (ResourceSet)this.domain.getResourceSet());
        super.execute();
        for (Map.Entry entry : usages.entrySet()) {
            EObject eObject = (EObject)entry.getKey();
            Collection settings = (Collection)entry.getValue();
            for (EStructuralFeature.Setting setting : settings) {
                EStructuralFeature eStructuralFeature;
                EObject referencingEObject;
                if (!this.shouldRemoveReference(setting) || eObjects.contains(referencingEObject = setting.getEObject()) || !(eStructuralFeature = setting.getEStructuralFeature()).isChangeable()) continue;
                if (eStructuralFeature.isMany()) {
                    this.appendAndExecute(RemoveCommand.create((EditingDomain)this.domain, (Object)referencingEObject, (Object)eStructuralFeature, (Object)eObject));
                    continue;
                }
                this.appendAndExecute(SetCommand.create((EditingDomain)this.domain, (Object)referencingEObject, (Object)eStructuralFeature, null));
            }
        }
    }
}

