/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.bridge.BaseScriptingEnvironment;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.ColorKey;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SVGColorConverter;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGSVGElement;

public class ImageTranscoderEx
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_MAINTAIN_ASPECT_RATIO = new BooleanKey();
    public static final TranscodingHints.Key KEY_FILL_COLOR = new ColorKey();
    public static final TranscodingHints.Key KEY_OUTLINE_COLOR = new ColorKey();
    public static final TranscodingHints.Key KEY_ANTI_ALIASING = new BooleanKey();
    private BufferedImage bufferedImage = null;

    protected void initSVGDocument(SVGOMDocument svgDoc) {
        Color fillColor = null;
        Color outlineColor = null;
        if (this.hints.containsKey((Object)KEY_FILL_COLOR)) {
            fillColor = (Color)this.hints.get((Object)KEY_FILL_COLOR);
        }
        if (this.hints.containsKey((Object)KEY_OUTLINE_COLOR)) {
            outlineColor = (Color)this.hints.get((Object)KEY_OUTLINE_COLOR);
        }
        if (fillColor == null && outlineColor == null) {
            return;
        }
        SVGColorConverter.getInstance().replaceDocumentColors(svgDoc, fillColor, outlineColor);
    }

    protected GraphicsNode buildGVTTree(SVGOMDocument svgDoc, BridgeContext context) throws TranscoderException {
        GVTBuilder gvtBuilder = new GVTBuilder();
        GraphicsNode gvtRoot = null;
        try {
            gvtRoot = gvtBuilder.build(context, (Document)svgDoc);
        }
        catch (BridgeException ex) {
            throw new TranscoderException((Exception)((Object)ex));
        }
        return gvtRoot;
    }

    protected AffineTransform calculateSizeTransform(SVGSVGElement svgRoot, GraphicsNode gvtRoot, String uri, float docWidth, float docHeight, float newWidth, float newHeight) throws TranscoderException {
        CanvasGraphicsNode cgn;
        float yscale;
        float xscale;
        AffineTransform Px;
        String ref = null;
        try {
            ref = new URL(uri == null ? "" : uri).getRef();
        }
        catch (MalformedURLException malformedURLException) {}
        boolean maintainAspectRatio = true;
        if (this.hints.containsKey((Object)KEY_MAINTAIN_ASPECT_RATIO)) {
            maintainAspectRatio = (Boolean)this.hints.get((Object)KEY_MAINTAIN_ASPECT_RATIO);
        }
        if (maintainAspectRatio) {
            try {
                Px = ViewBox.getViewTransform((String)ref, (Element)svgRoot, (float)newWidth, (float)newHeight);
            }
            catch (BridgeException ex) {
                throw new TranscoderException((Exception)((Object)ex));
            }
            if (Px.isIdentity() && (newWidth != docWidth || newHeight != docHeight)) {
                xscale = newWidth / docWidth;
                yscale = newHeight / docHeight;
                if (docHeight / docWidth > newHeight / newWidth) {
                    xscale = yscale;
                } else {
                    yscale = xscale;
                }
                Px = AffineTransform.getScaleInstance(xscale, yscale);
            }
        } else {
            xscale = newWidth / docWidth;
            yscale = newHeight / docHeight;
            Px = AffineTransform.getScaleInstance(xscale, yscale);
        }
        if (this.hints.containsKey((Object)KEY_AOI)) {
            Rectangle2D aoi = (Rectangle2D)this.hints.get((Object)KEY_AOI);
            aoi = Px.createTransformedShape(aoi).getBounds2D();
            AffineTransform Mx = new AffineTransform();
            double sx = (double)newWidth / aoi.getWidth();
            double sy = (double)newHeight / aoi.getHeight();
            Mx.scale(sx, sy);
            double tx = -aoi.getX();
            double ty = -aoi.getY();
            Mx.translate(tx, ty);
            Px.preConcatenate(Mx);
        }
        if ((cgn = this.getCanvasGraphicsNode(gvtRoot)) != null) {
            cgn.setViewingTransform(Px);
            this.curTxf = new AffineTransform();
        } else {
            this.curTxf = Px;
        }
        return this.curTxf;
    }

    private boolean shouldCopyDocument(Document document) {
        if (!(document.getImplementation() instanceof SVGDOMImplementation)) {
            return true;
        }
        return this.hints.containsKey((Object)KEY_FILL_COLOR) || this.hints.containsKey((Object)KEY_OUTLINE_COLOR);
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        GraphicsNode gvtRoot;
        boolean isDynamic;
        if (this.shouldCopyDocument(document)) {
            DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
            document = DOMUtilities.deepCloneDocument((Document)document, (DOMImplementation)impl);
            if (uri != null) {
                try {
                    URL url = new URL(uri);
                    ((SVGOMDocument)document).setURLObject(url);
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        this.ctx = new BridgeContext(this.userAgent);
        SVGOMDocument svgDoc = (SVGOMDocument)document;
        SVGSVGElement svgRoot = svgDoc.getRootElement();
        this.builder = new GVTBuilder();
        boolean bl = isDynamic = this.hints.containsKey((Object)KEY_EXECUTE_ONLOAD) && (Boolean)this.hints.get((Object)KEY_EXECUTE_ONLOAD) != false && BaseScriptingEnvironment.isDynamicDocument((BridgeContext)this.ctx, (Document)svgDoc);
        if (isDynamic) {
            this.ctx.setDynamicState(2);
        }
        this.initSVGDocument(svgDoc);
        try {
            gvtRoot = this.builder.build(this.ctx, (Document)svgDoc);
        }
        catch (BridgeException ex) {
            throw new TranscoderException((Exception)((Object)ex));
        }
        float docWidth = (float)this.ctx.getDocumentSize().getWidth();
        float docHeight = (float)this.ctx.getDocumentSize().getHeight();
        this.setImageSize(docWidth, docHeight);
        AffineTransform Px = this.calculateSizeTransform(svgRoot, gvtRoot, uri, docWidth, docHeight, this.width, this.height);
        this.root = gvtRoot = this.renderImage(output, gvtRoot, Px, (int)this.width, (int)this.height);
    }

    private GraphicsNode renderImage(TranscoderOutput output, GraphicsNode gvtRoot, AffineTransform Px, int w, int h) throws TranscoderException {
        Graphics2D g2d = this.createGraphics(w, h);
        if (this.hints.containsKey((Object)KEY_ANTI_ALIASING)) {
            boolean antialias = (Boolean)this.hints.get((Object)KEY_ANTI_ALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2d.clip(new Rectangle(0, 0, w, h));
        g2d.transform(Px);
        gvtRoot.paint(g2d);
        this.postRenderImage(g2d);
        return null;
    }

    protected Graphics2D createGraphics(int w, int h) {
        this.bufferedImage = this.createImage(w, h);
        Graphics2D g2d = GraphicsUtil.createGraphics((BufferedImage)this.bufferedImage);
        return g2d;
    }

    protected void postRenderImage(Graphics2D g2d) {
        g2d.dispose();
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public BufferedImage createImage(int w, int h) {
        return new BufferedImage(w, h, 2);
    }

    public void writeImage(BufferedImage img, TranscoderOutput arg1) throws TranscoderException {
        this.bufferedImage = img;
    }

    public class DimensionFloat
    extends Dimension2D {
        private float w;
        private float h;

        public DimensionFloat(float width, float height) {
            this.w = width;
            this.h = height;
        }

        public double getWidth() {
            return this.w;
        }

        public double getHeight() {
            return this.h;
        }

        public void setSize(double width, double height) {
            this.w = (float)width;
            this.h = (float)height;
        }
    }
}

