/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorPlugin;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.l10n.EditorMessages;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.util.NotationExtendedMetaData;

public class DiagramIOUtil {
    private static String UNABLE_TO_LOAD_DIAGRAM = EditorMessages.Diagram_UNABLE_TO_LOAD_RESOURCE;
    private static String NO_DIAGRAM_IN_RESOURCE = EditorMessages.Diagram_NO_DIAGRAM_IN_RESOURCE;
    static /* synthetic */ Class class$0;

    private static void logResourceErrorsAndWarnings(Resource resource) {
        Resource.Diagnostic diagnostic;
        Iterator iter = resource.getErrors().iterator();
        while (iter.hasNext()) {
            diagnostic = (Resource.Diagnostic)iter.next();
            Log.error((Plugin)EditorPlugin.getInstance(), (int)1, (String)diagnostic.getMessage());
        }
        iter = resource.getWarnings().iterator();
        while (iter.hasNext()) {
            diagnostic = (Resource.Diagnostic)iter.next();
            Log.warning((Plugin)EditorPlugin.getInstance(), (int)7, (String)diagnostic.getMessage());
        }
    }

    public static Diagram load(TransactionalEditingDomain domain, IFile file, boolean bTryCompatible, IProgressMonitor monitor) throws CoreException {
        FileLoader loader = new FileLoader(file);
        return DiagramIOUtil.load(domain, loader, bTryCompatible, monitor);
    }

    public static Diagram load(TransactionalEditingDomain domain, IStorage storage, boolean bTryCompatible, IProgressMonitor monitor) throws CoreException {
        ILoader loader = null;
        loader = storage instanceof IFile ? new FileLoader((IFile)storage) : new StorageLoader(storage);
        return DiagramIOUtil.load(domain, loader, bTryCompatible, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Diagram load(TransactionalEditingDomain domain, ILoader loader, boolean bTryCompatible, IProgressMonitor monitor) throws CoreException {
        Resource notationModel = null;
        try {
            EObject rootElement;
            try {
                notationModel = loader.load(domain, new HashMap(), monitor);
            }
            catch (Resource.IOWrappedException e) {
                Exception exc;
                if (!bTryCompatible) {
                    throw e;
                }
                Throwable causeError = e.getCause();
                if (causeError == null) {
                    causeError = e;
                }
                String errMsg = causeError.getLocalizedMessage();
                if (causeError instanceof Resource.IOWrappedException && (exc = (Exception)((Resource.IOWrappedException)causeError).getCause()) != null) {
                    causeError = exc;
                }
                if (!(causeError instanceof PackageNotFoundException || causeError instanceof ClassNotFoundException || causeError instanceof FeatureNotFoundException)) {
                    throw e;
                }
                if (!DiagramIOUtil.shouldLoadInCompatibilityMode(errMsg)) {
                    return null;
                }
                HashMap<String, Object> loadOptions = new HashMap<String, Object>();
                loadOptions.put("EXTENDED_META_DATA", new NotationExtendedMetaData());
                loadOptions.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
                notationModel = loader.load(domain, loadOptions, monitor);
            }
            if (notationModel == null) {
                throw new RuntimeException(UNABLE_TO_LOAD_DIAGRAM);
            }
            Iterator rootContents = notationModel.getContents().iterator();
            do {
                if (rootContents.hasNext()) continue;
                throw new RuntimeException(NO_DIAGRAM_IN_RESOURCE);
            } while (!((rootElement = (EObject)rootContents.next()) instanceof Diagram));
            return (Diagram)rootElement;
        }
        catch (Exception e) {
            EditorPlugin editorPlugin = EditorPlugin.getInstance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            Trace.catching((Plugin)editorPlugin, (String)EditorDebugOptions.EXCEPTIONS_CATCHING, (Class)clazz, (String)"load(IFile, boolean)", (Throwable)e);
            CoreException thrownExcp = null;
            if (e instanceof CoreException) {
                thrownExcp = (CoreException)((Object)e);
            } else {
                String exceptionMessage = e.getLocalizedMessage();
                thrownExcp = new CoreException((IStatus)new Status(4, EditorPlugin.getPluginId(), 1, exceptionMessage != null ? exceptionMessage : "load(IFile, boolean)", (Throwable)e));
            }
            EditorPlugin editorPlugin2 = EditorPlugin.getInstance();
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz3 = class$0 = clazz4;
            }
            Trace.throwing((Plugin)editorPlugin2, (String)EditorDebugOptions.EXCEPTIONS_THROWING, (Class)clazz3, (String)"load(IFile, boolean)", (Throwable)thrownExcp);
            throw thrownExcp;
        }
    }

    public static void save(TransactionalEditingDomain domain, IFile file, Diagram diagram, boolean bKeepUnrecognizedData, IProgressMonitor progressMonitor) throws CoreException {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        if (bKeepUnrecognizedData) {
            options.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        }
        DiagramIOUtil.save(domain, file, diagram, progressMonitor, options);
    }

    public static void save(TransactionalEditingDomain domain, IFile file, Diagram diagram, IProgressMonitor progressMonitor) throws CoreException {
        HashMap options = new HashMap();
        DiagramIOUtil.save(domain, file, diagram, progressMonitor, options);
    }

    public static void save(TransactionalEditingDomain domain, IFile file, Diagram diagram, IProgressMonitor progressMonitor, Map options) throws CoreException {
        Resource notationModel = diagram.eResource();
        String fileName = file.getFullPath().toOSString();
        notationModel.setURI(URI.createPlatformResourceURI((String)fileName, (boolean)true));
        try {
            notationModel.save(options);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, EditorPlugin.getPluginId(), 5, e.getLocalizedMessage(), null));
        }
        if (progressMonitor != null) {
            progressMonitor.done();
        }
        DiagramIOUtil.logResourceErrorsAndWarnings(notationModel);
    }

    private static boolean shouldLoadInCompatibilityMode(String errMsg) {
        return false;
    }

    public static void unload(TransactionalEditingDomain domain, Diagram diagram) {
        diagram.eResource().unload();
    }

    public static boolean hasUnrecognizedData(Resource resource) {
        return false;
    }

    private static interface ILoader {
        public Resource load(TransactionalEditingDomain var1, Map var2, IProgressMonitor var3) throws IOException, CoreException;
    }

    private static class FileLoader
    implements ILoader {
        private IFile fFile;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public FileLoader(IFile file) {
            if (!$assertionsDisabled && file == null) {
                throw new AssertionError();
            }
            this.fFile = file;
        }

        public Resource load(TransactionalEditingDomain domain, Map loadOptions, IProgressMonitor monitor) throws IOException, CoreException {
            this.fFile.refreshLocal(0, monitor);
            URI uri = URI.createPlatformResourceURI((String)this.fFile.getFullPath().toString(), (boolean)true);
            Resource resource = domain.getResourceSet().getResource(uri, false);
            if (resource == null) {
                resource = domain.getResourceSet().createResource(uri);
            }
            if (!resource.isLoaded()) {
                HashMap loadingOptions = new HashMap(GMFResourceFactory.getDefaultLoadOptions());
                Iterator iter = loadOptions.keySet().iterator();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    loadingOptions.put(key, loadOptions.get(key));
                }
                try {
                    resource.load(loadingOptions);
                }
                catch (IOException e) {
                    resource.unload();
                    throw e;
                }
            }
            DiagramIOUtil.logResourceErrorsAndWarnings(resource);
            return resource;
        }
    }

    private static class StorageLoader
    implements ILoader {
        private IStorage fStorage;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public StorageLoader(IStorage storage) {
            if (!$assertionsDisabled && storage == null) {
                throw new AssertionError();
            }
            this.fStorage = storage;
        }

        public Resource load(TransactionalEditingDomain editingDomain, Map loadOptions, IProgressMonitor monitor) throws IOException, CoreException {
            String storageName = this.fStorage.getName();
            URI uri = URI.createPlatformResourceURI((String)storageName);
            Resource resource = editingDomain.getResourceSet().getResource(uri, false);
            if (resource == null) {
                resource = editingDomain.getResourceSet().createResource(uri);
            }
            if (!resource.isLoaded()) {
                resource.load(this.fStorage.getContents(), loadOptions);
            }
            DiagramIOUtil.logResourceErrorsAndWarnings(resource);
            return resource;
        }
    }
}

