/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.providers.internal;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.internal.commands.IPropertyValueDeferred;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.DiagramActionsDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.internal.requests.ChangeBoundsDeferredRequest;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.LayoutNodesOperation;
import org.eclipse.gmf.runtime.diagram.ui.providers.internal.DiagramProvidersPlugin;
import org.eclipse.gmf.runtime.diagram.ui.providers.internal.l10n.DiagramUIProvidersMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.ChangePropertyValueRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.SetAllBendpointRequest;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutEditPartProvider;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.util.Assert;

public class RadialProvider
extends AbstractLayoutEditPartProvider {
    public boolean provides(IOperation operation) {
        Assert.isNotNull((Object)operation);
        View cview = this.getContainer(operation);
        if (cview == null) {
            return false;
        }
        IAdaptable layoutHint = ((LayoutNodesOperation)operation).getLayoutHint();
        String layoutType = (String)layoutHint.getAdapter(String.class);
        return "RADIAL".equals(layoutType);
    }

    public Command layoutEditParts(GraphicalEditPart containerEP, IAdaptable layoutHint) {
        List children = containerEP.getChildren();
        return this.layout(containerEP, children, this.findRootView(children), layoutHint);
    }

    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint) {
        if (selectedObjects.size() == 0) {
            return null;
        }
        GraphicalEditPart editPart = (GraphicalEditPart)selectedObjects.get(0);
        GraphicalEditPart containerEditPart = (GraphicalEditPart)editPart.getParent();
        return this.layout(containerEditPart, selectedObjects, this.findRootView(selectedObjects), layoutHint);
    }

    public Command layout(GraphicalEditPart containerEP, List selectedObjects, ShapeEditPart rootEditPart, IAdaptable layoutHint) {
        OffsetRadialPartsCommand orpc;
        if (containerEP == null || selectedObjects == null) {
            InvalidParameterException ipe = new InvalidParameterException();
            Trace.throwing((Plugin)DiagramProvidersPlugin.getInstance(), (String)DiagramActionsDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)this)).getClass(), (String)"layout()", (Throwable)ipe);
            throw ipe;
        }
        if (rootEditPart == null) {
            rootEditPart = this.findRootView(selectedObjects);
        }
        ArrayList<Object> parts = new ArrayList<Object>(selectedObjects.size());
        ListIterator li = selectedObjects.listIterator();
        while (li.hasNext()) {
            EditPart ep = (EditPart)li.next();
            if (ep.equals(rootEditPart) || !(ep instanceof ShapeEditPart) && !(ep instanceof ConnectionNodeEditPart)) continue;
            parts.add(ep);
        }
        Command cmd = null;
        CompoundCommand cc = new CompoundCommand("");
        RadialLayout radialLayout = new RadialLayout(rootEditPart, parts, 0.0, Math.PI * 2, false);
        cmd = radialLayout.getPrelayoutCommand();
        if (cmd != null) {
            cc.add(cmd);
        }
        try {
            cmd = radialLayout.getCommand();
            parts.add(rootEditPart);
        }
        catch (LayoutEstheticsException layoutEstheticsException) {
            parts.add(rootEditPart);
            ArrangeRequest request = new ArrangeRequest("arrange_deferred");
            request.setViewAdaptersToArrange(parts);
            cmd = containerEP.getCommand((Request)request);
        }
        if (cmd != null) {
            cc.add(cmd);
        }
        Request req = new Request((Object)"refresh");
        cmd = rootEditPart.getParent().getCommand(req);
        if (cmd != null) {
            cc.add(cmd);
        }
        if ((cmd = new ICommandProxy((ICommand)(orpc = new OffsetRadialPartsCommand(rootEditPart.getEditingDomain(), parts)))) != null) {
            cc.add(cmd);
        }
        return cc;
    }

    protected ShapeEditPart findRootView(List editparts) {
        EditPart ep;
        if (editparts == null) {
            throw new InvalidParameterException();
        }
        int count = editparts.size();
        if (count > 0 && (ep = (EditPart)editparts.get(0)) instanceof ShapeEditPart) {
            return (ShapeEditPart)editparts.remove(0);
        }
        return null;
    }

    protected static class LayoutEstheticsException
    extends RuntimeException {
        private static final long serialVersionUID = 3084395663087786098L;

        public LayoutEstheticsException(String message) {
            super(message);
        }
    }

    protected static class OffsetRadialPartsCommand
    extends AbstractTransactionalCommand {
        private List editParts;
        private Rectangle origRect;

        public OffsetRadialPartsCommand(TransactionalEditingDomain editingDomain, List editParts) {
            super(editingDomain, "", null);
            this.editParts = editParts;
            this.origRect = this.calcBoundBox();
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            if (this.editParts == null) {
                return CommandResult.newCancelledCommandResult();
            }
            Rectangle radialRect = this.calcBoundBox();
            IGraphicalEditPart firstEP = (IGraphicalEditPart)this.editParts.get(0);
            IMapMode mm = MapModeUtil.getMapMode((IFigure)firstEP.getFigure());
            Rectangle newRadialRect = new Rectangle(radialRect);
            newRadialRect.translate(-radialRect.getTopLeft().x + mm.DPtoLP(50), -radialRect.getTopLeft().y + mm.DPtoLP(50));
            if (this.origRect.x > newRadialRect.x && this.origRect.y > newRadialRect.y) {
                newRadialRect = new Rectangle(Math.max(newRadialRect.x, this.origRect.x - radialRect.width / 2), Math.max(newRadialRect.y, this.origRect.y - radialRect.height / 2), radialRect.width, radialRect.height);
            }
            Point translate = new Point(newRadialRect.getTopLeft().x - radialRect.getTopLeft().x, newRadialRect.getTopLeft().y - radialRect.getTopLeft().y);
            ListIterator li = this.editParts.listIterator();
            while (li.hasNext()) {
                IGraphicalEditPart gep = (IGraphicalEditPart)li.next();
                View view = gep.getNotationView();
                if (view == null) continue;
                Integer pos = (Integer)ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
                ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)new Integer(pos + translate.x));
                pos = (Integer)ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
                ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)new Integer(pos + translate.y));
            }
            this.editParts = null;
            return CommandResult.newOKCommandResult();
        }

        private Rectangle calcBoundBox() {
            Rectangle radialRect = null;
            ListIterator li = this.editParts.listIterator();
            while (li.hasNext()) {
                IGraphicalEditPart gep = (IGraphicalEditPart)li.next();
                if (radialRect == null) {
                    radialRect = new Rectangle(gep.getFigure().getBounds());
                    continue;
                }
                radialRect.union(gep.getFigure().getBounds());
            }
            return radialRect == null ? new Rectangle() : radialRect;
        }
    }

    protected static class RadialLayout {
        private ShapeEditPart rootEP;
        private List allEditparts = new ArrayList();
        private double startTheta;
        private double totalTheta;
        private boolean rootPositionLocked;

        public RadialLayout(ShapeEditPart rootEP, List shapeViews, double startTheta, double totalTheta, boolean rootPositionLocked) {
            this.rootEP = rootEP;
            this.allEditparts.addAll(shapeViews);
            this.startTheta = startTheta;
            this.totalTheta = totalTheta;
            this.rootPositionLocked = rootPositionLocked;
        }

        public ShapeEditPart getRootEditPart() {
            return this.rootEP;
        }

        public Command getCommand() throws LayoutEstheticsException {
            double increaseTheta;
            CompoundCommand cc = new CompoundCommand("");
            Command cmd = null;
            ArrayList restViews = new ArrayList();
            ArrayList firstCircleParts = new ArrayList();
            int innerRingCount = this.findChildViews(this.rootEP, this.allEditparts, firstCircleParts, restViews);
            double theta = Math.PI;
            if (innerRingCount > 1) {
                theta = this.totalTheta / (double)innerRingCount;
            }
            Hashtable childAndSectionMap = new Hashtable(firstCircleParts.size());
            ArrayList circleSectionParts = null;
            ArrayList<EditPart> firstCircleShapes = new ArrayList<EditPart>(childAndSectionMap.keySet().size());
            int i = 0;
            while (i < firstCircleParts.size()) {
                EditPart ep = (EditPart)firstCircleParts.get(i);
                if (ep instanceof ShapeEditPart) {
                    ShapeEditPart shapeEP = (ShapeEditPart)ep;
                    circleSectionParts = new ArrayList(firstCircleParts.size());
                    ArrayList restRestViews = new ArrayList();
                    this.findChildViews(shapeEP, restViews, circleSectionParts, restRestViews);
                    firstCircleShapes.add(ep);
                    childAndSectionMap.put(ep, circleSectionParts);
                    childAndSectionMap.put(circleSectionParts, restRestViews);
                }
                ++i;
            }
            CalculateRadialInfoCommand radialInfoCmd = new CalculateRadialInfoCommand(this.rootEP, firstCircleShapes, theta);
            cc.add((Command)radialInfoCmd);
            cmd = this.positionRings(firstCircleParts, childAndSectionMap, theta, radialInfoCmd);
            if (cmd != null) {
                cc.add(cmd);
            }
            if ((cmd = this.routeConnection(firstCircleParts)) != null) {
                cc.add(cmd);
            }
            if ((cmd = this.positionNextRings(firstCircleParts, childAndSectionMap, increaseTheta = theta)) != null) {
                cc.add(cmd);
            }
            return cc;
        }

        private Command getPrelayoutCommand() {
            ArrayList restViews = new ArrayList();
            ArrayList firstCircleParts = new ArrayList();
            this.findChildViews(this.rootEP, this.allEditparts, firstCircleParts, restViews);
            Command cmd = this.diminishCircle(firstCircleParts);
            int size = this.getFontSize(this.rootEP);
            int fontAdjust = size / 8;
            Command c2 = this.diminishCircle(restViews, size -= fontAdjust);
            if (c2 != null) {
                if (cmd != null) {
                    cmd.chain(c2);
                } else {
                    cmd = c2;
                }
            }
            Request req = new Request((Object)"refresh");
            Command c3 = this.rootEP.getParent().getCommand(req);
            if (c3 != null) {
                if (cmd != null) {
                    cmd.chain(c3);
                } else {
                    cmd = c3;
                }
            }
            return cmd;
        }

        private Command positionNextRings(List firstCircleParts, Map childAndSectionMap, double theta) {
            CompoundCommand cc = new CompoundCommand("");
            int n = 0;
            int i = 0;
            while (i < firstCircleParts.size()) {
                List parts;
                double totalThetaPrim = theta;
                EditPart part = (EditPart)firstCircleParts.get(i);
                if (part instanceof ShapeEditPart && (parts = (List)childAndSectionMap.get(part)) != null && !parts.isEmpty()) {
                    int posViewCount = 0;
                    n = i;
                    while (i + 1 < firstCircleParts.size()) {
                        Object key = firstCircleParts.get(i + 1);
                        List nextViews = (List)childAndSectionMap.get(key);
                        if (nextViews == null || nextViews.size() != 0) break;
                        totalThetaPrim = Math.min(Math.PI, totalThetaPrim + theta);
                        ++i;
                    }
                    ListIterator li = parts.listIterator();
                    while (li.hasNext()) {
                        if (!(li.next() instanceof ShapeEditPart)) continue;
                        ++posViewCount;
                    }
                    double dTheta = this.startTheta + (double)n * theta;
                    double thetaPrim = totalThetaPrim / (double)posViewCount;
                    double startThetaPrim = posViewCount < 2 ? dTheta : dTheta - totalThetaPrim / 2.0 + thetaPrim / 2.0;
                    List restRestViews = (List)childAndSectionMap.get(parts);
                    parts.addAll(restRestViews);
                    RadialLayout radialLayout = new RadialLayout((ShapeEditPart)part, parts, startThetaPrim, totalThetaPrim, true);
                    Command cmd = radialLayout.getCommand();
                    if (cmd != null) {
                        cc.add(cmd);
                    }
                }
                ++i;
            }
            if (!cc.isEmpty()) {
                return cc;
            }
            return null;
        }

        protected int findChildViews(ShapeEditPart rootEditPart, List editparts, List childEPs, List restEPs) {
            EditPart ep;
            if (rootEditPart == null) {
                throw new InvalidParameterException();
            }
            if (childEPs == null) {
                throw new InvalidParameterException();
            }
            if (restEPs == null) {
                throw new InvalidParameterException();
            }
            HashSet<EditPart> allSet = new HashSet<EditPart>(editparts.size());
            int posViewCount = 0;
            int count = editparts.size();
            int i = 0;
            while (i < count) {
                EditPart ep2 = (EditPart)editparts.get(i);
                allSet.add(ep2);
                ++i;
            }
            ArrayList<EditPart> connectionEPs = new ArrayList<EditPart>();
            int i2 = 0;
            while (i2 < count) {
                ep = (EditPart)editparts.get(i2);
                if (ep instanceof ShapeEditPart) {
                    ShapeEditPart shapeEP = (ShapeEditPart)ep;
                    connectionEPs.addAll(shapeEP.getSourceConnections());
                    connectionEPs.addAll(shapeEP.getTargetConnections());
                } else if (ep instanceof ConnectionNodeEditPart) {
                    connectionEPs.add(ep);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < connectionEPs.size()) {
                ep = (EditPart)connectionEPs.get(i2);
                if (ep instanceof ConnectionNodeEditPart) {
                    ConnectionNodeEditPart connectionEP = (ConnectionNodeEditPart)ep;
                    EditPart fromEP = connectionEP.getSource();
                    EditPart toEP = connectionEP.getTarget();
                    EditPart el = null;
                    if (fromEP.equals(rootEditPart)) {
                        el = toEP;
                    } else if (toEP.equals(rootEditPart)) {
                        el = fromEP;
                    }
                    if (el != null && allSet.contains(el)) {
                        childEPs.add(el);
                        ++posViewCount;
                        childEPs.add(connectionEP);
                        allSet.remove(el);
                    }
                }
                ++i2;
            }
            restEPs.addAll(allSet);
            return posViewCount;
        }

        protected int getFontSize(ShapeEditPart sep) {
            FontStyle style;
            if (sep == null) {
                throw new InvalidParameterException();
            }
            View view = sep.getNotationView();
            if (view != null && (style = (FontStyle)view.getStyle(NotationPackage.eINSTANCE.getFontStyle())) != null) {
                return style.getFontHeight();
            }
            return 9;
        }

        protected Command setFontSize(ShapeEditPart sep, int size) {
            if (sep == null) {
                throw new InvalidParameterException();
            }
            ChangePropertyValueRequest cpvr = new ChangePropertyValueRequest(DiagramUIProvidersMessages.RadialProvider_changeFontRequest_label, Properties.ID_FONTSIZE, (Object)new Integer(size));
            return this.getCommand((EditPart)sep, (Request)cpvr, true);
        }

        protected Command diminishCircle(List editparts) {
            if (editparts == null) {
                throw new InvalidParameterException();
            }
            int count = editparts.size();
            CompoundCommand cc = new CompoundCommand("");
            int i = 0;
            while (i < count) {
                EditPart editpart = (EditPart)editparts.get(i);
                ChangePropertyValueRequest request = null;
                if (editpart instanceof ShapeEditPart) {
                    request = new ChangePropertyValueRequest(DiagramUIProvidersMessages.RadialProvider_changeVisibilityRequest_label, Properties.ID_ISVISIBLE, (Object)Boolean.FALSE);
                    ShapeEditPart shapeEditPart = (ShapeEditPart)editpart;
                    Iterator compartments = shapeEditPart.getResizableCompartments().iterator();
                    while (compartments.hasNext()) {
                        cc.add(((EditPart)compartments.next()).getCommand((Request)request));
                    }
                }
                ++i;
            }
            if (!cc.isEmpty()) {
                return cc;
            }
            return null;
        }

        protected Command diminishCircle(List editparts, int fontSize) {
            if (editparts == null) {
                throw new InvalidParameterException();
            }
            long count = editparts.size();
            CompoundCommand cc = new CompoundCommand("");
            Command cmd = this.diminishCircle(editparts);
            if (cmd != null) {
                cc.add(cmd);
            }
            int i = 0;
            while ((long)i < count) {
                EditPart ep = (EditPart)editparts.get(i);
                if (ep instanceof ShapeEditPart && (cmd = this.setFontSize((ShapeEditPart)ep, fontSize)) != null) {
                    cc.add(cmd);
                }
                ++i;
            }
            if (!cc.isEmpty()) {
                return cc;
            }
            return null;
        }

        protected void sortFirstCircleParts(List firstCircleParts, Map childAndSectionMap) {
            ArrayList firstCircleShapeParts = new ArrayList(firstCircleParts.size());
            ArrayList rest = new ArrayList(firstCircleParts.size());
            ListIterator li = firstCircleParts.listIterator();
            while (li.hasNext()) {
                Object obj = li.next();
                if (obj instanceof ShapeEditPart) {
                    firstCircleShapeParts.add(obj);
                    continue;
                }
                rest.add(obj);
            }
            ArrayList emptyNextCircleList = new ArrayList(firstCircleParts.size());
            ArrayList nextCircleList = new ArrayList(firstCircleParts.size());
            int i = 0;
            while (i < firstCircleShapeParts.size()) {
                List circleList = (List)childAndSectionMap.get(firstCircleShapeParts.get(i));
                if (circleList != null && circleList.size() == 0) {
                    emptyNextCircleList.add(firstCircleShapeParts.get(i));
                } else {
                    nextCircleList.add(firstCircleShapeParts.get(i));
                }
                ++i;
            }
            firstCircleParts.clear();
            if (nextCircleList.size() > 1) {
                int addInc = firstCircleShapeParts.size() / nextCircleList.size();
                int i2 = 0;
                while (nextCircleList.size() > 0 || emptyNextCircleList.size() > 0) {
                    if (i2 % addInc == 0 && nextCircleList.size() > 0) {
                        firstCircleParts.add(nextCircleList.remove(0));
                    } else if (emptyNextCircleList.size() > 0) {
                        firstCircleParts.add(emptyNextCircleList.remove(0));
                    }
                    ++i2;
                }
            } else {
                firstCircleParts.addAll(firstCircleShapeParts);
            }
            firstCircleParts.addAll(rest);
        }

        protected Command positionRings(List firstCircleParts, Map childAndSectionMap, double theta, CalculateRadialInfoCommand radialInfo) {
            RadialPosition deferredRootPos;
            ChangeBoundsDeferredRequest request;
            Command cmd;
            int n = 0;
            if (theta < 0.09817477042468103 && this.isRootPositionLocked()) {
                throw new LayoutEstheticsException("Angle is too small to resulting in very large radius");
            }
            CompoundCommand cc = new CompoundCommand("");
            ArrayList<ShapeEditPart> editParts = new ArrayList<ShapeEditPart>();
            editParts.add(this.rootEP);
            this.sortFirstCircleParts(firstCircleParts, childAndSectionMap);
            ListIterator li = firstCircleParts.listIterator();
            while (li.hasNext()) {
                EditPart editpart = (EditPart)li.next();
                if (!(editpart instanceof ShapeEditPart)) continue;
                ShapeEditPart sep = (ShapeEditPart)editpart;
                editParts.add(sep);
                RadialPosition deferredPos = new RadialPosition(sep, this.startTheta + (double)n * theta, radialInfo, this.isRootPositionLocked());
                ChangeBoundsDeferredRequest request2 = new ChangeBoundsDeferredRequest((IAdaptable)deferredPos);
                Command cmd2 = sep.getCommand((Request)request2);
                if (cmd2 != null) {
                    cc.add(cmd2);
                }
                ++n;
            }
            if (!this.isRootPositionLocked() && (cmd = this.rootEP.getCommand((Request)(request = new ChangeBoundsDeferredRequest((IAdaptable)(deferredRootPos = new RadialPosition(this.getRootEditPart(), 0.0, null, this.isRootPositionLocked())))))) != null) {
                cc.add(cmd);
            }
            if (!cc.isEmpty()) {
                return cc;
            }
            return null;
        }

        protected Command routeConnection(List connections) {
            CompoundCommand cc = new CompoundCommand("");
            ListIterator li = connections.listIterator();
            while (li.hasNext()) {
                Command cmd;
                EditPart editpart = (EditPart)li.next();
                if (!(editpart instanceof ConnectionNodeEditPart) || (cmd = this.routeConnection((ConnectionNodeEditPart)editpart)) == null) continue;
                cc.add(cmd);
            }
            if (!cc.isEmpty()) {
                return cc;
            }
            return null;
        }

        protected Command routeConnection(ConnectionNodeEditPart connectionEP) {
            if (connectionEP == null) {
                throw new InvalidParameterException();
            }
            Connection connection = connectionEP.getConnectionFigure();
            PointList newPoints = new PointList(2);
            newPoints.addPoint(connection.getPoints().getFirstPoint());
            newPoints.addPoint(connection.getPoints().getLastPoint());
            SetAllBendpointRequest request = new SetAllBendpointRequest("set_all_connection_bendpoint", newPoints);
            return connectionEP.getCommand((Request)request);
        }

        protected Command getCommand(EditPart editpart, Request request, boolean bRecursive) {
            List children = editpart.getChildren();
            ListIterator li = children.listIterator();
            CompoundCommand cc = new CompoundCommand("");
            Command cmd = editpart.getCommand(request);
            if (cmd != null) {
                cc.add(cmd);
            }
            if (bRecursive) {
                while (li.hasNext()) {
                    IGraphicalEditPart childEP = (IGraphicalEditPart)li.next();
                    cmd = this.getCommand((EditPart)childEP, request, bRecursive);
                    if (cmd == null) continue;
                    cc.add(cmd);
                }
            }
            if (!cc.isEmpty()) {
                return cc;
            }
            return null;
        }

        public boolean isRootPositionLocked() {
            return this.rootPositionLocked;
        }

        protected static class CalculateRadialInfoCommand
        extends Command {
            private int radius;
            private double theta;
            private ShapeEditPart rootEP;
            private List firstCircleViews;

            public CalculateRadialInfoCommand(ShapeEditPart rootEP, List firstCircleViews, double theta) {
                this.rootEP = rootEP;
                this.firstCircleViews = firstCircleViews;
                this.theta = theta;
            }

            public void execute() {
                this.radius = this.calculateNeededRadius(this.firstCircleViews, (double)this.firstCircleViews.size() * this.theta);
                double rootDiagonal = this.getViewWorstExtent(this.rootEP);
                if (2.0 * rootDiagonal > (double)this.radius) {
                    this.radius = (int)((double)this.radius + rootDiagonal);
                }
                this.radius = Math.max(MapModeUtil.getMapMode((IFigure)this.rootEP.getFigure()).DPtoLP(180), this.radius);
            }

            protected int calculateNeededRadius(List circleEPs, double sectionAngle) {
                if (circleEPs == null) {
                    throw new InvalidParameterException();
                }
                double neededDiameter = 0.0;
                int count = circleEPs.size();
                double maxDiagonal = 0.0;
                int i = 0;
                while (i < count) {
                    EditPart ep = (EditPart)circleEPs.get(i);
                    if (ep instanceof ShapeEditPart) {
                        ShapeEditPart sep = (ShapeEditPart)ep;
                        double diagonal = this.getViewWorstExtent(sep);
                        neededDiameter += diagonal;
                        if (diagonal > maxDiagonal) {
                            maxDiagonal = diagonal;
                        }
                    }
                    ++i;
                }
                double rad = neededDiameter / sectionAngle;
                return (int)Math.round(rad);
            }

            protected double getViewWorstExtent(ShapeEditPart sep) {
                if (sep == null) {
                    throw new InvalidParameterException();
                }
                Dimension ext = sep.getSize();
                return Math.sqrt(ext.width * ext.width + ext.height * ext.height) * 0.8;
            }

            public int getRadius() {
                return this.radius;
            }

            public Point getDelta() {
                View view = this.rootEP.getNotationView();
                if (view != null) {
                    Integer posX = (Integer)ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
                    Integer posY = (Integer)ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
                    return new Point(posX.intValue(), posY.intValue());
                }
                return new Point(0, 0);
            }
        }

        protected static class RadialPosition
        implements IAdaptable {
            private ShapeEditPart sep;
            private CalculateRadialInfoCommand radialInfo;
            private double theta;
            private boolean useDelta;
            private Point ptLocation = null;

            public RadialPosition(ShapeEditPart sep, double theta, CalculateRadialInfoCommand radialInfo, boolean useDelta) {
                this.sep = sep;
                this.theta = theta;
                this.radialInfo = radialInfo;
                this.useDelta = useDelta;
            }

            public Object getAdapter(Class adapterType) {
                if (adapterType == IPropertyValueDeferred.class) {
                    return this.getPosition();
                }
                return null;
            }

            public Point getPosition() {
                if (this.ptLocation == null) {
                    this.ptLocation = new Point(0, 0);
                    if (this.radialInfo != null) {
                        this.ptLocation.x = Math.round((float)this.radialInfo.getRadius() * (float)Math.cos(this.theta));
                        this.ptLocation.y = Math.round((float)this.radialInfo.getRadius() * (float)Math.sin(this.theta));
                        if (this.useDelta) {
                            this.ptLocation.translate(this.radialInfo.getDelta());
                        }
                    }
                    this.ptLocation.translate(-this.sep.getSize().width / 2, -this.sep.getSize().height / 2);
                    this.sep = null;
                    this.radialInfo = null;
                }
                return this.ptLocation;
            }
        }
    }
}

