/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages.simple;

import java.util.Iterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.internal.bridge.wizards.WizardUtil;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.Messages;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.ResolvedItem;
import org.eclipse.gmf.internal.common.IncrementalNamesDispenser;
import org.eclipse.gmf.internal.common.NamesDispenser;
import org.eclipse.gmf.tooldef.AbstractTool;
import org.eclipse.gmf.tooldef.CreationTool;
import org.eclipse.gmf.tooldef.GMFToolFactory;
import org.eclipse.gmf.tooldef.GMFToolPackage;
import org.eclipse.gmf.tooldef.Image;
import org.eclipse.gmf.tooldef.Palette;
import org.eclipse.gmf.tooldef.ToolGroup;
import org.eclipse.gmf.tooldef.ToolRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolDefBuilder {
    protected final ToolRegistry existingToolRegistry;
    protected GMFToolFactory gmfToolFactory = GMFToolPackage.eINSTANCE.getGMFToolFactory();
    protected NamesDispenser namesDispenser = new IncrementalNamesDispenser();
    protected ToolRegistry toolRegistry;
    protected ToolGroup group;

    public ToolDefBuilder(ToolRegistry existingToolRegistry) {
        this.existingToolRegistry = existingToolRegistry;
    }

    public static CreationTool getCreationTool(Iterator<EObject> source, EObject domainElement) {
        String name = WizardUtil.getCapName(domainElement);
        if (name == null) {
            return null;
        }
        return ToolDefBuilder.getCreationTool(source, name);
    }

    public static CreationTool getCreationTool(Iterator<EObject> source, String domainObjectName) {
        while (source.hasNext()) {
            EObject next = source.next();
            if (!(next instanceof CreationTool) || !domainObjectName.equals(((CreationTool)next).getTitle())) continue;
            return (CreationTool)next;
        }
        return null;
    }

    protected String getUniqueName(String semanticPart) {
        return this.namesDispenser.get(semanticPart);
    }

    protected String getUniqueName(String semanticPart, String suffixPart) {
        return this.namesDispenser.get(semanticPart, suffixPart);
    }

    protected void addExistingName(String name) {
        if (name != null) {
            this.namesDispenser.add(name);
        }
    }

    protected void addExistingNames(ToolRegistry toolRegistry) {
        TreeIterator it = toolRegistry.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof AbstractTool)) continue;
            this.addExistingName(((AbstractTool)next).getTitle());
        }
    }

    public ToolRegistry process(ResolvedItem item) {
        if (this.existingToolRegistry == null) {
            this.toolRegistry = this.gmfToolFactory.createToolRegistry();
        } else {
            this.toolRegistry = this.existingToolRegistry;
            this.addExistingNames(this.existingToolRegistry);
        }
        if (item != null) {
            EPackage ePackage = (EPackage)item.getDomainRef();
            Palette palette = this.toolRegistry.getPalette();
            if (palette == null) {
                palette = this.gmfToolFactory.createPalette();
                palette.setTitle(this.getUniqueName(ePackage.getName(), Messages.ToolDefBuilder1));
                this.toolRegistry.setPalette(palette);
            }
            this.group = null;
            for (Object tool : palette.getTools()) {
                if (!(tool instanceof ToolGroup)) continue;
                this.group = (ToolGroup)tool;
                break;
            }
            if (this.group == null) {
                this.group = this.gmfToolFactory.createToolGroup();
                this.group.setTitle(this.getUniqueName(ePackage.getName()));
                palette.getTools().add((Object)this.group);
            }
            for (ResolvedItem child : item.getChildren()) {
                this.processContents(child);
            }
        }
        return this.toolRegistry;
    }

    protected void processContents(ResolvedItem item) {
        if (!(item.isDisabled() || item.getResolution() != ResolvedItem.Resolution.NODE && item.getResolution() != ResolvedItem.Resolution.LINK)) {
            String baseName = null;
            if (item.getDomainRef() instanceof EClass) {
                baseName = WizardUtil.getCapName((EClass)item.getDomainRef());
            } else if (item.getDomainRef() instanceof EReference) {
                baseName = WizardUtil.getCapName((EStructuralFeature)((EReference)item.getDomainRef()));
            }
            if (baseName != null && baseName.length() > 0) {
                this.addCreationTool(baseName);
            }
        }
        for (ResolvedItem child : item.getChildren()) {
            this.processContents(child);
        }
    }

    protected CreationTool addCreationTool(String baseName) {
        CreationTool tool = this.gmfToolFactory.createCreationTool();
        tool.setTitle(this.getUniqueName(baseName));
        tool.setDescription(Messages.bind((String)Messages.ToolDefBuilder0, (Object)baseName));
        tool.setSmallIcon((Image)this.gmfToolFactory.createDefaultImage());
        tool.setLargeIcon((Image)this.gmfToolFactory.createDefaultImage());
        this.group.getTools().add((Object)tool);
        return tool;
    }
}

