/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.mappings.presentation;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.util.Assistant;
import org.eclipse.gmf.internal.common.ui.ComboElementSelectorExtension;
import org.eclipse.gmf.internal.common.ui.CreateNewModelExtension;
import org.eclipse.gmf.internal.common.ui.ElementSelectorExtension;
import org.eclipse.gmf.internal.common.ui.ExtensibleModelSelectionPage;
import org.eclipse.gmf.internal.common.ui.ListElementSelectorExtension;
import org.eclipse.gmf.internal.common.ui.ModelSelectionPage;
import org.eclipse.gmf.internal.common.ui.ModelSelectionPageExtension;
import org.eclipse.gmf.internal.common.ui.PredefinedModelExtension;
import org.eclipse.gmf.internal.common.ui.ResourceLocationProvider;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.GMFMapPackage;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.tooldef.GMFToolPackage;
import org.eclipse.gmf.tooldef.Palette;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class MapRefModelPages {
    private final boolean withSelectors;
    private ResourceSet resourceSet;
    private ExtensibleModelSelectionPage domainModelSelectionPage;
    private ExtensibleModelSelectionPage graphModelSelectionPage;
    private ExtensibleModelSelectionPage toolModelSelectionPage;

    public MapRefModelPages(boolean withSelectors, ResourceSet resourceSet) {
        this.withSelectors = withSelectors;
        this.resourceSet = resourceSet;
    }

    protected ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
        }
        return this.resourceSet;
    }

    public ExtensibleModelSelectionPage getDomainModelSelectionPage() {
        return this.domainModelSelectionPage;
    }

    public ExtensibleModelSelectionPage getGraphModelSelectionPage() {
        return this.graphModelSelectionPage;
    }

    public ExtensibleModelSelectionPage getToolModelSelectionPage() {
        return this.toolModelSelectionPage;
    }

    public void addPages(Wizard wizard, ISelection selection) {
        ResourceLocationProvider rloc = new ResourceLocationProvider(selection);
        this.addDomainPage(wizard, rloc);
        this.addGraphPage(wizard, rloc);
        this.addToolPage(wizard, rloc);
    }

    protected void addDomainPage(Wizard wizard, ResourceLocationProvider rloc) {
        this.domainModelSelectionPage = new ExtensibleModelSelectionPage("domain", rloc, this.getResourceSet()){

            protected String getModelFileExtension() {
                return "ecore";
            }
        };
        this.domainModelSelectionPage.setTitle("Select Domain Model");
        this.domainModelSelectionPage.setDescription("Load domain model and select element for canvas mapping.");
        List uris = rloc.getSelectedURIs("ecore");
        uris.add(URI.createURI((String)"platform:/plugin/org.eclipse.emf.ecore/model/Ecore.ecore"));
        this.domainModelSelectionPage.addExtension("prem", (ModelSelectionPageExtension)new PredefinedModelExtension((ModelSelectionPage)this.domainModelSelectionPage, uris));
        if (this.withSelectors) {
            this.domainModelSelectionPage.addExtension("domainModel", (ModelSelectionPageExtension)new ComboElementSelectorExtension(){

                protected String getModelElementName() {
                    return "Package:";
                }

                protected String getModelElementLabel(EObject modelElement) {
                    String name = ((EPackage)modelElement).getName();
                    if (name == null || name.trim().length() == 0) {
                        name = "<unnamed>";
                    }
                    return name;
                }

                protected EClass getModelElementClass() {
                    return EcorePackage.eINSTANCE.getEPackage();
                }
            });
            this.domainModelSelectionPage.addExtension("domainElement", (ModelSelectionPageExtension)new ListElementSelectorExtension(){

                protected String getModelElementName() {
                    return "Class:";
                }

                protected String getModelElementLabel(EObject modelElement) {
                    String name = ((EClass)modelElement).getName();
                    if (name == null || name.trim().length() == 0) {
                        name = "<unnamed>";
                    }
                    return name;
                }

                protected EClass getModelElementClass() {
                    return EcorePackage.eINSTANCE.getEClass();
                }
            });
        }
        wizard.addPage((IWizardPage)this.domainModelSelectionPage);
    }

    protected void addGraphPage(Wizard wizard, ResourceLocationProvider rloc) {
        this.graphModelSelectionPage = new ExtensibleModelSelectionPage("graph", rloc, this.getResourceSet()){

            protected String getModelFileExtension() {
                return "gmfgraph";
            }
        };
        this.graphModelSelectionPage.setTitle("Select Diagram Canvas");
        this.graphModelSelectionPage.setDescription("Load graphical definition model and select diagram canvas for canvas mapping.");
        List uris = rloc.getSelectedURIs("gmfgraph");
        uris.add(Assistant.getBasicGraphDef());
        this.graphModelSelectionPage.addExtension("prem", (ModelSelectionPageExtension)new PredefinedModelExtension((ModelSelectionPage)this.graphModelSelectionPage, uris));
        if (this.withSelectors) {
            this.graphModelSelectionPage.addExtension("canvas", (ModelSelectionPageExtension)new ComboElementSelectorExtension(){

                protected String getModelElementName() {
                    return "Diagram Canvas:";
                }

                protected String getModelElementLabel(EObject modelElement) {
                    String name = ((Canvas)modelElement).getName();
                    if (name == null || name.trim().length() == 0) {
                        name = "<unnamed>";
                    }
                    return name;
                }

                protected EClass getModelElementClass() {
                    return GMFGraphPackage.eINSTANCE.getCanvas();
                }
            });
        }
        wizard.addPage((IWizardPage)this.graphModelSelectionPage);
    }

    protected void addToolPage(Wizard wizard, ResourceLocationProvider rloc) {
        this.toolModelSelectionPage = new ExtensibleModelSelectionPage("tool", rloc, this.getResourceSet()){

            protected String getModelFileExtension() {
                return "gmftool";
            }

            public void validatePage() {
                CreateNewModelExtension ext = (CreateNewModelExtension)this.getExtension("new");
                if (ext != null) {
                    ext.validatePage();
                } else {
                    super.validatePage();
                }
            }
        };
        this.toolModelSelectionPage.setTitle("Select Diagram Palette");
        this.toolModelSelectionPage.setDescription("Load tooling definition model and select diagram palette for canvas mapping.");
        if (this.withSelectors) {
            this.toolModelSelectionPage.addExtension("palette", (ModelSelectionPageExtension)new ComboElementSelectorExtension(){

                protected String getModelElementName() {
                    return "Diagram Palette:";
                }

                protected String getModelElementLabel(EObject modelElement) {
                    String title = ((Palette)modelElement).getTitle();
                    if (title == null || title.trim().length() == 0) {
                        title = "<untitled>";
                    }
                    return title;
                }

                protected EClass getModelElementClass() {
                    return GMFToolPackage.eINSTANCE.getPalette();
                }
            });
        }
        wizard.addPage((IWizardPage)this.toolModelSelectionPage);
    }

    public void allowNewToolingModel() {
        this.toolModelSelectionPage.addExtension("new", (ModelSelectionPageExtension)new CreateNewModelExtension((ModelSelectionPage)this.toolModelSelectionPage));
    }

    public CreateNewModelExtension getCreateNewToolingModelExt() {
        if (this.toolModelSelectionPage == null) {
            return null;
        }
        return (CreateNewModelExtension)this.toolModelSelectionPage.getExtension("new");
    }

    public boolean shouldCreateNewToolingModel(boolean defaultValue) {
        CreateNewModelExtension ext = this.getCreateNewToolingModelExt();
        if (ext == null) {
            return defaultValue;
        }
        return ext.shouldCreateNewModel();
    }

    protected ElementSelectorExtension getElementSelectorExtension(ExtensibleModelSelectionPage page, String selectorId) {
        if (page == null) {
            return null;
        }
        return (ElementSelectorExtension)page.getExtension(selectorId);
    }

    protected EObject getSelectedElement(ExtensibleModelSelectionPage page, String selectorId) {
        ElementSelectorExtension ext = this.getElementSelectorExtension(page, selectorId);
        if (ext == null) {
            return null;
        }
        return ext.getModelElement();
    }

    public ElementSelectorExtension getDomainModelExt() {
        return this.getElementSelectorExtension(this.domainModelSelectionPage, "domainModel");
    }

    public ElementSelectorExtension getDomainElementExt() {
        return this.getElementSelectorExtension(this.domainModelSelectionPage, "domainElement");
    }

    public ElementSelectorExtension getCanvasExt() {
        return this.getElementSelectorExtension(this.graphModelSelectionPage, "canvas");
    }

    public ElementSelectorExtension getPaletteExt() {
        return this.getElementSelectorExtension(this.toolModelSelectionPage, "palette");
    }

    public EPackage getDomainModel() {
        return (EPackage)this.getSelectedElement(this.domainModelSelectionPage, "domainModel");
    }

    public EClass getDomainElement() {
        return (EClass)this.getSelectedElement(this.domainModelSelectionPage, "domainElement");
    }

    public Canvas getCanvas() {
        return (Canvas)this.getSelectedElement(this.graphModelSelectionPage, "canvas");
    }

    public Palette getPalette() {
        return (Palette)this.getSelectedElement(this.toolModelSelectionPage, "palette");
    }

    public Mapping createMapping() {
        Palette palette;
        Canvas canvas;
        EClass domainElement;
        Mapping mapping = GMFMapPackage.eINSTANCE.getGMFMapFactory().createMapping();
        CanvasMapping canvasMapping = GMFMapPackage.eINSTANCE.getGMFMapFactory().createCanvasMapping();
        mapping.setDiagram(canvasMapping);
        EPackage domainModel = this.getDomainModel();
        if (domainModel != null) {
            canvasMapping.setDomainModel(domainModel);
        }
        if ((domainElement = this.getDomainElement()) != null) {
            canvasMapping.setDomainMetaElement(domainElement);
        }
        if ((canvas = this.getCanvas()) != null) {
            canvasMapping.setDiagramCanvas(canvas);
        }
        if ((palette = this.getPalette()) != null) {
            canvasMapping.setPalette(palette);
        }
        return mapping;
    }
}

