/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.apache.batik.transcoder.TranscoderException;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IEmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.ITraceMe;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IWmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;

public class Header
implements IEmf2SvgConverter,
IWmf2SvgConverter,
ITraceMe {
    private int m_numRecords = 0;
    private Rectangle m_bounds = null;
    private int m_dpiX = 96;
    private int m_dpiY = 96;
    private static final int EMF_BOUNDS_OFFSET = 0;
    private static final int EMF_FRAME_OFFSET = 16;
    private static final int EMF_SIGNATURE_OFFSET = 32;
    private static final int EMF_NUM_RECORDS_OFFSET = 44;
    private static final int EMF_DEVICE_SIZE_OFFSET = 64;
    private static final int EMF_MM_SIZE_OFFSET = 72;
    private static final int APM_SIGNATURE_OFFSET = 0;
    private static final int APM_LEFT_OFFSET = 6;
    private static final int APM_TOP_OFFSET = 8;
    private static final int APM_RIGHT_OFFSET = 10;
    private static final int APM_BOTTOM_OFFSET = 12;
    private static final int APM_INCH_OFFSET = 14;
    private static final int WMF_FILE_TYPE_OFFSET = 0;
    private static final int WMF_HEADER_SIZE_OFFSET = 2;
    private String _sizes = null;

    public String toString() {
        return this._sizes;
    }

    public int getNumRecords() {
        return this.m_numRecords;
    }

    public Rectangle getBounds() {
        return this.m_bounds;
    }

    @Override
    public void readEMFRecord(Record rec) throws IOException {
        this.m_bounds = rec.getRectangleLAt(0);
        ++this.m_bounds.width;
        ++this.m_bounds.height;
        long signature = rec.getDWORDAt(32);
        if (signature != 1179469088L) {
            throw new IOException("Invalid Enhanced Metafile Format:  Wrong signature");
        }
        this.m_numRecords = (int)rec.getDWORDAt(44);
        Dimension deviceSize = rec.getDimensionLAt(64);
        Dimension mmSize = rec.getDimensionLAt(72);
        this.m_dpiX = (int)((double)deviceSize.width * 25.4 / (double)mmSize.width + 0.5);
        this.m_dpiY = (int)((double)deviceSize.height * 25.4 / (double)mmSize.height + 0.5);
        Rectangle pictFrame = rec.getRectangeAt(16);
        StringBuffer sb = new StringBuffer();
        sb.append("Bounds{device units}=" + String.valueOf(this.m_bounds));
        sb.append(", pictFrame{himetr}=" + pictFrame.toString());
        sb.append(", deviceSize{pels}=" + deviceSize.toString());
        sb.append(", mmSize{mm}=" + mmSize.toString());
        sb.append(", dpiX=" + this.m_dpiX);
        sb.append(", dpiY=" + this.m_dpiY);
        this._sizes = sb.toString();
    }

    @Override
    public void readWMFRecord(Record rec) throws IOException {
        long signature = rec.getDWORDAt(0);
        int offset = 0;
        if (signature == -1698247209L) {
            short left = rec.getShortAt(6);
            short top = rec.getShortAt(8);
            short right = rec.getShortAt(10);
            short bottom = rec.getShortAt(12);
            short inch = rec.getShortAt(14);
            this.m_bounds = new Rectangle(0, 0, right - left, bottom - top);
            this.m_dpiX = inch;
            this.m_dpiY = inch;
            offset = 22;
        } else {
            this.m_bounds = new Rectangle(0, 0, 1000, 1000);
        }
        short type = rec.getShortAt(offset + 0);
        short size = rec.getShortAt(offset + 2);
        if (type != 1 || size != 9) {
            throw new IOException("Not a valid WMF file");
        }
    }

    @Override
    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        context.setBounds(this.m_bounds);
        context.setDpiX(this.m_dpiX);
        context.setDpiY(this.m_dpiY);
        context.setViewportExtent(new Point(this.m_bounds.width, this.m_bounds.height));
        g.setColor(new Color(255, 255, 255));
        g.setBackground(new Color(255, 255, 255));
    }
}

