/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ListScrollBar
extends ScrollBar {
    protected ArrowButton downButtonFigure;
    protected ArrowButton upButtonFigure;
    ThumbFigure thumb;
    protected static Color fillLightGrey = new Color(null, new RGB(240, 240, 240));
    protected static Color outlineLightGrey = new Color(null, new RGB(185, 185, 185));
    protected static Color fillDarkGrey = new Color(null, new RGB(84, 84, 84));
    protected static Color outlineDarkGrey = new Color(null, new RGB(109, 109, 109));
    protected static Color arrowFill = new Color(null, new RGB(187, 187, 187));
    protected int mm_1;
    protected int mm_2;

    public ListScrollBar(int orientation, Insets insets, Dimension size, int stepInc, int pageInc) {
        this.setOrientation(orientation);
        MarginBorder margin = new MarginBorder(insets.top, insets.left, insets.bottom, insets.right);
        this.setBorder((Border)margin);
        this.setPreferredSize(size.width, size.height);
        this.setStepIncrement(stepInc);
        this.setPageIncrement(pageInc);
        if (this.isHorizontal()) {
            this.downButtonFigure.setDirection(16);
            this.upButtonFigure.setDirection(8);
        } else {
            this.downButtonFigure.setDirection(4);
            this.upButtonFigure.setDirection(1);
        }
        IMapMode mm = MapModeUtil.getMapMode();
        this.mm_1 = mm.DPtoLP(1);
        this.mm_2 = mm.DPtoLP(2);
    }

    protected Clickable createDefaultDownButton() {
        this.downButtonFigure = new ArrowButton();
        this.downButtonFigure.setBorder((Border)new MarginBorder(new Insets(this.mm_1)));
        Clickable button = new Clickable((IFigure)this.downButtonFigure){

            public boolean hasFocus() {
                return false;
            }
        };
        button.getModel().addChangeListener(new ChangeListener(){

            public void handleStateChanged(ChangeEvent event) {
                ListScrollBar.this.updateDownColors();
            }
        });
        button.setFiringMethod(1);
        button.setRolloverEnabled(true);
        return button;
    }

    protected Clickable createDefaultUpButton() {
        this.upButtonFigure = new ArrowButton();
        this.upButtonFigure.setBorder((Border)new MarginBorder(new Insets(this.mm_1)));
        Clickable button = new Clickable((IFigure)this.upButtonFigure){

            public boolean hasFocus() {
                return false;
            }
        };
        button.getModel().addChangeListener(new ChangeListener(){

            public void handleStateChanged(ChangeEvent event) {
                ListScrollBar.this.updateUpColors();
            }
        });
        button.setFiringMethod(1);
        button.setRolloverEnabled(true);
        return button;
    }

    protected void initialize() {
        super.initialize();
        this.setPageUp(null);
        this.setPageDown(null);
        this.setOpaque(true);
    }

    protected IFigure createDefaultThumb() {
        this.thumbDragger = new ThumbDraggerColors();
        this.thumb = new ThumbFigure();
        this.thumb.setMinimumSize(new Dimension(6, 6));
        return this.thumb;
    }

    protected void updateDownColors() {
        boolean pressed = false;
        boolean highlighted = false;
        if (this.getValue() < this.getMaximum() - this.getExtent()) {
            if (((Clickable)this.getButtonDown()).getModel().isPressed()) {
                pressed = true;
            } else if (((Clickable)this.getButtonDown()).getModel().isMouseOver()) {
                highlighted = true;
            }
        }
        boolean doRepaint = false;
        if (this.downButtonFigure.isHighlighted() != highlighted) {
            this.downButtonFigure.setHighlighted(highlighted);
            doRepaint = true;
        }
        if (this.downButtonFigure.isPressed() != pressed) {
            doRepaint = true;
            this.downButtonFigure.setPressed(pressed);
        }
        if (doRepaint) {
            this.downButtonFigure.setRecalculate(false);
            this.downButtonFigure.repaint();
        }
    }

    protected void updateUpColors() {
        boolean pressed = false;
        boolean highlighted = false;
        if (this.getValue() > this.getMinimum()) {
            if (((Clickable)this.getButtonUp()).getModel().isPressed()) {
                pressed = true;
            } else if (((Clickable)this.getButtonUp()).getModel().isMouseOver()) {
                highlighted = true;
            }
        }
        boolean doRepaint = false;
        if (this.upButtonFigure.isHighlighted() != highlighted) {
            this.upButtonFigure.setHighlighted(highlighted);
            doRepaint = true;
        }
        if (this.upButtonFigure.isPressed() != pressed) {
            doRepaint = true;
            this.upButtonFigure.setPressed(pressed);
        }
        if (doRepaint) {
            this.upButtonFigure.setRecalculate(false);
            this.upButtonFigure.repaint();
        }
    }

    protected class ArrowButton
    extends Figure {
        private PointList arrow = new PointList();
        private boolean recalculate;
        private int direction;
        private boolean highlighted;
        private boolean pressed;

        protected ArrowButton() {
        }

        protected void paintFigure(Graphics g) {
            Rectangle r = this.getBounds();
            g.setAlpha(130);
            if (!this.pressed) {
                g.setBackgroundColor(ColorConstants.white);
                g.fillRectangle(r);
            }
            if (!this.pressed) {
                g.setLineWidth(ListScrollBar.this.mm_1);
                if (this.highlighted) {
                    g.setForegroundColor(outlineDarkGrey);
                } else {
                    g.setForegroundColor(outlineLightGrey);
                }
                g.drawRectangle(r);
            }
            if (this.pressed) {
                g.setBackgroundColor(fillDarkGrey);
            } else {
                g.setBackgroundColor(fillLightGrey);
                r = r.getCopy().shrink(ListScrollBar.this.mm_2, ListScrollBar.this.mm_2);
            }
            g.fillRectangle(r);
            if (this.pressed) {
                r = r.getCopy().shrink(ListScrollBar.this.mm_2, ListScrollBar.this.mm_2);
            }
            if (this.recalculate || this.arrow.size() == 0) {
                Point p2;
                Point head;
                int size;
                switch (this.direction) {
                    case 8: 
                    case 16: {
                        size = Math.min(r.height / 2, r.width);
                        r.x += (r.width - size) / 2;
                        break;
                    }
                    default: {
                        size = Math.min(r.height, r.width / 2);
                        r.y += (r.height - size) / 2;
                    }
                }
                size = Math.max(size, 1);
                Point p3 = switch (this.direction) {
                    case 1 -> {
                        head = new Point(r.x + r.width / 2, r.y);
                        p2 = new Point(head.x - size, head.y + size);
                        yield new Point(head.x + size, head.y + size);
                    }
                    case 4 -> {
                        head = new Point(r.x + r.width / 2, r.y + size);
                        p2 = new Point(head.x - size, head.y - size);
                        yield new Point(head.x + size, head.y - size);
                    }
                    case 8 -> {
                        head = new Point(r.x, r.y + r.height / 2);
                        p2 = new Point(head.x + size, head.y - size);
                        yield new Point(head.x + size, head.y + size);
                    }
                    default -> {
                        head = new Point(r.x + size, r.y + r.height / 2);
                        p2 = new Point(head.x - size, head.y - size);
                        yield new Point(head.x - size, head.y + size);
                    }
                };
                this.arrow.removeAllPoints();
                this.arrow.addPoint(p2);
                this.arrow.addPoint(head);
                this.arrow.addPoint(p3);
            } else {
                this.recalculate = true;
            }
            if (this.highlighted) {
                g.setForegroundColor(fillDarkGrey);
            } else if (this.pressed) {
                g.setAlpha(255);
                g.setForegroundColor(ColorConstants.white);
            } else {
                g.setForegroundColor(arrowFill);
            }
            g.setLineWidth(ListScrollBar.this.mm_2);
            g.drawPolyline(this.arrow);
        }

        public void setDirection(int value) {
            this.direction = value;
        }

        public void setRecalculate(boolean value) {
            this.recalculate = value;
        }

        public void setHighlighted(boolean value) {
            this.highlighted = value;
        }

        public boolean isHighlighted() {
            return this.highlighted;
        }

        public void setPressed(boolean value) {
            this.pressed = value;
        }

        public boolean isPressed() {
            return this.pressed;
        }
    }

    protected class ThumbDraggerColors
    extends ScrollBar.ThumbDragger {
        protected ThumbDraggerColors() {
            super((ScrollBar)ListScrollBar.this);
        }

        public void mouseEntered(MouseEvent me) {
            ListScrollBar.this.thumb.setHighlighted(true);
            ListScrollBar.this.thumb.setPressed(false);
            ListScrollBar.this.thumb.repaint();
            super.mouseEntered(me);
        }

        public void mouseExited(MouseEvent me) {
            ListScrollBar.this.thumb.setHighlighted(false);
            ListScrollBar.this.thumb.setPressed(false);
            ListScrollBar.this.thumb.repaint();
            super.mouseExited(me);
        }

        public void mousePressed(MouseEvent me) {
            ListScrollBar.this.thumb.setHighlighted(false);
            ListScrollBar.this.thumb.setPressed(true);
            ListScrollBar.this.thumb.repaint();
            super.mousePressed(me);
        }

        public void mouseReleased(MouseEvent me) {
            ListScrollBar.this.thumb.setHighlighted(true);
            ListScrollBar.this.thumb.setPressed(false);
            ListScrollBar.this.thumb.repaint();
            super.mouseReleased(me);
        }
    }

    protected class ThumbFigure
    extends Panel {
        boolean highlighted;
        boolean pressed;

        protected ThumbFigure() {
        }

        protected void paintFigure(Graphics g) {
            g.setAlpha(130);
            Rectangle r = this.getBounds().getCopy();
            g.setBackgroundColor(ColorConstants.white);
            g.fillRectangle(this.getBounds());
            g.setLineWidth(ListScrollBar.this.mm_1);
            if (this.highlighted || this.pressed) {
                g.setForegroundColor(outlineDarkGrey);
            } else {
                g.setForegroundColor(outlineLightGrey);
            }
            g.drawRectangle(r);
            r = r.getCopy().shrink(ListScrollBar.this.mm_2, ListScrollBar.this.mm_2);
            if (this.pressed) {
                g.setBackgroundColor(fillDarkGrey);
            } else {
                g.setBackgroundColor(fillLightGrey);
            }
            g.fillRectangle(r);
        }

        public void setHighlighted(boolean value) {
            this.highlighted = value;
        }

        public boolean isHighlighted() {
            return this.highlighted;
        }

        public void setPressed(boolean value) {
            this.pressed = value;
        }

        public boolean isPressed() {
            return this.pressed;
        }
    }
}

