/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.ui.preferences;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.emf.core.internal.resources.PathmapManager;
import org.eclipse.gmf.runtime.emf.ui.internal.MslUIPlugin;
import org.eclipse.gmf.runtime.emf.ui.internal.l10n.EMFUIMessages;
import org.eclipse.gmf.runtime.emf.ui.preferences.NewPathVariableDialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PathmapsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String NAME_ATTRIBUTE = "name";
    private IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
    private Composite pathVariablesComposite;
    private CheckboxTableViewer pathVariables;
    private PathVariableContentProvider pathVariablesContent;
    private Button newVariable;
    private Button editVariable;
    private Button removeVariable;
    private Map variableChanges = new HashMap();
    private Object addedToken = new Object();
    private Object changedToken = new Object();
    private Object removedToken = new Object();

    protected void initHelp() {
    }

    protected Control createContents(Composite parent) {
        GridData gridData = null;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(2, false));
        PreferenceLinkArea pathVariablesArea = new PreferenceLinkArea(composite, 0, "org.eclipse.ui.preferencePages.LinkedResources", EMFUIMessages.PathmapsPreferencePage_mainDescription, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 2;
        pathVariablesArea.getControl().setLayoutData((Object)gridData);
        Label pathVariablesLabel = new Label(composite, 16384);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 2;
        gridData.verticalIndent = 20;
        pathVariablesLabel.setLayoutData((Object)gridData);
        pathVariablesLabel.setText(EMFUIMessages.PathmapsPreferencePage_availablePathVariables);
        this.pathVariablesComposite = new Composite(composite, 2048);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        this.pathVariablesComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.pathVariablesComposite.setLayout((Layout)gridLayout);
        this.pathVariables = CheckboxTableViewer.newCheckList((Composite)this.pathVariablesComposite, (int)2);
        this.pathVariablesContent = new PathVariableContentProvider();
        this.pathVariables.setContentProvider((IContentProvider)this.pathVariablesContent);
        this.pathVariables.setLabelProvider((IBaseLabelProvider)new PathVariableLabelProvider());
        this.pathVariables.setComparator((ViewerComparator)new PathVariableViewerComparator());
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = this.pathVariables.getTable().getItemHeight() * 7;
        gridData.widthHint = 332;
        this.pathVariables.getTable().setLayoutData((Object)gridData);
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 1;
        gridData.verticalAlignment = 1;
        buttonComposite.setLayoutData((Object)gridData);
        this.newVariable = new Button(buttonComposite, 0x1000000);
        this.newVariable.setText(EMFUIMessages.PathmapsPreferencePage_newVariable);
        this.setButtonLayoutData(this.newVariable);
        this.editVariable = new Button(buttonComposite, 0x1000000);
        this.editVariable.setText(EMFUIMessages.PathmapsPreferencePage_editVariable);
        this.setButtonLayoutData(this.editVariable);
        this.removeVariable = new Button(buttonComposite, 0x1000000);
        this.removeVariable.setText(EMFUIMessages.PathmapsPreferencePage_removeVariable);
        this.setButtonLayoutData(this.removeVariable);
        this.pathVariables.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PathmapsPreferencePage.this.pathVariableSelected(event.getSelection());
            }
        });
        this.pathVariables.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PathmapsPreferencePage.this.pathVariableChecked(event, (PathVariableEntry)event.getElement());
            }
        });
        this.newVariable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathmapsPreferencePage.this.addPathVariable();
            }
        });
        this.editVariable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathmapsPreferencePage.this.editPathVariable(PathmapsPreferencePage.this.pathVariables.getSelection());
            }
        });
        this.removeVariable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathmapsPreferencePage.this.removePathVariable(PathmapsPreferencePage.this.pathVariables.getSelection());
            }
        });
        this.initializeContents();
        this.applyDialogFont(composite);
        this.pathVariableSelected(this.pathVariables.getSelection());
        return composite;
    }

    private void pathVariableChecked(CheckStateChangedEvent event, PathVariableEntry entry) {
        if (event.getChecked()) {
            if (this.validateSelection(entry, false)) {
                entry.setSelected(true);
            } else {
                event.getCheckable().setChecked((Object)entry, false);
            }
        } else if (this.validateDeselection(entry, false)) {
            entry.setSelected(false);
        } else {
            event.getCheckable().setChecked((Object)entry, true);
        }
    }

    private void pathVariableSelected(ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.editVariable.setEnabled(this.validateEdit(ssel, false));
        this.removeVariable.setEnabled(this.validateRemove(ssel, false));
    }

    private void markAdded(String variableName) {
        Object currentChange = this.variableChanges.get(variableName);
        if (currentChange == this.removedToken) {
            this.variableChanges.put(variableName, this.changedToken);
        } else if (currentChange != this.changedToken) {
            this.variableChanges.put(variableName, this.addedToken);
        }
    }

    boolean isAdded(String variableName) {
        return this.variableChanges.get(variableName) == this.addedToken;
    }

    private void markRemoved(String variableName) {
        Object currentChange = this.variableChanges.get(variableName);
        if (currentChange == this.addedToken) {
            this.variableChanges.remove(variableName);
        } else {
            this.variableChanges.put(variableName, this.removedToken);
        }
    }

    boolean isRemoved(String variableName) {
        return this.variableChanges.get(variableName) == this.removedToken;
    }

    private void markChanged(String variableName) {
        Object currentChange = this.variableChanges.get(variableName);
        if (currentChange != this.addedToken) {
            this.variableChanges.put(variableName, this.changedToken);
        }
    }

    boolean isChanged(String variableName) {
        return this.variableChanges.get(variableName) == this.changedToken;
    }

    boolean isLocationDefined(IPath location) {
        Iterator iter = this.pathVariablesContent.entries.iterator();
        while (iter.hasNext()) {
            if (!location.equals((Object)((PathVariableEntry)iter.next()).getLocationPath())) continue;
            return true;
        }
        return false;
    }

    private void addPathVariable() {
        NewPathVariableDialog dlg = NewPathVariableDialog.openNew(this);
        if (dlg != null) {
            String name = dlg.getVariableName();
            IPath location = dlg.getVariableLocation();
            this.markAdded(name);
            PathVariableEntry entry = new PathVariableEntry(name, location);
            entry.setSelected(true);
            this.pathVariablesContent.add(entry);
            this.pathVariables.setChecked((Object)entry, true);
            this.pathVariables.setSelection((ISelection)new StructuredSelection((Object)entry));
        }
    }

    private void editPathVariable(ISelection selection) {
        String oldName;
        NewPathVariableDialog dlg;
        IStructuredSelection ssel;
        PathVariableEntry entry = null;
        if (selection instanceof IStructuredSelection && !(ssel = (IStructuredSelection)selection).isEmpty()) {
            entry = (PathVariableEntry)ssel.getFirstElement();
        }
        if (entry != null && (dlg = NewPathVariableDialog.openEdit(this, oldName = entry.getName(), entry.getLocation())) != null) {
            String[] stringArray;
            boolean nameChanged;
            String newName = dlg.getVariableName();
            IPath newLocation = dlg.getVariableLocation();
            boolean bl = nameChanged = !oldName.equals(newName);
            if (nameChanged) {
                this.markAdded(newName);
                this.markRemoved(oldName);
            } else {
                this.markChanged(oldName);
            }
            entry.setName(newName);
            entry.setLocation(newLocation);
            if (nameChanged) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = NAME_ATTRIBUTE;
            } else {
                stringArray = null;
            }
            this.pathVariables.update((Object)entry, stringArray);
        }
    }

    private void removePathVariable(ISelection selection) {
        IStructuredSelection ssel;
        Iterator entries = null;
        if (selection instanceof IStructuredSelection && !(ssel = (IStructuredSelection)selection).isEmpty()) {
            entries = ssel.iterator();
        }
        if (entries != null) {
            while (entries.hasNext()) {
                PathVariableEntry entry = (PathVariableEntry)entries.next();
                String name = entry.getName();
                this.markRemoved(name);
                this.pathVariablesContent.remove(entry);
            }
        }
    }

    private boolean validateSelection(PathVariableEntry entry, boolean showError) {
        String name = entry.getName();
        if (!PathmapManager.isCompatiblePathVariable((String)name)) {
            if (showError) {
                this.setMessage(EMFUIMessages.PathmapsPreferencePage_incompatiblePathVariableErrorMessage, 3);
            }
            return false;
        }
        if (PathmapManager.isRegisteredPathVariable((String)name)) {
            if (showError) {
                this.setMessage(EMFUIMessages.PathmapsPreferencePage_registeredPathVariableErrorMessage, 3);
            }
            return false;
        }
        return true;
    }

    private boolean validateDeselection(PathVariableEntry entry, boolean showError) {
        if (entry.isRequired()) {
            if (showError) {
                this.setMessage(EMFUIMessages.PathmapsPreferencePage_registeredPathVariableErrorMessage, 3);
            }
            return false;
        }
        return true;
    }

    private boolean validateEdit(IStructuredSelection selection, boolean showError) {
        if (selection.isEmpty() || selection.size() > 1) {
            return false;
        }
        String name = ((PathVariableEntry)selection.getFirstElement()).getName();
        if (PathmapManager.isRegisteredPathVariable((String)name)) {
            if (showError) {
                this.setMessage(EMFUIMessages.PathmapsPreferencePage_registeredPathVariableErrorMessage, 3);
            }
            return false;
        }
        return true;
    }

    private boolean validateRemove(IStructuredSelection selection, boolean showError) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            String name = ((PathVariableEntry)iter.next()).getName();
            if (!PathmapManager.isRegisteredPathVariable((String)name)) continue;
            if (showError) {
                this.setMessage(EMFUIMessages.PathmapsPreferencePage_registeredPathVariableErrorMessage, 3);
            }
            return false;
        }
        return true;
    }

    private void initializeContents() {
        this.setMessage(null);
        this.variableChanges.clear();
        Set currentVariables = PathmapManager.getPathVariableReferences();
        HashSet<PathVariableEntry> allVariables = new HashSet<PathVariableEntry>();
        HashSet<PathVariableEntry> checkedVariables = new HashSet<PathVariableEntry>();
        HashSet<String> pathVariableNames = new HashSet<String>();
        pathVariableNames.addAll(Arrays.asList(this.pathVariableManager.getPathVariableNames()));
        pathVariableNames.addAll(PathmapManager.getAllPathVariables());
        for (String name : pathVariableNames) {
            PathVariableEntry entry;
            if (PathmapManager.isRegisteredPathVariable((String)name)) {
                String value = PathmapManager.getRegisteredValue((String)name);
                try {
                    URI uri = URI.createURI((String)value);
                    if (uri.isFile()) {
                        value = uri.toFileString();
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                entry = new PathVariableEntry(name, value);
                checkedVariables.add(entry);
                allVariables.add(entry);
                continue;
            }
            if (!PathmapManager.isCompatiblePathVariable((String)name)) continue;
            entry = new PathVariableEntry(name, this.pathVariableManager.getValue(name));
            if (currentVariables.contains(entry.getName())) {
                checkedVariables.add(entry);
                entry.setSelected(true);
            }
            allVariables.add(entry);
        }
        this.pathVariables.setInput(allVariables);
        this.pathVariables.setCheckedElements(checkedVariables.toArray());
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.initializeContents();
        super.performDefaults();
    }

    public boolean performOk() {
        Set currentVariables = PathmapManager.getPathVariableReferences();
        try {
            Iterator iter = this.variableChanges.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                if (!this.isRemoved(name)) continue;
                if (this.pathVariableManager.isDefined(name)) {
                    this.pathVariableManager.setValue(name, null);
                }
                PathmapManager.removePathVariableReference((String)name);
                iter.remove();
            }
            Object[] variables = this.pathVariablesContent.getElements(null);
            int i = 0;
            while (i < variables.length) {
                PathVariableEntry entry = (PathVariableEntry)variables[i];
                String name = entry.getName();
                if (this.isChanged(name) || this.isAdded(name) && !this.pathVariableManager.isDefined(name)) {
                    this.pathVariableManager.setValue(name, (IPath)new Path(entry.getLocation()));
                    this.variableChanges.remove(name);
                }
                if (entry.isSelected() && !currentVariables.contains(name)) {
                    PathmapManager.addPathVariableReference((String)name);
                } else if (!entry.isSelected() && currentVariables.contains(name)) {
                    PathmapManager.removePathVariableReference((String)name);
                }
                ++i;
            }
            PathmapManager.updatePreferenceStore();
            return true;
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)EMFUIMessages.PathmapsPreferencePage_promptTitle, (String)EMFUIMessages.PathmapsPreferencePage_updateFailed, (IStatus)e.getStatus());
            return false;
        }
    }

    private static class PathVariableContentProvider
    implements IStructuredContentProvider {
        private Set entries = new HashSet();
        private TableViewer table;

        PathVariableContentProvider() {
        }

        void add(PathVariableEntry entry) {
            if (!this.entries.contains(entry)) {
                this.entries.add(entry);
                this.table.add((Object)entry);
            }
        }

        void remove(PathVariableEntry entry) {
            if (this.entries.contains(entry)) {
                this.entries.remove(entry);
                this.table.remove((Object)entry);
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.entries.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.entries = (Set)newInput;
            this.table = (TableViewer)viewer;
        }

        public void dispose() {
        }
    }

    private static final class PathVariableEntry {
        private String name;
        private String location;
        private IPath locationPath;
        private final boolean required;
        private boolean selected;

        PathVariableEntry(String name, IPath location) {
            this(name, location.toPortableString(), false);
            this.locationPath = location;
        }

        PathVariableEntry(String name, String location) {
            this(name, location, true);
        }

        private PathVariableEntry(String name, String location, boolean required) {
            this.name = name;
            this.location = location;
            this.required = required;
            this.selected = required;
        }

        boolean isRequired() {
            return this.required;
        }

        String getName() {
            return this.name;
        }

        void setName(String name) {
            if (!this.isRequired()) {
                this.name = name;
            }
        }

        String getLocation() {
            return this.location;
        }

        IPath getLocationPath() {
            return this.locationPath;
        }

        void setLocation(IPath location) {
            if (!this.isRequired()) {
                this.locationPath = location;
                this.location = location.toPortableString();
            }
        }

        boolean isSelected() {
            return this.selected;
        }

        void setSelected(boolean selected) {
            if (!this.isRequired()) {
                this.selected = selected;
            }
        }

        public String toString() {
            return String.valueOf(this.getName()) + " - " + this.getLocation();
        }
    }

    private static class PathVariableLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private Image lockImage = null;

        PathVariableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            PathVariableEntry entry = (PathVariableEntry)element;
            String name = entry.getName();
            if (PathmapManager.isRegisteredPathVariable((String)name)) {
                return this.getLockImage();
            }
            if (!this.isDirectory(entry.getLocation())) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            return null;
        }

        private boolean isDirectory(String location) {
            File file = new File(location);
            return file.exists() && file.isDirectory();
        }

        private Image getLockImage() {
            if (this.lockImage == null) {
                this.lockImage = MslUIPlugin.imageDescriptorFromPlugin((String)MslUIPlugin.getPluginId(), (String)"/icons/full/lock.gif").createImage();
            }
            return this.lockImage;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex != 0) {
                return null;
            }
            PathVariableEntry entry = (PathVariableEntry)element;
            String pathString = entry.isRequired() ? TextProcessor.process((String)entry.getLocation(), (String)":/?#@.!") : TextProcessor.process((String)entry.getLocation());
            return NLS.bind((String)EMFUIMessages.PathmapsPreferencePage_variablePattern, (Object)entry.getName(), (Object)pathString);
        }

        public void dispose() {
            if (this.lockImage != null) {
                this.lockImage.dispose();
                this.lockImage = null;
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }
    }

    private static class PathVariableViewerComparator
    extends ViewerComparator {
        PathVariableViewerComparator() {
        }

        public boolean isSorterProperty(Object element, String property) {
            return PathmapsPreferencePage.NAME_ATTRIBUTE.equals(property);
        }

        public int category(Object element) {
            return PathmapManager.isRegisteredPathVariable((String)((PathVariableEntry)element).getName()) ? 1 : 0;
        }
    }
}

