/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.dnd.drag;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.dnd.core.DragDropListenerService;
import org.eclipse.gmf.runtime.common.ui.services.dnd.core.TransferAdapterService;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drag.DragSourceContext;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drag.IDragSourceListener;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drag.ITransferDragSourceListener;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.CommonUIServicesDNDDebugOptions;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.CommonUIServicesDNDPlugin;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.core.DragListenerContext;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.l10n.CommonUIServicesDNDMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;

public final class DelegatingDragSourceAdapter
implements DragSourceListener {
    private final Hashtable allAdapters;
    private ITransferDragSourceListener[] currentAdapters = null;
    private ITransferDragSourceListener chosenAdapter = null;
    private final DragSourceContext context;

    public DelegatingDragSourceAdapter(DragSourceContext aContext) {
        assert (aContext != null) : "aContext cannot be null";
        this.context = aContext;
        this.allAdapters = this.getAllTransferAdapters();
    }

    public void dragStart(DragSourceEvent event) {
        try {
            if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND)) {
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)"dragStart entered");
            }
            boolean saveDoit = event.doit;
            Object saveData = event.data;
            this.setCurrentAdapters(null);
            this.setChosenAdapter(null);
            this.setCurrentAdapters(this.getAdapters(this.getListeners()));
            boolean doIt = false;
            ArrayList<ITransferDragSourceListener> listOfActiveAdapters = new ArrayList<ITransferDragSourceListener>();
            ArrayList<Transfer> listOfActiveTransferAgents = new ArrayList<Transfer>();
            if (this.getCurrentAdapters() != null && this.getCurrentAdapters().length > 0) {
                int i = 0;
                while (i < this.getCurrentAdapters().length) {
                    event.doit = saveDoit;
                    this.getCurrentAdapters()[i].dragStart(event);
                    if (event.doit) {
                        listOfActiveAdapters.add(this.getCurrentAdapters()[i]);
                        listOfActiveTransferAgents.add(this.getCurrentAdapters()[i].getTransferAgent().getTransfer());
                    }
                    doIt = doIt || event.doit;
                    ++i;
                }
                if (doIt) {
                    ((DragSource)event.widget).setTransfer(listOfActiveTransferAgents.toArray(new Transfer[listOfActiveTransferAgents.size()]));
                    this.setCurrentAdapters(listOfActiveAdapters.toArray(new ITransferDragSourceListener[listOfActiveAdapters.size()]));
                }
                if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND)) {
                    String result = doIt ? "true" : "false";
                    Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DragStart::Event do it flag is " + result));
                    int i2 = 0;
                    while (i2 < this.getCurrentAdapters().length) {
                        Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DragStart::Transfer Adapter is " + this.getCurrentAdapters()[i2].getClass().getName()));
                        ++i2;
                    }
                }
                event.data = saveData;
                event.doit = doIt;
            } else {
                this.getContext().dragStart(event);
            }
        }
        catch (Throwable e) {
            event.doit = false;
            this.handle(e, false);
        }
    }

    public void dragSetData(DragSourceEvent event) {
        try {
            this.setChosenAdapter(this.getAdapter(event.dataType));
            if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND)) {
                String adapterChosen = this.getChosenAdapter() != null ? this.getChosenAdapter().getClass().getName() : "No Adapter Chosen";
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DragSetData::Chosen Adapter is " + adapterChosen));
            }
            if (this.getChosenAdapter() != null) {
                this.getChosenAdapter().dragSetData(event);
            } else {
                this.getContext().dragSetData(event);
            }
        }
        catch (Throwable e) {
            event.data = null;
            this.handle(e, false);
        }
    }

    public void dragFinished(DragSourceEvent event) {
        block8: {
            try {
                try {
                    if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND)) {
                        String adapterChosen = this.getChosenAdapter() != null ? this.getChosenAdapter().getClass().getName() : "No Adapter Chosen";
                        Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DragFinished::Chosen Adapter is " + adapterChosen));
                    }
                    if (this.getChosenAdapter() != null) {
                        this.getChosenAdapter().dragFinished(event);
                        break block8;
                    }
                    this.setChosenAdapter(this.getAdapter(event.dataType));
                    if (this.getChosenAdapter() != null) {
                        this.getChosenAdapter().dragFinished(event);
                        break block8;
                    }
                    this.getContext().dragFinished(event);
                }
                catch (Throwable e) {
                    this.handle(e, false);
                    this.setChosenAdapter(null);
                    this.setCurrentAdapters(null);
                }
            }
            finally {
                this.setChosenAdapter(null);
                this.setCurrentAdapters(null);
            }
        }
    }

    private ITransferDragSourceListener[] getCurrentAdapters() {
        return this.currentAdapters;
    }

    private DragSourceContext getContext() {
        return this.context;
    }

    private IDragSourceListener[] getListeners() {
        ISelection selection = this.getContext().getSelection();
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object[] array = ((IStructuredSelection)selection).toArray();
        ArrayList listOfElementTypes = new ArrayList();
        int i = 0;
        while (i < array.length) {
            if (!listOfElementTypes.contains(array[i].getClass())) {
                listOfElementTypes.add(array[i].getClass());
            }
            ++i;
        }
        ArrayList<IDragSourceListener> listOfListeners = new ArrayList<IDragSourceListener>();
        for (Class clazz : listOfElementTypes) {
            DragListenerContext aContext = new DragListenerContext(this.getContext().getActivePart(), clazz, "ALL_TRANSFERS", false);
            IDragSourceListener[] listeners = DragDropListenerService.getInstance().getDragSourceListeners(aContext);
            if (listeners == null || listeners.length == 0) {
                aContext = new DragListenerContext(this.getContext().getActivePart(), clazz, "ALL_TRANSFERS", true);
                listeners = DragDropListenerService.getInstance().getDragSourceListeners(aContext);
            }
            if (listeners == null || listeners.length == 0) continue;
            int i2 = 0;
            while (i2 < listeners.length) {
                if (!listOfListeners.contains(listeners[i2])) {
                    listOfListeners.add(listeners[i2]);
                }
                ++i2;
            }
        }
        return !listOfListeners.isEmpty() ? listOfListeners.toArray(new IDragSourceListener[listOfListeners.size()]) : null;
    }

    private ITransferDragSourceListener[] getAdapters(IDragSourceListener[] listeners) {
        if (listeners == null || listeners.length == 0) {
            return null;
        }
        Hashtable<String, ArrayList> listOfUniqueTransferIds = new Hashtable<String, ArrayList>();
        int i = 0;
        while (i < listeners.length) {
            String[] transferIds;
            if (listeners[i].isDraggable(this.getContext()) && (transferIds = listeners[i].getSupportingTransferIds()) != null && transferIds.length != 0) {
                int y = 0;
                while (y < transferIds.length) {
                    ArrayList listOfListeners = null;
                    listOfListeners = !listOfUniqueTransferIds.containsKey(transferIds[y]) ? new ArrayList() : (ArrayList)listOfUniqueTransferIds.get(transferIds[y]);
                    if (listOfListeners != null) {
                        listOfListeners.add(listeners[i]);
                        listOfUniqueTransferIds.put(transferIds[y], listOfListeners);
                    }
                    ++y;
                }
            }
            ++i;
        }
        if (listOfUniqueTransferIds.isEmpty()) {
            return null;
        }
        ArrayList<ITransferDragSourceListener> listOfAdapters = new ArrayList<ITransferDragSourceListener>();
        Enumeration enumeration = listOfUniqueTransferIds.keys();
        while (enumeration.hasMoreElements()) {
            String transferId = (String)enumeration.nextElement();
            ArrayList supportingListeners = (ArrayList)listOfUniqueTransferIds.get(transferId);
            ITransferDragSourceListener adapter = (ITransferDragSourceListener)this.getAllAdapters().get(transferId.hashCode());
            if (adapter == null) continue;
            adapter.init(supportingListeners.toArray(new IDragSourceListener[supportingListeners.size()]), this.getContext());
            listOfAdapters.add(adapter);
        }
        return !listOfAdapters.isEmpty() ? listOfAdapters.toArray(new ITransferDragSourceListener[listOfAdapters.size()]) : null;
    }

    private void setCurrentAdapters(ITransferDragSourceListener[] currentAdapterArray) {
        this.currentAdapters = currentAdapterArray;
    }

    private ITransferDragSourceListener getAdapter(TransferData type) {
        if (type != null) {
            int i = 0;
            while (i < this.getCurrentAdapters().length) {
                if (this.getCurrentAdapters()[i].getTransferAgent().getTransfer().isSupportedType(type)) {
                    return this.getCurrentAdapters()[i];
                }
                ++i;
            }
        }
        return null;
    }

    private ITransferDragSourceListener getChosenAdapter() {
        return this.chosenAdapter;
    }

    private void setChosenAdapter(ITransferDragSourceListener aChosenAdapter) {
        this.chosenAdapter = aChosenAdapter;
    }

    private Hashtable getAllTransferAdapters() {
        Hashtable<Integer, ITransferDragSourceListener> listOfSupportedAdapters = new Hashtable<Integer, ITransferDragSourceListener>();
        String[] transferIds = DragDropListenerService.getInstance().getAllTransferIds(this.getContext().getActivePart().getSite().getId(), "drag");
        if (transferIds == null || transferIds.length == 0) {
            return null;
        }
        int i = 0;
        while (i < transferIds.length) {
            ITransferDragSourceListener adapter = TransferAdapterService.getInstance().getTransferDragSourceAdapter(transferIds[i]);
            if (adapter != null) {
                listOfSupportedAdapters.put(transferIds[i].hashCode(), adapter);
            }
            ++i;
        }
        return listOfSupportedAdapters;
    }

    private void handle(Throwable exception, boolean displayDialog) {
        if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.EXCEPTIONS_CATCHING)) {
            Trace.catching((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"handle", (Throwable)exception);
        }
        Status status = new Status(4, CommonUIServicesDNDPlugin.getPluginId(), 2, CommonUIServicesDNDMessages.DelegatingDragSourceAdapter__ERROR__errorMessage, exception);
        Log.log((Plugin)CommonUIServicesDNDPlugin.getDefault(), (IStatus)status);
        if (displayDialog) {
            status = new Status(4, CommonUIServicesDNDPlugin.getPluginId(), 2, CommonUIServicesDNDMessages.DelegatingDragSourceAdapter__ERROR__errorMessage, exception);
            ErrorDialog.openError((Shell)this.getContext().getActivePart().getSite().getShell(), null, null, (IStatus)status);
        }
    }

    private Hashtable getAllAdapters() {
        return this.allAdapters;
    }
}

