/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.gef.ui.palette.customize;

import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gmf.runtime.gef.ui.palette.customize.IPaletteState;
import org.eclipse.ui.IMemento;

public class PaletteEntryState
implements IPaletteState {
    private PaletteEntry paletteEntry;
    private static final String LABEL_KEY = "label";
    private static final String DESCRIPTION_KEY = "description";
    private static final String ISVISIBLE_KEY = "isVisible";
    private String label;
    private String description;
    private boolean isVisible;

    public PaletteEntryState(PaletteEntry entry) {
        this.paletteEntry = entry;
    }

    protected PaletteEntry getPaletteEntry() {
        return this.paletteEntry;
    }

    public void storeState() {
        PaletteEntry entry = this.getPaletteEntry();
        this.label = entry.getLabel();
        this.description = entry.getDescription();
        this.isVisible = entry.isVisible();
    }

    public void rollback() {
        PaletteEntry entry = this.getPaletteEntry();
        entry.setLabel(this.label);
        entry.setDescription(this.description);
        entry.setVisible(this.isVisible);
    }

    public void storeChangesInMemento(IMemento memento) {
        PaletteEntry entry = this.getPaletteEntry();
        if (this.label != null && !this.label.equals(entry.getLabel()) || this.label == null && entry.getLabel() != null) {
            memento.putString(LABEL_KEY, entry.getLabel());
        }
        if (this.description != null && !this.description.equals(entry.getDescription()) || this.description == null && entry.getDescription() != null) {
            memento.putString(DESCRIPTION_KEY, entry.getDescription());
        }
        if (this.isVisible != entry.isVisible()) {
            memento.putBoolean(ISVISIBLE_KEY, entry.isVisible());
        }
    }

    public void applyChangesFromMemento(IMemento entryMemento) {
        Boolean bValue;
        PaletteEntry entry = this.getPaletteEntry();
        String sValue = entryMemento.getString(LABEL_KEY);
        if (sValue != null) {
            entry.setLabel(sValue);
        }
        if ((sValue = entryMemento.getString(DESCRIPTION_KEY)) != null) {
            entry.setDescription(sValue);
        }
        if ((bValue = entryMemento.getBoolean(ISVISIBLE_KEY)) != null) {
            entry.setVisible(bValue.booleanValue());
        }
    }
}

