/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.image.EPSImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.JpegImage;
import org.apache.fop.pdf.BitmapImage;
import org.apache.fop.pdf.DCTFilter;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFImage;
import org.apache.fop.pdf.PDFXObject;

public class FopPDFImage
implements PDFImage {
    private FopImage fopImage;
    private PDFICCStream pdfICCStream = null;
    private PDFFilter pdfFilter = null;
    private String maskRef;
    private String softMaskRef;
    private boolean isPS = false;
    private String key;

    public FopPDFImage(FopImage image, String key) {
        this.fopImage = image;
        this.key = key;
        this.isPS = this.fopImage instanceof EPSImage;
    }

    public String getKey() {
        return this.key;
    }

    public void setup(PDFDocument doc) {
        if ("image/jpeg".equals(this.fopImage.getMimeType())) {
            this.pdfFilter = new DCTFilter();
            this.pdfFilter.setApplied(true);
            JpegImage jpegimage = (JpegImage)this.fopImage;
            ICC_Profile prof = jpegimage.getICCProfile();
            PDFColorSpace pdfCS = FopPDFImage.toPDFColorSpace(jpegimage.getColorSpace());
            if (prof != null) {
                this.pdfICCStream = doc.getFactory().makePDFICCStream();
                this.pdfICCStream.setColorSpace(prof, pdfCS);
            }
        }
        if (this.fopImage.hasSoftMask()) {
            byte[] softMask = this.fopImage.getSoftMask();
            if (softMask == null) {
                return;
            }
            BitmapImage fopimg = new BitmapImage("Mask:" + this.key, this.fopImage.getWidth(), this.fopImage.getHeight(), softMask, null);
            fopimg.setColorSpace(new PDFColorSpace(1));
            PDFXObject xobj = doc.addImage(null, fopimg);
            this.softMaskRef = xobj.referencePDF();
        }
    }

    public boolean isPS() {
        return this.isPS;
    }

    public boolean isDCT() {
        return this.fopImage.getMimeType().equals("image/jpeg");
    }

    public int getWidth() {
        return this.fopImage.getWidth();
    }

    public int getHeight() {
        return this.fopImage.getHeight();
    }

    public PDFColorSpace getColorSpace() {
        return FopPDFImage.toPDFColorSpace(this.fopImage.getColorSpace());
    }

    public int getBitsPerPixel() {
        return this.fopImage.getBitsPerPixel();
    }

    public boolean isTransparent() {
        return this.fopImage.isTransparent();
    }

    public PDFColor getTransparentColor() {
        return new PDFColor(this.fopImage.getTransparentColor().getRed(), this.fopImage.getTransparentColor().getGreen(), this.fopImage.getTransparentColor().getBlue());
    }

    public String getMask() {
        return this.maskRef;
    }

    public String getSoftMask() {
        return this.softMaskRef;
    }

    public void outputContents(OutputStream out) throws IOException {
        if (this.isPS) {
            this.outputPostScriptContents(out);
        } else {
            out.write(this.fopImage.getBitmaps());
        }
    }

    protected void outputPostScriptContents(OutputStream out) throws IOException {
        EPSImage epsImage = (EPSImage)this.fopImage;
        int[] bbox = epsImage.getBBox();
        int bboxw = bbox[2] - bbox[0];
        int bboxh = bbox[3] - bbox[1];
        StringBuffer preamble = new StringBuffer();
        preamble.append("%%BeginDocument: " + epsImage.getDocName() + "\n");
        preamble.append("userdict begin                 % Push userdict on dict stack\n");
        preamble.append("/PreEPS_state save def\n");
        preamble.append("/dict_stack countdictstack def\n");
        preamble.append("/ops_count count 1 sub def\n");
        preamble.append("/showpage {} def\n");
        preamble.append(1.0 / (double)bboxw + " " + 1.0 / (double)bboxh + " scale\n");
        preamble.append(-bbox[0] + " " + -bbox[1] + " translate\n");
        preamble.append(bbox[0] + " " + bbox[1] + " " + bboxw + " " + bboxh + " rectclip\n");
        preamble.append("newpath\n");
        StringBuffer post = new StringBuffer();
        post.append("%%EndDocument\n");
        post.append("count ops_count sub {pop} repeat\n");
        post.append("countdictstack dict_stack sub {end} repeat\n");
        post.append("PreEPS_state restore\n");
        post.append("end % userdict\n");
        out.write(PDFDocument.encode(preamble.toString()));
        out.write(((EPSImage)this.fopImage).getEPSImage());
        out.write(PDFDocument.encode(post.toString()));
    }

    public PDFICCStream getICCStream() {
        return this.pdfICCStream;
    }

    public static PDFColorSpace toPDFColorSpace(ColorSpace cs) {
        if (cs == null) {
            return null;
        }
        PDFColorSpace pdfCS = new PDFColorSpace(0);
        switch (cs.getType()) {
            case 9: {
                pdfCS.setColorSpace(3);
                break;
            }
            case 5: {
                pdfCS.setColorSpace(2);
                break;
            }
            case 6: {
                pdfCS.setColorSpace(1);
            }
        }
        return pdfCS;
    }

    public String getFilterHint() {
        if (this.isPS()) {
            return "content";
        }
        if (this.fopImage.getMimeType().equals("image/jpeg")) {
            return "jpeg";
        }
        return "image";
    }
}

