/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.util;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gmf.runtime.common.ui.services.icon.IconOptions;
import org.eclipse.gmf.runtime.common.ui.services.icon.IconService;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserService;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class CommonLabelProvider
extends DecoratingLabelProvider {
    public CommonLabelProvider() {
        super((ILabelProvider)new MyDelegatingLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
    }

    public void setParserOptions(int options) {
        ((MyDelegatingLabelProvider)this.getLabelProvider()).setParserOptions(options);
    }

    public void setIconOptions(int options) {
        ((MyDelegatingLabelProvider)this.getLabelProvider()).setIconOptions(options);
    }

    private static class MyDelegatingLabelProvider
    extends LabelProvider {
        private int parserOptions = ParserOptions.NONE.intValue();
        private int iconOptions = IconOptions.NONE.intValue();

        private MyDelegatingLabelProvider() {
        }

        public Image getImage(Object element) {
            IStructuredSelection ss;
            if (element instanceof IStructuredSelection && (ss = (IStructuredSelection)element).size() == 1) {
                element = ss.getFirstElement();
            }
            if (!(element instanceof IAdaptable)) {
                return null;
            }
            return IconService.getInstance().getIcon((IAdaptable)element, this.iconOptions);
        }

        public String getText(Object element) {
            IStructuredSelection ss;
            if (element instanceof IStructuredSelection && (ss = (IStructuredSelection)element).size() == 1) {
                element = ss.getFirstElement();
            }
            if (!(element instanceof IAdaptable)) {
                return "";
            }
            return ParserService.getInstance().getPrintString((IAdaptable)element, this.parserOptions);
        }

        public void setParserOptions(int options) {
            this.parserOptions = options;
        }

        public void setIconOptions(int options) {
            this.iconOptions = options;
        }
    }
}

