/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.PartPositionInfo;
import org.eclipse.gmf.runtime.diagram.ui.render.util.DiagramImageUtils;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PrecisionPointList;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PartPositionInfoGenerator {
    public static final String CONNECTION_MARGIN = "connectionMargin";
    public static final String DIAGRAM_ORIGIN = "diagramOrigin";
    public static final String SCALE_FACTOR = "scaleFactor";

    public static final List<PartPositionInfo> getDiagramPartInfo(DiagramEditPart diagramEditPart, Map<String, Object> options) {
        double scale;
        ArrayList<PartPositionInfo> result = new ArrayList<PartPositionInfo>();
        ArrayList<IGraphicalEditPart> editParts = new ArrayList<IGraphicalEditPart>();
        List children = diagramEditPart.getPrimaryEditParts();
        IMapMode mm = MapModeUtil.getMapMode((IFigure)diagramEditPart.getFigure());
        double connectionMargin = options.get(CONNECTION_MARGIN) != null ? (Double)options.get(CONNECTION_MARGIN) : 0.0;
        Point origin = options.get(DIAGRAM_ORIGIN) != null ? (Point)options.get(DIAGRAM_ORIGIN) : new Point();
        double d = scale = options.get(SCALE_FACTOR) != null ? (Double)options.get(CONNECTION_MARGIN) : 1.0;
        if (scale <= 0.0) {
            throw new IllegalArgumentException();
        }
        for (IGraphicalEditPart part : children) {
            editParts.add(part);
            PartPositionInfoGenerator.getNestedEditParts(part, editParts);
        }
        IFigure printableLayer = LayerManager.Helper.find((EditPart)diagramEditPart).getLayer((Object)"Printable Layers");
        for (IGraphicalEditPart part : editParts) {
            PartPositionInfo position;
            IFigure figure = part.getFigure();
            View view = part.getNotationView();
            if (part instanceof ConnectionEditPart && figure instanceof PolylineConnection) {
                position = new PartPositionInfo();
                position.setView(view);
                position.setSemanticElement(ViewUtil.resolveSemanticElement((View)view));
                PolylineConnection mainPoly = (PolylineConnection)figure;
                if (mainPoly.isVisible() && !mainPoly.getBounds().isEmpty()) {
                    PointList mainPts = mainPoly.getPoints().getCopy();
                    DiagramImageUtils.translateTo((Translatable)mainPts, figure, printableLayer);
                    PointList envelopingPts = PartPositionInfoGenerator.calculateEnvelopingPolyline(mainPts, (int)Math.max(connectionMargin, (double)(mainPoly.getLineWidth() >> 1)));
                    envelopingPts.translate((Point)new PrecisionPoint(-origin.preciseX(), -origin.preciseY()));
                    mm.LPtoDP((Translatable)envelopingPts);
                    envelopingPts.performScale(scale);
                    ArrayList<Point> pts = new ArrayList<Point>(envelopingPts.size());
                    int i = 0;
                    while (i < envelopingPts.size()) {
                        pts.add(envelopingPts.getPoint(i));
                        ++i;
                    }
                    position.setPolyline(pts);
                }
                result.add(0, position);
                continue;
            }
            if ((view == null || !view.isSetElement()) && !(part instanceof ShapeEditPart) && !(part instanceof ShapeCompartmentEditPart) && !(part instanceof LabelEditPart)) continue;
            position = new PartPositionInfo();
            position.setView(view);
            position.setSemanticElement(ViewUtil.resolveSemanticElement((View)view));
            if (figure.isShowing() && !figure.getBounds().isEmpty()) {
                PrecisionRectangle bounds = new PrecisionRectangle(figure.getBounds());
                DiagramImageUtils.translateTo((Translatable)bounds, figure, printableLayer);
                bounds.translate((Point)new PrecisionPoint(-origin.preciseX(), -origin.preciseY()));
                mm.LPtoDP((Translatable)bounds);
                bounds.performScale(scale);
                position.setPartHeight(bounds.height);
                position.setPartWidth(bounds.width);
                position.setPartX(bounds.x);
                position.setPartY(bounds.y);
            }
            result.add(0, position);
        }
        return result;
    }

    private static void getNestedEditParts(IGraphicalEditPart childEditPart, Collection editParts) {
        for (IGraphicalEditPart child : childEditPart.getChildren()) {
            editParts.add(child);
            PartPositionInfoGenerator.getNestedEditParts(child, editParts);
        }
    }

    private static PointList calculateEnvelopingPolyline(PointList polyPts, int margin) {
        PrecisionPointList result = new PrecisionPointList(polyPts.size() << 1);
        List mainSegs = PointListUtilities.getLineSegments((PointList)polyPts);
        PartPositionInfoGenerator.removeRedundantSegments(mainSegs);
        if (mainSegs.size() > 0) {
            result = PartPositionInfoGenerator.calculateParallelPolyline(mainSegs, margin);
            PointList pts = PartPositionInfoGenerator.calculateParallelPolyline(mainSegs, -margin);
            int i = pts.size() - 1;
            while (i >= 0) {
                result.addPoint(pts.getPoint(i));
                --i;
            }
            result.addPoint(result.getFirstPoint());
        }
        return result;
    }

    private static void removeRedundantSegments(List<LineSeg> polyPts) {
        ListIterator<LineSeg> itr = polyPts.listIterator();
        while (itr.hasNext()) {
            LineSeg lineSeg = (LineSeg)itr.next();
            if (!lineSeg.getOrigin().equals((Object)lineSeg.getTerminus())) continue;
            itr.remove();
        }
    }

    private static PointList calculateParallelPolyline(List<LineSeg> polySegs, int margin) {
        PrecisionPointList result = new PrecisionPointList(polySegs.size() << 2);
        int index = 0;
        int absMargin = Math.abs(margin);
        LineSeg.Sign sign = margin < 0 ? LineSeg.Sign.NEGATIVE : LineSeg.Sign.POSITIVE;
        result.addPoint(polySegs.get(index++).locatePoint(0.0, (long)absMargin, sign));
        LineSeg parallel_1 = polySegs.get(index - 1).getParallelLineSegThroughPoint(result.getLastPoint());
        while (index < polySegs.size()) {
            LineSeg parallel_2 = polySegs.get(index).getParallelLineSegThroughPoint(polySegs.get(index).locatePoint(0.0, (long)absMargin, sign));
            PointList intersections = parallel_1.getLinesIntersections(parallel_2);
            if (intersections.size() > 0) {
                result.addPoint(intersections.getFirstPoint());
            } else {
                result.addPoint(parallel_1.getTerminus());
                result.addPoint(parallel_2.getOrigin());
            }
            parallel_1 = parallel_2;
            ++index;
        }
        result.addPoint(polySegs.get(index - 1).locatePoint(1.0, (long)absMargin, sign));
        return result;
    }
}

