/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.l10n.DiagramUIGeoshapesMessages;

public class GeoshapeConstants {
    public static final String GROUP_RECTANGLES = "rectangleMultiTool";
    public static final String GROUP_POLYGONS = "polygon";
    public static final String TOOL_OVAL = "oval";
    public static final String TOOL_TRIANGLE = "triangle";
    public static final String TOOL_RECTANGLE = "rectangle";
    public static final String TOOL_SHADOWRECTANGLE = "shadowRectangle";
    public static final String TOOL_3DRECTANGLE = "rectangle3D";
    public static final String TOOL_ROUNDRECTANGLE = "roundRectangle";
    public static final String TOOL_HEXAGON = "hexagon";
    public static final String TOOL_OCTAGON = "octagon";
    public static final String TOOL_PENTAGON = "pentagon";
    public static final String TOOL_DIAMOND = "diamond";
    public static final String TOOL_CYLINDER = "cylinder";
    public static final String TOOL_LINE = "line";

    public static List getSupportedShapes() {
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.add(TOOL_OVAL);
        toReturn.add(TOOL_TRIANGLE);
        toReturn.add(TOOL_RECTANGLE);
        toReturn.add(TOOL_SHADOWRECTANGLE);
        toReturn.add(TOOL_3DRECTANGLE);
        toReturn.add(TOOL_ROUNDRECTANGLE);
        toReturn.add(TOOL_HEXAGON);
        toReturn.add(TOOL_OCTAGON);
        toReturn.add(TOOL_PENTAGON);
        toReturn.add(TOOL_DIAMOND);
        toReturn.add(TOOL_CYLINDER);
        return toReturn;
    }

    public static List getSupportedConnections() {
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.add(TOOL_LINE);
        return toReturn;
    }

    public static String getShapeLocalizedType(String typeName) {
        return GeoshapeConstants.getShapeLabel(typeName).replaceFirst("&", "");
    }

    public static String getDisplayName(String label) {
        return label.replaceFirst("&", "");
    }

    public static String getShapeLabel(String toGet) {
        if (toGet.equals(TOOL_OVAL)) {
            return DiagramUIGeoshapesMessages.geoshape_OvalTool_Label;
        }
        if (toGet.equals(TOOL_TRIANGLE)) {
            return DiagramUIGeoshapesMessages.geoshape_TriangleTool_Label;
        }
        if (toGet.equals(TOOL_RECTANGLE)) {
            return DiagramUIGeoshapesMessages.geoshape_RectangleTool_Label;
        }
        if (toGet.equals(TOOL_SHADOWRECTANGLE)) {
            return DiagramUIGeoshapesMessages.geoshape_ShadowRectangleTool_Label;
        }
        if (toGet.equals(TOOL_3DRECTANGLE)) {
            return DiagramUIGeoshapesMessages.geoshape_3DRectangleTool_Label;
        }
        if (toGet.equals(TOOL_ROUNDRECTANGLE)) {
            return DiagramUIGeoshapesMessages.geoshape_RoundRectangleTool_Label;
        }
        if (toGet.equals(TOOL_HEXAGON)) {
            return DiagramUIGeoshapesMessages.geoshape_HexagonTool_Label;
        }
        if (toGet.equals(TOOL_OCTAGON)) {
            return DiagramUIGeoshapesMessages.geoshape_OctagonTool_Label;
        }
        if (toGet.equals(TOOL_PENTAGON)) {
            return DiagramUIGeoshapesMessages.geoshape_PentagonTool_Label;
        }
        if (toGet.equals(TOOL_DIAMOND)) {
            return DiagramUIGeoshapesMessages.geoshape_DiamondTool_Label;
        }
        if (toGet.equals(TOOL_CYLINDER)) {
            return DiagramUIGeoshapesMessages.geoshape_CylinderTool_Label;
        }
        return DiagramUIGeoshapesMessages.geoshape_GeometricShapeTool_Label;
    }
}

