/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.resources;

import java.io.File;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;
import org.eclipse.gmf.runtime.common.ui.internal.l10n.CommonUIMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.PlatformUI;

public class FileModificationValidator {
    private static FileModificationValidator INSTANCE = new FileModificationValidator();

    public static FileModificationValidator getInstance() {
        return INSTANCE;
    }

    private FileModificationValidator() {
    }

    public boolean okToEdit(IFile[] files, String modificationReason) {
        return this.okToEdit(files, modificationReason, null);
    }

    public boolean okToEdit(IFile[] files, final String modificationReason, final Shell shell) {
        final IStatus fileStatus = this.validateEdit(files, shell);
        if (!fileStatus.isOK()) {
            if (shell != null) {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)shell, (String)NLS.bind((String)CommonUIMessages.FileModificationValidator_EditProblemDialogTitle, (Object)modificationReason), (String)NLS.bind((String)CommonUIMessages.FileModificationValidator_EditProblemDialogMessage, (Object)modificationReason, (Object)fileStatus.getMessage()));
                    }
                });
            }
            return false;
        }
        return true;
    }

    public boolean okToSave(IFile file) {
        IStatus status = null;
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)file.getProject());
        IFileModificationValidator validator = null;
        if (provider != null) {
            validator = provider.getFileModificationValidator();
        }
        if ((status = validator == null ? this.getDefaultStatus(file) : validator.validateSave(file)).isOK()) {
            return true;
        }
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CommonUIMessages.FileModificationValidator_SaveProblemDialogTitle, (String)NLS.bind((String)CommonUIMessages.FileModificationValidator_SaveProblemDialogMessage, (Object)status.getMessage(), (Object)status.getMessage()));
        return false;
    }

    private IStatus getDefaultStatus(IFile file) {
        if (file.isReadOnly()) {
            String message = NLS.bind((String)CommonUIMessages.FileModificationValidator_FileIsReadOnlyErrorMessage, (Object)file.getFullPath().toString());
            return new Status(4, CommonUIPlugin.getPluginId(), 4, message, null);
        }
        return new Status(0, CommonUIPlugin.getPluginId(), 0, CommonUIMessages.FileModificationValidator_OK, null);
    }

    public IStatus validateEdit(IFile[] files, Object shell) {
        IStatus status = Status.OK_STATUS;
        if (files == null || files.length == 0) {
            return status;
        }
        HashSet<IFile> unsynchedFiles = new HashSet<IFile>();
        HashMap<IFile, ModificationStamp> filesToModificationStamps = new HashMap<IFile, ModificationStamp>();
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            filesToModificationStamps.put(file, new ModificationStamp(file));
            boolean inSync = file.isSynchronized(0);
            if (!inSync) {
                unsynchedFiles.add(file);
            }
            ++i;
        }
        if (!unsynchedFiles.isEmpty()) {
            status = this.buildOutOfSyncStatus(unsynchedFiles);
        }
        if (status.isOK()) {
            status = ResourcesPlugin.getWorkspace().validateEdit(files, shell);
            for (Map.Entry entry : filesToModificationStamps.entrySet()) {
                IFile file = (IFile)entry.getKey();
                ModificationStamp stamp = (ModificationStamp)entry.getValue();
                if (!stamp.hasFileChanged()) continue;
                unsynchedFiles.add(file);
            }
            if (!unsynchedFiles.isEmpty()) {
                status = this.buildOutOfSyncStatus(unsynchedFiles);
            }
        }
        return status;
    }

    private IStatus buildOutOfSyncStatus(Set<IFile> unsynchedFiles) {
        StringBuffer buf = new StringBuffer(CommonUIMessages.FileModificationValidator_OutOfSyncMessage);
        buf.append("\n");
        for (IFile file : unsynchedFiles) {
            buf.append(file.getFullPath().toString());
            buf.append("\n");
        }
        return new Status(4, CommonUIPlugin.getPluginId(), 0, buf.toString(), null);
    }

    private static class ModificationStamp {
        private IFile file;
        private Timestamp lastModified = null;
        private long fileLength = 0L;

        public ModificationStamp(IFile file) {
            assert (file != null);
            this.file = file;
            IPath path = file.getLocation();
            if (path != null) {
                File ioFile = path.toFile();
                if (ioFile != null) {
                    this.lastModified = new Timestamp(ioFile.lastModified());
                    this.lastModified.setNanos(0);
                    this.fileLength = ioFile.length();
                } else {
                    this.lastModified = new Timestamp(file.getModificationStamp());
                    this.lastModified.setNanos(0);
                }
            } else {
                this.lastModified = new Timestamp(file.getModificationStamp());
                this.lastModified.setNanos(0);
            }
        }

        public Timestamp getLastModified() {
            return this.lastModified;
        }

        public long getFileLength() {
            return this.fileLength;
        }

        public IFile getFile() {
            return this.file;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModificationStamp) {
                ModificationStamp stamp = (ModificationStamp)obj;
                return this.file.equals((Object)stamp.getFile()) && this.fileLength == stamp.getFileLength() && this.lastModified.equals(stamp.getLastModified());
            }
            return false;
        }

        public int hashCode() {
            return this.file.hashCode() + this.lastModified.hashCode() + (int)(this.fileLength ^ this.fileLength >>> 32);
        }

        public boolean hasFileChanged() {
            IPath path = this.file.getLocation();
            if (path == null) {
                return false;
            }
            File ioFile = path.toFile();
            if (ioFile == null) {
                return false;
            }
            Timestamp newTimestamp = new Timestamp(ioFile.lastModified());
            newTimestamp.setNanos(0);
            return this.lastModified.getTime() != newTimestamp.getTime() || this.fileLength != ioFile.length();
        }
    }
}

