/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.commands;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;

public class SetValueCommand
extends EditElementCommand {
    private final EStructuralFeature feature;
    private final Object value;

    public SetValueCommand(SetRequest request) {
        super(request.getLabel(), request.getElementToEdit(), request);
        this.feature = request.getFeature();
        this.value = request.getValue();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EObject elementToEdit = this.getElementToEdit();
        boolean many = FeatureMapUtil.isMany((EObject)elementToEdit, (EStructuralFeature)this.feature);
        if (many) {
            Collection collection = (Collection)elementToEdit.eGet(this.feature);
            if (this.value instanceof List) {
                List values = (List)this.value;
                collection.clear();
                collection.addAll(values);
            } else {
                collection.add(this.value);
            }
        } else {
            this.getElementToEdit().eSet(this.feature, this.value);
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    public boolean canExecute() {
        EObject elementToEdit = this.getElementToEdit();
        if (elementToEdit == null || !super.canExecute()) {
            return false;
        }
        boolean many = FeatureMapUtil.isMany((EObject)elementToEdit, (EStructuralFeature)this.feature);
        if (this.value == null && many) {
            return false;
        }
        EList allFeatures = this.getElementToEdit().eClass().getEAllStructuralFeatures();
        if (allFeatures.contains(this.feature) && this.feature.isChangeable()) {
            if (!many && (this.value == null || this.feature.getEType().isInstance(this.value))) {
                return true;
            }
            return this.verifyMany();
        }
        return false;
    }

    private boolean verifyMany() {
        if (this.value instanceof List) {
            List values = (List)this.value;
            for (Object element : values) {
                if (this.feature.getEType().isInstance(element)) continue;
                return false;
            }
            return true;
        }
        return this.feature.getEType().isInstance(this.value);
    }
}

