/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.commands;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;

public class DestroyReferenceCommand
extends EditElementCommand {
    private EObject container;
    private EReference containingFeature;
    private EObject referencedObject;

    public DestroyReferenceCommand(DestroyReferenceRequest request) {
        super(request.getLabel(), request.getContainer(), request);
        this.container = request.getContainer();
        this.containingFeature = request.getContainingFeature();
        this.referencedObject = request.getReferencedObject();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ArrayList<EReference> features = new ArrayList<EReference>();
        if (this.getContainingFeature() == null) {
            features.addAll((Collection<EReference>)this.getContainer().eClass().getEAllReferences());
        } else {
            features.add(this.getContainingFeature());
        }
        for (EReference nextReference : features) {
            if (!nextReference.isChangeable() || nextReference.isDerived() || !this.getContainer().eIsSet((EStructuralFeature)nextReference)) continue;
            if (FeatureMapUtil.isMany((EObject)this.getContainer(), (EStructuralFeature)nextReference)) {
                Collection referenceCollection = (Collection)this.getContainer().eGet((EStructuralFeature)nextReference);
                referenceCollection.remove(this.getReferencedObject());
                continue;
            }
            if (this.getContainer().eGet((EStructuralFeature)nextReference) != this.getReferencedObject()) continue;
            this.getContainer().eSet((EStructuralFeature)nextReference, null);
        }
        return CommandResult.newOKCommandResult();
    }

    protected EObject getContainer() {
        return this.container;
    }

    protected EReference getContainingFeature() {
        return this.containingFeature;
    }

    protected EObject getReferencedObject() {
        return this.referencedObject;
    }

    @Override
    public boolean canExecute() {
        return this.getReferencedObject() != null && this.getContainer() != null;
    }
}

