/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.graph;

import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.gmf.runtime.draw2d.ui.graph.BorderNode;
import org.eclipse.gmf.runtime.draw2d.ui.graph.JointEdges;

class JointIncomingEdges
extends Edge
implements JointEdges {
    private BorderNode joint;
    EdgeList edges = new EdgeList();
    private Edge leadingEdge = null;
    private int leadingCost = Integer.MAX_VALUE;

    public JointIncomingEdges(BorderNode joint) {
        super(new Node(), new Node());
        this.joint = joint;
        this.source = this.target = joint.borderNodeParent;
    }

    @Override
    public Edge getLeadingEdge() {
        if (this.leadingEdge == null) {
            int i = 0;
            while (i < this.edges.size()) {
                Edge e = this.edges.getEdge(i);
                int cost = this.getBendpointX(e) - e.target.x - e.target.getOffsetIncoming();
                if (Math.abs(cost) < this.leadingCost) {
                    this.leadingCost = Math.abs(cost);
                    this.leadingEdge = e;
                }
                ++i;
            }
        }
        return this.leadingEdge;
    }

    @Override
    public BorderNode getJoint() {
        return this.joint;
    }

    private int getBendpointX(Edge e) {
        Node node = e.vNodes == null ? e.source : e.vNodes.getNode(e.vNodes.size() - 1);
        return node.x + node.getOffsetOutgoing();
    }
}

