/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.document;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DocumentEvent;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IElementStateListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.ISchedulingRuleProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorPlugin;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.l10n.EditorMessages;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

public abstract class AbstractDocumentProvider
implements IDocumentProvider {
    protected static final boolean PR10806_UC5_ENABLED = true;
    protected static final boolean PR14469_ENABLED = false;
    public static final IStatus STATUS_OK = new Status(0, EditorPlugin.getPluginId(), 0, EditorMessages.AbstractDocumentProvider_ok, null);
    public static final IStatus STATUS_ERROR = new Status(4, EditorPlugin.getPluginId(), 1, EditorMessages.AbstractDocumentProvider_error, null);
    private Map fElementInfoMap = new HashMap();
    private List fElementStateListeners = new ArrayList();
    private IProgressMonitor fProgressMonitor;

    protected AbstractDocumentProvider() {
    }

    protected abstract IDocument createDocument(Object var1) throws CoreException;

    protected abstract IDocument createEmptyDocument();

    protected abstract void doSaveDocument(IProgressMonitor var1, Object var2, IDocument var3, boolean var4) throws CoreException;

    protected abstract IRunnableContext getOperationRunner(IProgressMonitor var1);

    protected ISchedulingRule getSynchronizeRule(Object element) {
        return null;
    }

    protected ISchedulingRule getValidateStateRule(Object element) {
        return null;
    }

    protected ISchedulingRule getSaveRule(Object element) {
        return null;
    }

    protected ISchedulingRule getResetRule(Object element) {
        return null;
    }

    protected ElementInfo getElementInfo(Object element) {
        return (ElementInfo)this.fElementInfoMap.get(element);
    }

    protected ElementInfo createElementInfo(Object element) throws CoreException {
        return new ElementInfo(this.createDocument(element));
    }

    protected void disposeElementInfo(Object element, ElementInfo info) {
    }

    protected void addUnchangedElementListeners(Object element, ElementInfo info) {
        if (info.fDocument != null) {
            info.fDocument.addDocumentListener(info);
        }
    }

    protected void removeUnchangedElementListeners(Object element, ElementInfo info) {
        if (info.fDocument != null) {
            info.fDocument.removeDocumentListener(info);
        }
    }

    protected Iterator getConnectedElements() {
        HashSet s = new HashSet();
        Set keys = this.fElementInfoMap.keySet();
        if (keys != null) {
            s.addAll(keys);
        }
        return s.iterator();
    }

    @Override
    public final void connect(Object element) throws CoreException {
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        if (info == null) {
            info = this.createElementInfo(element);
            if (info == null) {
                info = new ElementInfo(null);
            }
            info.fElement = element;
            this.addUnchangedElementListeners(element, info);
            this.fElementInfoMap.put(element, info);
            if (this.fElementInfoMap.size() == 1) {
                this.connected();
            }
        }
        ++info.fCount;
    }

    protected void connected() {
    }

    @Override
    public final void disconnect(Object element) {
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        if (info == null) {
            return;
        }
        if (info.fCount == 1) {
            this.fElementInfoMap.remove(element);
            this.removeUnchangedElementListeners(element, info);
            this.disposeElementInfo(element, info);
            if (this.fElementInfoMap.size() == 0) {
                this.disconnected();
            }
        } else {
            --info.fCount;
        }
    }

    protected void disconnected() {
    }

    @Override
    public IDocument getDocument(Object element) {
        if (element == null) {
            return null;
        }
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        return info != null ? info.fDocument : null;
    }

    @Override
    public boolean mustSaveDocument(Object element) {
        if (element == null) {
            return false;
        }
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        return info != null ? info.fCount == 1 && info.fCanBeSaved : false;
    }

    @Override
    public boolean canSaveDocument(Object element) {
        if (element == null) {
            return false;
        }
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        return info != null ? info.fCanBeSaved : false;
    }

    protected void doResetDocument(Object element, IProgressMonitor monitor) throws CoreException {
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        if (info != null) {
            IDocument original = null;
            IStatus status = null;
            try {
                original = this.createDocument(element);
            }
            catch (CoreException x) {
                status = x.getStatus();
            }
            info.fStatus = status;
            if (original != null) {
                this.fireElementContentAboutToBeReplaced(element);
                info.fDocument.setContent(original.getContent());
                if (info.fCanBeSaved) {
                    info.fCanBeSaved = false;
                    this.addUnchangedElementListeners(element, info);
                }
                this.fireElementContentReplaced(element);
                this.fireElementDirtyStateChanged(element, false);
            }
        }
    }

    protected void executeOperation(DocumentProviderOperation operation, IProgressMonitor monitor) throws CoreException {
        try {
            IRunnableContext runner = this.getOperationRunner(monitor);
            if (runner != null) {
                runner.run(false, false, (IRunnableWithProgress)operation);
            } else {
                operation.run(monitor);
            }
        }
        catch (InvocationTargetException x) {
            Throwable e = x.getTargetException();
            if (e instanceof CoreException) {
                throw (CoreException)e;
            }
            String message = e.getMessage() != null ? e.getMessage() : "";
            throw new CoreException((IStatus)new Status(4, EditorPlugin.getPluginId(), 4, message, e));
        }
        catch (InterruptedException x) {
            String message = x.getMessage() != null ? x.getMessage() : "";
            throw new CoreException((IStatus)new Status(8, EditorPlugin.getPluginId(), 0, message, (Throwable)x));
        }
    }

    @Override
    public final void resetDocument(Object element) throws CoreException {
        if (element == null) {
            return;
        }
        this.executeOperation(this.getResetOperation(element), this.getProgressMonitor());
    }

    public DocumentProviderOperation getResetOperation(Object element) {
        class ResetOperation
        extends DocumentProviderOperation
        implements ISchedulingRuleProvider {
            private final /* synthetic */ Object val$element;

            ResetOperation(Object object) {
                this.val$element = object;
            }

            @Override
            protected void execute(IProgressMonitor monitor) throws CoreException {
                AbstractDocumentProvider.this.doResetDocument(this.val$element, monitor);
            }

            @Override
            public ISchedulingRule getSchedulingRule() {
                return AbstractDocumentProvider.this.getResetRule(this.val$element);
            }
        }
        return new ResetOperation(element);
    }

    @Override
    public final void saveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element == null) {
            return;
        }
        this.executeOperation(this.getSaveOperation(element, document, overwrite), monitor);
    }

    public DocumentProviderOperation getSaveOperation(Object element, IDocument document, boolean overwrite) {
        class SaveOperation
        extends DocumentProviderOperation
        implements ISchedulingRuleProvider {
            private final /* synthetic */ Object val$element;
            private final /* synthetic */ IDocument val$document;
            private final /* synthetic */ boolean val$overwrite;

            SaveOperation(Object object, IDocument iDocument, boolean bl) {
                this.val$element = object;
                this.val$document = iDocument;
                this.val$overwrite = bl;
            }

            @Override
            protected void execute(IProgressMonitor pm) throws CoreException {
                ElementInfo info = (ElementInfo)AbstractDocumentProvider.this.fElementInfoMap.get(this.val$element);
                if (info != null) {
                    if (info.fDocument != this.val$document) {
                        Status status = new Status(2, EditorPlugin.getPluginId(), 4, EditorMessages.AbstractDocumentProvider_error_save_inuse, null);
                        throw new CoreException((IStatus)status);
                    }
                    AbstractDocumentProvider.this.doSaveDocument(pm, this.val$element, this.val$document, this.val$overwrite);
                    if (pm != null && pm.isCanceled()) {
                        return;
                    }
                    info.fCanBeSaved = false;
                    AbstractDocumentProvider.this.addUnchangedElementListeners(this.val$element, info);
                    AbstractDocumentProvider.this.fireElementDirtyStateChanged(this.val$element, false);
                } else {
                    AbstractDocumentProvider.this.doSaveDocument(pm, this.val$element, this.val$document, this.val$overwrite);
                }
            }

            @Override
            public ISchedulingRule getSchedulingRule() {
                return AbstractDocumentProvider.this.getSaveRule(this.val$element);
            }
        }
        return new SaveOperation(element, document, overwrite);
    }

    @Override
    public void aboutToChange(Object element) {
    }

    @Override
    public void changed(Object element) {
    }

    @Override
    public void addElementStateListener(IElementStateListener listener) {
        assert (listener != null);
        if (!this.fElementStateListeners.contains(listener)) {
            this.fElementStateListeners.add(listener);
        }
    }

    @Override
    public void removeElementStateListener(IElementStateListener listener) {
        assert (listener != null);
        this.fElementStateListeners.remove(listener);
    }

    protected void fireElementDirtyStateChanged(Object element, boolean isDirty) {
        for (IElementStateListener l : new ArrayList(this.fElementStateListeners)) {
            l.elementDirtyStateChanged(element, isDirty);
        }
    }

    protected void fireElementContentAboutToBeReplaced(Object element) {
        for (IElementStateListener l : new ArrayList(this.fElementStateListeners)) {
            l.elementContentAboutToBeReplaced(element);
        }
    }

    protected void fireElementContentReplaced(Object element) {
        for (IElementStateListener l : new ArrayList(this.fElementStateListeners)) {
            l.elementContentReplaced(element);
        }
    }

    protected void fireElementDeleted(Object element) {
        for (IElementStateListener l : new ArrayList(this.fElementStateListeners)) {
            l.elementDeleted(element);
        }
    }

    protected void fireElementMoved(Object originalElement, Object movedElement) {
        for (IElementStateListener l : new ArrayList(this.fElementStateListeners)) {
            l.elementMoved(originalElement, movedElement);
        }
    }

    @Override
    public long getModificationStamp(Object element) {
        return 0L;
    }

    @Override
    public long getSynchronizationStamp(Object element) {
        return 0L;
    }

    @Override
    public boolean isDeleted(Object element) {
        return false;
    }

    @Override
    public boolean isReadOnly(Object element) {
        return true;
    }

    @Override
    public boolean isModifiable(Object element) {
        return false;
    }

    @Override
    public boolean isStateValidated(Object element) {
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        if (info != null) {
            return info.fIsStateValidated;
        }
        return false;
    }

    protected void doValidateState(Object element, Object computationContext) throws CoreException {
    }

    @Override
    public void validateState(Object element, Object computationContext) throws CoreException {
        if (element == null) {
            return;
        }
        class ValidateStateOperation
        extends DocumentProviderOperation
        implements ISchedulingRuleProvider {
            private final /* synthetic */ Object val$element;
            private final /* synthetic */ Object val$computationContext;

            ValidateStateOperation(Object object, Object object2) {
                this.val$element = object;
                this.val$computationContext = object2;
            }

            @Override
            protected void execute(IProgressMonitor monitor) throws CoreException {
                ElementInfo info = (ElementInfo)AbstractDocumentProvider.this.fElementInfoMap.get(this.val$element);
                if (info == null) {
                    return;
                }
                AbstractDocumentProvider.this.doValidateState(this.val$element, this.val$computationContext);
                AbstractDocumentProvider.this.doUpdateStateCache(this.val$element);
                info.fIsStateValidated = true;
                AbstractDocumentProvider.this.fireElementStateValidationChanged(this.val$element, true);
            }

            @Override
            public ISchedulingRule getSchedulingRule() {
                return AbstractDocumentProvider.this.getValidateStateRule(this.val$element);
            }
        }
        this.executeOperation(new ValidateStateOperation(element, computationContext), this.getProgressMonitor());
    }

    protected void doUpdateStateCache(Object element) throws CoreException {
    }

    protected boolean invalidatesState(Object element, boolean wasReadOnly) {
        boolean readOnlyChanged = this.isReadOnly(element) != wasReadOnly && !wasReadOnly;
        return readOnlyChanged;
    }

    @Override
    public final void updateStateCache(Object element) throws CoreException {
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        if (info != null) {
            boolean wasReadOnly = this.isReadOnly(element);
            this.doUpdateStateCache(element);
            if (this.invalidatesState(element, wasReadOnly)) {
                info.fIsStateValidated = false;
                this.fireElementStateValidationChanged(element, false);
            }
        }
    }

    @Override
    public void setCanSaveDocument(Object element) {
        ElementInfo info;
        if (element != null && (info = (ElementInfo)this.fElementInfoMap.get(element)) != null) {
            info.fCanBeSaved = true;
            this.removeUnchangedElementListeners(element, info);
            this.fireElementDirtyStateChanged(element, info.fCanBeSaved);
        }
    }

    protected void fireElementStateValidationChanged(Object element, boolean isStateValidated) {
        for (Object o : new ArrayList(this.fElementStateListeners)) {
            if (!(o instanceof IElementStateListener)) continue;
            IElementStateListener l = (IElementStateListener)o;
            l.elementStateValidationChanged(element, isStateValidated);
        }
    }

    protected void fireElementStateChanging(Object element) {
        for (Object o : new ArrayList(this.fElementStateListeners)) {
            if (!(o instanceof IElementStateListener)) continue;
            IElementStateListener l = (IElementStateListener)o;
            l.elementStateChanging(element);
        }
    }

    protected void fireElementStateChangeFailed(Object element) {
        for (Object o : new ArrayList(this.fElementStateListeners)) {
            if (!(o instanceof IElementStateListener)) continue;
            IElementStateListener l = (IElementStateListener)o;
            l.elementStateChangeFailed(element);
        }
    }

    @Override
    public IStatus getStatus(Object element) {
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        if (info != null) {
            if (info.fStatus != null) {
                return info.fStatus;
            }
            return info.fDocument == null ? STATUS_ERROR : STATUS_OK;
        }
        return STATUS_ERROR;
    }

    protected void doSynchronize(Object element, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public final void synchronize(Object element) throws CoreException {
        if (element == null) {
            return;
        }
        class SynchronizeOperation
        extends DocumentProviderOperation
        implements ISchedulingRuleProvider {
            private final /* synthetic */ Object val$element;

            SynchronizeOperation(Object object) {
                this.val$element = object;
            }

            @Override
            protected void execute(IProgressMonitor monitor) throws CoreException {
                AbstractDocumentProvider.this.doSynchronize(this.val$element, monitor);
            }

            @Override
            public ISchedulingRule getSchedulingRule() {
                return AbstractDocumentProvider.this.getSynchronizeRule(this.val$element);
            }
        }
        this.executeOperation(new SynchronizeOperation(element), this.getProgressMonitor());
    }

    @Override
    public IProgressMonitor getProgressMonitor() {
        return this.fProgressMonitor == null ? new NullProgressMonitor() : this.fProgressMonitor;
    }

    @Override
    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.fProgressMonitor = progressMonitor;
    }

    @Override
    public boolean isSynchronized(Object element) {
        return true;
    }

    protected static abstract class DocumentProviderOperation
    implements IRunnableWithProgress {
        protected DocumentProviderOperation() {
        }

        protected abstract void execute(IProgressMonitor var1) throws CoreException;

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                this.execute(monitor);
            }
            catch (CoreException x) {
                throw new InvocationTargetException(x);
            }
        }
    }

    protected class ElementInfo
    implements IDocumentListener {
        public Object fElement;
        public int fCount;
        public boolean fCanBeSaved;
        public IDocument fDocument;
        public boolean fIsStateValidated;
        public IStatus fStatus;

        public ElementInfo(IDocument document) {
            this.fDocument = document;
            this.fCount = 0;
            this.fCanBeSaved = false;
            this.fIsStateValidated = false;
        }

        public boolean equals(Object o) {
            if (o instanceof ElementInfo) {
                ElementInfo e = (ElementInfo)o;
                return this.fDocument.equals(e.fDocument);
            }
            return false;
        }

        public int hashCode() {
            return this.fDocument.hashCode();
        }

        @Override
        public void documentChanged(DocumentEvent event) {
            this.fCanBeSaved = true;
            AbstractDocumentProvider.this.removeUnchangedElementListeners(this.fElement, this);
            AbstractDocumentProvider.this.fireElementDirtyStateChanged(this.fElement, this.fCanBeSaved);
        }

        @Override
        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    }
}

