/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import java.util.List;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TopGraphicEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ComponentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ContainerEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.PopupBarEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public abstract class ShapeEditPart
extends TopGraphicEditPart
implements IPrimaryEditPart {
    public ShapeEditPart(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new ContainerEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy());
        this.installEditPolicy("PopupBarEditPolicy", (EditPolicy)new PopupBarEditPolicy());
    }

    public final Point getLocation() {
        return this.getFigure().getBounds().getLocation();
    }

    public final Dimension getSize() {
        return this.getFigure().getBounds().getSize();
    }

    @Override
    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (NotationPackage.eINSTANCE.getSize_Width().equals(feature) || NotationPackage.eINSTANCE.getSize_Height().equals(feature) || NotationPackage.eINSTANCE.getLocation_X().equals(feature) || NotationPackage.eINSTANCE.getLocation_Y().equals(feature)) {
            this.refreshBounds();
        } else if (NotationPackage.eINSTANCE.getFillStyle_FillColor().equals(feature)) {
            Integer c = (Integer)notification.getNewValue();
            this.setBackgroundColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getLineStyle_LineColor().equals(feature)) {
            Integer c = (Integer)notification.getNewValue();
            this.setForegroundColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getFontStyle().getEAllAttributes().contains(feature)) {
            this.refreshFont();
        } else if (notification.getFeature() == NotationPackage.eINSTANCE.getView_Element() && (EObject)notification.getNotifier() == this.getNotationView()) {
            this.handleMajorSemanticChange();
        } else if (notification.getEventType() == 1003 && this.hasNotationView()) {
            String id2;
            String id1;
            EObject notifier = (EObject)notification.getNotifier();
            EObject viewElement = this.getNotationView().getElement();
            if (viewElement != null && (id1 = EMFCoreUtil.getProxyID((EObject)notifier)).equals(id2 = EMFCoreUtil.getProxyID((EObject)viewElement))) {
                this.handleMajorSemanticChange();
            }
        } else {
            super.handleNotificationEvent(notification);
        }
    }

    protected void refreshBounds() {
        int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        Dimension size = new Dimension(width, height);
        int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Point loc = new Point(x, y);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(loc, size));
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshBounds();
        this.refreshBackgroundColor();
        this.refreshForegroundColor();
        this.refreshFont();
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        EditPolicy policy = this.getEditPolicy("PrimaryDrag Policy");
        return policy != null ? policy : new ResizableShapeEditPolicy();
    }

    public EditPart getTargetEditPart(Request request) {
        if ("selection" == request.getType() && this.getParent() instanceof GroupEditPart) {
            if (this.getSelected() != 0) {
                return super.getTargetEditPart(request);
            }
            GroupEditPart groupEP = (GroupEditPart)this.getParent();
            if (this.getSelected() == 0 && request instanceof SelectionRequest && ((SelectionRequest)request).getLastButtonPressed() == 3) {
                return groupEP.getTargetEditPart(request);
            }
            if (groupEP.getSelected() != 0) {
                return super.getTargetEditPart(request);
            }
            for (EditPart childEP : groupEP.getChildren()) {
                if (childEP.getSelected() == 0) continue;
                return super.getTargetEditPart(request);
            }
            return groupEP.getTargetEditPart(request);
        }
        return super.getTargetEditPart(request);
    }

    protected static class ShapeContainerEditPolicy
    extends ContainerEditPolicy {
        @Override
        protected Command getArrangeCommand(ArrangeRequest request) {
            List parts;
            if (("arrangeSelectionAction".equals(request.getType()) || "toolbarArrangeSelectionAction".equals(request.getType())) && (parts = request.getPartsToArrange()).size() == 1 && parts.contains(this.getHost())) {
                CompoundCommand cc = new CompoundCommand();
                for (Object childEP : this.getHost().getChildren()) {
                    if (!(childEP instanceof CompartmentEditPart) || !(((CompartmentEditPart)childEP).getContentPane().getLayoutManager() instanceof XYLayout)) continue;
                    ArrangeRequest newRequest = this.createRequest(request, ((CompartmentEditPart)childEP).getChildren());
                    cc.add(super.getArrangeCommand(newRequest));
                }
                return cc;
            }
            return super.getArrangeCommand(request);
        }

        private ArrangeRequest createRequest(ArrangeRequest request, List partsToArrange) {
            ArrangeRequest newRequest = new ArrangeRequest((String)request.getType(), request.getLayoutType());
            newRequest.setExtendedData(request.getExtendedData());
            newRequest.setPartsToArrange(partsToArrange);
            return newRequest;
        }

        @Override
        public EditPart getTargetEditPart(Request request) {
            return this.understandsRequest(request) ? this.getHost() : null;
        }
    }
}

