/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.Filtering;
import org.eclipse.gmf.runtime.notation.FilteringStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Sorting;
import org.eclipse.gmf.runtime.notation.SortingDirection;
import org.eclipse.gmf.runtime.notation.SortingStyle;
import org.eclipse.gmf.runtime.notation.View;

public abstract class SemanticListCompartmentEditPart
extends ListCompartmentEditPart {
    public SemanticListCompartmentEditPart(EObject model) {
        super(model);
    }

    protected void refreshChildren() {
        GraphicalEditPart editPart;
        List modelObjects = this.getModelChildren();
        List _children = this.getChildren();
        if (modelObjects.size() == 0 && _children.size() == 0) {
            return;
        }
        HashMap<Object, GraphicalEditPart> modelToEditPart = new HashMap<Object, GraphicalEditPart>();
        int i = 0;
        while (i < _children.size()) {
            editPart = (GraphicalEditPart)_children.get(i);
            modelToEditPart.put(editPart.basicGetModel(), editPart);
            ++i;
        }
        i = 0;
        while (i < modelObjects.size()) {
            EObject element = (EObject)modelObjects.get(i);
            if (i >= _children.size() || ((GraphicalEditPart)_children.get(i)).basicGetModel() != element) {
                editPart = (GraphicalEditPart)modelToEditPart.get(element);
                if (editPart != null) {
                    this.reorderChild((EditPart)editPart, i);
                } else {
                    this.semanticChildAdded(element, i);
                }
            }
            ++i;
        }
        ArrayList trash = new ArrayList();
        while (i < _children.size()) {
            trash.add(_children.get(i));
            ++i;
        }
        i = 0;
        while (i < trash.size()) {
            EditPart ep = (EditPart)trash.get(i);
            this.removeChild(ep);
            ++i;
        }
    }

    protected void semanticChildRemoved(EObject child) {
        if (this.children == null) {
            return;
        }
        for (GraphicalEditPart ep : this.children) {
            if (!ep.basicGetModel().equals(child)) continue;
            this.removeChild((EditPart)ep);
            break;
        }
    }

    protected void refreshSemanticChildren() {
        if (!this.isCanonicalEnabled()) {
            return;
        }
        if (this.resolveSemanticElement() == null) {
            return;
        }
        List editPartsChildren = this.getChildren();
        List modelChildren = this.getModelChildren();
        if (editPartsChildren.size() == 0 && modelChildren.size() == 0) {
            return;
        }
        ArrayList semanticChildren = new ArrayList(modelChildren);
        for (GraphicalEditPart eP : editPartsChildren) {
            EObject semanticChild = (EObject)eP.basicGetModel();
            semanticChildren.remove(semanticChild);
        }
        if (!semanticChildren.isEmpty()) {
            for (EObject element : semanticChildren) {
                this.semanticChildAdded(element, -1);
            }
        }
    }

    @Override
    public void activate() {
        super.activate();
        this.refreshSemanticChildren();
    }

    protected abstract void semanticChildAdded(EObject var1, int var2);

    protected abstract List getSemanticChildrenList();

    @Override
    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (this.hasModelChildrenChanged(event)) {
            this.semanticChildrenListChanged(event);
        } else if (NotationPackage.eINSTANCE.getDrawerStyle_Collapsed() == feature || NotationPackage.eINSTANCE.getView_Visible() == feature && !event.getNewBooleanValue() || NotationPackage.eINSTANCE.getView_Visible() == feature && event.getNewBooleanValue()) {
            this.refreshSemanticChildren();
        }
        super.handleNotificationEvent(event);
    }

    protected void semanticChildrenListChanged(Notification event) {
        if (this.isCanonicalEnabled()) {
            if (NotificationUtil.isElementAddedToSlot((Notification)event) || NotificationUtil.isMove((Notification)event)) {
                this.refreshChildren();
            } else if (NotificationUtil.isElementRemovedFromSlot((Notification)event)) {
                if (event.getOldValue() instanceof Collection) {
                    for (EObject removedObject : (Collection)event.getOldValue()) {
                        this.semanticChildRemoved(removedObject);
                    }
                } else if (event.getOldValue() instanceof EObject) {
                    this.semanticChildRemoved((EObject)event.getOldValue());
                }
            }
        } else if (NotificationUtil.isElementRemovedFromSlot((Notification)event) && !this.getChildren().isEmpty()) {
            if (event.getOldValue() instanceof Collection) {
                for (EObject removedObject : (Collection)event.getOldValue()) {
                    this.semanticChildRemoved(removedObject);
                }
            } else if (event.getOldValue() instanceof EObject) {
                this.semanticChildRemoved((EObject)event.getOldValue());
            }
        }
    }

    protected boolean isCanonicalEnabled() {
        boolean isCollapsed;
        DrawerStyle dstyle = (DrawerStyle)((View)this.getModel()).getStyle(NotationPackage.Literals.DRAWER_STYLE);
        boolean bl = isCollapsed = dstyle == null ? false : dstyle.isCollapsed();
        if (isCollapsed) {
            return false;
        }
        return ((View)this.getModel()).isVisible();
    }

    public boolean isCanonicalOn() {
        return this.isCanonicalEnabled();
    }

    @Override
    protected List getSortedChildren() {
        SortingStyle style = (SortingStyle)((View)this.getModel()).getStyle(NotationPackage.eINSTANCE.getSortingStyle());
        if (style != null) {
            Sorting sorting = style.getSorting();
            if (Sorting.NONE_LITERAL == sorting) {
                return this.getSemanticChildrenList();
            }
            if (Sorting.MANUAL_LITERAL == sorting) {
                List allChildren = this.getSemanticChildrenList();
                if (allChildren.isEmpty()) {
                    return allChildren;
                }
                List sortedChildren = style.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getSortingStyle_SortedObjects()) ? style.getSortedObjects() : Collections.EMPTY_LIST;
                ArrayList<EObject> sorted = new ArrayList<EObject>();
                for (EObject eObject : sortedChildren) {
                    if (!allChildren.contains(eObject)) continue;
                    sorted.add(eObject);
                }
                int j = 0;
                while (j < allChildren.size()) {
                    EObject element = (EObject)allChildren.get(j);
                    if (!sorted.contains(element)) {
                        sorted.add(element);
                    }
                    ++j;
                }
                return sorted;
            }
            if (Sorting.AUTOMATIC_LITERAL == sorting) {
                Map sortingKeys = style.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getSortingStyle_SortingKeys()) ? style.getSortingKeys() : Collections.EMPTY_MAP;
                return this.getChildrenSortedBy(sortingKeys);
            }
        }
        return this.getSemanticChildrenList();
    }

    @Override
    protected List getChildrenSortedBy(Map sortingKeys) {
        SortingDirection direction;
        Set keySet;
        Iterator i;
        String name;
        Comparator comparator;
        ArrayList allChildren = new ArrayList(this.getSemanticChildrenList());
        if (sortingKeys != null && !sortingKeys.isEmpty() && (comparator = this.getComparator(name = (String)(i = (keySet = sortingKeys.keySet()).iterator()).next(), direction = (SortingDirection)sortingKeys.get(name))) != null) {
            Collections.sort(allChildren, this.getComparator(name, direction));
        }
        return allChildren;
    }

    @Override
    protected List getFilteredChildren() {
        View view;
        FilteringStyle style;
        Object model = this.getModel();
        if (model instanceof View && (style = (FilteringStyle)(view = (View)model).getStyle(NotationPackage.eINSTANCE.getFilteringStyle())) != null) {
            Filtering filtering = style.getFiltering();
            if (Filtering.NONE_LITERAL == filtering) {
                return Collections.EMPTY_LIST;
            }
            if (Filtering.MANUAL_LITERAL == filtering) {
                List filteredChildren = style.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getFilteringStyle_FilteredObjects()) ? style.getFilteredObjects() : Collections.EMPTY_LIST;
                return filteredChildren;
            }
            if (Filtering.AUTOMATIC_LITERAL == filtering) {
                List filteringKeys = style.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getFilteringStyle_FilteringKeys()) ? style.getFilteringKeys() : Collections.EMPTY_LIST;
                return this.getChildrenFilteredBy(filteringKeys);
            }
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }
}

