/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;

public class CommandUtilities {
    public static boolean canRedo(Command command) {
        if (command == null) {
            return false;
        }
        if (command instanceof IUndoableOperation) {
            return ((IUndoableOperation)command).canRedo();
        }
        if (command instanceof CompoundCommand) {
            Iterator iter = ((CompoundCommand)command).getCommands().iterator();
            while (iter.hasNext()) {
                try {
                    if (CommandUtilities.canRedo((Command)iter.next())) continue;
                    return false;
                }
                catch (ClassCastException e) {
                    return false;
                }
            }
            return true;
        }
        if (command instanceof ICommandProxy) {
            return ((ICommandProxy)command).getICommand().canRedo();
        }
        return command.canUndo();
    }

    public static Collection getAffectedFiles(Command command) {
        if (command == null) {
            return Collections.EMPTY_LIST;
        }
        if (command instanceof ICommand) {
            return ((ICommand)command).getAffectedFiles();
        }
        if (command instanceof ICommandProxy) {
            return ((ICommandProxy)command).getICommand().getAffectedFiles();
        }
        if (command instanceof CompoundCommand) {
            LinkedHashSet result = new LinkedHashSet();
            Iterator iter = ((CompoundCommand)command).getCommands().iterator();
            while (iter.hasNext()) {
                result.addAll(CommandUtilities.getAffectedFiles((Command)iter.next()));
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public static IStatus getMostSevereStatus(Command command) {
        CommandResult commandResult;
        IStatus status = null;
        ICommand iCommand = null;
        if (command instanceof CompoundCommand) {
            ArrayList<IStatus> statusList = new ArrayList<IStatus>(((CompoundCommand)command).size());
            for (Command nextCommand : ((CompoundCommand)command).getCommands()) {
                status = CommandUtilities.getMostSevereStatus(nextCommand);
                if (status == null) continue;
                statusList.add(status);
            }
            return CommandUtilities.aggregateStatuses(statusList);
        }
        if (command instanceof ICommand) {
            iCommand = (ICommand)command;
        } else if (command instanceof ICommandProxy) {
            iCommand = ((ICommandProxy)command).getICommand();
        }
        if (iCommand != null && (commandResult = iCommand.getCommandResult()) != null) {
            status = commandResult.getStatus();
        }
        return status;
    }

    protected static IStatus aggregateStatuses(List<IStatus> statuses) {
        IStatus result;
        if (statuses.isEmpty()) {
            result = null;
        } else if (statuses.size() == 1) {
            result = statuses.get(0);
        } else {
            IStatus[] statusArray = statuses.toArray(new IStatus[statuses.size()]);
            IStatus worst = statusArray[0];
            int i = 1;
            while (i < statusArray.length) {
                if (statusArray[i].getSeverity() > worst.getSeverity()) {
                    worst = statusArray[i];
                }
                ++i;
            }
            result = new MultiStatus(worst.getPlugin(), worst.getCode(), statusArray, worst.getMessage(), null);
        }
        return result;
    }
}

