/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.Map;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontReader;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.Typeface;

public class LazyFont
extends Typeface
implements FontDescriptor {
    private String metricsFileName = null;
    private String fontEmbedPath = null;
    private boolean useKerning = false;
    private boolean isMetricsLoaded = false;
    private Typeface realFont = null;
    private FontDescriptor realFontDescriptor = null;

    public LazyFont(String fontEmbedPath, String metricsFileName, boolean useKerning) {
        this.metricsFileName = metricsFileName;
        this.fontEmbedPath = fontEmbedPath;
        this.useKerning = useKerning;
    }

    private void load() {
        if (!this.isMetricsLoaded) {
            this.isMetricsLoaded = true;
            try {
                FontReader reader = new FontReader(this.metricsFileName);
                reader.setKerningEnabled(this.useKerning);
                reader.setFontEmbedPath(this.fontEmbedPath);
                this.realFont = reader.getFont();
                if (this.realFont instanceof FontDescriptor) {
                    this.realFontDescriptor = (FontDescriptor)((Object)this.realFont);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public Typeface getRealFont() {
        this.load();
        return this.realFont;
    }

    public String getEncoding() {
        this.load();
        return this.realFont.getEncoding();
    }

    public char mapChar(char c) {
        this.load();
        return this.realFont.mapChar(c);
    }

    public boolean hasChar(char c) {
        this.load();
        return this.realFont.hasChar(c);
    }

    public boolean isMultiByte() {
        return this.realFont.isMultiByte();
    }

    public String getFontName() {
        this.load();
        return this.realFont.getFontName();
    }

    public int getAscender(int size) {
        this.load();
        return this.realFont.getAscender(size);
    }

    public int getCapHeight(int size) {
        this.load();
        return this.realFont.getCapHeight(size);
    }

    public int getDescender(int size) {
        this.load();
        return this.realFont.getDescender(size);
    }

    public int getXHeight(int size) {
        this.load();
        return this.realFont.getXHeight(size);
    }

    public int getWidth(int i, int size) {
        this.load();
        return this.realFont.getWidth(i, size);
    }

    public int[] getWidths() {
        this.load();
        return this.realFont.getWidths();
    }

    public boolean hasKerningInfo() {
        this.load();
        return this.realFont.hasKerningInfo();
    }

    public Map getKerningInfo() {
        this.load();
        return this.realFont.getKerningInfo();
    }

    public int getCapHeight() {
        this.load();
        return this.realFontDescriptor.getCapHeight();
    }

    public int getDescender() {
        this.load();
        return this.realFontDescriptor.getDescender();
    }

    public int getAscender() {
        this.load();
        return this.realFontDescriptor.getAscender();
    }

    public int getFlags() {
        this.load();
        return this.realFontDescriptor.getFlags();
    }

    public int[] getFontBBox() {
        this.load();
        return this.realFontDescriptor.getFontBBox();
    }

    public int getItalicAngle() {
        this.load();
        return this.realFontDescriptor.getItalicAngle();
    }

    public int getStemV() {
        this.load();
        return this.realFontDescriptor.getStemV();
    }

    public FontType getFontType() {
        this.load();
        return this.realFontDescriptor.getFontType();
    }

    public boolean isEmbeddable() {
        this.load();
        return this.realFontDescriptor.isEmbeddable();
    }
}

