/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Font;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSFontFace;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.SVGFontFace;
import org.apache.batik.bridge.SVGFontFaceElementBridge;
import org.apache.batik.bridge.SVGFontFamily;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.apache.batik.gvt.font.AWTFontFamily;
import org.apache.batik.gvt.font.FontFamilyResolver;
import org.apache.batik.gvt.font.GVTFontFace;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public abstract class FontFace
extends GVTFontFace
implements ErrorConstants {
    List srcs;

    public FontFace(List list, String string, float f, String string2, String string3, String string4, String string5, float f2, String string6, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        super(string, f, string2, string3, string4, string5, f2, string6, f3, f4, f5, f6, f7, f8, f9, f10);
        this.srcs = list;
    }

    protected FontFace(String string) {
        super(string);
    }

    public static CSSFontFace createFontFace(String string, FontFace fontFace) {
        return new CSSFontFace(new LinkedList(fontFace.srcs), string, fontFace.unitsPerEm, fontFace.fontWeight, fontFace.fontStyle, fontFace.fontVariant, fontFace.fontStretch, fontFace.slope, fontFace.panose1, fontFace.ascent, fontFace.descent, fontFace.strikethroughPosition, fontFace.strikethroughThickness, fontFace.underlinePosition, fontFace.underlineThickness, fontFace.overlinePosition, fontFace.overlineThickness);
    }

    public GVTFontFamily getFontFamily(BridgeContext bridgeContext) {
        String string = FontFamilyResolver.lookup(this.familyName);
        if (string != null) {
            CSSFontFace cSSFontFace = FontFace.createFontFace(string, this);
            return new AWTFontFamily(cSSFontFace);
        }
        Iterator iterator = this.srcs.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object e = iterator.next();
            if (e instanceof String) {
                object = (String)e;
                string = FontFamilyResolver.lookup((String)object);
                if (string == null) continue;
                CSSFontFace cSSFontFace = FontFace.createFontFace((String)object, this);
                return new AWTFontFamily(cSSFontFace);
            }
            if (!(e instanceof ParsedURL)) continue;
            try {
                object = this.getFontFamily(bridgeContext, (ParsedURL)e);
                if (object == null) continue;
                return object;
            }
            catch (SecurityException securityException) {
                bridgeContext.getUserAgent().displayError(securityException);
            }
            catch (BridgeException bridgeException) {
                if (!"uri.unsecure".equals(bridgeException.getCode())) continue;
                bridgeContext.getUserAgent().displayError(bridgeException);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new AWTFontFamily(this);
    }

    protected GVTFontFamily getFontFamily(BridgeContext bridgeContext, ParsedURL parsedURL) {
        String string = parsedURL.toString();
        Element element = this.getBaseElement(bridgeContext);
        SVGDocument sVGDocument = (SVGDocument)element.getOwnerDocument();
        String string2 = sVGDocument.getURL();
        ParsedURL parsedURL2 = null;
        if (string2 != null) {
            parsedURL2 = new ParsedURL(string2);
        }
        String string3 = XMLBaseSupport.getCascadedXMLBase((Element)element);
        parsedURL = new ParsedURL(string3, string);
        UserAgent userAgent = bridgeContext.getUserAgent();
        try {
            userAgent.checkLoadExternalResource(parsedURL, parsedURL2);
        }
        catch (SecurityException securityException) {
            userAgent.displayError(securityException);
            return null;
        }
        if (parsedURL.getRef() != null) {
            Node node;
            Object object;
            Element element2 = bridgeContext.getReferencedElement(element, string);
            if (!element2.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !element2.getLocalName().equals("font")) {
                return null;
            }
            SVGDocument sVGDocument2 = (SVGDocument)element.getOwnerDocument();
            SVGDocument sVGDocument3 = (SVGDocument)element2.getOwnerDocument();
            Element element3 = element2;
            if (sVGDocument2 != sVGDocument3) {
                element3 = (Element)sVGDocument2.importNode(element2, true);
                object = XMLBaseSupport.getCascadedXMLBase((Element)element2);
                node = sVGDocument2.createElementNS("http://www.w3.org/2000/svg", "g");
                node.appendChild(element3);
                node.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:base", (String)object);
                CSSUtilities.computeStyleAndURIs(element2, element3, string);
            }
            object = null;
            node = element3.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.w3.org/2000/svg") && node.getLocalName().equals("font-face")) {
                    object = (Element)node;
                    break;
                }
                node = node.getNextSibling();
            }
            SVGFontFaceElementBridge sVGFontFaceElementBridge = (SVGFontFaceElementBridge)bridgeContext.getBridge("http://www.w3.org/2000/svg", "font-face");
            SVGFontFace sVGFontFace = sVGFontFaceElementBridge.createFontFace(bridgeContext, (Element)object);
            return new SVGFontFamily(sVGFontFace, element3, bridgeContext);
        }
        try {
            Font font = Font.createFont(0, parsedURL.openStream());
            return new AWTFontFamily(this, font);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Element getBaseElement(BridgeContext bridgeContext) {
        SVGDocument sVGDocument = (SVGDocument)bridgeContext.getDocument();
        return sVGDocument.getRootElement();
    }
}

