/******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation 
 ****************************************************************************/

package org.eclipse.gmf.runtime.diagram.ui.printing.render.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

/**
 * This class is used as the model in the MVC infrastructure required for databindings
 * used with the JPS dialog.
 *
 * @author Christian Damus (cdamus)
 * @author James Bruck (jbruck)
 */
abstract class PrintModelElement {
    protected final PropertyChangeSupport bean = new PropertyChangeSupport(this);
    
    public PrintModelElement() {
        super();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        bean.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName,
            PropertyChangeListener listener) {
        bean.addPropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return bean.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(
            String propertyName) {
        return bean.getPropertyChangeListeners(propertyName);
    }

    public boolean hasListeners(String propertyName) {
        return bean.hasListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        bean.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName,
            PropertyChangeListener listener) {
        bean.removePropertyChangeListener(propertyName, listener);
    }
    
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        bean.firePropertyChange(propertyName, oldValue, newValue);
    }
    
    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        bean.firePropertyChange(propertyName, oldValue, newValue);
    }
    
    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        bean.firePropertyChange(propertyName, oldValue, newValue);
    }
}
