/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.CompositeRule;
import org.apache.batik.ext.awt.image.GraphicsUtil;

public class SVGComposite
implements Composite {
    public static final SVGComposite OVER = new SVGComposite(CompositeRule.OVER);
    public static final SVGComposite IN = new SVGComposite(CompositeRule.IN);
    public static final SVGComposite OUT = new SVGComposite(CompositeRule.OUT);
    public static final SVGComposite ATOP = new SVGComposite(CompositeRule.ATOP);
    public static final SVGComposite XOR = new SVGComposite(CompositeRule.XOR);
    public static final SVGComposite MULTIPLY = new SVGComposite(CompositeRule.MULTIPLY);
    public static final SVGComposite SCREEN = new SVGComposite(CompositeRule.SCREEN);
    public static final SVGComposite DARKEN = new SVGComposite(CompositeRule.DARKEN);
    public static final SVGComposite LIGHTEN = new SVGComposite(CompositeRule.LIGHTEN);
    CompositeRule rule;

    public CompositeRule getRule() {
        return this.rule;
    }

    public SVGComposite(CompositeRule compositeRule) {
        this.rule = compositeRule;
    }

    public boolean equals(Object object) {
        if (object instanceof SVGComposite) {
            SVGComposite sVGComposite = (SVGComposite)object;
            return sVGComposite.getRule() == this.getRule();
        }
        if (object instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)object;
            switch (this.getRule().getRule()) {
                case 1: {
                    return alphaComposite == AlphaComposite.SrcOver;
                }
                case 2: {
                    return alphaComposite == AlphaComposite.SrcIn;
                }
                case 3: {
                    return alphaComposite == AlphaComposite.SrcOut;
                }
            }
            return false;
        }
        return false;
    }

    public boolean is_INT_PACK(ColorModel colorModel) {
        if (!(colorModel instanceof PackedColorModel)) {
            return false;
        }
        PackedColorModel packedColorModel = (PackedColorModel)colorModel;
        int[] nArray = packedColorModel.getMasks();
        if (nArray.length != 4) {
            return false;
        }
        if (nArray[0] != 0xFF0000) {
            return false;
        }
        if (nArray[1] != 65280) {
            return false;
        }
        if (nArray[2] != 255) {
            return false;
        }
        return nArray[3] == -16777216;
    }

    public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
        boolean bl = this.is_INT_PACK(colorModel) && this.is_INT_PACK(colorModel2);
        switch (this.rule.getRule()) {
            case 1: {
                if (!colorModel2.hasAlpha()) {
                    if (bl) {
                        return new OverCompositeContext_INT_PACK_NA(colorModel, colorModel2);
                    }
                    return new OverCompositeContext_NA(colorModel, colorModel2);
                }
                if (!bl) {
                    return new OverCompositeContext(colorModel, colorModel2);
                }
                if (colorModel.isAlphaPremultiplied()) {
                    return new OverCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new OverCompositeContext_INT_PACK_UNPRE(colorModel, colorModel2);
            }
            case 2: {
                if (bl) {
                    return new InCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new InCompositeContext(colorModel, colorModel2);
            }
            case 3: {
                if (bl) {
                    return new OutCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new OutCompositeContext(colorModel, colorModel2);
            }
            case 4: {
                if (bl) {
                    return new AtopCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new AtopCompositeContext(colorModel, colorModel2);
            }
            case 5: {
                if (bl) {
                    return new XorCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new XorCompositeContext(colorModel, colorModel2);
            }
            case 6: {
                float[] fArray = this.rule.getCoefficients();
                if (bl) {
                    return new ArithCompositeContext_INT_PACK_LUT(colorModel, colorModel2, fArray[0], fArray[1], fArray[2], fArray[3]);
                }
                return new ArithCompositeContext(colorModel, colorModel2, fArray[0], fArray[1], fArray[2], fArray[3]);
            }
            case 7: {
                if (bl) {
                    return new MultiplyCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new MultiplyCompositeContext(colorModel, colorModel2);
            }
            case 8: {
                if (bl) {
                    return new ScreenCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new ScreenCompositeContext(colorModel, colorModel2);
            }
            case 9: {
                if (bl) {
                    return new DarkenCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new DarkenCompositeContext(colorModel, colorModel2);
            }
            case 10: {
                if (bl) {
                    return new LightenCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new LightenCompositeContext(colorModel, colorModel2);
            }
        }
        throw new UnsupportedOperationException("Unknown composite rule requested.");
    }

    public static abstract class AlphaPreCompositeContext
    implements CompositeContext {
        ColorModel srcCM;
        ColorModel dstCM;

        AlphaPreCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            this.srcCM = colorModel;
            this.dstCM = colorModel2;
        }

        public void dispose() {
            this.srcCM = null;
            this.dstCM = null;
        }

        protected abstract void precompose(Raster var1, Raster var2, WritableRaster var3);

        public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            ColorModel colorModel = this.srcCM;
            if (!this.srcCM.isAlphaPremultiplied()) {
                colorModel = GraphicsUtil.coerceData((WritableRaster)raster, this.srcCM, true);
            }
            ColorModel colorModel2 = this.dstCM;
            if (!this.dstCM.isAlphaPremultiplied()) {
                colorModel2 = GraphicsUtil.coerceData((WritableRaster)raster2, this.dstCM, true);
            }
            this.precompose(raster, raster2, writableRaster);
            if (!this.srcCM.isAlphaPremultiplied()) {
                GraphicsUtil.coerceData((WritableRaster)raster, colorModel, false);
            }
            if (!this.dstCM.isAlphaPremultiplied()) {
                GraphicsUtil.coerceData(writableRaster, colorModel2, false);
                if (raster2 != writableRaster) {
                    GraphicsUtil.coerceData((WritableRaster)raster2, colorModel2, false);
                }
            }
        }
    }

    public static abstract class AlphaPreCompositeContext_INT_PACK
    extends AlphaPreCompositeContext {
        AlphaPreCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        protected abstract void precompose_INT_PACK(int var1, int var2, int[] var3, int var4, int var5, int[] var6, int var7, int var8, int[] var9, int var10, int var11);

        protected void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = writableRaster.getHeight();
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
            int n5 = singlePixelPackedSampleModel.getScanlineStride();
            DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
            int[] nArray = dataBufferInt.getBankData()[0];
            int n6 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n - raster.getSampleModelTranslateX(), n3 - raster.getSampleModelTranslateY());
            SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)raster2.getSampleModel();
            int n7 = singlePixelPackedSampleModel2.getScanlineStride();
            DataBufferInt dataBufferInt2 = (DataBufferInt)raster2.getDataBuffer();
            int[] nArray2 = dataBufferInt2.getBankData()[0];
            int n8 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(n - raster2.getSampleModelTranslateX(), n3 - raster2.getSampleModelTranslateY());
            SinglePixelPackedSampleModel singlePixelPackedSampleModel3 = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
            int n9 = singlePixelPackedSampleModel3.getScanlineStride();
            DataBufferInt dataBufferInt3 = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray3 = dataBufferInt3.getBankData()[0];
            int n10 = dataBufferInt3.getOffset() + singlePixelPackedSampleModel3.getOffset(n - writableRaster.getSampleModelTranslateX(), n3 - writableRaster.getSampleModelTranslateY());
            int n11 = n5 - n2;
            int n12 = n7 - n2;
            int n13 = n9 - n2;
            this.precompose_INT_PACK(n2, n4, nArray, n11, n6, nArray2, n12, n8, nArray3, n13, n10);
        }
    }

    public static class ArithCompositeContext
    extends AlphaPreCompositeContext {
        float k1;
        float k2;
        float k3;
        float k4;

        ArithCompositeContext(ColorModel colorModel, ColorModel colorModel2, float f, float f2, float f3, float f4) {
            super(colorModel, colorModel2);
            this.k1 = f;
            this.k2 = f2;
            this.k3 = f3;
            this.k4 = f4;
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getNumBands();
            int n4 = writableRaster.getMinY();
            int n5 = n4 + writableRaster.getHeight();
            float f = this.k1 / 255.0f;
            float f2 = this.k4 * 255.0f + 0.5f;
            int n6 = n4;
            while (n6 < n5) {
                nArray = raster.getPixels(n, n6, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n6, n2, 1, nArray2);
                int n7 = 0;
                while (n7 < nArray.length) {
                    int n8;
                    int n9 = 0;
                    int n10 = 1;
                    while (n10 < n3) {
                        n8 = (int)(f * (float)nArray[n7] * (float)nArray2[n7] + this.k2 * (float)nArray[n7] + this.k3 * (float)nArray2[n7] + f2);
                        if ((n8 & 0xFFFFFF00) != 0) {
                            n8 = (n8 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                        }
                        if (n8 > n9) {
                            n9 = n8;
                        }
                        nArray2[n7] = n8;
                        ++n10;
                        ++n7;
                    }
                    n8 = (int)(f * (float)nArray[n7] * (float)nArray2[n7] + this.k2 * (float)nArray[n7] + this.k3 * (float)nArray2[n7] + f2);
                    if ((n8 & 0xFFFFFF00) != 0) {
                        n8 = (n8 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    nArray2[n7] = n8 > n9 ? n8 : n9;
                    ++n7;
                }
                writableRaster.setPixels(n, n6, n2, 1, nArray2);
                ++n6;
            }
        }
    }

    public static class ArithCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        float k1;
        float k2;
        float k3;
        float k4;

        ArithCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2, float f, float f2, float f3, float f4) {
            super(colorModel, colorModel2);
            this.k1 = f / 255.0f;
            this.k2 = f2;
            this.k3 = f3;
            this.k4 = f4 * 255.0f + 0.5f;
        }

        public void precompose_INT_PACK(int n, int n2, int[] nArray, int n3, int n4, int[] nArray2, int n5, int n6, int[] nArray3, int n7, int n8) {
            int n9 = 0;
            while (n9 < n2) {
                int n10 = n8 + n;
                while (n8 < n10) {
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    if (((n16 = (int)((float)(((n15 = nArray[n4++]) >>> 24) * ((n14 = nArray2[n6++]) >>> 24)) * this.k1 + (float)(n15 >>> 24) * this.k2 + (float)(n14 >>> 24) * this.k3 + this.k4)) & 0xFFFFFF00) != 0) {
                        n16 = (n16 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if (((n13 = (int)((float)((n15 >> 16 & 0xFF) * (n14 >> 16 & 0xFF)) * this.k1 + (float)(n15 >> 16 & 0xFF) * this.k2 + (float)(n14 >> 16 & 0xFF) * this.k3 + this.k4)) & 0xFFFFFF00) != 0) {
                        n13 = (n13 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if (n16 < n13) {
                        n16 = n13;
                    }
                    if (((n12 = (int)((float)((n15 >> 8 & 0xFF) * (n14 >> 8 & 0xFF)) * this.k1 + (float)(n15 >> 8 & 0xFF) * this.k2 + (float)(n14 >> 8 & 0xFF) * this.k3 + this.k4)) & 0xFFFFFF00) != 0) {
                        n12 = (n12 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if (n16 < n12) {
                        n16 = n12;
                    }
                    if (((n11 = (int)((float)((n15 & 0xFF) * (n14 & 0xFF)) * this.k1 + (float)(n15 & 0xFF) * this.k2 + (float)(n14 & 0xFF) * this.k3 + this.k4)) & 0xFFFFFF00) != 0) {
                        n11 = (n11 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if (n16 < n11) {
                        n16 = n11;
                    }
                    nArray3[n8++] = n16 << 24 | n13 << 16 | n12 << 8 | n11;
                }
                n4 += n3;
                n6 += n5;
                n8 += n7;
                ++n9;
            }
        }
    }

    public static class ArithCompositeContext_INT_PACK_LUT
    extends AlphaPreCompositeContext_INT_PACK {
        byte[] lut;

        ArithCompositeContext_INT_PACK_LUT(ColorModel colorModel, ColorModel colorModel2, float f, float f2, float f3, float f4) {
            super(colorModel, colorModel2);
            f /= 255.0f;
            f4 = f4 * 255.0f + 0.5f;
            int n = 65536;
            this.lut = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = (int)((float)((n2 >> 8) * (n2 & 0xFF)) * f + (float)(n2 >> 8) * f2 + (float)(n2 & 0xFF) * f3 + f4);
                if ((n3 & 0xFFFFFF00) != 0) {
                    n3 = (n3 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                this.lut[n2] = (byte)n3;
                ++n2;
            }
        }

        public void precompose_INT_PACK(int n, int n2, int[] nArray, int n3, int n4, int[] nArray2, int n5, int n6, int[] nArray3, int n7, int n8) {
            int n9 = 0;
            while (n9 < n2) {
                int n10 = n8 + n;
                while (n8 < n10) {
                    int n11 = nArray[n4++];
                    int n12 = nArray2[n6++];
                    int n13 = this.lut[n11 >> 16 & 0xFF00 | n12 >>> 24];
                    n13 &= 0xFF;
                    int n14 = this.lut[n11 >> 8 & 0xFF00 | n12 >> 16 & 0xFF];
                    int n15 = this.lut[n11 & 0xFF00 | n12 >> 8 & 0xFF];
                    n15 &= 0xFF;
                    int n16 = this.lut[n11 << 8 & 0xFF00 | n12 & 0xFF];
                    n16 &= 0xFF;
                    if ((n14 &= 0xFF) > n13) {
                        n13 = n14;
                    }
                    if (n15 > n13) {
                        n13 = n15;
                    }
                    if (n16 > n13) {
                        n13 = n16;
                    }
                    nArray3[n8++] = n13 << 24 | n14 << 16 | n15 << 8 | n16;
                }
                n4 += n3;
                n6 += n5;
                n8 += n7;
                ++n9;
            }
        }
    }

    public static class AtopCompositeContext
    extends AlphaPreCompositeContext {
        AtopCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    int n8 = nArray2[n6 + 3] * 65793;
                    int n9 = (255 - nArray[n6 + 3]) * 65793;
                    nArray2[n6] = nArray[n6] * n8 + nArray2[n6] * n9 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + nArray2[n6] * n9 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + nArray2[n6] * n9 + 0x800000 >>> 24;
                    n6 += 2;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class AtopCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        AtopCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose_INT_PACK(int n, int n2, int[] nArray, int n3, int n4, int[] nArray2, int n5, int n6, int[] nArray3, int n7, int n8) {
            int n9 = 0;
            while (n9 < n2) {
                int n10 = n8 + n;
                while (n8 < n10) {
                    int n11 = nArray[n4++];
                    int n12 = nArray2[n6++];
                    int n13 = (n12 >>> 24) * 65793;
                    int n14 = (255 - (n11 >>> 24)) * 65793;
                    nArray3[n8++] = n12 & 0xFF000000 | ((n11 >> 16 & 0xFF) * n13 + (n12 >> 16 & 0xFF) * n14 + 0x800000 & 0xFF000000) >>> 8 | ((n11 >> 8 & 0xFF) * n13 + (n12 >> 8 & 0xFF) * n14 + 0x800000 & 0xFF000000) >>> 16 | (n11 & 0xFF) * n13 + (n12 & 0xFF) * n14 + 0x800000 >>> 24;
                }
                n4 += n3;
                n6 += n5;
                n8 += n7;
                ++n9;
            }
        }
    }

    public static class DarkenCompositeContext
    extends AlphaPreCompositeContext {
        DarkenCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    int n8 = 255 - nArray2[n6 + 3];
                    int n9 = (n8 * nArray[n6] * 65793 + 0x800000 >>> 24) + nArray2[n6];
                    int n10 = 255 - nArray[n6 + 3];
                    int n11 = (n10 * nArray2[n6] * 65793 + 0x800000 >>> 24) + nArray[n6];
                    nArray2[n6] = n9 > n11 ? n11 : n9;
                    n9 = (n8 * nArray[++n6] * 65793 + 0x800000 >>> 24) + nArray2[n6];
                    n11 = (n10 * nArray2[n6] * 65793 + 0x800000 >>> 24) + nArray[n6];
                    nArray2[n6] = n9 > n11 ? n11 : n9;
                    n9 = (n8 * nArray[++n6] * 65793 + 0x800000 >>> 24) + nArray2[n6];
                    n11 = (n10 * nArray2[n6] * 65793 + 0x800000 >>> 24) + nArray[n6];
                    nArray2[n6] = n9 > n11 ? n11 : n9;
                    nArray2[++n6] = nArray[n6] + nArray2[n6] - (nArray2[n6] * nArray[n6] * 65793 + 0x800000 >>> 24);
                    ++n6;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class DarkenCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        DarkenCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose_INT_PACK(int n, int n2, int[] nArray, int n3, int n4, int[] nArray2, int n5, int n6, int[] nArray3, int n7, int n8) {
            int n9 = 0;
            while (n9 < n2) {
                int n10 = n8 + n;
                while (n8 < n10) {
                    int n11;
                    int n12;
                    int n13 = nArray[n4++];
                    int n14 = nArray2[n6++];
                    int n15 = n13 >>> 24;
                    int n16 = n14 >>> 24;
                    int n17 = (255 - n16) * 65793;
                    int n18 = (255 - n15) * 65793;
                    int n19 = n15 + n16 - (n15 * n16 * 65793 + 0x800000 >>> 24);
                    n15 = n13 >> 16 & 0xFF;
                    n16 = n14 >> 16 & 0xFF;
                    int n20 = (n17 * n15 + 0x800000 >>> 24) + n16;
                    int n21 = (n18 * n16 + 0x800000 >>> 24) + n15;
                    if (n20 > n21) {
                        n20 = n21;
                    }
                    if ((n12 = (n17 * (n15 = n13 >> 8 & 0xFF) + 0x800000 >>> 24) + (n16 = n14 >> 8 & 0xFF)) > (n21 = (n18 * n16 + 0x800000 >>> 24) + n15)) {
                        n12 = n21;
                    }
                    if ((n11 = (n17 * (n15 = n13 & 0xFF) + 0x800000 >>> 24) + (n16 = n14 & 0xFF)) > (n21 = (n18 * n16 + 0x800000 >>> 24) + n15)) {
                        n11 = n21;
                    }
                    nArray3[n8++] = n19 << 24 | n20 << 16 | n12 << 8 | n11;
                }
                n4 += n3;
                n6 += n5;
                n8 += n7;
                ++n9;
            }
        }
    }

    public static class InCompositeContext
    extends AlphaPreCompositeContext {
        InCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    int n8 = nArray2[n6 + 3] * 65793;
                    nArray2[n6] = nArray[n6] * n8 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + 0x800000 >>> 24;
                    ++n6;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class InCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        InCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose_INT_PACK(int n, int n2, int[] nArray, int n3, int n4, int[] nArray2, int n5, int n6, int[] nArray3, int n7, int n8) {
            int n9 = 0;
            while (n9 < n2) {
                int n10 = n8 + n;
                while (n8 < n10) {
                    int n11 = (nArray2[n6++] >>> 24) * 65793;
                    int n12 = nArray[n4++];
                    nArray3[n8++] = (n12 >>> 24) * n11 + 0x800000 & 0xFF000000 | ((n12 >> 16 & 0xFF) * n11 + 0x800000 & 0xFF000000) >>> 8 | ((n12 >> 8 & 0xFF) * n11 + 0x800000 & 0xFF000000) >>> 16 | (n12 & 0xFF) * n11 + 0x800000 >>> 24;
                }
                n4 += n3;
                n6 += n5;
                n8 += n7;
                ++n9;
            }
        }
    }

    public static class LightenCompositeContext
    extends AlphaPreCompositeContext {
        LightenCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    int n8 = 255 - nArray2[n6 + 3];
                    int n9 = (n8 * nArray[n6] * 65793 + 0x800000 >>> 24) + nArray2[n6];
                    int n10 = 255 - nArray[n6 + 3];
                    int n11 = (n10 * nArray2[n6] * 65793 + 0x800000 >>> 24) + nArray[n6];
                    nArray2[n6] = n9 > n11 ? n9 : n11;
                    n9 = (n8 * nArray[++n6] * 65793 + 0x800000 >>> 24) + nArray2[n6];
                    n11 = (n10 * nArray2[n6] * 65793 + 0x800000 >>> 24) + nArray[n6];
                    nArray2[n6] = n9 > n11 ? n9 : n11;
                    n9 = (n8 * nArray[++n6] * 65793 + 0x800000 >>> 24) + nArray2[n6];
                    n11 = (n10 * nArray2[n6] * 65793 + 0x800000 >>> 24) + nArray[n6];
                    nArray2[n6] = n9 > n11 ? n9 : n11;
                    nArray2[++n6] = nArray[n6] + nArray2[n6] - (nArray2[n6] * nArray[n6] * 65793 + 0x800000 >>> 24);
                    ++n6;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class LightenCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        LightenCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose_INT_PACK(int n, int n2, int[] nArray, int n3, int n4, int[] nArray2, int n5, int n6, int[] nArray3, int n7, int n8) {
            int n9 = 0;
            while (n9 < n2) {
                int n10 = n8 + n;
                while (n8 < n10) {
                    int n11;
                    int n12;
                    int n13 = nArray[n4++];
                    int n14 = nArray2[n6++];
                    int n15 = n13 >>> 24;
                    int n16 = n14 >>> 24;
                    int n17 = (255 - n16) * 65793;
                    int n18 = (255 - n15) * 65793;
                    int n19 = n15 + n16 - (n15 * n16 * 65793 + 0x800000 >>> 24);
                    n15 = n13 >> 16 & 0xFF;
                    n16 = n14 >> 16 & 0xFF;
                    int n20 = (n17 * n15 + 0x800000 >>> 24) + n16;
                    int n21 = (n18 * n16 + 0x800000 >>> 24) + n15;
                    if (n20 < n21) {
                        n20 = n21;
                    }
                    if ((n12 = (n17 * (n15 = n13 >> 8 & 0xFF) + 0x800000 >>> 24) + (n16 = n14 >> 8 & 0xFF)) < (n21 = (n18 * n16 + 0x800000 >>> 24) + n15)) {
                        n12 = n21;
                    }
                    if ((n11 = (n17 * (n15 = n13 & 0xFF) + 0x800000 >>> 24) + (n16 = n14 & 0xFF)) < (n21 = (n18 * n16 + 0x800000 >>> 24) + n15)) {
                        n11 = n21;
                    }
                    nArray3[n8++] = n19 << 24 | n20 << 16 | n12 << 8 | n11;
                }
                n4 += n3;
                n6 += n5;
                n8 += n7;
                ++n9;
            }
        }
    }

    public static class MultiplyCompositeContext
    extends AlphaPreCompositeContext {
        MultiplyCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    int n8 = 255 - nArray2[n6 + 3];
                    int n9 = 255 - nArray[n6 + 3];
                    nArray2[n6] = (nArray[n6] * n8 + nArray2[n6] * n9 + nArray[n6] * nArray2[n6]) * 65793 + 0x800000 >>> 24;
                    nArray2[++n6] = (nArray[n6] * n8 + nArray2[n6] * n9 + nArray[n6] * nArray2[n6]) * 65793 + 0x800000 >>> 24;
                    nArray2[++n6] = (nArray[n6] * n8 + nArray2[n6] * n9 + nArray[n6] * nArray2[n6]) * 65793 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] + nArray2[n6] - (nArray2[n6] * nArray[n6] * 65793 + 0x800000 >>> 24);
                    ++n6;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class MultiplyCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        MultiplyCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose_INT_PACK(int n, int n2, int[] nArray, int n3, int n4, int[] nArray2, int n5, int n6, int[] nArray3, int n7, int n8) {
            int n9 = 0;
            while (n9 < n2) {
                int n10 = n8 + n;
                while (n8 < n10) {
                    int n11 = nArray[n4++];
                    int n12 = nArray2[n6++];
                    int n13 = n11 >>> 24;
                    int n14 = n12 >>> 24;
                    int n15 = n11 >> 16 & 0xFF;
                    int n16 = n12 >> 16 & 0xFF;
                    int n17 = n11 >> 8 & 0xFF;
                    int n18 = n12 >> 8 & 0xFF;
                    int n19 = n11 & 0xFF;
                    int n20 = n12 & 0xFF;
                    int n21 = 255 - n14;
                    int n22 = 255 - n13;
                    nArray3[n8++] = ((n15 * n21 + n16 * n22 + n15 * n16) * 65793 + 0x800000 & 0xFF000000) >>> 8 | ((n17 * n21 + n18 * n22 + n17 * n18) * 65793 + 0x800000 & 0xFF000000) >>> 16 | (n19 * n21 + n20 * n22 + n19 * n20) * 65793 + 0x800000 >>> 24 | n13 + n14 - (n13 * n14 * 65793 + 0x800000 >>> 24) << 24;
                }
                n4 += n3;
                n6 += n5;
                n8 += n7;
                ++n9;
            }
        }
    }

    public static class OutCompositeContext
    extends AlphaPreCompositeContext {
        OutCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    int n8 = (255 - nArray2[n6 + 3]) * 65793;
                    nArray2[n6] = nArray[n6] * n8 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + 0x800000 >>> 24;
                    ++n6;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class OutCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        OutCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose_INT_PACK(int n, int n2, int[] nArray, int n3, int n4, int[] nArray2, int n5, int n6, int[] nArray3, int n7, int n8) {
            int n9 = 0;
            while (n9 < n2) {
                int n10 = n8 + n;
                while (n8 < n10) {
                    int n11 = (255 - (nArray2[n6++] >>> 24)) * 65793;
                    int n12 = nArray[n4++];
                    nArray3[n8++] = (n12 >>> 24) * n11 + 0x800000 & 0xFF000000 | ((n12 >> 16 & 0xFF) * n11 + 0x800000 & 0xFF000000) >>> 8 | ((n12 >> 8 & 0xFF) * n11 + 0x800000 & 0xFF000000) >>> 16 | (n12 & 0xFF) * n11 + 0x800000 >>> 24;
                }
                n4 += n3;
                n6 += n5;
                n8 += n7;
                ++n9;
            }
        }
    }

    public static class OverCompositeContext
    extends AlphaPreCompositeContext {
        OverCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    int n8 = (255 - nArray[n6 + 3]) * 65793;
                    nArray2[n6] = nArray[n6] + (nArray2[n6] * n8 + 0x800000 >>> 24);
                    nArray2[++n6] = nArray[n6] + (nArray2[n6] * n8 + 0x800000 >>> 24);
                    nArray2[++n6] = nArray[n6] + (nArray2[n6] * n8 + 0x800000 >>> 24);
                    nArray2[++n6] = nArray[n6] + (nArray2[n6] * n8 + 0x800000 >>> 24);
                    ++n6;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class OverCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        OverCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose_INT_PACK(int n, int n2, int[] nArray, int n3, int n4, int[] nArray2, int n5, int n6, int[] nArray3, int n7, int n8) {
            int n9 = 0;
            while (n9 < n2) {
                int n10 = n8 + n;
                while (n8 < n10) {
                    int n11 = nArray[n4++];
                    int n12 = nArray2[n6++];
                    int n13 = (255 - (n11 >>> 24)) * 65793;
                    nArray3[n8++] = (n11 & 0xFF000000) + ((n12 >>> 24) * n13 + 0x800000 & 0xFF000000) | (n11 & 0xFF0000) + (((n12 >> 16 & 0xFF) * n13 + 0x800000 & 0xFF000000) >>> 8) | (n11 & 0xFF00) + (((n12 >> 8 & 0xFF) * n13 + 0x800000 & 0xFF000000) >>> 16) | (n11 & 0xFF) + ((n12 & 0xFF) * n13 + 0x800000 >>> 24);
                }
                n4 += n3;
                n6 += n5;
                n8 += n7;
                ++n9;
            }
        }
    }

    public static class OverCompositeContext_INT_PACK_NA
    extends AlphaPreCompositeContext_INT_PACK {
        OverCompositeContext_INT_PACK_NA(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose_INT_PACK(int n, int n2, int[] nArray, int n3, int n4, int[] nArray2, int n5, int n6, int[] nArray3, int n7, int n8) {
            int n9 = 0;
            while (n9 < n2) {
                int n10 = n8 + n;
                while (n8 < n10) {
                    int n11 = nArray[n4++];
                    int n12 = nArray2[n6++];
                    int n13 = (255 - (n11 >>> 24)) * 65793;
                    nArray3[n8++] = (n11 & 0xFF0000) + (((n12 >> 16 & 0xFF) * n13 + 0x800000 & 0xFF000000) >>> 8) | (n11 & 0xFF00) + (((n12 >> 8 & 0xFF) * n13 + 0x800000 & 0xFF000000) >>> 16) | (n11 & 0xFF) + ((n12 & 0xFF) * n13 + 0x800000 >>> 24);
                }
                n4 += n3;
                n6 += n5;
                n8 += n7;
                ++n9;
            }
        }
    }

    public static class OverCompositeContext_INT_PACK_UNPRE
    extends AlphaPreCompositeContext_INT_PACK {
        OverCompositeContext_INT_PACK_UNPRE(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
            if (colorModel.isAlphaPremultiplied()) {
                throw new IllegalArgumentException("OverCompositeContext_INT_PACK_UNPRE is only forsources with unpremultiplied alpha");
            }
        }

        public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            ColorModel colorModel = this.dstCM;
            if (!this.dstCM.isAlphaPremultiplied()) {
                colorModel = GraphicsUtil.coerceData((WritableRaster)raster2, this.dstCM, true);
            }
            this.precompose(raster, raster2, writableRaster);
            if (!this.dstCM.isAlphaPremultiplied()) {
                GraphicsUtil.coerceData(writableRaster, colorModel, false);
                if (raster2 != writableRaster) {
                    GraphicsUtil.coerceData((WritableRaster)raster2, colorModel, false);
                }
            }
        }

        public void precompose_INT_PACK(int n, int n2, int[] nArray, int n3, int n4, int[] nArray2, int n5, int n6, int[] nArray3, int n7, int n8) {
            int n9 = 0;
            while (n9 < n2) {
                int n10 = n8 + n;
                while (n8 < n10) {
                    int n11 = nArray[n4++];
                    int n12 = nArray2[n6++];
                    int n13 = (n11 >>> 24) * 65793;
                    int n14 = (255 - (n11 >>> 24)) * 65793;
                    nArray3[n8++] = (n11 & 0xFF000000) + (n12 >>> 24) * n14 + 0x800000 & 0xFF000000 | ((n11 >> 16 & 0xFF) * n13 + (n12 >> 16 & 0xFF) * n14 + 0x800000 & 0xFF000000) >>> 8 | ((n11 >> 8 & 0xFF) * n13 + (n12 >> 8 & 0xFF) * n14 + 0x800000 & 0xFF000000) >>> 16 | (n11 & 0xFF) * n13 + (n12 & 0xFF) * n14 + 0x800000 >>> 24;
                }
                n4 += n3;
                n6 += n5;
                n8 += n7;
                ++n9;
            }
        }
    }

    public static class OverCompositeContext_NA
    extends AlphaPreCompositeContext {
        OverCompositeContext_NA(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = 0;
                int n8 = n2 * 4;
                while (n6 < n8) {
                    int n9 = (255 - nArray[n6 + 3]) * 65793;
                    nArray2[n7] = nArray[n6] + (nArray2[n7] * n9 + 0x800000 >>> 24);
                    nArray2[++n7] = nArray[++n6] + (nArray2[n7] * n9 + 0x800000 >>> 24);
                    nArray2[++n7] = nArray[++n6] + (nArray2[n7] * n9 + 0x800000 >>> 24);
                    n6 += 2;
                    ++n7;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class ScreenCompositeContext
    extends AlphaPreCompositeContext {
        ScreenCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    nArray2[n6] = nArray[n6] + nArray2[n6] - (nArray2[n6] * nArray[n6] * 65793 + 0x800000 >>> 24);
                    nArray2[++n6] = nArray[n6] + nArray2[n6] - (nArray2[n6] * nArray[n6] * 65793 + 0x800000 >>> 24);
                    nArray2[++n6] = nArray[n6] + nArray2[n6] - (nArray2[n6] * nArray[n6] * 65793 + 0x800000 >>> 24);
                    nArray2[++n6] = nArray[n6] + nArray2[n6] - (nArray2[n6] * nArray[n6] * 65793 + 0x800000 >>> 24);
                    ++n6;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class ScreenCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        ScreenCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose_INT_PACK(int n, int n2, int[] nArray, int n3, int n4, int[] nArray2, int n5, int n6, int[] nArray3, int n7, int n8) {
            int n9 = 0;
            while (n9 < n2) {
                int n10 = n8 + n;
                while (n8 < n10) {
                    int n11 = nArray[n4++];
                    int n12 = nArray2[n6++];
                    int n13 = n11 >>> 24;
                    int n14 = n12 >>> 24;
                    int n15 = n11 >> 16 & 0xFF;
                    int n16 = n12 >> 16 & 0xFF;
                    int n17 = n11 >> 8 & 0xFF;
                    int n18 = n12 >> 8 & 0xFF;
                    int n19 = n11 & 0xFF;
                    int n20 = n12 & 0xFF;
                    nArray3[n8++] = n15 + n16 - (n15 * n16 * 65793 + 0x800000 >>> 24) << 16 | n17 + n18 - (n17 * n18 * 65793 + 0x800000 >>> 24) << 8 | n19 + n20 - (n19 * n20 * 65793 + 0x800000 >>> 24) | n13 + n14 - (n13 * n14 * 65793 + 0x800000 >>> 24) << 24;
                }
                n4 += n3;
                n6 += n5;
                n8 += n7;
                ++n9;
            }
        }
    }

    public static class XorCompositeContext
    extends AlphaPreCompositeContext {
        XorCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    int n8 = (255 - nArray2[n6 + 3]) * 65793;
                    int n9 = (255 - nArray[n6 + 3]) * 65793;
                    nArray2[n6] = nArray[n6] * n8 + nArray2[n6] * n9 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + nArray2[n6] * n9 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + nArray2[n6] * n9 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + nArray2[n6] * n9 + 0x800000 >>> 24;
                    ++n6;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class XorCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        XorCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose_INT_PACK(int n, int n2, int[] nArray, int n3, int n4, int[] nArray2, int n5, int n6, int[] nArray3, int n7, int n8) {
            int n9 = 0;
            while (n9 < n2) {
                int n10 = n8 + n;
                while (n8 < n10) {
                    int n11 = nArray[n4++];
                    int n12 = nArray2[n6++];
                    int n13 = (255 - (n12 >>> 24)) * 65793;
                    int n14 = (255 - (n11 >>> 24)) * 65793;
                    nArray3[n8++] = (n11 >>> 24) * n13 + (n12 >>> 24) * n14 + 0x800000 & 0xFF000000 | ((n11 >> 16 & 0xFF) * n13 + (n12 >> 16 & 0xFF) * n14 + 0x800000 & 0xFF000000) >>> 8 | ((n11 >> 8 & 0xFF) * n13 + (n12 >> 8 & 0xFF) * n14 + 0x800000 & 0xFF000000) >>> 16 | (n11 & 0xFF) * n13 + (n12 & 0xFF) * n14 + 0x800000 >>> 24;
                }
                n4 += n3;
                n6 += n5;
                n8 += n7;
                ++n9;
            }
        }
    }
}

