/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;
import org.eclipse.gmf.internal.xpand.model.XpandIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForEachStatement
extends Statement {
    public static final String ITERATOR_VAR_NAME = "iterator";
    private final Statement[] body;
    private final Expression target;
    private final Expression separator;
    private final Identifier variable;
    private final Identifier iteratorName;

    public ForEachStatement(int start, int end, int line, Identifier variable, Expression target, Statement[] body, Expression separator, Identifier iterator) {
        super(start, end, line);
        this.variable = variable;
        this.target = target;
        this.body = body;
        this.separator = separator;
        this.iteratorName = iterator;
    }

    public Statement[] getBody() {
        return this.body;
    }

    public Expression getSeparator() {
        return this.separator;
    }

    public Expression getTarget() {
        return this.target;
    }

    public Identifier getVariable() {
        return this.variable;
    }

    @Override
    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        Object t = this.getTarget().analyze(ctx, issues);
        if (this.getSeparator() != null) {
            EClassifier sepT = this.getSeparator().analyze(ctx, issues);
            if (!BuiltinMetaModel.isAssignableFrom((EClassifier)EcorePackage.eINSTANCE.getEString(), sepT)) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "String expected!", this.target));
            }
        }
        if (t != null) {
            if (BuiltinMetaModel.isCollectionType(t)) {
                t = BuiltinMetaModel.isParameterizedType(t) ? BuiltinMetaModel.getInnerType(t) : EcorePackage.eINSTANCE.getEJavaObject();
            } else {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "Collection type expected!", this.target));
                return;
            }
        }
        ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(this.getVariable().getValue(), t));
        if (this.iteratorName != null) {
            ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(this.iteratorName.getValue(), BuiltinMetaModel.ITERATOR_TYPE));
        }
        Statement[] statementArray = this.getBody();
        int n = statementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            statement.analyze(ctx, issues);
            ++n2;
        }
    }

    @Override
    public void evaluateInternal(XpandExecutionContext ctx) {
        Object o = this.getTarget().evaluate(ctx);
        if (!(o instanceof Collection)) {
            throw new EvaluationException("Collection expected!", (SyntaxElement)this.getTarget());
        }
        Collection col = (Collection)o;
        String sep = (String)(this.getSeparator() != null ? this.getSeparator().evaluate(ctx) : null);
        XpandIterator iterator = new XpandIterator(col.size());
        if (this.iteratorName != null) {
            ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(this.iteratorName.getValue(), iterator));
        }
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(this.getVariable().getValue(), element));
            int i = 0;
            while (i < this.getBody().length) {
                this.getBody()[i].evaluate(ctx);
                ++i;
            }
            if (sep != null && iter.hasNext()) {
                ctx.getOutput().write(sep);
            }
            iterator.increment();
        }
    }
}

