/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.graphics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

final class FontRegistry {
    private static FontRegistry singletonInstance = new FontRegistry();
    private Map fonts = null;

    public static FontRegistry getInstance() {
        return singletonInstance;
    }

    private FontRegistry() {
    }

    public Font getFont(Device device, FontData fd) {
        Object value;
        if (this.fonts == null) {
            this.fonts = new HashMap();
        }
        if ((value = this.fonts.get(fd.toString())) != null) {
            return (Font)value;
        }
        Font newFont = new Font(device, fd);
        this.fonts.put(fd.toString(), newFont);
        return newFont;
    }

    public void clearFontCache() {
        if (this.fonts != null) {
            ArrayList keys = new ArrayList(this.fonts.keySet());
            Iterator keyiter = keys.iterator();
            while (keyiter.hasNext()) {
                Font font = (Font)this.fonts.remove(keyiter.next());
                font.dispose();
            }
        }
    }
}

