/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.figures;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.internal.mapmode.DiagramMapModeUtil;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderInfo;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.RenderHelper;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.RenderingListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;

public class ScalableImageFigure
extends ImageFigure {
    private RenderingListenerImpl renderingListener = new RenderingListenerImpl();
    private Dimension preferredSize = new Dimension(-1, -1);
    private static final int FLAG_USE_DEFAULT_IMAGESIZE = MAX_FLAG << 1;
    private static final int FLAG_MAINTAIN_ASPECT_RATIO = MAX_FLAG << 2;
    private static final int FLAG_ANTI_ALIAS = MAX_FLAG << 3;
    private static final int FLAG_USE_ORIGINAL_COLORS = MAX_FLAG << 4;
    private RenderedImage lastRenderedImage = null;

    public boolean isAntiAlias() {
        return this.getFlag(FLAG_ANTI_ALIAS);
    }

    public void setAntiAlias(boolean antiAlias) {
        this.setFlag(FLAG_ANTI_ALIAS, antiAlias);
        this.invalidate();
    }

    public boolean isMaintainAspectRatio() {
        return this.getFlag(FLAG_MAINTAIN_ASPECT_RATIO);
    }

    public void setMaintainAspectRatio(boolean maintainAspectRatio) {
        this.setFlag(FLAG_MAINTAIN_ASPECT_RATIO, maintainAspectRatio);
        this.invalidate();
    }

    public ScalableImageFigure(Image img) {
        ImageLoader imageLoader = new ImageLoader();
        ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
        imageLoader.data = new ImageData[]{img.getImageData()};
        imageLoader.logicalScreenHeight = img.getBounds().width;
        imageLoader.logicalScreenHeight = img.getBounds().height;
        imageLoader.save((OutputStream)byteOS, 0);
        this.lastRenderedImage = RenderedImageFactory.getInstance(byteOS.toByteArray());
        this.setFlag(FLAG_USE_DEFAULT_IMAGESIZE, false);
        this.setFlag(FLAG_USE_ORIGINAL_COLORS, false);
        this.setFlag(FLAG_MAINTAIN_ASPECT_RATIO, true);
        this.setFlag(FLAG_ANTI_ALIAS, true);
    }

    public ScalableImageFigure(RenderedImage renderedImage) {
        this(renderedImage, false, false, true);
    }

    public ScalableImageFigure(RenderedImage renderedImage, boolean antiAlias) {
        this(renderedImage, false, false, antiAlias);
    }

    public ScalableImageFigure(RenderedImage renderedImage, boolean useDefaultImageSize, boolean useOriginalColors, boolean antiAlias) {
        this.lastRenderedImage = renderedImage;
        this.setFlag(FLAG_USE_DEFAULT_IMAGESIZE, useDefaultImageSize);
        this.setFlag(FLAG_USE_ORIGINAL_COLORS, useOriginalColors);
        this.setFlag(FLAG_MAINTAIN_ASPECT_RATIO, true);
        this.setFlag(FLAG_ANTI_ALIAS, antiAlias);
    }

    public void setPreferredImageSize(int w, int h) {
        this.preferredSize = new Dimension(w, h);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.preferredSize.height == -1 && this.preferredSize.width == -1) {
            int extent = MapModeUtil.getMapMode((IFigure)this).DPtoLP(32);
            this.preferredSize = new Dimension(extent, extent);
            if (this.getFlag(FLAG_USE_DEFAULT_IMAGESIZE) && this.getRenderedImage() != null) {
                this.setRenderedImage(this.getRenderedImage(new Dimension(0, 0)));
                Image swtImage = null;
                if (this.getRenderedImage() != null) {
                    swtImage = this.getRenderedImage().getSWTImage();
                }
                if (swtImage != null) {
                    org.eclipse.swt.graphics.Rectangle imgRect = swtImage.getBounds();
                    this.preferredSize.width = MapModeUtil.getMapMode((IFigure)this).DPtoLP(imgRect.width);
                    this.preferredSize.height = MapModeUtil.getMapMode((IFigure)this).DPtoLP(imgRect.height);
                }
            }
        }
        return this.preferredSize;
    }

    public void setBounds(Rectangle rect) {
        Dimension devDim = new Dimension(rect.getSize());
        MapModeUtil.getMapMode((IFigure)this).LPtoDP((Translatable)devDim);
        this.setRenderedImage(this.getRenderedImage(devDim));
        super.setBounds(rect);
    }

    public Image getImage() {
        if (this.getRenderedImage() == null) {
            return null;
        }
        return this.getRenderedImage().getSWTImage();
    }

    private RenderedImage getRenderedImage(Dimension dim) {
        Color fill = this.getBackgroundColor();
        Color outline = this.getForegroundColor();
        RenderInfo newRenderInfo = this.getRenderedImage().getRenderInfo();
        newRenderInfo.setValues(dim.width, dim.height, this.isMaintainAspectRatio(), this.isAntiAlias(), this.useOriginalColors() ? null : new RGB(fill.getRed(), fill.getGreen(), fill.getBlue()), this.useOriginalColors() ? null : new RGB(outline.getRed(), outline.getGreen(), outline.getBlue()));
        RenderedImage newRenderedImage = this.getRenderedImage().getNewRenderedImage(newRenderInfo);
        return newRenderedImage;
    }

    public boolean useOriginalColors() {
        return this.getFlag(FLAG_USE_ORIGINAL_COLORS);
    }

    protected void paintFigureWhileRendering(Graphics g) {
        Rectangle area = this.getClientArea().getCopy();
        g.pushState();
        g.setBackgroundColor(ColorConstants.white);
        g.fillRectangle(area.x, area.y, area.width - 1, area.height - 1);
        g.setForegroundColor(ColorConstants.red);
        g.drawRectangle(area.x, area.y, area.width - 1, area.height - 1);
        g.setLineStyle(3);
        g.drawLine(area.x, area.y, area.x + area.width, area.y + area.height);
        g.drawLine(area.x + area.width, area.y, area.x, area.y + area.height);
        g.popState();
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle area = this.getClientArea().getCopy();
        RenderInfo rndInfo = this.getRenderedImage().getRenderInfo();
        if (!(this.useOriginalColors() || rndInfo.getBackgroundColor() == this.getBackgroundColor().getRGB() && rndInfo.getForegroundColor() == this.getForegroundColor().getRGB())) {
            rndInfo.setValues(rndInfo.getWidth(), rndInfo.getHeight(), rndInfo.shouldMaintainAspectRatio(), rndInfo.shouldAntiAlias(), this.getBackgroundColor().getRGB(), this.getForegroundColor().getRGB());
            this.setRenderedImage(this.getRenderedImage().getNewRenderedImage(rndInfo));
        }
        this.setRenderedImage(RenderHelper.getInstance(DiagramMapModeUtil.getScale((IMapMode)MapModeUtil.getMapMode((IFigure)this)), false, false, null).drawRenderedImage(graphics, this.getRenderedImage(), area, this.renderingListener));
    }

    public RenderedImage getRenderedImage() {
        return this.lastRenderedImage;
    }

    public void setRenderedImage(RenderedImage renderedImage) {
        this.lastRenderedImage = renderedImage;
    }

    private class RenderingListenerImpl
    implements RenderingListener {
        public void paintFigureWhileRendering(Graphics g) {
            ScalableImageFigure.this.paintFigureWhileRendering(g);
        }

        public void imageRendered(RenderedImage rndImg) {
            if (ScalableImageFigure.this.getParent() != null) {
                ScalableImageFigure.this.setRenderedImage(rndImg);
                ScalableImageFigure.this.repaint();
            }
        }

        public ScalableImageFigure getFigure() {
            return ScalableImageFigure.this;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RenderingListenerImpl) {
                return ((Object)((Object)((RenderingListenerImpl)obj).getFigure())).equals((Object)this.getFigure());
            }
            return false;
        }

        public int hashCode() {
            return ((Object)((Object)ScalableImageFigure.this)).hashCode();
        }
    }
}

